<?php
require_once 'Zend/Mail.php';
require_once 'mail.php';

session_start();

$_SESSION['error'] = array();

foreach ($_POST as $key => $value) {
	$_SESSION[$key] = $value;
}
$_SESSION['date'] = date('d/m/Y H:i');

// La page de reservation, pour les 2 langues
if ($_POST['page'] == 'booking') {
	// on check le prénom
	if (empty($_POST['firstname'])) {
		$_SESSION['error'][] = 'firstname';
		$_SESSION['firstname'] = '';
	}
	// le nom
	if (empty($_POST['lastname'])) {
		$_SESSION['error'][] = 'lastname';
		$_SESSION['lastname'] = '';
	}
	// et l'email
	if ( (empty($_POST['email'])) || ( ! filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) ) {
		$_SESSION['error'][] = 'email';
		$_SESSION['email'] = '';
	}
	// le tel
	if (empty($_POST['tel'])) {
		$_SESSION['error'][] = 'tel';
		$_SESSION['tel'] = '';
	}
	// la rue
	if (empty($_POST['street'])) {
		$_SESSION['error'][] = 'street';
		$_SESSION['street'] = '';
	}
	// la ville
	if (empty($_POST['town'])) {
		$_SESSION['error'][] = 'town';
		$_SESSION['town'] = '';
	}
	// le pays
	if (empty($_POST['country'])) {
		$_SESSION['error'][] = 'country';
		$_SESSION['country'] = '';
	}

	// si l'un est vide ou si le mail n'est pas valide, on renvoit sur la page de reservation initiale
	if (!empty($_SESSION['error'])) {
		if ($_POST['lang'] == 'en') {
			header('Location: ../en/booking/index.php');
		} else {
			header('Location: ../fr/reserver/index.php');
		}
		die();
	}
	// sinon on redirige vers la page page en fonction de la langue
	if ($_POST['lang'] == 'en') {
		if (!empty($_POST['lagoon-420-blue-submit'])) {
			header('Location: ../en/booking/lagoon-420-blue.php');
			
		} elseif (!empty($_POST['catamaran-cabin-submit'])) {
			header('Location: ../en/booking/catamaran-cabin-charter.php');
			
		} elseif (!empty($_POST['beneteau-cabin-submit'])) {
			header('Location: ../en/booking/beneteau-cabin-charter.php');
			
		} elseif (!empty($_POST['lagoon52-submit'])) {
			header('Location: ../en/booking/lagoon52.php');
			
		} elseif (!empty($_POST['punch41-submit'])) {
			header('Location: ../en/booking/punch41.php');
			
		} elseif (!empty($_POST['classic60-submit'])) {
			header('Location: ../en/booking/classic60.php');
			
		} elseif (!empty($_POST['oceanis40-submit'])) {
			header('Location: ../en/booking/oceanis40.php');
		
		} elseif (!empty($_POST['beneteau50-submit'])) {
			header('Location: ../en/booking/beneteau50.php');
									
		} elseif (!empty($_POST['lagoon420-submit'])) {
			header('Location: ../en/booking/lagoon420.php');
			
		} elseif (!empty($_POST['lagoon46-submit'])) {
			header('Location: ../en/booking/lagoon46.php');
			
		}
	} else {
		if (!empty($_POST['lagoon-420-blue-submit'])) {
			header('Location: ../fr/reserver/lagoon-420-blue.php');
		
		} elseif (!empty($_POST['croisiere-cabine-catamaran'])) {
			header('Location: ../fr/reserver/croisiere-cabine-catamaran.php');
			
		} elseif (!empty($_POST['croisiere-cabine-beneteau'])) {
			header('Location: ../fr/reserver/croisiere-cabine-beneteau.php');
			
		} elseif (!empty($_POST['lagoon52-submit'])) {
			header('Location: ../fr/reserver/lagoon52.php');
			
		} elseif (!empty($_POST['lagoon46-submit'])) {
			header('Location: ../fr/reserver/lagoon46.php');
			
		} elseif (!empty($_POST['punch41-submit'])) {
			header('Location: ../fr/reserver/punch41.php');
			
		} elseif (!empty($_POST['classic60-submit'])) {
			header('Location: ../fr/reserver/caique60.php');
		
		} elseif (!empty($_POST['oceanis40-submit'])) {
			header('Location: ../fr/reserver/oceanis40.php');
			
		} elseif (!empty($_POST['beneteau50-submit'])) {
			header('Location: ../fr/reserver/beneteau50.php');
			
		} elseif (!empty($_POST['lagoon420-submit'])) {
			header('Location: ../fr/reserver/lagoon420.php');
		
		}
	}
	die();
}

// Traitement commun aux pages catamaran-cabin-charter, beneteau-cabin-charter, croisiere-cabine-catamaran, croisiere-cabine-beneteau, comments, lagoon-420-blue, lagoon52, lagoon39, oceanis40, classic60, beneteau50, lagoon420
if (in_array($_POST['page'], array('catamaran-cabin-charter', 'beneteau-cabin-charter', 'croisiere-cabine-catamaran', 'croisiere-cabine-beneteau', 'lagoon-420-blue', 'lagoon52', 'lagoon39', 'punch41', 'oceanis40', 'beneteau50', 'classic60', 'lagoon420'))) {

	// on vérifie que l'arrivée soit bien après le départ
	$departure = mktime(0,0,0,$_POST['departure_month'], $_POST['departure_day'], $_POST['departure_year']);
	$arrival = mktime(0,0,0,$_POST['arrival_month'], $_POST['arrival_day'], $_POST['arrival_year']);
	
	$_SESSION['departure_date'] = date('d/m/Y', $departure);
	$_SESSION['arrival_date'] = date('d/m/Y', $arrival);
	
	if ($arrival <= $departure) {
		$_SESSION['error'][] = 'date';
	}
	
	if ($departure < time()) {
		$_SESSION['error'][] = 'date';
	}
	
	if (empty($_POST['persons_sharing'])) {
		$_SESSION['error'][] = 'persons_sharing';
		$_SESSION['persons_sharing'] = '';
	}
	if (empty($_POST['amount'])) {
		$_SESSION['error'][] = 'amount';
		$_SESSION['amount'] = '';
	}
	if (empty($_POST['agree'])) {
		$_SESSION['error'][] = 'agree';
		$_SESSION['agree'] = 'no';
	}
	if ( ! isset($_SESSION['message'])) {
		$_SESSION['message'] = '';
	}
}

// Traitement commun aux pages catamaran-cabin-charter, beneteau-cabin-charter, croisiere-cabine-catamaran, croisiere-cabine-beneteau, comments, lagoon-420-blue, lagoon52, lagoon39, oceanis40, classic60, beneteau50, 
if (in_array($_POST['page'], array('catamaran-cabin-charter', 'beneteau-cabin-charter', 'croisiere-cabine-catamaran', 'croisiere-cabine-beneteau','lagoon-420-blue', 'lagoon52', 'lagoon46', 'punch41', 'oceanis40', 'beneteau50', 'classic60', 'lagoon420'))) {

	// on vérifie que l'arrivée soit bien après le départ
	$departure = mktime(0,0,0,$_POST['departure_month'], $_POST['departure_day'], $_POST['departure_year']);
	$arrival = mktime(0,0,0,$_POST['arrival_month'], $_POST['arrival_day'], $_POST['arrival_year']);
	
	$_SESSION['departure_date'] = date('d/m/Y', $departure);
	$_SESSION['arrival_date'] = date('d/m/Y', $arrival);
	
	if ($arrival <= $departure) {
		$_SESSION['error'][] = 'date';
	}
	
	if ($departure < time()) {
		$_SESSION['error'][] = 'date';
	}
	
	if (empty($_POST['persons_sharing'])) {
		$_SESSION['error'][] = 'persons_sharing';
		$_SESSION['persons_sharing'] = '';
	}
	if (empty($_POST['amount'])) {
		$_SESSION['error'][] = 'amount';
		$_SESSION['amount'] = '';
	}
	if (empty($_POST['agree'])) {
		$_SESSION['error'][] = 'agree';
		$_SESSION['agree'] = 'no';
	}
	
	if ( ! isset($_SESSION['message'])) {
		$_SESSION['message'] = '';
	}
}

// traitement communs aux pages lagoon-420-blue, lagoon52, lagoon46, oceanis40, classic 60, lagoon-420(Mediterraneo)
if (in_array($_POST['page'], array('lagoon-420-blue', 'catamaran-cabin-charter', 'beneteau-cabin-charter', 'croisiere-cabine-catamaran', 'croisiere-cabine-beneteau', 'lagoon52', 'punch41', 'oceanis40', 'beneteau50', 'classic60', 'lagoon46', ))) {

	if ( ($_POST['yacht'] == 'other') && (empty($_POST['other_yacht'])) ) {
		$_SESSION['error'][] = 'other_yacht';
	}
}

if ($_POST['page'] == 'catamaran-cabin-charter') {
	
	if (empty($_POST['double_cabin'])) {
		$_SESSION['error'][] = 'double_cabin';
		$_SESSION['double_cabin'] = '';
	}
	
	if (empty($_POST['pilot_cabin'])) {
		$_SESSION['pilot_cabin'] = 'no';
	}
	
	// s'il y a une erreur, on renvoi sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/croisiere-cabine-catamaran.php');
		} else {
			header('Location: ../en/booking/catamaran-cabin-charter.php');
		}
		die();
	}
	
	//sinon on envoit le mail !
	$_SESSION['title'] = 'Booking - Lagoon 420 catamaran cabin charter';
	sendMail($_SESSION, 'mail_booking/mail_booking_cabin.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/money-transfert.php');
		} else {
			header('Location: ../en/booking/online-payment.php');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/money-transfert.php');
		} else {
			header('Location: ../en/booking/online-payment.php');
		}
	}
	die();
}

if ($_POST['page'] == 'beneteau-cabin-charter') {
	
	if (empty($_POST['double_cabin'])) {
		$_SESSION['error'][] = 'double_cabin';
		$_SESSION['double_cabin'] = '';
	}
	
	// s'il y a une erreur, on renvoi sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/croisiere-cabine-beneteau.php');
		} else {
			header('Location: ../en/booking/beneteau-cabin-charter.php');
		}
		die();
	}
	
	//sinon on envoit le mail !
	$_SESSION['title'] = 'Booking for Beneteau 50 cabin charter';
	sendMail($_SESSION, 'mail_booking/mail_booking_cabin.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/beneteau50-money-transfert.php');
		} else {
			header('Location: ../en/booking/beneteau50-online-payment');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/beneteau50-money-transfert.php');
		} else {
			header('Location: ../en/booking/beneteau50-online-payment.php');
		}
	}
	die();
}

if ($_POST['page'] == 'croisiere-cabine-catamaran') {
	
	if (empty($_POST['double_cabin'])) {
		$_SESSION['error'][] = 'double_cabin';
		$_SESSION['double_cabin'] = '';
	}
	
	if (empty($_POST['pilot_cabin'])) {
		$_SESSION['pilot_cabin'] = 'no';
	}
	
	// s'il y a une erreur, on renvoit sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/croisiere-cabine-catamaran.php');
		} else {
			header('Location: ../en/booking/catamaran-cabin-charter.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Réservation Croisière à la Cabine catamaran Lagoon 420';
	sendMail($_SESSION, 'mail_booking/mail_booking_cabin.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/money-transfert.php');
		} else {
			header('Location: ../en/booking/online-payment.php');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/money-transfert.php');
		} else {
			header('Location: ../en/booking/online-payment.php');
		}
	}
	die();
}

if ($_POST['page'] == 'croisiere-cabine-beneteau') {
	
	if (empty($_POST['double_cabin'])) {
		$_SESSION['error'][] = 'double_cabin';
		$_SESSION['double_cabin'] = '';
	}
	
	// s'il y a une erreur, on renvoi sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/croisiere-cabine-beneteau.php');
		} else {
			header('Location: ../en/booking/beneteau-cabin-charter.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Réservation croisière à la cabine voilier Beneteau 50';
	sendMail($_SESSION, 'mail_booking/mail_booking_cabin.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/beneteau50-money-transfert.php');
		} else {
			header('Location: ../en/booking/beneteau50-online-payment');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/beneteau50-money-transfert.php');
		} else {
			header('Location: ../en/booking/beneteau50-online-payment');
		}
	}
	die();
}

if ($_POST['page'] == 'lagoon-420-blue') {

	// s'il y a une erreur, on renvoi sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/lagoon-420-blue.php');
		} else {
			header('Location: ../en/booking/lagoon-420-blue.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Booking - Lagoon 420 Blue';
	sendMail($_SESSION, 'mail_booking/mail_booking_catamaran_yacht.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/lagoon-420-blue-money-transfert.php');
		} else {
			header('Location: ../en/booking/online-payment.php');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/lagoon-420-blue-money-transfert.php');
		} else {
			header('Location: ../en/booking/online-payment.php');
		}
	}
	die();
}


if ($_POST['page'] == 'punch41') {

	// s'il y a une erreur, on renvoit sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/punch41.php');
		} else {
			header('Location: ../en/booking/punch41.php');
		}
		die();
	}
	
	//sinon on envoit le mail !
	$_SESSION['title'] = 'Booking - Punch 41';
	sendMail($_SESSION, 'mail_booking/mail_booking_catamaran_yacht.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/punch41-money-transfert.php');
		} else {
			header('Location: ../en/booking/punch41-online-payment.php');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/punch41-money-transfert.php');
		} else {
			header('Location: ../en/booking/punch41-online-payment.php');
		}
	}
	die();
}

if ($_POST['page'] == 'beneteau50') {

	// s'il y a une erreur, on renvoit sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/beneteau50.php');
		} else {
			header('Location: ../en/booking/beneteau50.php');
		}
		die();
	}
	
	//sinon on envoit le mail !
	$_SESSION['title'] = 'Booking - Beneteau 50';
	sendMail($_SESSION, 'mail_booking/mail_booking_catamaran_yacht.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/beneteau50-money-transfert.php');
		} else {
			header('Location: ../en/booking/beneteau50-online-payment.php');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/beneteau50-money-transfert.php');
		} else {
			header('Location: ../en/booking/beneteau50-online-payment.php');
		}
	}
	die();
}


if ($_POST['page'] == 'classic60') {

	// s'il y a une erreur, on renvoit sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/caique60.php');
		} else {
			header('Location: ../en/booking/classic60.php');
		}
		die();
	}
	
	//sinon on envoit le mail !
	$_SESSION['title'] = 'Booking - Classic Trechantiri 60';
	sendMail($_SESSION, 'mail_booking/mail_booking_catamaran_yacht.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/caique60-money-transfert.php');
		} else {
			header('Location: ../en/booking/classic60-online-payment.php');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/classic60-money-transfert.php');
		} else {
			header('Location: ../en/booking/classic60-online-payment.php');
		}
	}
	die();
}


if ($_POST['page'] == 'oceanis40') {
	
	// s'il y a une erreur, on renvoi sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/oceanis40.php');
		} else {
			header('Location: ../en/booking/oceanis40.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Booking - Oceanis 40';
	sendMail($_SESSION, 'mail_booking/mail_booking_catamaran_yacht.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/oceanis40-money-transfert.php');
		} else {
			header('Location: ../en/booking/oceanis40-online-payment.php');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/oceanis40-money-transfert.php');
		} else {
			header('Location: ../en/booking/oceanis40-online-payment.php');
		}
	}
	die();
}

if ($_POST['page'] == 'beneteau50') {

	// s'il y a une erreur, on renvoi sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/beneteau50.php');
		} else {
			header('Location: ../en/booking/beneteau50.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Booking - Beneteau 50';
	sendMail($_SESSION, 'mail_booking/mail_booking_catamaran_yacht.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../fr/reserver/beneteau50-money-transfert.php');
		} else {
			header('Location: ../en/booking/online-payment.php');
		}
	} else {
		if ($_SESSION['payment'] == 'transfert') {
			header('Location: ../en/booking/beneteau50-money-transfert.php');
		} else {
			header('Location: ../en/booking/online-payment.php');
		}
	}
	die();
}

if ($_POST['page'] == 'lagoon52') {

	// s'il y a une erreur, on renvoi sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/lagoon52.php');
		} else {
			header('Location: ../en/booking/lagoon52.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Booking - Lagoon 52';
	sendMail($_SESSION, 'mail_booking/mail_booking_catamaran_yacht.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		header('Location: ../fr/reserver/lagoon52-money-transfert.php');
		} else {
			header('Location: ../en/booking/lagoon52-money-transfert.php');
	}
	die();
}


if ($_POST['page'] == 'lagoon46') {

	// s'il y a une erreur, on renvoi sur le formulaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/reserver/lagoon46.php');
		} else {
			header('Location: ../en/booking/lagoon46.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Booking - Lagoon 46 Alice';
	sendMail($_SESSION, 'mail_booking/mail_booking_catamaran_yacht.php', true);
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		header('Location: ../fr/reserver/lagoon46-money-transfert.php');
		} else {
			header('Location: ../en/booking/lagoon46-money-transfert.php');
	}
	die();
}