<?php
require_once 'Zend/Mail.php';
require_once 'mail.php';

session_start();

$_SESSION['error'] = array();

foreach ($_POST as $key => $value) {
	$_SESSION[$key] = $value;
}
$_SESSION['date'] = date('d/m/Y H:i');

// La page de contact, pour les 2 langues
if ($_POST['page'] == 'contact') {
	// on check le prénom
	if (empty($_POST['firstname'])) {
		$_SESSION['error'][] = 'firstname';
		$_SESSION['firstname'] = '';
	}
	// le nom
	if (empty($_POST['lastname'])) {
		$_SESSION['error'][] = 'lastname';
		$_SESSION['lastname'] = '';
	}
	// et l'email
	if ( (empty($_POST['email'])) || ( ! filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) ) {
		$_SESSION['error'][] = 'email';
		$_SESSION['email'] = '';
	}

	// si l'un est vide ou si le mail n'est pas valide, on renvoi sur la page contact
	if (!empty($_SESSION['error'])) {
		header('Location: ../'.$_POST['lang'].'/contact/index.php');
		die();
	}
	// sinon on redirige vers la page page en fonction de la langue
	if ($_POST['lang'] == 'en') {
		if (!empty($_POST['catamaran-sumbit'])) {
			header('Location: ../en/contact/catamaran-charter-availability.php');
			
		} elseif (!empty($_POST['comments-submit'])) {
			header('Location: ../en/contact/comments.php');
			
		} elseif (!empty($_POST['cabin-submit'])) {
			header('Location: ../en/contact/cabin-charter-availability.php');
			
		} elseif (!empty($_POST['yacht-charter'])) {
			header('Location: ../en/contact/yacht-charter-availability.php');
		}
	} else {
		if (!empty($_POST['catamaran-sumbit'])) {
			header('Location: ../fr/contact/disponibilite-catamaran.php');
			
		} elseif (!empty($_POST['comments-submit'])) {
			header('Location: ../fr/contact/comments.php');
			
		} elseif (!empty($_POST['cabin-submit'])) {
			header('Location: ../fr/contact/disponibilite-croisiere-cabine.php');
			
		} elseif (!empty($_POST['yacht-charter'])) {
			header('Location: ../fr/contact/disponibilite-voilier-monocoque.php');
		}
	}
	die();
}

// Traitement commun aux pages cabin-charter, comments, catamaran-charter et yacht-charter
if (in_array($_POST['page'], array('cabin-charter', 'catamaran-charter', 'yacht-charter'))) {

	// on vérifie que l'arrivée soit bien après le départ
	$departure = mktime(0,0,0,$_POST['departure_month'], $_POST['departure_day'], $_POST['departure_year']);
	$arrival = mktime(0,0,0,$_POST['arrival_month'], $_POST['arrival_day'], $_POST['arrival_year']);
	
	$_SESSION['departure_date'] = date('d/m/Y', $departure);
	$_SESSION['arrival_date'] = date('d/m/Y', $arrival);
	
	if ($arrival <= $departure) {
		$_SESSION['error'][] = 'date';
	}
	
	if ($departure < time()) {
		$_SESSION['error'][] = 'date';
	}
	
	if (empty($_POST['persons_sharing'])) {
		$_SESSION['error'][] = 'persons_sharing';
		$_SESSION['persons_sharing'] = '';
	}
	
	if ( ! isset($_SESSION['message'])) {
		$_SESSION['message'] = '';
	}
}

// traitement communs aux pages catamaran-charter et yacht-charter
if (in_array($_POST['page'], array('catamaran-charter', 'yacht-charter'))) {

	if ( ($_POST['yacht'] == 'other') && (empty($_POST['other_yacht'])) ) {
		$_SESSION['error'][] = 'other_yacht';
	}
}

// la page cabine
if ($_POST['page'] == 'cabin-charter') {

	if (empty($_POST['double_cabin'])) {
		$_SESSION['error'][] = 'double_cabin';
		$_SESSION['double_cabin'] = '';
	}
	
	if (empty($_POST['pilot_cabin'])) {
		$_SESSION['pilot_cabin'] = 'no';
	}
	
	if ( ($_POST['yacht'] == 'other') && (empty($_POST['other_yacht'])) ) {
		$_SESSION['error'][] = 'other_yacht';
	}
	
	
	// s'il y a une erreur, on renvoi sur le forumalaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/contact/disponibilite-croisiere-cabine.php');
		} else {
			header('Location: ../en/contact/cabin-charter-availability.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Archipel - Inquiry for Cabin Charter';
	sendMail($_SESSION, 'mail_contact/mail_booking_cabin.php');
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		header('Location: ../fr/contact/success.html');
	} else {
		header('Location: ../en/contact/success.html');
	}
	die();
}

if ($_POST['page'] == 'catamaran-charter') {

	// s'il y a une erreur, on renvoi sur le forumalaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/contact/disponibilite-catamaran.php');
		} else {
			header('Location: ../en/contact/catamaran-charter-availability.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Archipel - Inquiry for Catamaran Charter';
	sendMail($_SESSION, 'mail_contact/mail_booking_catamaran_yacht.php');
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		header('Location: ../fr/contact/success.html');
	} else {
		header('Location: ../en/contact/success.html');
	}
	die();
}

if ($_POST['page'] == 'yacht-charter') {

	// s'il y a une erreur, on renvoi sur le forumalaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/contact/disponibilite-voilier-monocoque.php');
		} else {
			header('Location: ../en/contact/yacht-charter-availability.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Archipel - Inquiry for Yacht Charter';
	sendMail($_SESSION, 'mail_contact/mail_booking_catamaran_yacht.php');
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		header('Location: ../fr/contact/success.html');
	} else {
		header('Location: ../en/contact/success.html');
	}
	die();
}

if ($_POST['page'] == 'comments') {
	
	if (empty($_POST['message'])) {
		$_SESSION['error'][] = 'message';
		$_SESSION['message'] = '';
	}

	// s'il y a une erreur, on renvoi sur le forumalaire
	if ( ! empty($_SESSION['error'])) {
		if ($_SESSION['lang'] == 'fr') {
			header('Location: ../fr/contact/comments.php');
		} else {
			header('Location: ../en/contact/comments.php');
		}
		die();
	}
	
	//sinon on envoi le mail !
	$_SESSION['title'] = 'Archipel - Contact => Comments';
	sendMail($_SESSION, 'mail_contact/mail_comments.php');
	
	// succés
	if ($_SESSION['lang'] == 'fr') {
		header('Location: ../fr/contact/success.html');
	} else {
		header('Location: ../en/contact/success.html');
	}
	die();
}
