


// -----------------------------------------------------------------------------------------
// --- BERNIES GALLERY --- v1.0 --- 2006/05/20 ---------------------------------------------
// -----------------------------------------------------------------------------------------

Gallery.holder = {};

function Gallery() {
	// main defaults -------------------------------
	this.galleryId = 'myGallery';
	this.imageId   = 'galleryImg';
	this.descId    = 'galleryDsc';
	// ---------------------------------------------
	// preload codes -------------------------------
	this.mainPreload = 'loading image @@ ...';
	this.prevPreload = 'loading page @@ ...';
	// ---------------------------------------------
	// previews defaults ---------------------------
	this.prevId    = 'galleryPreviews';
	this.pageId    = 'prevPage';
	this.pageClass    = 'prevPage';
	this.preloadClass = 'preload';
	this.prevItemsPerPage = 6;
	this.prevX = 0;
	this.prevY = 0;
	this.prevDur = 300;
	this.prevAcc = -1;
	this.prevPageWidth = 200;
	// ---------------------------------------------
	// navigation defaults -------------------------
	this.prevNavId  = 'gNavLeft';
	this.prevNav    = '<a href="@@">&laquo;</a>';
	this.noPrevNav  = '<em>&laquo;</em>';
	this.nextNavId  = 'gNavRight';
	this.nextNav    = '<a href="@@">&raquo;</a>';
	this.noNextNav  = '<em>&raquo;</em>';
	this.pageNavId  = 'gNavPage';
	this.pagesNavId = 'gNavPages';
	// ---------------------------------------------
	this.data = {};
	this.images = {};
}


// INIT ------------------------------------------------------------------------------------
Gallery.prototype.init = function() {
	var o = this;
	// init main -----------------------------------
	o.galleryImg = o.getElemRef( o.imageId );
	o.galleryDsc = o.getElemRef( o.descId );
	o.currImage  = null;
	// ---------------------------------------------
	// init previews -------------------------------
	o.pE = o.getElemRef( o.prevId );
	if ( !o.pE ) return;
	o.slideOK   = false;
	o.currPage  = 1;
	o.objCount  = o.data.images;
	o.pageCount = Math.ceil( o.objCount / o.prevItemsPerPage );
	// ---------------------------------------------
	// create preloadCounter prototype -------------
	function PreloadCounter() {}
	PreloadCounter.prototype.length = function() { var x=0; for (i in this) { x++; }; return x-1; }
	// ---------------------------------------------
	// init previewdata ----------------------------
	o.pageData = new Array();
	for( i=0; i<=o.pageCount-1; i++ ) {
		o.pageData[i] = { 'shown':false, 
											'preload':new PreloadCounter,
											'code':'',
											'thumbnails':[] };
		var startIdx = i * o.prevItemsPerPage;
		var k = 0, j = startIdx;
		while ( j <= startIdx+o.prevItemsPerPage-1 && o.objCount > j  ) {
			o.pageData[i].thumbnails[k] = { 'path':o.data['thnPath'] + (j+1) + '.jpg', 
																		  'img':new Image };
			k++; j++; }
	}
	// ---------------------------------------------
	// create preview code -------------------------
	var j = 1;
	for ( i in o.pageData ) {
		var p = o.pageData[ parseInt(i) ];
		var imgCount = p.thumbnails.length, content='', i = 0;
		while ( (imgCount--) > 0 ) {
			content += '<div><a href="javascript:' + o.galleryId + '.showImage(' + (j++) + ');">' +
			           '<img src="' + p.thumbnails[ i++ ].path + '" alt="Dummy" /></a>';
			if ( imgCount > 0 ) { content += '<a href="javascript:' + o.galleryId + '.showImage(' + (j++) + ');">' +
									 					'<img src="' + p.thumbnails[ i++ ].path + '" alt="Dummy" /></a>'; imgCount--; }
			content += '</div>\n'; }
		p.code = content;
	}
	// ---------------------------------------------
	// init navigation -----------------------------
	o.pN  = o.getElemRef( o.prevNavId );
	o.nN  = o.getElemRef( o.nextNavId ); 
	o.psN = o.getElemRef( o.pagesNavId ); 
	o.defpN = o.prevNav.replace(/@@/,'javascript:'+ o.galleryId +'.previousPage();');
	o.defnN = o.nextNav.replace(/@@/,'javascript:'+ o.galleryId +'.nextPage();');
	// ---------------------------------------------
	// init slider ---------------------------------
	Gallery.holder[ o.prevId ] = o;
	o.animString = "Gallery.holder." + o.prevId;
	var px = window.opera ? 0 : "px";
	if ( o.prevX ) { o.pE.style.left = o.prevX + px; }
	if ( o.prevY ) { o.pE.style.top = o.prevY + px; }
	// ---------------------------------------------
	// init default content & page navigation ------
	var initContent = '';
	var initPageNav = '';
	for ( i=1; i<=o.pageCount; i++ ) {
		initContent += '<div id="' + o.pageId + i + '" class="' + o.pageClass + '">&nbsp;</div>';
		initPageNav += '<a href="javascript:' + o.galleryId + '.gotoPage(' + i + ');" id="' + 
									 o.pageNavId + i + '">' + i + '</a> ';
	}
	o.pE.innerHTML = initContent;
	o.psN.innerHTML = initPageNav;
	// ---------------------------------------------
	// display gallery -----------------------------
	o.checkNav();
	for (p in o.pageData) {
		for ( i in o.pageData[ +p ].thumbnails ) { o.preloadThumbnail( +p+1, +i+1 ); }
	}
	o.showPage( 1 );
	o.showImage( 1 );
	o.slideOK = true;
}
// -----------------------------------------------------------------------------------------


// SHOW IMAGE ------------------------------------------------------------------------------
Gallery.prototype.showImage = function( image ) {
	var o = this;
	o.currImage = image;
	if ( o.images[ image ] && o.images[ image ].preload == true ) { o.displayImage( image ); return; }
	o.galleryImg.innerHTML = o.mainPreload.replace( /@@/, image );
	o.preloadImage( image );
	var t1;
	testFn = function() {
		if ( o.images[ image ].preload == true ) { o.displayImage( image ); clearInterval( t1 ); }
		else if ( o.currImage != image ) { clearInterval( t1 ); }
	}
	t1 = setInterval( testFn, 500 );
}
// DISPLAY IMAGE ---------------------------------------------------------------------------
Gallery.prototype.displayImage = function( image ) {
	var o = this;
	o.galleryImg.innerHTML = '<img src="'+o.images[ image ].src+'" alt="Gallery Image" id="galleryImg" />'
	o.galleryDsc.innerHTML = ''
	if ( o.data['descriptions'].hasOwnProperty( image ) ) { 
		o.galleryDsc.innerHTML = o.data['descriptions'][ image ]
	}
}
// -----------------------------------------------------------------------------------------
// PRELOAD IMAGE ---------------------------------------------------------------------------
Gallery.prototype.preloadImage = function( image ) {
	var o = this;
	o.images[ image ] = new Image();
	var oImg = o.images[ image ];
	oImg.preload = false;
	oImg.parent = o;
	oImg.image = image;
	oImg.onload  = o.onImageLoad;
	oImg.onerror = o.onImageError;
	oImg.onabort = o.onImageAbort;
	oImg.src = o.data['imgPath'] + image + '.jpg';
}
Gallery.prototype.onImageLoad = function() {
	var oImg = this;
	// onImageLoad
  oImg.parent.onImageComplete( oImg.image, true );
}
Gallery.prototype.onImageError = function() {
	var oImg = this;
	// onImageError
	oImg.parent.onImageComplete( oImg.image, false );
}
Gallery.prototype.onImageAbort = function() {
	var oImg = this;
	// onImageAbort
	oImg.parent.onImageComplete( oImg.image, false );
}
Gallery.prototype.onImageComplete = function( image, status ) {
	var o = this;
	o.images[ image ].preload = true;
}
// -----------------------------------------------------------------------------------------



// PREVIOUS PAGE ---------------------------------------------------------------------------
Gallery.prototype.previousPage = function() {
	var o = this;
	if ( o.currPage==1 || ! o.slideOK ) return;
	if ( o.pageData[ o.currPage-2 ].shown==false ) { o.showPage( o.currPage-1 ) }
	var newPos = ( o.currPage-2 ) * o.prevPageWidth;
	o.slideTo( -newPos, 0 );
	o.currPage--;
	o.checkNav();
}
// -----------------------------------------------------------------------------------------
// NEXT PAGE -------------------------------------------------------------------------------
Gallery.prototype.nextPage = function() {
	var o = this;
	if ( o.currPage==o.pageCount || ! o.slideOK ) return;
	if ( o.pageData[ o.currPage ].shown==false ) { o.showPage( o.currPage+1 ) }
	var newPos = o.currPage * o.prevPageWidth;
	o.slideTo( -newPos, 0 );
	o.currPage++;
	o.checkNav();
}
// -----------------------------------------------------------------------------------------
// GO TO PAGE -------------------------------------------------------------------------------
Gallery.prototype.gotoPage = function( page ) {
	var o = this;
	if ( page<1 || page>o.pageCount || ! o.slideOK ) return;
	if ( o.currPage<page ) { for ( i=o.currPage+1; i<=page; i++ ) { o.showPage( i ) } }
	if ( o.currPage>page ) { for ( i=o.currPage-1; i>=page; i-- ) { o.showPage( i ) } }
	var newPos = ( page-1 ) * o.prevPageWidth;
	o.slideTo( -newPos, 0 );
	o.currPage = page;
	o.checkNav();
}
// -----------------------------------------------------------------------------------------



// SHOW PAGE --------------------------------------------------------------------------------
Gallery.prototype.showPage = function( page ) {
	var o = this;
	var p = o.pageData[ page-1 ];
	if ( p.shown == true ) { return; }
	if ( p.preload.length() == p.thumbnails.length ) { o.displayPage( page ); return; }
	
	var content = o.prevPreload.replace( /@@/, page );
	var e = o.getElemRef( o.pageId+page );
	e.innerHTML = '';
	//e.className = o.pageClass + ' ' + o.preloadClass;
	tOut = setTimeout( function() { e.innerHTML = content; }, 100 );
	var t1;
	testFn = function() {
		if ( p.preload.length() == p.thumbnails.length ) { o.displayPage( page ); clearInterval( t1 ); }
	}
	t1 = setInterval( testFn, 500 );
}
// -----------------------------------------------------------------------------------------
// DISPLAY PAGE ----------------------------------------------------------------------------
Gallery.prototype.displayPage = function( page ) {
	var o = this;
	var p = o.pageData[ page-1 ];
	var e = o.getElemRef( o.pageId+page );
	e.innerHTML = '';
	//e.className = o.pageClass;
	tOut = setTimeout( function() { e.innerHTML = p.code; }, 100 );
	p.shown = true;
}
// -----------------------------------------------------------------------------------------
// HIDE PAGE -------------------------------------------------------------------------------
Gallery.prototype.hidePage = function( page ) {
	var o = this;
	var p = o.pageData[ page-1 ];
	if ( p.shown == false ) { return; }
	var e = o.getElemRef( o.pageId+page );
	//e.className = o.pageClass;
	e.innerHTML = ''; 
	p.shown = false;
}
// -----------------------------------------------------------------------------------------
// HIDE UNUSED PAGES -----------------------------------------------------------------------
Gallery.prototype.hideUnusedPages = function() {
	var o = this;
	for ( i=1; i<=o.pageCount; i++ ) {
		if ( i != o.currPage && o.pageData[i-1].shown == true ) { o.hidePage( i ); }
	}
}
// -----------------------------------------------------------------------------------------
// PRELOAD THUMBNAIL -----------------------------------------------------------------------
Gallery.prototype.preloadThumbnail = function( page, image ) {
	var o = this;
	var oImg = o.pageData[ page-1 ].thumbnails[ image-1 ].img;
	oImg.parent = o;
	oImg.page = page;
	oImg.image = image;
	oImg.onload  = o.onThumbnailLoad;
	oImg.onerror = o.onThumbnailError;
	oImg.onabort = o.onThumbnailAbort;
	oImg.src = o.pageData[ page-1 ].thumbnails[ image-1 ].path;
}
Gallery.prototype.onThumbnailLoad = function() {
	var oImg = this;
	// onImageLoad
  oImg.parent.onThumbnailComplete( oImg.page, oImg.image, true );
}
Gallery.prototype.onThumbnailError = function() {
	var oImg = this;
	// onImageError
	oImg.parent.onThumbnailComplete( oImg.page, oImg.image, false );
}
Gallery.prototype.onThumbnailAbort = function() {
	var oImg = this;
	// onImageAbort
	oImg.parent.onThumbnailComplete( oImg.page, oImg.image, false );
}
Gallery.prototype.onThumbnailComplete = function( page, image, status ) {
	var o = this;
	o.pageData[ page-1 ].preload[ image-1 ] = true;
}
// -----------------------------------------------------------------------------------------



// CHECK NAV --------------------------------------------------------------------------------
Gallery.prototype.checkNav = function() {
  var o = this;
	if ( o.currPage == 1 ) { o.pN.innerHTML = o.noPrevNav; } else { o.pN.innerHTML = o.defpN }
	if ( o.currPage == o.pageCount ) { o.nN.innerHTML = o.noNextNav; } else { o.nN.innerHTML = o.defnN }
	for ( i=1; i<=o.pageCount; i++ ) {
		var pM = o.getElemRef( o.pageNavId+i );
		if ( i == o.currPage ) { pM.className = 'active' } else { pM.className = null }
	}
}
// -----------------------------------------------------------------------------------------



// SUPPORT SECTION -------------------------------------------------------------------------
// shift to --------------------------------------------------------------------------------
Gallery.prototype.shiftTo = function( x, y ) {
	var o = this;
  var pE = o.pE ? o.pE : o.getElemRef( o.prevId ) ? o.getElemRef( o.prevId ) : null;
  if ( pE ) {
    if ( x != null ) pE.style.left = (o.prevX = x) + "px";
    if ( y != null ) pE.style.top = (o.prevY = y) + "px";
  }
}
// shift by --------------------------------------------------------------------------------
Gallery.prototype.shiftBy = function( x, y ) { 
	var o = this;
	o.shiftTo( o.prevX+x, o.prevY+y ); 
}
// slide to --------------------------------------------------------------------------------
Gallery.prototype.slideTo = function ( destX, destY, startFn, endFn ) {
	var o = this;
  if ( ! document.getElementById ) return;
  o.prevDur = o.prevDur || .0001; 
	o.prevAcc = -o.prevAcc || 0;
	if ( startFn ) { o.onSlideStart = startFn; }
  if ( endFn ) { o.onSlideEnd = endFn; }
 	if ( destX == null ) { o.destX = o.prevX;	} else { o.destX = destX; }
  if ( destY == null ) { o.destY = o.prevY; } else { o.destY = destY; }
  o.startX = o.prevX; 
	o.startY = o.prevY;
	o.startTime = new Date().getTime();
  o.xc1 = o.prevX + ( (1 + o.prevAcc) * (o.destX - o.prevX) /3 );
	o.xc2 = o.prevX + ( (2 + o.prevAcc) * (o.destX - o.prevX) /3 );
  o.yc1 = o.prevY + ( (1 + o.prevAcc) * (o.destY - o.prevY) /3 );
	o.yc2 = o.prevY + ( (2 + o.prevAcc) * (o.destY - o.prevY) /3 );
	o.sliding = true;
  o.onSlideStart();
  dw_Animation.add( o.animString + ".doSlide()" );
}
// slide by --------------------------------------------------------------------------------
Gallery.prototype.slideBy = function( x, y, startFn, endFn ) {
	var o = this;
	o.slideTo(  o.prevX+x, o.prevY+y, startFn, endFn );
}
// support ---------------------------------------------------------------------------------
Gallery.prototype.onSlideStart = function () {}
Gallery.prototype.onSlideEnd = function () {
	var o = this;
	o.hideUnusedPages();
}
Gallery.prototype.doSlide = function() {
	var o = this;
	if ( ! o.sliding ) return;	
	var elapsed = new Date().getTime() - o.startTime;
	if ( elapsed < o.prevDur ) {
    var x = dw_Bezier.getValue( elapsed/o.prevDur, o.startX, o.destX, o.xc1, o.xc2 );
    var y = dw_Bezier.getValue( elapsed/o.prevDur, o.startY, o.destY, o.yc1, o.yc2 );
		o.shiftTo( Math.round(x) ,Math.round(y) );
	} else {
    dw_Animation.remove( o.animString + ".doSlide()" );
		o.shiftTo( o.destX, o.destY );
		o.sliding = false;
		o.onSlideEnd();
		if ( o.pE ) { o.pE = null; }
	}
}
Gallery.prototype.getElemRef = function( id ) { 
  var element = document.getElementById ? document.getElementById( id ) : null;
  return element;
}
dw_Bezier = {
  B1: function (t) { return t*t*t },
  B2: function (t) { return 3*t*t*(1-t) },
  B3: function (t) { return 3*t*(1-t)*(1-t) },
  B4: function (t) { return (1-t)*(1-t)*(1-t) },
  getValue: function (percent,startVal,endVal,c1,c2) { return endVal * this.B1(percent) + c2 * this.B2(percent) + c1 * this.B3(percent) + startVal * this.B4(percent); }
}
dw_Animation = {
  instances: [],
  add: function(fp) { this.instances[this.instances.length] = fp; if (this.instances.length == 1) this.timerID = window.setInterval("dw_Animation.control()", 10); },
  remove: function(fp) { for (var i = 0; this.instances[i]; i++) { if (fp == this.instances[i]) { this.instances = this.instances.slice(0,i).concat( this.instances.slice(i+1) ); break; } } if (this.instances.length == 0) { window.clearInterval(this.timerID);	this.timerID = null; } },
  control: function() { for (var i = 0; this.instances[i]; i++) { if (typeof this.instances[i] == "function" ) this.instances[i](); else eval(this.instances[i]); } }
}

//Gallery.holder={};function Gallery(){this.galleryId='myGallery';this.imageId='galleryImg';this.descId='galleryDsc';this.mainPreload='loading image @@ ...';this.prevPreload='loading page @@ ...';this.prevId='galleryPreviews';this.pageId='prevPage';this.pageClass='prevPage';this.preloadClass='preload';this.prevItemsPerPage=6;this.prevX=0;this.prevY=0;this.prevDur=300;this.prevAcc=-1;this.prevPageWidth=200;this.prevNavId='gNavLeft';this.prevNav='<a href="@@">&laquo;</a>';this.noPrevNav='<em>&laquo;</em>';this.nextNavId='gNavRight';this.nextNav='<a href="@@">&raquo;</a>';this.noNextNav='<em>&raquo;</em>';this.pageNavId='gNavPage';this.pagesNavId='gNavPages';this.data={};this.images={};};Gallery.prototype.init=function(){var o=this;o.galleryImg=o.getElemRef(o.imageId);o.galleryDsc=o.getElemRef(o.descId);o.currImage=null;o.pE=o.getElemRef(o.prevId);if(!o.pE)return;o.slideOK=false;o.currPage=1;o.objCount=o.data.images;o.pageCount=Math.ceil(o.objCount/o.prevItemsPerPage);function PreloadCounter(){};PreloadCounter.prototype.length=function(){var x=0;for(i in this){x++;};return x-1;};o.pageData=new Array();for(i=0;i<=o.pageCount-1;i++){o.pageData[i]={'shown':false,'preload':new PreloadCounter,'code':'','thumbnails':[]};var startIdx=i*o.prevItemsPerPage;var k=0,j=startIdx;while(j<=startIdx+o.prevItemsPerPage-1&&o.objCount>j){o.pageData[i].thumbnails[k]={'path':o.data['thnPath']+(j+1)+'.jpg','img':new Image};k++;j++;};};var j=1;for(i in o.pageData){var p=o.pageData[parseInt(i)];var imgCount=p.thumbnails.length,content='',i=0;while((imgCount--)>0){content+='<div><a href="javascript:'+o.galleryId+'.showImage('+(j++)+');">'+'<img src="'+p.thumbnails[i++].path+'" alt="Dummy" /></a>';if(imgCount>0){content+='<a href="javascript:'+o.galleryId+'.showImage('+(j++)+');">'+'<img src="'+p.thumbnails[i++].path+'" alt="Dummy" /></a>';imgCount--;};content+='</div>\n';};p.code=content;};o.pN=o.getElemRef(o.prevNavId);o.nN=o.getElemRef(o.nextNavId);o.psN=o.getElemRef(o.pagesNavId);o.defpN=o.prevNav.replace(/@@/,'javascript:'+o.galleryId+'.previousPage();');o.defnN=o.nextNav.replace(/@@/,'javascript:'+o.galleryId+'.nextPage();');Gallery.holder[o.prevId]=o;o.animString="Gallery.holder."+o.prevId;var px=window.opera?0:"px";if(o.prevX){o.pE.style.left=o.prevX+px;};if(o.prevY){o.pE.style.top=o.prevY+px;};var initContent='';var initPageNav='';for(i=1;i<=o.pageCount;i++){initContent+='<div id="'+o.pageId+i+'" class="'+o.pageClass+'">&nbsp;</div>';initPageNav+='<a href="javascript:'+o.galleryId+'.gotoPage('+i+');" id="'+o.pageNavId+i+'">'+i+'</a> ';};o.pE.innerHTML=initContent;o.psN.innerHTML=initPageNav;o.checkNav();for(p in o.pageData){for(i in o.pageData[+p].thumbnails){o.preloadThumbnail(+p+1,+i+1);};};o.showPage(1);o.showImage(1);o.slideOK=true;};Gallery.prototype.showImage=function(image){var o=this;o.currImage=image;if(o.images[image]&&o.images[image].preload==true){o.displayImage(image);return;};o.galleryImg.innerHTML=o.mainPreload.replace(/@@/,image);o.preloadImage(image);var t1;testFn=function(){if(o.images[image].preload==true){o.displayImage(image);clearInterval(t1);}else if(o.currImage!=image){clearInterval(t1);};};t1=setInterval(testFn,500);};Gallery.prototype.displayImage=function(image){var o=this;o.galleryImg.innerHTML='<img src="'+o.images[image].src+'" alt="Gallery Image" id="galleryImg" />';o.galleryDsc.innerHTML='';if(o.data['descriptions'].hasOwnProperty(image)){o.galleryDsc.innerHTML=o.data['descriptions'][image]};};Gallery.prototype.preloadImage=function(image){var o=this;o.images[image]=new Image();var oImg=o.images[image];oImg.preload=false;oImg.parent=o;oImg.image=image;oImg.onload=o.onImageLoad;oImg.onerror=o.onImageError;oImg.onabort=o.onImageAbort;oImg.src=o.data['imgPath']+image+'.jpg';};Gallery.prototype.onImageLoad=function(){var oImg=this;oImg.parent.onImageComplete(oImg.image,true);};Gallery.prototype.onImageError=function(){var oImg=this;oImg.parent.onImageComplete(oImg.image,false);};Gallery.prototype.onImageAbort=function(){var oImg=this;oImg.parent.onImageComplete(oImg.image,false);};Gallery.prototype.onImageComplete=function(image,status){var o=this;o.images[image].preload=true;};Gallery.prototype.previousPage=function(){var o=this;if(o.currPage==1||!o.slideOK)return;if(o.pageData[o.currPage-2].shown==false){o.showPage(o.currPage-1)};var newPos=(o.currPage-2)*o.prevPageWidth;o.slideTo(-newPos,0);o.currPage--;o.checkNav();};Gallery.prototype.nextPage=function(){var o=this;if(o.currPage==o.pageCount||!o.slideOK)return;if(o.pageData[o.currPage].shown==false){o.showPage(o.currPage+1)};var newPos=o.currPage*o.prevPageWidth;o.slideTo(-newPos,0);o.currPage++;o.checkNav();};Gallery.prototype.gotoPage=function(page){var o=this;if(page<1||page>o.pageCount||!o.slideOK)return;if(o.currPage<page){for(i=o.currPage+1;i<=page;i++){o.showPage(i)}};if(o.currPage>page){for(i=o.currPage-1;i>=page;i--){o.showPage(i)}};var newPos=(page-1)*o.prevPageWidth;o.slideTo(-newPos,0);o.currPage=page;o.checkNav();};Gallery.prototype.showPage=function(page){var o=this;var p=o.pageData[page-1];if(p.shown==true){return;};if(p.preload.length()==p.thumbnails.length){o.displayPage(page);return;};var content=o.prevPreload.replace(/@@/,page);var e=o.getElemRef(o.pageId+page);e.innerHTML='';tOut=setTimeout(function(){e.innerHTML=content;},100);var t1;testFn=function(){if(p.preload.length()==p.thumbnails.length){o.displayPage(page);clearInterval(t1);};};t1=setInterval(testFn,500);};Gallery.prototype.displayPage=function(page){var o=this;var p=o.pageData[page-1];var e=o.getElemRef(o.pageId+page);e.innerHTML='';tOut=setTimeout(function(){e.innerHTML=p.code;},100);p.shown=true;};Gallery.prototype.hidePage=function(page){var o=this;var p=o.pageData[page-1];if(p.shown==false){return;};var e=o.getElemRef(o.pageId+page);e.innerHTML='';p.shown=false;};Gallery.prototype.hideUnusedPages=function(){var o=this;for(i=1;i<=o.pageCount;i++){if(i!=o.currPage&&o.pageData[i-1].shown==true){o.hidePage(i);};};};Gallery.prototype.preloadThumbnail=function(page,image){var o=this;var oImg=o.pageData[page-1].thumbnails[image-1].img;oImg.parent=o;oImg.page=page;oImg.image=image;oImg.onload=o.onThumbnailLoad;oImg.onerror=o.onThumbnailError;oImg.onabort=o.onThumbnailAbort;oImg.src=o.pageData[page-1].thumbnails[image-1].path;};Gallery.prototype.onThumbnailLoad=function(){var oImg=this;oImg.parent.onThumbnailComplete(oImg.page,oImg.image,true);};Gallery.prototype.onThumbnailError=function(){var oImg=this;oImg.parent.onThumbnailComplete(oImg.page,oImg.image,false);};Gallery.prototype.onThumbnailAbort=function(){var oImg=this;oImg.parent.onThumbnailComplete(oImg.page,oImg.image,false);};Gallery.prototype.onThumbnailComplete=function(page,image,status){var o=this;o.pageData[page-1].preload[image-1]=true;};Gallery.prototype.checkNav=function(){var o=this;if(o.currPage==1){o.pN.innerHTML=o.noPrevNav;}else{o.pN.innerHTML=o.defpN};if(o.currPage==o.pageCount){o.nN.innerHTML=o.noNextNav;}else{o.nN.innerHTML=o.defnN};for(i=1;i<=o.pageCount;i++){var pM=o.getElemRef(o.pageNavId+i);if(i==o.currPage){pM.className='active'}else{pM.className=null};};};Gallery.prototype.shiftTo=function(x,y){var o=this;var pE=o.pE?o.pE:o.getElemRef(o.prevId)?o.getElemRef(o.prevId):null;if(pE){if(x!=null)pE.style.left=(o.prevX=x)+"px";if(y!=null)pE.style.top=(o.prevY=y)+"px";};};Gallery.prototype.shiftBy=function(x,y){var o=this;o.shiftTo(o.prevX+x,o.prevY+y);};Gallery.prototype.slideTo=function(destX,destY,startFn,endFn){var o=this;if(!document.getElementById)return;o.prevDur=o.prevDur||.0001;o.prevAcc=-o.prevAcc||0;if(startFn){o.onSlideStart=startFn;};if(endFn){o.onSlideEnd=endFn;};if(destX==null){o.destX=o.prevX;}else{o.destX=destX;};if(destY==null){o.destY=o.prevY;}else{o.destY=destY;};o.startX=o.prevX;o.startY=o.prevY;o.startTime=new Date().getTime();o.xc1=o.prevX+((1+o.prevAcc)*(o.destX-o.prevX)/3);o.xc2=o.prevX+((2+o.prevAcc)*(o.destX-o.prevX)/3);o.yc1=o.prevY+((1+o.prevAcc)*(o.destY-o.prevY)/3);o.yc2=o.prevY+((2+o.prevAcc)*(o.destY-o.prevY)/3);o.sliding=true;o.onSlideStart();dw_Animation.add(o.animString+".doSlide()");};Gallery.prototype.slideBy=function(x,y,startFn,endFn){var o=this;o.slideTo(o.prevX+x,o.prevY+y,startFn,endFn);};Gallery.prototype.onSlideStart=function(){};Gallery.prototype.onSlideEnd=function(){var o=this;o.hideUnusedPages();};Gallery.prototype.doSlide=function(){var o=this;if(!o.sliding)return;var elapsed=new Date().getTime()-o.startTime;if(elapsed<o.prevDur){var x=dw_Bezier.getValue(elapsed/o.prevDur,o.startX,o.destX,o.xc1,o.xc2);var y=dw_Bezier.getValue(elapsed/o.prevDur,o.startY,o.destY,o.yc1,o.yc2);o.shiftTo(Math.round(x),Math.round(y));}else{dw_Animation.remove(o.animString+".doSlide()");o.shiftTo(o.destX,o.destY);o.sliding=false;o.onSlideEnd();if(o.pE){o.pE=null;};};};Gallery.prototype.getElemRef=function(id){var element=document.getElementById?document.getElementById(id):null;return element;};dw_Bezier={B1:function(t){return t*t*t},B2:function(t){return 3*t*t*(1-t)},B3:function(t){return 3*t*(1-t)*(1-t)},B4:function(t){return (1-t)*(1-t)*(1-t)},getValue:function(p,s,e,c1,c2){return e*this.B1(p)+c2*this.B2(p)+c1*this.B3(p)+s*this.B4(p);}};dw_Animation={s:[],add:function(fp){this.s[this.s.length]=fp;if(this.s.length==1)this.t=window.setInterval("dw_Animation.control()",10);},remove:function(fp){for(var i=0;this.s[i];i++){if(fp==this.s[i]){this.s=this.s.slice(0,i).concat(this.s.slice(i+1));break;}}if(this.s.length==0){window.clearInterval(this.t);this.t=null;}},control:function(){for(var i=0;this.s[i];i++){if(typeof this.s[i]=="function")this.s[i]();else eval(this.s[i]);}}}