<?php
require_once(  get_template_directory() . '/admin/importer/importer/helpers.php' ); //load admin theme data importer
require_once(  get_template_directory() . '/admin/importer/importer/okthemes-importer.php' ); //load admin theme data importer

class luxuryvilla_OKThemes_Theme_Demo_Data_Importer extends luxuryvilla_OKThemes_Theme_Importer {

    /**
     * Holds a copy of the object for easy reference.
     *
     * @since 2.2.0
     *
     * @var object
     */
    private static $instance;
    
    /**
     * Set the key to be used to store theme options
     *
     * @since 2.2.0
     *
     * @var object
     */
    public $theme_option_name         = 'my_theme_options'; //set theme options name here
    
    public $theme_options_file_name   = 'theme_options.json';
    
    public $widgets_file_name         =  'widgets.json';
    
    public $content_demo_file_name    =  'content.xml';
	
	/**
	 * Holds a copy of the widget settings 
	 *
	 * @since 2.2.0
	 *
	 * @var object
	 */
	public $widget_import_results;
	
    /**
     * Constructor. Hooks all interactions to initialize the class.
     *
     * @since 2.2.0
     */
    public function __construct() {
        
		$this->demo_files_path = get_template_directory() . '/admin/importer/demo-files/';

        self::$instance = $this;
		parent::__construct();

        add_action( 'admin_init', array($this, 'luxuryvilla_theme_activation') );
        add_action( 'admin_menu', array($this, 'luxuryvilla_add_admin') );
        add_action( 'admin_print_scripts', array($this, 'luxuryvilla_enqueue_admin_assets') );
    }

    // Custom assets for admin pages
    function luxuryvilla_enqueue_admin_assets() {
        wp_enqueue_style( 'luxuryvilla-theme-admin', get_template_directory_uri() . '/admin/importer/assets/admin-style.css' );
    }

    // Redirect to Demo Import page after Theme activation
    public function luxuryvilla_theme_activation() {
        global $pagenow;
        if ( is_admin() AND $pagenow == 'themes.php' AND isset( $_GET['activated'] ) ) {
            //Redirect to demo import
            header( 'Location: ' . admin_url( 'admin.php?page=luxuryvilla-home' ) );
        }
    }

    /**
     * Add Panel Page
     *
     * @since 2.2.0
     */
    public function luxuryvilla_add_admin() {
        //Output buffering
        ob_start();
        add_theme_page("About the theme", "About the theme", 'switch_themes', 'luxuryvilla-home', array($this, 'luxuryvilla_welcome_page'));
        add_theme_page("Import Demo Data", "Import Demo Data", 'switch_themes', 'luxuryvilla-demo-import', array($this, 'luxuryvilla_demo_installer'));
        if ( class_exists( 'acf' ) ) {
            add_theme_page("Customizer Import", "Import theme options", 'switch_themes', 'import', array($this, 'luxuryvilla_import_option_page'));
            add_theme_page("Customizer Export", "Export theme options", 'switch_themes', 'export', array($this, 'luxuryvilla_export_option_page'));
        }
    }


    // Menus to Import and assign
	public function luxuryvilla_set_demo_menus(){
		
        $main_menu    = get_term_by('name', 'Main', 'nav_menu');

		set_theme_mod( 'nav_menu_locations', array(
                'main-menu'   => $main_menu->term_id
            )
        );
    }

    // Remove hello and sample post/page
    public function luxuryvilla_remove_hello_post(){

        //Remove the hello world post
        wp_delete_post(1);

        //Remove the samples pages
        wp_delete_post(2);
    }

    //Set the page options
    public function luxuryvilla_set_page_options(){

        //Set the frontpage and the blog page
        $frontpage = get_page('28');
        $blogpage  = get_page('815');

        update_option('show_on_front', 'page');    // show on front a static page
        update_option('page_on_front', $frontpage->ID);
        update_option('page_for_posts', $blogpage->ID);

    }

    public function luxuryvilla_welcome_page() {

        $theme = wp_get_theme();
        if ( is_child_theme() ) {
            $theme = wp_get_theme( $theme->get( 'Template' ) );
        }
        $theme_name = $theme->get( 'Name' );
        $theme_version = $theme->get( 'Version' );

        $return_url = admin_url('admin.php?page=luxuryvilla-home');

        
        ?>
        
        <div class="gg-admin-welcome-page">
            

            <div class="welcome-panel" style="padding-bottom: 23px;">
                <div class="welcome-panel-content">

                    <h2><?php echo sprintf( __( 'Welcome to <strong>%s</strong>', 'luxuryvilla' ), $theme_name . ' ' . $theme_version ) ?></h2>
                    <p class="about-description"><?php esc_html_e( 'Beautifully crafted WordPress theme ready to take your property to the next level.', 'luxuryvilla' ) ?></p>

                    <div class="welcome-panel-column-container">
                        <div class="welcome-panel-column">
                            <h3><i class="dashicons dashicons-screenoptions"></i><?php esc_html_e( 'Install Plugins', 'luxuryvilla' ) ?></h3>
                            <p><?php echo sprintf( __( '%s has bundled popular premium plugins which greatly increases the flexibility of the theme. Install them in order to maximize the theme power.', 'luxuryvilla' ), $theme_name ); ?></p>
                            <a class="button button-primary" href="<?php echo admin_url( 'admin.php?page=tgmpa-install-plugins' ); ?>"><?php esc_html_e( 'Install Plugins', 'luxuryvilla' ) ?></a>
                        </div>
                        <div class="welcome-panel-column">
                            <h3><i class="dashicons dashicons-download"></i><?php esc_html_e( 'Import Demo Content', 'luxuryvilla' ) ?></h3>
                            <p><?php esc_html_e( 'If you have installed this theme on a clean WordPress installation then this is where you\'ll want to go next. This feature imports the demo content.', 'luxuryvilla' ) ?></p>
                            <a class="button button-primary" href="<?php echo admin_url( 'admin.php?page=luxuryvilla-demo-import' ); ?>">
                                <?php esc_html_e( 'Import Demo Content', 'luxuryvilla' ) ?></a>
                        </div>
                        <div class="welcome-panel-column welcome-panel-last">
                            <h3><i class="dashicons dashicons-admin-appearance"></i><?php esc_html_e( 'Customize Appearance', 'luxuryvilla' ) ?></h3>
                            <p><?php esc_html_e( 'Customize the look and feel of your site with the help of the Theme Options panel.', 'luxuryvilla' ) ?></p>
                            <a class="button button-primary" href="<?php echo admin_url( 'customize.php' ); ?>"><?php esc_html_e( 'Go to Theme Options', 'luxuryvilla' ) ?></a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="footer" style="display:none;">
                <ul">
                    <li>
                        <i class="dashicons dashicons-editor-help"></i>
                        <a href="#" target="_blank"><?php esc_html_e( 'Online Documentation', 'luxuryvilla' ) ?></a>
                    </li>
                    <li>
                        <i class="dashicons dashicons-sos"></i>
                        <a href="#" target="_blank"><?php esc_html_e( 'Support Portal', 'luxuryvilla' ) ?></a>
                    </li>
                    <li>
                        <i class="dashicons dashicons-backup"></i>
                        <a href="#" target="_blank"><?php esc_html_e( 'Theme Changelog', 'luxuryvilla' ) ?></a>
                    </li>
                </ul>
            </div>

        </div>
        <?php
    }     


}

new luxuryvilla_OKThemes_Theme_Demo_Data_Importer;