<?php
if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array (
    'key' => 'group_56cc290ef387a',
    'title' => 'Exclude categories',
    'fields' => array (
        array (
            'key' => 'field_56cc291ac270e',
            'label' => 'Exclude categories',
            'name' => 'gg_exclude_categories',
            'type' => 'taxonomy',
            'instructions' => 'Exclude categories',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'taxonomy' => 'property_category',
            'field_type' => 'multi_select',
            'allow_null' => 0,
            'add_term' => 0,
            'save_terms' => 0,
            'load_terms' => 0,
            'return_format' => 'id',
            'multiple' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/areas-var2.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_55efffce78c76',
    'title' => 'Slideshow Options',
    'fields' => array (
        array (
            'key' => 'field_55effff0429a7',
            'label' => 'Slider autoplay',
            'name' => 'gg_slider_autoplay',
            'type' => 'true_false',
            'instructions' => 'Enable slider autoplay. This will autoplay the properties not the background images inside the properties.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 0,
        ),
        array (
            'key' => 'field_55f00066429a8',
            'label' => 'Slider autoplay speed',
            'name' => 'gg_slider_autoplay_speed',
            'type' => 'text',
            'instructions' => 'Insert the slider speed in milliseconds. Default is 5000, which means the slides will scrolling every 5 seconds.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_55effff0429a7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 5000,
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_55f0014809d61',
            'label' => 'Background images speed',
            'name' => 'gg_background_images_speed',
            'type' => 'text',
            'instructions' => 'Insert the background images speed in milliseconds. Default is 6000, which means the images will be rotating every 6 seconds.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 6000,
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var1.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var2.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_551e722700965',
    'title' => 'Advanced Search Options',
    'fields' => array (
        array (
            'key' => 'field_551e722709068',
            'label' => 'Advanced Search layout',
            'name' => 'gg_adv_search_layout',
            'type' => 'select',
            'instructions' => 'Select the advanced search layout',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'fitRows' => 'Grid Fit rows',
                'masonry' => 'Grid Masonry',
            ),
            'default_value' => array (
                'masonry' => 'masonry',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_551e722709459',
            'label' => 'Advanced Search layout style',
            'name' => 'gg_adv_search_layout_style',
            'type' => 'select',
            'instructions' => 'Select the advanced search layout style',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'gap' => 'Gap',
                'nogap' => 'No Gap',
            ),
            'default_value' => array (
                'gap' => 'gap',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_551e722709845',
            'label' => 'Advanced Search columns',
            'name' => 'gg_adv_search_columns',
            'type' => 'select',
            'instructions' => 'Select the number of columns',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
            ),
            'default_value' => array (
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/advanced-search.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_547c67fc97bed',
    'title' => 'General Homepage Options',
    'fields' => array (
        array (
            'key' => 'field_547c683d05fc0',
            'label' => 'Sidebar/Widget area',
            'name' => 'gg_homepage_sidebar',
            'type' => 'true_false',
            'instructions' => 'Enable/disable homepage sidebar',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_547c6e6fd071f',
            'label' => 'Quick reservation form',
            'name' => 'gg_homepage_qrf',
            'type' => 'true_false',
            'instructions' => 'Enable/disable the quick reservation form',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 0,
        ),
        array (
            'key' => 'field_54803484383de',
            'label' => 'Email address',
            'name' => 'gg_homepage_qrf_email',
            'type' => 'text',
            'instructions' => 'Enter your email address. On this address you will receive the emails from this booking form.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_547c6e6fd071f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => 50,
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_548034ad383df',
            'label' => 'From: Email address',
            'name' => 'gg_homepage_qrf_email_from',
            'type' => 'text',
            'instructions' => 'Enter the FROM email address. E.G.: noreply@yoursitename.com',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_547c6e6fd071f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => 50,
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_548034d4383e0',
            'label' => 'Success text',
            'name' => 'gg_homepage_qrf_success_msg',
            'type' => 'text',
            'instructions' => 'Enter the success message that will be displayed on successful email delivery.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_547c6e6fd071f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => 50,
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Your message was sent successfully.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_54803501383e1',
            'label' => 'Error text',
            'name' => 'gg_homepage_qrf_error_msg',
            'type' => 'text',
            'instructions' => 'Enter the error message that will be displayed on    email delivery failure.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_547c6e6fd071f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => 50,
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'There was an error submitting the form.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var1.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var2.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var3.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var4.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var5.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_5475ac121f54b',
    'title' => 'Homepage Style 3 & 4 Options',
    'fields' => array (
        array (
            'key' => 'field_5475ac2521ba9',
            'label' => 'Homepage images',
            'name' => 'gg_homepage_var3_images',
            'type' => 'gallery',
            'instructions' => 'Insert the images that will scroll on the homepage',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'min' => '',
            'max' => '',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => 0,
            'min_height' => 0,
            'min_size' => 0,
            'max_width' => 0,
            'max_height' => 0,
            'max_size' => 0,
            'mime_types' => '',
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var3.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var4.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_54705ec07b25b',
    'title' => 'Areas options (Gallery)',
    'fields' => array (
        array (
            'key' => 'field_54705ed1e3712',
            'label' => 'Gallery layout',
            'name' => 'gg_areas_gallery_layout',
            'type' => 'select',
            'instructions' => 'Select the gallery layout',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'fitRows' => 'Grid Fit rows',
                'masonry' => 'Grid Masonry',
            ),
            'default_value' => array (
                'masonry' => 'masonry',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54705f01e3713',
            'label' => 'Gallery layout style',
            'name' => 'gg_areas_gallery_layout_style',
            'type' => 'select',
            'instructions' => 'Select the gallery layout style',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'gap' => 'Gap',
                'nogap' => 'No Gap',
            ),
            'default_value' => array (
                'gap' => 'gap',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54705f2ae3714',
            'label' => 'Gallery columns',
            'name' => 'gg_areas_gallery_columns',
            'type' => 'select',
            'instructions' => 'Select the number of columns',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
            ),
            'default_value' => array (
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/areas-var2.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_5470546a711af',
    'title' => 'Areas options (Map)',
    'fields' => array (
        array (
            'key' => 'field_547055e4bb736',
            'label' => 'Property link (When you click on View more InfoWindow)',
            'name' => 'gg_areas_map_property_link',
            'type' => 'select',
            'instructions' => 'Select where the link goes when you click on the View more link from the InfoWindow',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'property_page' => 'On the property page',
                'ajax_page' => 'On the same page (It opens an ajax description area underneath the map)',
                'none' => 'Hides the View more link',
            ),
            'default_value' => array (
                'ajax_page' => 'ajax_page',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/areas.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_546f6edba0a16',
    'title' => 'Gallery Options',
    'fields' => array (
        array (
            'key' => 'field_546f6f0c116a8',
            'label' => 'Gallery layout',
            'name' => 'gg_gallery_layout',
            'type' => 'select',
            'instructions' => 'Select the gallery layout',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'fitRows' => 'Grid Fit rows',
                'masonry' => 'Grid Masonry',
            ),
            'default_value' => array (
                'masonry' => 'masonry',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_546f6f46116a9',
            'label' => 'Gallery layout style',
            'name' => 'gg_gallery_layout_style',
            'type' => 'select',
            'instructions' => 'Select the gallery layout style',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'gap' => 'Gap',
                'nogap' => 'No Gap',
            ),
            'default_value' => array (
                'gap' => 'gap',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_546f6f72116aa',
            'label' => 'Gallery columns',
            'name' => 'gg_gallery_columns',
            'type' => 'select',
            'instructions' => 'Select the number of columns',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
            ),
            'default_value' => array (
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/gallery.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_546f382ea7dc2',
    'title' => 'Booking Options',
    'fields' => array (
        array (
            'key' => 'field_546f383a57bd2',
            'label' => 'Email address',
            'name' => 'gg_booking_page_email',
            'type' => 'text',
            'instructions' => 'Enter your email address. On this address you will receive the emails from this booking form.',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546f386980878',
            'label' => 'From: Email address',
            'name' => 'gg_booking_page_email_from',
            'type' => 'text',
            'instructions' => 'Enter the FROM email address. E.G.: noreply@yoursitename.com',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'noreply@yoursitename.com',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546f3895bfe9f',
            'label' => 'Success text',
            'name' => 'gg_booking_page_success_msg',
            'type' => 'text',
            'instructions' => 'Enter the success message that will be displayed on successful email delivery.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Your message was sent successfully.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546f38bedd7eb',
            'label' => 'Error text',
            'name' => 'gg_booking_page_error_msg',
            'type' => 'text',
            'instructions' => 'Enter the error message that will be displayed on    email delivery failure.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'There was an error submitting the form.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/booking.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_546f25c33193d',
    'title' => 'Post Options',
    'fields' => array (
        array (
            'key' => 'field_546f260095c89',
            'label' => 'Post image',
            'name' => 'gg_post_inner_image',
            'type' => 'true_false',
            'instructions' => 'Enable/Disable post image on post inner page',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_546f25d44af1e',
            'label' => 'Social share',
            'name' => 'gg_post_social_share',
            'type' => 'true_false',
            'instructions' => 'Enable/Disable social share on post',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'post',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_546ef5e7380c4',
    'title' => 'Blog Options',
    'fields' => array (
        array (
            'key' => 'field_546ef5ea14c14',
            'label' => 'Blog layout',
            'name' => 'gg_blog_layout',
            'type' => 'select',
            'instructions' => 'Select the blog layout',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'fitRows' => 'Grid Fit rows',
                'masonry' => 'Grid Masonry',
            ),
            'default_value' => array (
                'masonry' => 'masonry',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_546f0a785014f',
            'label' => 'Blog layout style',
            'name' => 'gg_blog_layout_style',
            'type' => 'select',
            'instructions' => 'Select the blog layout style',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'gap' => 'Gap',
                'nogap' => 'No Gap',
            ),
            'default_value' => array (
                'gap' => 'gap',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_546f0aff3a532',
            'label' => 'Blog columns',
            'name' => 'gg_blog_columns',
            'type' => 'select',
            'instructions' => 'Select the number of columns',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
            ),
            'default_value' => array (
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_type',
                'operator' => '==',
                'value' => 'posts_page',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/blog.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_546cd8557271d',
    'title' => 'Page Layout',
    'fields' => array (
        array (
            'key' => 'field_546efd85462c2',
            'label' => 'Page container',
            'name' => 'gg_page_container_select',
            'type' => 'select',
            'instructions' => 'Select the page container',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1170 => '1170px container',
                'fullscreen' => 'Fullscreen',
            ),
            'default_value' => array (
                'fullscreen' => 'fullscreen',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_546cd877c748e',
            'label' => 'Page layout',
            'name' => 'gg_page_layout_select',
            'type' => 'select',
            'instructions' => 'Select the page layout',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'with_right_sidebar' => 'With right sidebar',
                'with_left_sidebar' => 'With left sidebar',
                'no_sidebar' => 'No sidebar',
            ),
            'default_value' => array (
                'with_right_sidebar' => 'with_right_sidebar',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'post_type',
                'operator' => '!=',
                'value' => 'property_cpt',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/booking.php',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/homepage-var1.php',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/contact.php',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/areas.php',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/homepage-var2.php',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/homepage-var3.php',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/homepage-var4.php',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/homepage-var5.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_5464cf5f3e820',
    'title' => 'Page Options',
    'fields' => array (
        array (
            'key' => 'field_5464cfec33375',
            'label' => 'Page header',
            'name' => 'gg_page_header',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => 'Enable/Disable page header.',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_5464d01033376',
            'label' => 'Page title',
            'name' => 'gg_page_title',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => 'Enable/Disable page title.',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_5464d02f33377',
            'label' => 'Page description',
            'name' => 'gg_page_description',
            'type' => 'textarea',
            'instructions' => 'Insert your page short description here.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'post_type',
                'operator' => '!=',
                'value' => 'property_cpt',
            ),
            array (
                'param' => 'page_template',
                'operator' => '!=',
                'value' => 'theme-templates/homepage-var1.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_5464caee8eb6f',
    'title' => 'Property Options',
    'fields' => array (
        array (
            'key' => 'field_5464cb263fd39',
            'label' => 'General',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_5464cb413fd3a',
            'label' => 'Location (City, Area)',
            'name' => 'gg_property_meta_location_city',
            'type' => 'text',
            'instructions' => 'Insert the property city location. E.G.: Benicarlo',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Benicarlo',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5464cbb317d47',
            'label' => 'Location (Country)',
            'name' => 'gg_property_meta_location_country',
            'type' => 'text',
            'instructions' => 'Insert the property country location. E.G.: Spain',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Spain',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5472f32027b1c',
            'label' => 'Location (Address)',
            'name' => 'gg_property_meta_location_address',
            'type' => 'text',
            'instructions' => 'Insert the property address. E.G.: 455 LARKSPUR DR SAN JOSE CS 92926 4601 ',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_551c013c577a3',
            'label' => 'Sleeps',
            'name' => 'gg_sleeps',
            'type' => 'select',
            'instructions' => 'Select the number of persons the property can accommodate.
',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
                5 => 5,
                6 => 6,
                7 => 7,
                8 => 8,
                9 => 9,
                10 => 10,
                11 => 11,
                12 => 12,
                13 => 13,
                14 => 14,
                15 => 15,
                16 => 16,
                17 => 17,
                18 => 18,
                19 => 19,
                20 => 20,
                '20+' => '20+',
            ),
            'default_value' => array (
            ),
            'allow_null' => 1,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_551bff49bc50c',
            'label' => 'Bedrooms',
            'name' => 'gg_bedrooms',
            'type' => 'select',
            'instructions' => 'Select the property number of bedrooms',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
                5 => 5,
                6 => 6,
                7 => 7,
                8 => 8,
                9 => 9,
                10 => 10,
                11 => 11,
                12 => 12,
                13 => 13,
                14 => 14,
                15 => 15,
                16 => 16,
                17 => 17,
                18 => 18,
                19 => 19,
                20 => 20,
                '20+' => '20+',
            ),
            'default_value' => array (
            ),
            'allow_null' => 1,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_551bffc62b69b',
            'label' => 'Bathrooms',
            'name' => 'gg_bathrooms',
            'type' => 'select',
            'instructions' => 'Select the property number of bathrooms',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
                5 => 5,
                6 => 6,
                7 => 7,
                8 => 8,
                9 => 9,
                10 => 10,
                11 => 11,
                12 => 12,
                13 => 13,
                14 => 14,
                15 => 15,
                16 => 16,
                17 => 17,
                18 => 18,
                19 => 19,
                20 => 20,
                '20+' => '20+',
            ),
            'default_value' => array (
            ),
            'allow_null' => 1,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_5464cbdea27e6',
            'label' => 'Price (Teaser)',
            'name' => 'gg_property_meta_price',
            'type' => 'text',
            'instructions' => 'Insert the property price. E.G.: From €2.000
This price is informative to attract the user attention.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'From €2.000',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5473534770bdc',
            'label' => 'Price (Booking)',
            'name' => 'gg_property_meta_price_booking',
            'type' => 'text',
            'instructions' => 'Insert the property price. E.G.: €2.000.
This price is used on the booking page and it\'s the actual price the clients will book.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '€2.000',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_54735419be2af',
            'label' => 'Price (Booking) / per',
            'name' => 'gg_property_meta_price_booking_per',
            'type' => 'text',
            'instructions' => 'Insert how the property is priced. E.G.: /day , /night, /week
This field is used on the booking page and it\'s the actual field the clients will book.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '/night',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5464cbf1a27e7',
            'label' => 'Wheather',
            'name' => 'gg_property_meta_wheather',
            'type' => 'text',
            'instructions' => 'Insert the property location wheater. E.G.: 16°, Cleaner',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '16°, Cleaner',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5470b22ca738c',
            'label' => 'Phone',
            'name' => 'gg_property_meta_phone',
            'type' => 'text',
            'instructions' => 'Insert the property contact phone number',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '555 - 555 444 3332',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5470b2689a6be',
            'label' => 'Email',
            'name' => 'gg_property_meta_email',
            'type' => 'email',
            'instructions' => 'Insert the property contact email',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
        ),
        array (
            'key' => 'field_5464cf181abae',
            'label' => 'Homepage',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_5464cf221abaf',
            'label' => 'Property homepage slideshow images',
            'name' => 'gg_property_homepage_slideshow_images',
            'type' => 'gallery',
            'instructions' => 'Upload the images used on the property homepage slideshow.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'min' => '',
            'max' => '',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => 0,
            'min_height' => 0,
            'min_size' => 0,
            'max_width' => 0,
            'max_height' => 0,
            'max_size' => 0,
            'mime_types' => '',
        ),
        array (
            'key' => 'field_5464ceba89789',
            'label' => 'Single page',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_5464cecc8978a',
            'label' => 'Property layout style',
            'name' => 'gg_property_single_layout_style',
            'type' => 'select',
            'instructions' => 'Choose the property layout style.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array (
                'classic' => 'Classic (use the content editor)',
                'half-screen' => 'Half Screen (50% content - use the content editor, 50% gallery)',
                'quarter-screen' => 'Quarter Screen (25% content, 75% gallery)',
                'third-screen' => 'Third Screen (33% content, 77% gallery)',
            ),
            'default_value' => array (
                'half-screen' => 'half-screen',
            ),
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            'disabled' => 0,
            'readonly' => 0,
        ),
        array (
            'key' => 'field_54aa78126e223',
            'label' => 'Reserve now URL',
            'name' => 'gg_property_reserve_now_url',
            'type' => 'url',
            'instructions' => 'Insert the "Reserve now" URL, usually this must point to the booking page.   Leave empty to disable it.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '==',
                        'value' => 'classic',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '==',
                        'value' => 'half-screen',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
        ),
        array (
            'key' => 'field_5473038cc9d5e',
            'label' => 'Share box',
            'name' => 'gg_property_share_box',
            'type' => 'true_false',
            'instructions' => 'Enable/disable share box',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '==',
                        'value' => 'quarter-screen',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '==',
                        'value' => 'third-screen',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_547303bac9d5f',
            'label' => 'Book now link',
            'name' => 'gg_property_book_now',
            'type' => 'true_false',
            'instructions' => 'Enable/disable "Book now" link',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '==',
                        'value' => 'quarter-screen',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '==',
                        'value' => 'third-screen',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_547303f74de1c',
            'label' => 'Book now URL',
            'name' => 'gg_property_book_now_url',
            'type' => 'url',
            'instructions' => 'Insert the "Book now"    URL',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_547303bac9d5f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '==',
                        'value' => 'quarter-screen',
                    ),
                ),
                array (
                    array (
                        'field' => 'field_547303bac9d5f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '==',
                        'value' => 'third-screen',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
        ),
        array (
            'key' => 'field_5464ceeb8978b',
            'label' => 'Property single slideshow images',
            'name' => 'gg_property_single_slideshow_images',
            'type' => 'gallery',
            'instructions' => 'Upload the images used on the property page slideshow.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'min' => '',
            'max' => '',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => 0,
            'min_height' => 0,
            'min_size' => 0,
            'max_width' => 0,
            'max_height' => 0,
            'max_size' => 0,
            'mime_types' => '',
        ),
        array (
            'key' => 'field_5464d5354f94b',
            'label' => 'Overview',
            'name' => 'gg_overview_content',
            'type' => 'wysiwyg',
            'instructions' => 'Insert the property overview. This field is used to show a description of the property for the property layout style: Quarter Screen and Third Screen',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '!=',
                        'value' => 'classic',
                    ),
                    array (
                        'field' => 'field_5464cecc8978a',
                        'operator' => '!=',
                        'value' => 'half-screen',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'tabs' => 'all',
            'toolbar' => 'basic',
            'media_upload' => 1,
        ),
        array (
            'key' => 'field_5464cc316fa3a',
            'label' => 'Map & Contact',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_5464cc526fa3b',
            'label' => 'Latitude',
            'name' => 'gg_map_latitude',
            'type' => 'number',
            'instructions' => 'Insert the property latitude. E.G.: 51.13456',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5464cc6d6fa3c',
            'label' => 'Longitude',
            'name' => 'gg_map_longitude',
            'type' => 'number',
            'instructions' => 'Insert the property longitude. E.G.: -1.34333',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5464cc816fa3d',
            'label' => 'Zoom',
            'name' => 'gg_map_zoom',
            'type' => 'number',
            'instructions' => 'Insert the zoom level. Default: 10',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_5464ccf7f2857',
            'label' => 'Galleries',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_5464cd09f2858',
            'label' => 'Gallery',
            'name' => 'gg_gallery',
            'type' => 'repeater',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'min' => '',
            'max' => '',
            'layout' => 'table',
            'button_label' => 'Add Row',
            'sub_fields' => array (
                array (
                    'key' => 'field_5464cd2ff2859',
                    'label' => 'Gallery name',
                    'name' => 'gg_gallery_name',
                    'type' => 'text',
                    'instructions' => 'Insert the gallery name. E.G.: Indoor, Outdoor, Pools',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => 20,
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'Indoor',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                    'readonly' => 0,
                    'disabled' => 0,
                ),
                array (
                    'key' => 'field_5464cd51f285a',
                    'label' => 'Images',
                    'name' => 'gg_gallery_images',
                    'type' => 'gallery',
                    'instructions' => 'Insert the gallery images',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => 80,
                        'class' => '',
                        'id' => '',
                    ),
                    'min' => '',
                    'max' => '',
                    'preview_size' => 'thumbnail',
                    'library' => 'all',
                    'min_width' => 0,
                    'min_height' => 0,
                    'min_size' => 0,
                    'max_width' => 0,
                    'max_height' => 0,
                    'max_size' => 0,
                    'mime_types' => '',
                ),
            ),
            'collapsed' => '',
        ),
        array (
            'key' => 'field_5464cd76f285b',
            'label' => 'Rooms',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_5464cdb5997e3',
            'label' => 'Room',
            'name' => 'gg_room',
            'type' => 'repeater',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'min' => '',
            'max' => '',
            'layout' => 'table',
            'button_label' => 'Add Row',
            'sub_fields' => array (
                array (
                    'key' => 'field_5464cdf2997e4',
                    'label' => 'Room name',
                    'name' => 'gg_room_name',
                    'type' => 'text',
                    'instructions' => 'Insert room name. E.G.: Deluxe Room',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'Deluxe Room',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                    'readonly' => 0,
                    'disabled' => 0,
                ),
                array (
                    'key' => 'field_5464ce09997e5',
                    'label' => 'Room type',
                    'name' => 'gg_room_type',
                    'type' => 'text',
                    'instructions' => 'Insert room name. E.G.: Double, Single, Executive',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'Double',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                    'readonly' => 0,
                    'disabled' => 0,
                ),
                array (
                    'key' => 'field_5464ce23997e6',
                    'label' => 'Price',
                    'name' => 'gg_room_price',
                    'type' => 'text',
                    'instructions' => 'Insert the room price. E.G.: $200',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '$200',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                    'readonly' => 0,
                    'disabled' => 0,
                ),
                array (
                    'key' => 'field_5464ce4e997e7',
                    'label' => '(Price) per',
                    'name' => 'gg_room_price_per',
                    'type' => 'text',
                    'instructions' => 'Insert how the room is priced. E.G.: /day , /night, /week',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '/night',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                    'readonly' => 0,
                    'disabled' => 0,
                ),
                array (
                    'key' => 'field_5464ce5e997e8',
                    'label' => 'Room image',
                    'name' => 'gg_room_image',
                    'type' => 'image',
                    'instructions' => 'Insert the room image.',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'array',
                    'preview_size' => 'thumbnail',
                    'library' => 'all',
                    'min_width' => 0,
                    'min_height' => 0,
                    'min_size' => 0,
                    'max_width' => 0,
                    'max_height' => 0,
                    'max_size' => 0,
                    'mime_types' => '',
                ),
                array (
                    'key' => 'field_547d9eb8b7783',
                    'label' => 'Room description',
                    'name' => 'gg_room_description',
                    'type' => 'textarea',
                    'instructions' => 'Insert the room description',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'maxlength' => '',
                    'rows' => '',
                    'new_lines' => '',
                    'readonly' => 0,
                    'disabled' => 0,
                ),
                array (
                    'key' => 'field_54817acf78496',
                    'label' => 'Show on booking page',
                    'name' => 'gg_room_show_on_booking_page',
                    'type' => 'true_false',
                    'instructions' => 'Check if you want the room to be displayed on the booking page.',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array (
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'default_value' => 1,
                ),
            ),
            'collapsed' => '',
        ),
        array (
            'key' => 'field_547ecf26f6bee',
            'label' => 'Areas',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_547ecf3bf6bef',
            'label' => 'Property short description',
            'name' => 'gg_areas_property_short_description',
            'type' => 'wysiwyg',
            'instructions' => 'Insert a property short description that will be used when you click on a property marker on the Areas map page.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'tabs' => 'all',
            'toolbar' => 'full',
            'media_upload' => 1,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'property_cpt',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_54608def6f0d5',
    'title' => 'Display Options',
    'fields' => array (
        array (
            'key' => 'field_54608e003f524',
            'label' => 'Exclude properties',
            'name' => 'gg_exclude_properties',
            'type' => 'post_object',
            'instructions' => 'Select properties to exclude.',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'post_type' => array (
                0 => 'property_cpt',
            ),
            'taxonomy' => array (
            ),
            'allow_null' => 0,
            'multiple' => 1,
            'return_format' => 'id',
            'ui' => 1,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/gallery.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/areas.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var3.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var2.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var1.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var4.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/homepage-var5.php',
            ),
        ),
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/areas-var2.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

acf_add_local_field_group(array (
    'key' => 'group_545fd8502b9c3',
    'title' => 'Contact Page Options',
    'fields' => array (
        array (
            'key' => 'field_546dcd82787e0',
            'label' => 'General',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_546dcfa3244b2',
            'label' => 'Phone',
            'name' => 'gg_contact_phone',
            'type' => 'text',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546dd01d244b4',
            'label' => 'Address',
            'name' => 'gg_contact_address',
            'type' => 'textarea',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 4,
            'new_lines' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546dcfd0244b3',
            'label' => 'Email',
            'name' => 'gg_contact_email',
            'type' => 'email',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
        ),
        array (
            'key' => 'field_546dcd2bd9317',
            'label' => 'Contact form',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_545fd8677d64f',
            'label' => 'Contact form',
            'name' => 'gg_contact_form',
            'type' => 'true_false',
            'instructions' => 'Enable/disable contact form. Default: true',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_546cdaeb1f361',
            'label' => 'Contact form headline',
            'name' => 'gg_contact_form_headline',
            'type' => 'text',
            'instructions' => 'Insert the contact form headline. E.G.: Send us a message',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fd9b10cb74',
            'label' => 'Email address',
            'name' => 'gg_contact_page_email',
            'type' => 'text',
            'instructions' => 'Enter your email address. On this address you will receive the emails from this contact form.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546de0476002b',
            'label' => 'From: Email address',
            'name' => 'gg_contact_page_email_from',
            'type' => 'text',
            'instructions' => 'Enter the FROM email address. E.G.: noreply@yoursitename.com',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'noreply@yoursitename.com',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fda0b7c2ec',
            'label' => 'Success text',
            'name' => 'gg_contact_page_success_msg',
            'type' => 'text',
            'instructions' => 'Enter the success message that will be displayed on successful email delivery.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Your message was sent successfully.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fda6446ed5',
            'label' => 'Error text',
            'name' => 'gg_contact_page_error_msg',
            'type' => 'text',
            'instructions' => 'Enter the error message that will be displayed on    email delivery failure.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fd8677d64f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'There was an error submitting the form.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_546dcd41d9318',
            'label' => 'Map',
            'name' => '',
            'type' => 'tab',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array (
            'key' => 'field_545fdaaede793',
            'label' => 'Map',
            'name' => 'gg_contact_map',
            'type' => 'true_false',
            'instructions' => 'Enable/disable map. Default: true',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => '',
            'default_value' => 1,
        ),
        array (
            'key' => 'field_545fdacdde794',
            'label' => 'Latitude',
            'name' => 'gg_contact_map_latitude',
            'type' => 'text',
            'instructions' => 'Enter the latitude value of your location in this format 51.13456
Latitude value is the first string (before comma) of google map address. E.G.: 51.13456, -1.34333',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fdb0853b00',
            'label' => 'Longitude',
            'name' => 'gg_contact_map_longitude',
            'type' => 'text',
            'instructions' => 'Enter the longitude value of your location in this format -1.34333
Latitude value is the second string (after comma) of google map address. E.G.: 51.13456, -1.34333',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fdb2b53b01',
            'label' => 'Zoom',
            'name' => 'gg_contact_zoom',
            'type' => 'text',
            'instructions' => 'Insert the zoom level. Default: 10',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fdb5153b02',
            'label' => 'InfoWindow',
            'name' => 'gg_contact_map_infowindow',
            'type' => 'textarea',
            'instructions' => 'Insert your address details. Will appear after you click on the marker icon. HTML supported.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => 'wpautop',
            'readonly' => 0,
            'disabled' => 0,
        ),
        array (
            'key' => 'field_545fdb8053b03',
            'label' => 'InfoWindow title',
            'name' => 'gg_contact_map_infowindow_title',
            'type' => 'text',
            'instructions' => 'Insert the infoWindow title. Will appear only on marker hover.',
            'required' => 0,
            'conditional_logic' => array (
                array (
                    array (
                        'field' => 'field_545fdaaede793',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array (
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
            'readonly' => 0,
            'disabled' => 0,
        ),
    ),
    'location' => array (
        array (
            array (
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'theme-templates/contact.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'left',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
));

endif;