<?php 
/**
* @version		$Id: iosrt-fwp.php 1416 2020-01-29 18:47:53Z IOS $
* @package		Component IOS Reservations
* @author		Ioannis Sannos ( https://www.isopensource.com )
* @copyright	Copyright (c) 2008-2020 Is Open Source (https://www.isopensource.com). All rights reserved.
* @license		Commercial
* @description 	Online booking system
**************************************/

if (!defined('ABSPATH')) { die('Direct access to this location is not allow!' ); }


class iosRentalsFleetWP {

	private $plugindir = '';//API Client plugin, not fleet!
	private $pluginurl = '';//API Client plugin, not fleet!
	private $apiidok = true;
	private $client = null;
	private $version = '1.8.0';


	/********************/
	/* MAGIC CONTRUCTOR */
	/********************/
	public function __construct($plugindir, $pluginurl, $version) {
		$this->plugindir = $plugindir;
		$this->pluginurl = $pluginurl;
		$this->version = $version;
	}


	/*************/
	/* ADD HOOKS */
	/*************/
	public function makeAll() {
		add_action('admin_menu', array($this, 'makeAdminMenu'));
		add_action('wp_head', array($this, 'prepareClient'));
		add_shortcode('iosrtfleet', array($this, 'parseShortCode'));// [iosrtfleet apiid="X" vtype="Y"]
	}


	/********************************/
	/* PREPARE CLIENT AND MAKE HEAD */
	/********************************/
	public function prepareClient() {
		if (is_admin()) { return; }
		if (!is_single() && !is_page()) { return; }
		if (!file_exists(($this->plugindir.'/client/client.class.php'))) { return; }

		$apiid = '';
		$vtype = '';
		$has_vtype = false;

		global $post;
		if (has_shortcode($post->post_content, 'iosrtfleet')) {
			$regex = "#\[iosrtfleet\s*(.*?)\]#s";
			preg_match_all($regex, $post->post_content, $matches, PREG_PATTERN_ORDER);
			if ($matches) {
				if (isset($matches[1][0])) {
					$atts = shortcode_parse_atts(trim($matches[1][0]));
					if ($atts && is_array($atts)) {
						if (isset($atts['apiid'])) { $apiid = trim($atts['apiid']); }
						if (isset($atts['vtype'])) { $vtype = trim($atts['vtype']); $has_vtype = true; }
					}
				}
			}
		}

		if ($apiid == '') { $this->apiidok = false; return; }

		if (!defined('_IOSRTAPICLIENT_')) { define('_IOSRTAPICLIENT_', 1); }
		$cfgoptions = array();
		$mldata = $this->wpLanguage($apiid);
		if ($mldata['gui'] != '') { $cfgoptions['guilang'] = $mldata['gui']; }
		if ($mldata['server'] != '') { $cfgoptions['lang'] = $mldata['server']; }
		if ($mldata['action'] != '') { $cfgoptions['formaction'] = $mldata['action']; }
		if ($has_vtype) { $cfgoptions['vtype'] = $vtype; }
		unset($mldata);

		require_once($this->plugindir.'/client/client.class.php');
		$this->client = new iosrtApiClient($apiid, $cfgoptions);
		if ($this->client->getError() != '') { $this->apiidok = false; return; }

		define('_IOSRTAPIID_', $apiid);

		$font = $this->client->getOption('loadfont', '');
		if ($font != '') {
			echo '<link rel="stylesheet" id="iosrtapi-font-css" href="'.$this->pluginurl.'/client/css/'.$font.'.css?ver='.$this->version.'" type="text/css" media="all" />'."\n";
		}

		$cssfile = 'client.css';
		if ($this->client->getLang('DIR') == 'rtl') { $cssfile = 'client-rtl.css'; }
		echo '<link rel="stylesheet" id="iosrtapi-client-css" href="'.$this->pluginurl.'/client/css/'.$cssfile.'?ver='.$this->version.'" type="text/css" media="all" />'."\n";
		echo '<link rel="stylesheet" id="iosrtapi-flatpickr-css" href="'.$this->pluginurl.'/client/css/flatpickr.min.css?ver='.$this->version.'" type="text/css" media="all" />'."\n";
		echo '<link rel="stylesheet" id="iosrtapi-swiper-css" href="'.$this->pluginurl.'/client/css/swiper.min.css?ver='.$this->version.'" type="text/css" media="all" />'."\n";
		echo '<script src="'.$this->pluginurl.'/client/js/tippy.min.js?ver='.$this->version.'"></script>'."\n";
		echo '<script src="'.$this->pluginurl.'/client/js/flatpickr.min.js?ver='.$this->version.'"></script>'."\n";
		echo '<script src="'.$this->pluginurl.'/client/js/swiper.min.js?ver='.$this->version.'"></script>'."\n";
		$lng = strtolower($this->client->getGUILang());
		if (file_exists($this->plugindir.'/client/js/flatpickri18n/'.$lng.'.js')) {
			echo '<script src="'.$this->pluginurl.'/client/js/flatpickri18n/'.$lng.'.js?ver='.$this->version.'"></script>'."\n";
		}
		echo '<script src="'.$this->pluginurl.'/client/js/client.js?ver='.$this->version.'"></script>'."\n";

		$calendar = $this->client->calendarData();
		echo '<script>'."\n";
		if ($calendar['disranges']) {
			echo 'var iosRTCalDisRanges = '.json_encode($calendar['disranges']).';'."\n";
		} else {
			echo 'var iosRTCalDisRanges = {};'."\n";
		}
		if ($calendar['nwranges']) {
			echo 'var iosRTCalHourRanges = '.json_encode($calendar['nwranges']).';'."\n";
		} else {
			echo 'var iosRTCalHourRanges = {};'."\n";
		}
		if ($calendar['rentdranges']) {
			echo 'var iosRTCalRentdRanges = '.json_encode($calendar['rentdranges']).';'."\n";
		} else {
			echo 'var iosRTCalRentdRanges = {};'."\n";
		}
		echo 'var iosRTCalminrentdays = '.$calendar['minrentdays'].';'."\n";
		echo 'var iosRTCalmaxrentdays = '.$calendar['maxrentdays'].';'."\n";
		echo 'var iosRTCalpickupdayofweek = '.$calendar['pickupdayofweek'].';'."\n";
		echo 'var iosRTCaldropoffdayofweek = '.$calendar['dropoffdayofweek'].';'."\n";
		echo 'var iosRThidedrop = '.$calendar['hidedrop'].';'."\n";
		echo 'var iosRTpickplushours = '.$calendar['pickplushours'].';'."\n";
		echo "</script>\n";
	}


	/*******************************************/
	/* WORDPRESS LANGUAGE (WPML) AND IOSRT API */
	/*******************************************/
	private function wpLanguage($apiid) {
		$mldata = array('gui' => '', 'server' => '', 'action' => '');
		//if (!function_exists('icl_object_id')) { return $mldata; }//WORDPRESS WPML
		if (!defined('ICL_LANGUAGE_CODE')) { return $mldata; }
		if (!file_exists($this->plugindir.'/client/apiconfig.php')) { return $mldata; }
		include($this->plugindir.'/client/apiconfig.php');
		if (!isset($apiconfig) || !is_array($apiconfig) || (count($apiconfig) == 0)) { return $mldata; }

		$guilang = 'ZZZZZZZZZZZZ';
		$lang = 'ZZZZZZZZZZZZ';
		$formaction = '';
		foreach ($apiconfig as $cfg) {
			if ($cfg['apiid'] != $apiid) { continue; }
			$guilang = $cfg['guilang'];
			$lang = $cfg['lang'];
			$formaction = $cfg['formaction'];
			break;
		}

		if ($guilang != '') { return $mldata; }
		
		$curlang = ICL_LANGUAGE_CODE;//apply_filters('wpml_current_language', null);//or ICL_LANGUAGE_CODE or get_bloginfo("language");
		$curlang_low = strtolower($curlang);
		$testlang = '';
		if (strpos($curlang_low, '_') !== false) {
			$p = explode('_', $curlang_low);
			if ((count($p) == 2) && (strlen($p[0]) == 2)) { $testlang = $p[0]; }
		} else if (strpos($curlang_low, '-') !== false) {
			$p = explode('-', $curlang_low);
			if ((count($p) == 2) && (strlen($p[0]) == 2)) { $testlang = $p[0]; }
		} else if (strlen($curlang_low) == 2) {
			$testlang = $curlang_low;
		}
		if (($testlang != '') && file_exists($this->plugindir.'/client/language/'.$testlang.'.php')) {
			$mldata['gui'] = $testlang;
			if ($lang == '') { $mldata['server'] = $testlang; }
			if ($formaction != '') {
				if (stripos($formaction, '(ML/)') !== false) {
					$wpml_options = get_option('icl_sitepress_settings');
					$default_lang = strtolower($wpml_options['default_language']);
					if ($curlang_low == $default_lang) {
						$mldata['action'] = str_replace('(ML/)', '', $formaction);
					} else {
						$mldata['action'] = str_replace('(ML/)', $curlang.'/', $formaction);
					}
				}
			}
		}
		return $mldata;
	}


	/*******************/
	/* PARSE SHORTCODE */
	/*******************/
	public function parseShortCode($atts) {//[iosrtfleet apiid="X" vtype="Y"]
		if (!file_exists(($this->plugindir.'/client/client.class.php'))) {
			return '<div style="margin:20px 0; padding:10px; color:#FF0000; font-weight:bold;">Required plugin IOSRT API Client not found! Vehicles fleet cannot be displayed. Please install IOSRT API Client plugin.</div>';
		}

		if (!$this->apiidok) { return ''; }

		$a = shortcode_atts(array('apiid' => '', 'vtype' => ''), $atts);
		$apiid = trim($a['apiid']);
		$vtype = trim($a['vtype']);
		if ($apiid == '') { return ''; }
		if (!is_single() && !is_page()) { return ''; }

		if (!$this->client) {//try to re-load
			if (!defined('_IOSRTAPIID_')) { return ''; }
			if (!defined('_IOSRTAPICLIENT_')) { define('_IOSRTAPICLIENT_', 1); }
			require_once($this->plugindir.'/client/client.class.php');
			$cfgoptions = array();
			$this->client = new iosrtApiClient(_IOSRTAPIID_, $cfgoptions);
		}
		$html = $this->client->fleetinit();

		return $html;
	}


	/*******************/
	/* MAKE ADMIN MENU */
	/*******************/
	public function makeAdminMenu() {
		add_menu_page(__('IOSRT Fleet','iosrtfl-menu'), __('IOSRT Fleet','iosrtfl-menu'), 'manage_options', 'iosrt-fleet', array($this, 'iosrtFleetPage'), 'dashicons-admin-generic', 65);
	}


	/*****************************/
	/* DISPLAY API SETTINGS FORM */
	/*****************************/
	public function iosrtFleetPage() {
		if (!current_user_can('manage_options')) {
			wp_die( __('You do not have sufficient permissions to access this page.') );
			return;//just in case...
		}

		$pluginpath = plugin_dir_path(__DIR__).'iosrt-api-client/';//API Client plugin, not fleet!
		$pluginpath = rtrim(str_replace('\\', '/', $pluginpath), '/');

		echo '<div class="wrap">'."\n";
		echo '<h1 class="iosrt_wp_h1">IOSRT Fleet <span>v'.$this->version."</span></h1>\n";

		if (!file_exists($pluginpath.'/client/client.class.php')) {
			echo '<div class="error"><p>Plugin <strong>IOSRT API Client</strong> not found! The IOSRT Fleet plugin requires plugin IOSRT API Client. Please install it!</p></div>'."\n";
		}
		echo '<p class="description">This plugin displays fleet of vehicles. The plugin uses IOS Rentals XML/JSON API connection to receive the data 
		from IOS Rentals server. The IOSRT Fleet plugin requires plugin IOSRT API Client. All the configuration is performed there.</p>';

		echo '<p>To integrate the plugin inside an article type inside an article\'s or page ';
		echo '<strong>[iosrtfleet apiid="X" vtype="Y"]</strong> where <strong>X</strong> the API ID and <strong>Y</strong> the optional vehicle type 
		(options: car, moto, scooter, atv, buggy, bicycle, boat, other. Leave empty for all type of vehicles).</p>'."\n";

		echo "</div>\n";
	}

}

?>