<?php
/*
Plugin Name: Andros theme-specific plugin
Description: Features required by the Andros theme.
Plugin URI: https://www.cssigniter.com/themes/andros/
Version: 1.2.1
License: GNU General Public License v2 or later
Author: The CSSIgniter Team
Author URI: https://www.cssigniter.com/
License: GNU General Public License v2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Text Domain: andros-plugin
*/

if ( ! defined( 'ANDROS_PLUGIN_VERSION' ) ) {
	define( 'ANDROS_PLUGIN_VERSION', '1.2.1' );
}

if ( ! defined( 'ANDROS_PLUGIN_DIR' ) ) {
	define( 'ANDROS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'ANDROS_PLUGIN_DIR_URL' ) ) {
	define( 'ANDROS_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

add_action( 'after_setup_theme', 'andros_plugin_setup' );
function andros_plugin_setup() {
	load_plugin_textdomain( 'andros-plugin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

}

/**
 * Enqueue admin scripts and styles.
 */
function andros_plugin_admin_scripts( $hook ) {

	if ( ! wp_script_is( 'alpha-color-picker', 'enqueued' ) && ! wp_script_is( 'alpha-color-picker', 'registered' ) ) {
		wp_register_style( 'alpha-color-picker', untrailingslashit( ANDROS_PLUGIN_DIR_URL ) . '/base/assets/vendor/alpha-color-picker/alpha-color-picker.css', array(
			'wp-color-picker',
		), andros_plugin_asset_version( '1.0.0' ) );
		wp_register_script( 'alpha-color-picker', untrailingslashit( ANDROS_PLUGIN_DIR_URL ) . '/base/assets/vendor/alpha-color-picker/alpha-color-picker.js', array(
			'jquery',
			'wp-color-picker',
		), andros_plugin_asset_version( '1.0.0' ), true );
	}

	wp_register_style( 'andros-repeating-fields', untrailingslashit( ANDROS_PLUGIN_DIR_URL ) . '/base/assets/repeating-fields/repeating-fields.css', array(), andros_plugin_asset_version() );
	wp_register_script( 'andros-repeating-fields', untrailingslashit( ANDROS_PLUGIN_DIR_URL ) . '/base/assets/repeating-fields/repeating-fields.js', array(
		'jquery',
		'jquery-ui-sortable',
	), andros_plugin_asset_version(), true );

	wp_register_style( 'andros-plugin-post-meta', untrailingslashit( ANDROS_PLUGIN_DIR_URL ) . '/base/assets/css/post-meta.css', array(
		'alpha-color-picker',
	), andros_plugin_asset_version() );
	wp_register_script( 'andros-plugin-post-meta', untrailingslashit( ANDROS_PLUGIN_DIR_URL ) . '/base/assets/js/post-meta.js', array(
		'media-editor',
		'jquery',
		'jquery-ui-sortable',
		'alpha-color-picker',
	), andros_plugin_asset_version(), true );

	$settings = array(
		'ajaxurl'             => admin_url( 'admin-ajax.php' ),
		'tSelectFile'         => esc_html__( 'Select file', 'andros-plugin' ),
		'tSelectFiles'        => esc_html__( 'Select files', 'andros-plugin' ),
		'tUseThisFile'        => esc_html__( 'Use this file', 'andros-plugin' ),
		'tUseTheseFiles'      => esc_html__( 'Use these files', 'andros-plugin' ),
		'tUpdateGallery'      => esc_html__( 'Update gallery', 'andros-plugin' ),
		'tLoading'            => esc_html__( 'Loading...', 'andros-plugin' ),
		'tPreviewUnavailable' => esc_html__( 'Gallery preview not available.', 'andros-plugin' ),
		'tRemoveImage'        => esc_html__( 'Remove image', 'andros-plugin' ),
		'tRemoveFromGallery'  => esc_html__( 'Remove from gallery', 'andros-plugin' ),
	);
	wp_localize_script( 'andros-plugin-post-meta', 'andros_plugin_PostMeta', $settings );


	//
	// Enqueue
	//
	if ( in_array( $hook, array( 'post.php', 'post-new.php' ), true ) ) {
		wp_enqueue_media();

		wp_enqueue_style( 'andros-repeating-fields' );
		wp_enqueue_script( 'andros-repeating-fields' );

		wp_enqueue_style( 'andros-plugin-post-meta' );
		wp_enqueue_script( 'andros-plugin-post-meta' );
	}

}
add_action( 'admin_enqueue_scripts', 'andros_plugin_admin_scripts' );


function andros_plugin_get_columns_classes( $columns ) {
	if ( function_exists( 'andros_get_columns_classes' ) ) {
		return andros_get_columns_classes( $columns );
	}

	switch ( intval( $columns ) ) {
		case 1:
			$classes = 'col-12';
			break;
		case 2:
			$classes = 'col-sm-6 col-12';
			break;
		case 3:
			$classes = 'col-lg-4 col-sm-6 col-12';
			break;
		case 4:
		default:
			$classes = 'col-xl-3 col-lg-4 col-sm-6 col-12';
			break;
	}

	// Filter name intentionally same to andros_get_columns_classes()
	return apply_filters( 'andros_get_columns_classes', $classes, $columns );
}


function andros_plugin_activated() {
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}

	andros_plugin_create_cpt_room();

	andros_plugin_create_cpt_testimonial();

	flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'andros_plugin_activated' );

function andros_plugin_deactivated() {
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}

	unregister_post_type( 'andros_room' );
	unregister_taxonomy( 'andros_room_category' );

	unregister_post_type( 'andros_testimonial' );

	flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'andros_plugin_deactivated' );



/**
 * Custom fields / post types / taxonomies.
 */
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/custom-fields-post.php';
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/custom-fields-page.php';
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/custom-fields-room.php';
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/custom-fields-testimonial.php';


/**
 * Standard helper functions.
 */
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/base/helpers.php';

/**
 * Standard sanitization functions.
 */
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/base/sanitization.php';

/**
 * Post meta helpers.
 */
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/base/post-meta.php';
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/base/post-meta-title-subtitle.php';
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/base/post-meta-hero.php';
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/base/post-meta-sidebar.php';

/**
 * Post type related includes.
 */
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/base/items-listing.php';

/**
 * User fields.
 */
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/user-meta.php';

/**
 * Theme-specific shortcodes.
 */
require untrailingslashit( ANDROS_PLUGIN_DIR ) . '/shortcodes.php';
