<?php
function andros_plugin_sanitize_metabox_tab_sidebar( $post_id ) {
	// Nonce verification is being done inside andros_plugin_can_save_meta(), from the caller of this function.
	// phpcs:disable WordPress.Security.NonceVerification
	update_post_meta( $post_id, 'andros_sidebar', andros_plugin_sanitize_sidebar( $_POST['andros_sidebar'] ) );
	// phpcs:enable
}

function andros_plugin_print_metabox_tab_sidebar( $object, $box ) {

	andros_plugin_metabox_open_tab( esc_html__( 'Sidebar', 'andros-plugin' ) );

		$options = andros_plugin_get_sidebar_choices();
		foreach ( $options as $key => $value ) {
			andros_plugin_metabox_radio( 'andros_sidebar', "sidebar-$key", $key, $value, array( 'default' => apply_filters( 'andros_plugin_sanitize_sidebar_default', 'right' ) ) );
		}

	andros_plugin_metabox_close_tab();
}

function andros_plugin_get_sidebar_choices() {
	return apply_filters( 'andros_plugin_sidebar_choices', array(
		'left'  => esc_html__( 'Left sidebar', 'andros-plugin' ),
		'right' => esc_html__( 'Right sidebar', 'andros-plugin' ),
		'none'  => esc_html__( 'No sidebar', 'andros-plugin' ),
	) );
}

function andros_plugin_sanitize_sidebar( $value ) {
	$choices = andros_plugin_get_sidebar_choices();
	if ( array_key_exists( $value, $choices ) ) {
		return $value;
	}

	return apply_filters( 'andros_plugin_sanitize_sidebar_default', 'right' );
}
