<?php
function andros_plugin_sanitize_metabox_tab_sub_title( $post_id ) {
	// Nonce verification is being done inside andros_plugin_can_save_meta(), from the caller of this function.
	// phpcs:disable WordPress.Security.NonceVerification
	update_post_meta( $post_id, 'title', wp_kses( $_POST['title'], andros_plugin_get_allowed_tags() ) );
	update_post_meta( $post_id, 'subtitle', wp_kses( $_POST['subtitle'], andros_plugin_get_allowed_tags( 'guide' ) ) );
	// phpcs:enable
}

function andros_plugin_print_metabox_tab_sub_title( $object, $box ) {

	andros_plugin_metabox_open_tab( esc_html__( 'Title / Subtitle', 'andros-plugin' ) );

		andros_plugin_metabox_guide( array(
			wp_kses( __( 'You can provide an HTML version of your title, in order to format it according to your needs. If you leave it empty, the normal title will be used instead.', 'andros-plugin' ), andros_plugin_get_allowed_tags( 'guide' ) ),
			/* translators: %1$s is an opening HTML tag. %2$s is a closing HTML tag. */
			wp_kses( sprintf( __( 'You can wrap some text within <code>%1$s</code> and <code>%2$s</code> in order to make it stand out.', 'andros-plugin' ), esc_html( '<span class="text-theme">' ), esc_html( '</span>' ) ), andros_plugin_get_allowed_tags( 'guide' ) ),
		) );
		andros_plugin_metabox_input( 'title', esc_html__( 'Page Title (overrides the normal title):', 'andros-plugin' ) );
		andros_plugin_metabox_input( 'subtitle', esc_html__( 'Page Subtitle:', 'andros-plugin' ) );

	andros_plugin_metabox_close_tab();
}
