<?php
add_action( 'admin_init', 'andros_plugin_cpt_page_add_metaboxes' );
add_action( 'save_post', 'andros_plugin_cpt_page_update_meta' );

if ( ! function_exists( 'andros_plugin_cpt_page_add_metaboxes' ) ) :
	function andros_plugin_cpt_page_add_metaboxes() {
		add_meta_box( 'andros-plugin-hero', esc_html__( 'Hero section', 'andros-plugin' ), 'andros_plugin_add_page_hero_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'andros-plugin-sidebar', esc_html__( 'Sidebar', 'andros-plugin' ), 'andros_plugin_add_page_sidebar_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'andros-plugin-tpl-front-page', esc_html__( 'Front Page Options', 'andros-plugin' ), 'andros_plugin_add_page_front_page_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'andros-plugin-tpl-room-listing', esc_html__( 'Room Listing Options', 'andros-plugin' ), 'andros_plugin_add_page_room_listing_meta_box', 'page', 'normal', 'high' );
	}
endif;

if ( ! function_exists( 'andros_plugin_cpt_page_update_meta' ) ) :
	function andros_plugin_cpt_page_update_meta( $post_id ) {

		// Nonce verification is being done inside andros_plugin_can_save_meta()
		// phpcs:disable WordPress.Security.NonceVerification
		if ( ! andros_plugin_can_save_meta( 'page' ) ) {
			return;
		}

		andros_plugin_sanitize_metabox_tab_sub_title( $post_id );

		andros_plugin_sanitize_metabox_tab_hero( $post_id );

		andros_plugin_sanitize_metabox_tab_sidebar( $post_id );

		update_post_meta( $post_id, 'andros_front_slider_id', andros_plugin_sanitize_intval_or_empty( $_POST['andros_front_slider_id'] ) );

		andros_plugin_sanitize_metabox_tab_post_type_listing( 'andros_room', $post_id );

		// phpcs:enable
	}
endif;

if ( ! function_exists( 'andros_plugin_add_page_hero_meta_box' ) ) :
	function andros_plugin_add_page_hero_meta_box( $object, $box ) {
		andros_plugin_prepare_metabox( 'page' );

		?><div class="ci-cf-wrap"><?php

			andros_plugin_print_metabox_tab_sub_title( $object, $box );

			andros_plugin_print_metabox_tab_hero( $object, $box );

		?></div><?php
	}
endif;

if ( ! function_exists( 'andros_plugin_add_page_sidebar_meta_box' ) ) :
	function andros_plugin_add_page_sidebar_meta_box( $object, $box ) {
		andros_plugin_prepare_metabox( 'page' );

		?><div class="ci-cf-wrap"><?php

			andros_plugin_print_metabox_tab_sidebar( $object, $box );

		?></div><?php

		andros_plugin_bind_metabox_to_page_template( 'andros-plugin-sidebar', 'default' );
	}
endif;

if ( ! function_exists( 'andros_plugin_add_page_front_page_meta_box' ) ) :
	function andros_plugin_add_page_front_page_meta_box( $object, $box ) {
		andros_plugin_prepare_metabox( 'page' );

		?><div class="ci-cf-wrap"><?php

			andros_plugin_metabox_open_tab( '' );
				andros_plugin_metabox_guide( esc_html__( 'You can select a MaxSlider slideshow to display on your front page. If you choose a slideshow, it will be displayed instead of the image and/or video that you have set on "Hero section".', 'andros-plugin' ) );
				?>
				<p class="ci-field-group ci-field-dropdown">
					<label for="background_slider_id"><?php esc_html_e( 'MaxSlider Slideshow', 'andros-plugin' ); ?></label>
					<?php
						$post_type = 'maxslider_slide';
						if ( function_exists( 'MaxSlider' ) ) {
							$post_type = MaxSlider()->post_type;
						}
						andros_plugin_dropdown_posts( array(
							'post_type'            => $post_type,
							'selected'             => get_post_meta( $object->ID, 'andros_front_slider_id', true ),
							'class'                => 'posts_dropdown',
							'show_option_none'     => esc_html__( 'Disable Slideshow', 'andros-plugin' ),
							'select_even_if_empty' => true,
						), 'andros_front_slider_id' );
					?>
				</p>
				<?php

			andros_plugin_metabox_close_tab();

		?></div><?php

		andros_plugin_bind_metabox_to_page_template( 'andros-plugin-tpl-front-page', 'templates/front-page.php' );
	}
endif;

if ( ! function_exists( 'andros_plugin_add_page_room_listing_meta_box' ) ) :
	function andros_plugin_add_page_room_listing_meta_box( $object, $box ) {
		andros_plugin_prepare_metabox( 'page' );

		?><div class="ci-cf-wrap"><?php

			andros_plugin_print_metabox_tab_post_type_listing( 'andros_room', $object, $box, esc_html__( 'Room listing', 'andros-plugin' ) );

		?></div><?php

		andros_plugin_bind_metabox_to_page_template( 'andros-plugin-tpl-room-listing', 'templates/listing-andros_room.php' );
	}
endif;
