<?php
add_action( 'admin_init', 'andros_plugin_cpt_post_add_metaboxes' );
add_action( 'save_post', 'andros_plugin_cpt_post_update_meta' );

if ( ! function_exists( 'andros_plugin_cpt_post_add_metaboxes' ) ) :
	function andros_plugin_cpt_post_add_metaboxes() {
		add_meta_box( 'andros-plugin-hero', esc_html__( 'Hero section', 'andros-plugin' ), 'andros_plugin_add_post_hero_meta_box', 'post', 'normal', 'high' );
		add_meta_box( 'andros-plugin-sidebar', esc_html__( 'Sidebar', 'andros-plugin' ), 'andros_plugin_add_post_sidebar_meta_box', 'post', 'normal', 'high' );
	}
endif;

if ( ! function_exists( 'andros_plugin_cpt_post_update_meta' ) ) :
	function andros_plugin_cpt_post_update_meta( $post_id ) {

		// Nonce verification is being done inside andros_plugin_can_save_meta()
		// phpcs:disable WordPress.Security.NonceVerification
		if ( ! andros_plugin_can_save_meta( 'post' ) ) {
			return;
		}

		andros_plugin_sanitize_metabox_tab_sub_title( $post_id );

		andros_plugin_sanitize_metabox_tab_hero( $post_id );

		andros_plugin_sanitize_metabox_tab_sidebar( $post_id );

		// phpcs:enable
	}
endif;

if ( ! function_exists( 'andros_plugin_add_post_hero_meta_box' ) ) :
	function andros_plugin_add_post_hero_meta_box( $object, $box ) {
		andros_plugin_prepare_metabox( 'post' );

		?><div class="ci-cf-wrap"><?php

			andros_plugin_print_metabox_tab_sub_title( $object, $box );

			andros_plugin_print_metabox_tab_hero( $object, $box );

		?></div><?php
	}
endif;

if ( ! function_exists( 'andros_plugin_add_post_sidebar_meta_box' ) ) :
	function andros_plugin_add_post_sidebar_meta_box( $object, $box ) {
		andros_plugin_prepare_metabox( 'post' );

		?><div class="ci-cf-wrap"><?php

			andros_plugin_print_metabox_tab_sidebar( $object, $box );

		?></div><?php
	}
endif;
