<?php
add_action( 'init', 'andros_plugin_create_cpt_room' );

if ( ! function_exists( 'andros_plugin_create_cpt_room' ) ) :
	function andros_plugin_create_cpt_room() {
		$labels = array(
			'name'               => esc_html_x( 'Rooms', 'post type general name', 'andros-plugin' ),
			'singular_name'      => esc_html_x( 'Room', 'post type singular name', 'andros-plugin' ),
			'menu_name'          => esc_html_x( 'Rooms', 'admin menu', 'andros-plugin' ),
			'name_admin_bar'     => esc_html_x( 'Room', 'add new on admin bar', 'andros-plugin' ),
			'add_new'            => esc_html_x( 'Add New', 'Room', 'andros-plugin' ),
			'add_new_item'       => esc_html__( 'Add New Room', 'andros-plugin' ),
			'edit_item'          => esc_html__( 'Edit Room', 'andros-plugin' ),
			'new_item'           => esc_html__( 'New Room', 'andros-plugin' ),
			'view_item'          => esc_html__( 'View Room', 'andros-plugin' ),
			'search_items'       => esc_html__( 'Search Rooms', 'andros-plugin' ),
			'not_found'          => esc_html__( 'No Rooms found', 'andros-plugin' ),
			'not_found_in_trash' => esc_html__( 'No Rooms found in the trash', 'andros-plugin' ),
			'parent_item_colon'  => esc_html__( 'Parent Room:', 'andros-plugin' ),
		);

		$args = array(
			'labels'          => $labels,
			'singular_label'  => esc_html_x( 'Room', 'post type singular name', 'andros-plugin' ),
			'public'          => true,
			'show_ui'         => true,
			'capability_type' => 'post',
			'hierarchical'    => false,
			'has_archive'     => _x( 'room-archive', 'post type archive slug', 'andros-plugin' ),
			'rewrite'         => array( 'slug' => esc_html_x( 'room', 'post type slug', 'andros-plugin' ) ),
			'menu_position'   => 10,
			'supports'        => array( 'title', 'editor', 'thumbnail' ),
			'menu_icon'       => 'dashicons-admin-home',
		);
		register_post_type( 'andros_room', $args );

		$labels = array(
			'name'              => esc_html_x( 'Room Categories', 'taxonomy general name', 'andros-plugin' ),
			'singular_name'     => esc_html_x( 'Room Category', 'taxonomy singular name', 'andros-plugin' ),
			'search_items'      => esc_html__( 'Search Room Categories', 'andros-plugin' ),
			'all_items'         => esc_html__( 'All Room Categories', 'andros-plugin' ),
			'parent_item'       => esc_html__( 'Parent Room Category', 'andros-plugin' ),
			'parent_item_colon' => esc_html__( 'Parent Room Category:', 'andros-plugin' ),
			'edit_item'         => esc_html__( 'Edit Room Category', 'andros-plugin' ),
			'update_item'       => esc_html__( 'Update Room Category', 'andros-plugin' ),
			'add_new_item'      => esc_html__( 'Add New Room Category', 'andros-plugin' ),
			'new_item_name'     => esc_html__( 'New Room Category Name', 'andros-plugin' ),
			'menu_name'         => esc_html__( 'Categories', 'andros-plugin' ),
			'view_item'         => esc_html__( 'View Room Category', 'andros-plugin' ),
			'popular_items'     => esc_html__( 'Popular Room Categories', 'andros-plugin' ),
		);
		register_taxonomy( 'andros_room_category', array( 'andros_room' ), array(
			'labels'            => $labels,
			'hierarchical'      => true,
			'show_admin_column' => true,
			'rewrite'           => array( 'slug' => esc_html_x( 'room-category', 'taxonomy slug', 'andros-plugin' ) ),
		) );
	}
endif;

add_action( 'admin_init', 'andros_plugin_cpt_room_add_metaboxes' );
add_action( 'save_post', 'andros_plugin_cpt_room_update_meta' );

if ( ! function_exists( 'andros_plugin_cpt_room_add_metaboxes' ) ) :
	function andros_plugin_cpt_room_add_metaboxes() {
		add_meta_box( 'andros-plugin-room-options', esc_html__( 'Room Options', 'andros-plugin' ), 'andros_plugin_add_room_options_meta_box', 'andros_room', 'normal', 'high' );
	}
endif;

if ( ! function_exists( 'andros_plugin_cpt_room_update_meta' ) ) :
	function andros_plugin_cpt_room_update_meta( $post_id ) {

		// Nonce verification is being done inside andros_plugin_can_save_meta()
		// phpcs:disable WordPress.Security.NonceVerification
		if ( ! andros_plugin_can_save_meta( 'andros_room' ) ) {
			return;
		}

		andros_plugin_sanitize_metabox_tab_sub_title( $post_id );

		andros_plugin_sanitize_metabox_tab_sidebar( $post_id );

		andros_plugin_metabox_gallery_save( $_POST );

		update_post_meta( $post_id, 'andros_room_on_offer', isset( $_POST['andros_room_on_offer'] ) ? 1 : 0 );
		update_post_meta( $post_id, 'andros_room_offer_text', sanitize_text_field( $_POST['andros_room_offer_text'] ) );

		update_post_meta( $post_id, 'andros_room_amenities_title', sanitize_text_field( $_POST['andros_room_amenities_title'] ) );
		update_post_meta( $post_id, 'andros_room_amenities', andros_plugin_sanitize_room_amenities( $_POST ) );

		// phpcs:enable
	}
endif;

if ( ! function_exists( 'andros_plugin_add_room_options_meta_box' ) ) :
	function andros_plugin_add_room_options_meta_box( $object, $box ) {
		andros_plugin_prepare_metabox( 'andros_room' );

		?><div class="ci-cf-wrap"><?php

			andros_plugin_print_metabox_tab_sub_title( $object, $box );

			andros_plugin_print_metabox_tab_sidebar( $object, $box );

			andros_plugin_metabox_open_tab( esc_html__( 'Amenities', 'andros-plugin' ) );
				andros_plugin_metabox_guide( array(
					wp_kses( __( 'Provide the amenities of the room. Select <em>Add Field</em> as many times as you want to create a list of amenities. You can delete one by clicking on its <em>Remove Me</em> button. You may also click and drag the fields to re-arrange them.', 'andros-plugin' ), andros_plugin_get_allowed_tags( 'guide' ) ),
					wp_kses( __( 'In order to display the room\'s amenities, just paste the shortcode <code>[amenities]</code> anywhere within the main content. You may specify the number of columns by providing a <em>columns</em> parameter, e.g. <code>[amenities columns="4"]</code>. Valid columns are <em>4</em>-<em>10</em>. Default: <em>4</em>.', 'andros-plugin' ), andros_plugin_get_allowed_tags( 'guide' ) ),
				) );

				andros_plugin_metabox_input( 'andros_room_amenities_title', esc_html__( "Amenities' title", 'andros-plugin' ), array( 'default' => esc_html__( 'Amenities', 'andros-plugin' ) ) );

				$choices = array_merge( array( '' => '' ), andros_plugin_hotel_icons() );

				?>
				<fieldset class="amenities ci-repeating-fields">
					<div class="inner">
						<?php
							$fields = get_post_meta( $object->ID, 'andros_room_amenities', true );
							if ( ! empty( $fields ) ) {
								foreach ( $fields as $field ) {
									?>
									<div class="post-field">
										<label><?php esc_html_e( 'Icon:', 'andros-plugin' ); ?>
											<select name="andros_plugin_repeatable_room_amenities_icon[]" class="widefat">
												<?php foreach ( $choices as $key => $value ) : ?>
													<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $field['icon'] ); ?>><?php echo wp_kses( $value, 'strip' ); ?></option>
												<?php endforeach; ?>
											</select>
										</label>
										<label><?php esc_html_e( 'Title override (optional):', 'andros-plugin' ); ?> <input type="text" name="andros_plugin_repeatable_room_amenities_title[]" value="<?php echo esc_attr( $field['title'] ); ?>" class="widefat" /></label>
										<p class="ci-repeating-remove-action"><a href="#" class="button ci-repeating-remove-field"><i class="dashicons dashicons-dismiss"></i><?php esc_html_e( 'Remove me', 'andros-plugin' ); ?></a></p>
									</div>
									<?php
								}
							}
						?>
						<div class="post-field field-prototype" style="display: none;">
							<label><?php esc_html_e( 'Icon:', 'andros-plugin' ); ?>
								<select name="andros_plugin_repeatable_room_amenities_icon[]" class="widefat">
									<?php foreach ( $choices as $key => $value ) : ?>
										<option value="<?php echo esc_attr( $key ); ?>"><?php echo wp_kses( $value, 'strip' ); ?></option>
									<?php endforeach; ?>
								</select>
							</label>
							<label><?php esc_html_e( 'Title override:', 'andros-plugin' ); ?> <input type="text" name="andros_plugin_repeatable_room_amenities_title[]" value="" class="widefat" /></label>
							<p class="ci-repeating-remove-action"><a href="#" class="button ci-repeating-remove-field"><i class="dashicons dashicons-dismiss"></i><?php esc_html_e( 'Remove me', 'andros-plugin' ); ?></a></p>
						</div>
					</div>
					<a href="#" class="ci-repeating-add-field button"><i class="dashicons dashicons-plus-alt"></i><?php esc_html_e( 'Add Field', 'andros-plugin' ); ?></a>
				</fieldset>
				<?php
			andros_plugin_metabox_close_tab();

			andros_plugin_metabox_open_tab( esc_html__( 'Gallery', 'andros-plugin' ) );
				andros_plugin_metabox_guide( wp_kses( __( 'You can create a gallery by pressing the <em>Add Images</em> button below. You should also set a featured image that will be used as the cover image.', 'andros-room' ), andros_plugin_get_allowed_tags( 'guide' ) ) );
				andros_plugin_metabox_gallery();
			andros_plugin_metabox_close_tab();

			andros_plugin_metabox_open_tab( esc_html__( 'Offer', 'andros-plugin' ) );
				andros_plugin_metabox_guide( esc_html__( 'Check the following checkbox if the room is on offer. It will be marked as such on the front-end. You may also provide a customized text instead of the default one.', 'andros-room' ) );
				andros_plugin_metabox_checkbox( 'andros_room_on_offer', 1, esc_html__( 'Room is on offer.', 'andros-plugin' ) );
				andros_plugin_metabox_input( 'andros_room_offer_text', esc_html__( 'Offer text (optional):', 'andros-plugin' ) );
			andros_plugin_metabox_close_tab();

		?></div><?php
	}
endif;

if ( ! function_exists( 'andros_plugin_sanitize_room_amenities' ) ) :
	function andros_plugin_sanitize_room_amenities( $post_array ) {
		if ( empty( $post_array ) || ! is_array( $post_array ) ) {
			return false;
		}

		$titles = $post_array['andros_plugin_repeatable_room_amenities_title'];
		$icons  = $post_array['andros_plugin_repeatable_room_amenities_icon'];

		$count = max( count( $titles ), count( $icons ) );

		$new_fields = array();

		$records_count = 0;
		for ( $i = 0; $i < $count; $i++ ) {
			// Don't care if title is empty, but we definitely need an icon.
			if ( empty( $icons[ $i ] ) ) {
				continue;
			}

			$new_fields[ $records_count ]['title'] = sanitize_text_field( $titles[ $i ] );
			$new_fields[ $records_count ]['icon']  = andros_plugin_sanitize_hotel_icon( $icons[ $i ] );
			$records_count++;
		}
		return $new_fields;
	}
endif;

function andros_plugin_hotel_icons() {
	return apply_filters( 'andros_plugin_hotel_icons', array(
		'air-conditioning'   => esc_html__( 'Air Conditioning', 'andros-plugin' ),
		'alarm'              => esc_html__( 'Alarm', 'andros-plugin' ),
		'bar'                => esc_html__( 'Bar', 'andros-plugin' ),
		'bathrobe'           => esc_html__( 'Bathrobe', 'andros-plugin' ),
		'bathroom'           => esc_html__( 'Bathroom', 'andros-plugin' ),
		'breakfast'          => esc_html__( 'Breakfast', 'andros-plugin' ),
		'car-rental'         => esc_html__( 'Car Rental', 'andros-plugin' ),
		'concierge'          => esc_html__( 'Concierge', 'andros-plugin' ),
		'disabled'           => esc_html__( 'Disabled', 'andros-plugin' ),
		'elevator'           => esc_html__( 'Elevator', 'andros-plugin' ),
		'fitness-center'     => esc_html__( 'Fitness Center', 'andros-plugin' ),
		'free-toiletries'    => esc_html__( 'Free Toiletries', 'andros-plugin' ),
		'hairdryer'          => esc_html__( 'Hairdryer', 'andros-plugin' ),
		'heating'            => esc_html__( 'Heating', 'andros-plugin' ),
		'iron'               => esc_html__( 'Iron', 'andros-plugin' ),
		'laundry'            => esc_html__( 'Laundry', 'andros-plugin' ),
		'linens'             => esc_html__( 'Linens', 'andros-plugin' ),
		'lounge'             => esc_html__( 'Lounge', 'andros-plugin' ),
		'minibar'            => esc_html__( 'Minibar', 'andros-plugin' ),
		'newspapers'         => esc_html__( 'Newspapers', 'andros-plugin' ),
		'no-smoking'         => esc_html__( 'No Smoking', 'andros-plugin' ),
		'parking'            => esc_html__( 'Parking', 'andros-plugin' ),
		'pets'               => esc_html__( 'Pets', 'andros-plugin' ),
		'pool'               => esc_html__( 'Pool', 'andros-plugin' ),
		'radio'              => esc_html__( 'Radio', 'andros-plugin' ),
		'refrigerator'       => esc_html__( 'Refrigerator', 'andros-plugin' ),
		'restaurant'         => esc_html__( 'Restaurant', 'andros-plugin' ),
		'safe'               => esc_html__( 'Safe', 'andros-plugin' ),
		'satellite-channels' => esc_html__( 'Satellite Channels', 'andros-plugin' ),
		'shower'             => esc_html__( 'Shower', 'andros-plugin' ),
		'shuttle-service'    => esc_html__( 'Shuttle Service', 'andros-plugin' ),
		'slippers'           => esc_html__( 'Slippers', 'andros-plugin' ),
		'smoking'            => esc_html__( 'Smoking', 'andros-plugin' ),
		'soundproof'         => esc_html__( 'Soundproof', 'andros-plugin' ),
		'spa'                => esc_html__( 'Spa', 'andros-plugin' ),
		'sun-deck'           => esc_html__( 'Sun-deck', 'andros-plugin' ),
		'toilet'             => esc_html__( 'Toilet', 'andros-plugin' ),
		'towels'             => esc_html__( 'Towels', 'andros-plugin' ),
		'tv'                 => esc_html__( 'TV', 'andros-plugin' ),
		'wifi'               => esc_html__( 'WiFi', 'andros-plugin' ),
	) );
}

function andros_plugin_sanitize_hotel_icon( $value ) {
	$choices = andros_plugin_hotel_icons();
	if ( array_key_exists( $value, $choices ) ) {
		return $value;
	}

	return '';
}
