<?php
add_shortcode( 'latest-post-type', 'andros_plugin_shortcode_latest_post_type' );
if ( ! function_exists( 'andros_plugin_shortcode_latest_post_type' ) ) :
	function andros_plugin_shortcode_latest_post_type( $params, $content = null, $shortcode ) {

		$params = shortcode_atts( array(
			'post_type' => 'post',
			'random'    => false,
			'count'     => 3,
			'columns'   => 3,
		), $params, $shortcode );

		$post_type = $params['post_type'];
		$random    = $params['random'];
		$count     = intval( $params['count'] );
		$columns   = intval( $params['columns'] );

		if ( 0 === $count ) {
			return '';
		}

		if ( empty( $post_type ) ) {
			$post_type = 'post';
		}

		if ( empty( $random ) || 'false' === $random || 'FALSE' === $random || '0' === $random || false === (bool) $random ) {
			$random = false;
		} else {
			true;
		}

		$col_options = andros_plugin_post_type_listing_get_valid_columns_options();

		if ( $columns < $col_options['min'] ) {
			$columns = $col_options['min'];
		}

		if ( $columns > $col_options['max'] ) {
			$columns = $col_options['max'];
		}

		$query_args = array(
			'post_type'           => $post_type,
			'ignore_sticky_posts' => true,
			'orderby'             => 'date',
			'order'               => 'DESC',
			'posts_per_page'      => $count,
		);

		if ( $random ) {
			$query_args['orderby'] = 'rand';
			unset( $query_args['order'] );
		}

		$q = new WP_Query( $query_args );

		ob_start();

		if ( $q->have_posts() ) {
			?><div class="row row-items"><?php

				while ( $q->have_posts() ) {
					$q->the_post();

					?><div class="<?php echo esc_attr( andros_plugin_get_columns_classes( $columns ) ); ?>"><?php

					get_template_part( 'template-parts/widgets/home-item', get_post_type() );

					?></div><?php
				}
				wp_reset_postdata();

			?></div><?php
		}

		$output = ob_get_clean();

		return $output;
	}
endif;

add_shortcode( 'latest-testimonials', 'andros_plugin_shortcode_latest_testimonials' );
if ( ! function_exists( 'andros_plugin_shortcode_latest_testimonials' ) ) :
	function andros_plugin_shortcode_latest_testimonials( $params, $content = null, $shortcode ) {

		$params = shortcode_atts( array(
			'random' => false,
			'count'  => 3,
		), $params, $shortcode );

		$random = $params['random'];
		$count  = intval( $params['count'] );

		if ( 0 === $count ) {
			return '';
		}

		if ( empty( $random ) || 'false' === $random || 'FALSE' === $random || '0' === $random || false === (bool) $random ) {
			$random = false;
		} else {
			true;
		}

		$query_args = array(
			'post_type'           => 'andros_testimonial',
			'ignore_sticky_posts' => true,
			'orderby'             => 'date',
			'order'               => 'DESC',
			'posts_per_page'      => $count,
		);

		if ( $random ) {
			$query_args['orderby'] = 'rand';
			unset( $query_args['order'] );
		}

		$q = new WP_Query( $query_args );

		ob_start();

		if ( $q->have_posts() ) {

			?><div class="slideshow-testimonials andros-slick-slider"><?php

			$i = 1;

			while ( $q->have_posts() ) {
				$q->the_post();

				if ( 0 === $i % 2 ) {
					$side = 'right';
				} else {
					$side = 'left';
				}

				get_template_part( 'template-parts/testimonial', $side );

				$i++;
			}
			wp_reset_postdata();

			?></div><?php

		}

		$output = ob_get_clean();

		return $output;
	}
endif;

add_shortcode( 'amenities', 'andros_shortcode_room_amenities_shortcode' );
if ( ! function_exists( 'andros_shortcode_room_amenities_shortcode' ) ) :
	function andros_shortcode_room_amenities_shortcode( $atts, $content = null, $tag = 'room-amenities' ) {
		$atts = shortcode_atts( array(
			'id'      => '',
			'columns' => 4,
		), $atts, $tag );

		$id   = $atts['id'];
		$post = get_post();

		// By default, when the shortcode tries to get the room amenities, should be
		// restricted to only published rooms.
		// However, when the rooms itself shows its own amenities, it should be allowed to do so,
		// no matter what its post status may be.

		$post_id = false;

		if ( empty( $id ) ) {
			// We are showing the current post's amenities (since we didn't get any parameters),
			// so we need to make sure we can retrieve it whatever its post status might be.
			$post_id = $post->ID;
		} elseif ( ! empty( $id ) && $id > 0 ) {
			$id = intval( $id );

			// Check if the current post's ID matches what was passed.
			// If so, we need to make sure we can retrieve it whatever its post status might be.
			if ( $post->ID === $id ) {
				$post_id = $id;
			} elseif ( 'publish' === get_post_status( $id ) ) {
				$post_id = $id;
			}
		}

		if ( empty( $post_id ) ) {
			return apply_filters( 'andros_room_amenities_shortcode_error_msg', esc_html__( 'Cannot show amenities of non-public, non-published rooms.', 'andros-plugin' ) );
		}

		$columns = intval( $atts['columns'] );
		$columns = $columns < 4 ? 4 : $columns;
		$columns = $columns > 10 ? 10 : $columns;

		$output          = '';
		$amenities       = get_post_meta( $post_id, 'andros_room_amenities', true );
		$amenities_title = get_post_meta( $post_id, 'andros_room_amenities_title', true );

		$icons = andros_plugin_hotel_icons();

		if ( ! empty( $amenities ) ) {
			ob_start();
			?>
			<?php if ( ! empty( $amenities_title ) ) : ?>
				<h3 class="amenities-title"><?php echo wp_kses( $amenities_title, andros_plugin_get_allowed_tags() ); ?></h3>
			<?php endif; ?>

			<ul class="entry-room-amenities room-amenities-<?php echo esc_attr( $columns ); ?>">
				<?php foreach ( $amenities as $amenity ) : ?>
					<?php $title = ! empty( $amenity['title'] ) ? $amenity['title'] : $icons[ $amenity['icon'] ]; ?>
					<li><span class="ci-hotel-icons ci-hotel-icons-<?php echo esc_attr( $amenity['icon'] ); ?>"></span> <?php echo wp_kses( $title, andros_plugin_get_allowed_tags() ); ?></li>
				<?php endforeach; ?>
			</ul>
			<?php
			$output = ob_get_clean();
		}

		return $output;
	}
endif;
