<?php
function andros_plugin_sanitize_metabox_tab_hero( $post_id ) {
	// Nonce verification is being done inside andros_plugin_can_save_meta(), from the caller of this function.
	// phpcs:disable WordPress.Security.NonceVerification
	$support = get_theme_support( 'andros-hero' );
	$support = $support[0];
	if ( ! $support['required'] ) {
		update_post_meta( $post_id, 'hero_show', isset( $_POST['hero_show'] ) ? 1 : 0 );
	}

	update_post_meta( $post_id, 'hero_text_align', andros_plugin_sanitize_text_align( $_POST['hero_text_align'] ) );
	update_post_meta( $post_id, 'page_title_hide', isset( $_POST['page_title_hide'] ) ? 1 : 0 );

	update_post_meta( $post_id, 'hero_image_id', andros_plugin_sanitize_intval_or_empty( $_POST['hero_image_id'] ) );
	update_post_meta( $post_id, 'hero_bg_color', sanitize_hex_color( $_POST['hero_bg_color'] ) );
	update_post_meta( $post_id, 'hero_text_color', sanitize_hex_color( $_POST['hero_text_color'] ) );
	update_post_meta( $post_id, 'hero_overlay_color', andros_plugin_sanitize_rgba_color( $_POST['hero_overlay_color'] ) );
	update_post_meta( $post_id, 'hero_image_repeat', andros_plugin_sanitize_image_repeat( $_POST['hero_image_repeat'] ) );
	update_post_meta( $post_id, 'hero_image_position_x', andros_plugin_sanitize_image_position_x( $_POST['hero_image_position_x'] ) );
	update_post_meta( $post_id, 'hero_image_position_y', andros_plugin_sanitize_image_position_y( $_POST['hero_image_position_y'] ) );
	update_post_meta( $post_id, 'hero_image_attachment', andros_plugin_sanitize_image_attachment( $_POST['hero_image_attachment'] ) );
	update_post_meta( $post_id, 'hero_image_cover', isset( $_POST['hero_image_cover'] ) ? 1 : 0 );
	update_post_meta( $post_id, 'hero_video_url', esc_url_raw( $_POST['hero_video_url'] ) );
	// phpcs:enaable
}

function andros_plugin_print_metabox_tab_hero( $object, $box ) {
	$support = get_theme_support( 'andros-hero' );
	$support = $support[0];

	$page_title_hide_default    = 1;
	$page_title_hide_guide_text = __( 'Since the hero section shows the title by default, you may want to disable the page title (shown before the content).', 'andros-plugin' );

	if ( 'post' === get_post_type( $object->ID ) ) {
		$page_title_hide_default = 0;
		/* translators: %s is a user-provided title. */
		$page_title_hide_guide_text = sprintf( __( 'When checked, the title will appear on the hero section, replacing the blog title you have set from <em>Customize &rarr; Titles &rarr; General &rarr; Blog title</em>, currently set to: <em>%s</em>.', 'andros-plugin' ), get_theme_mod( 'title_blog', __( 'From the blog', 'andros-plugin' ) ) );
	}

	$page_title_hide_default    = apply_filters( 'andros_hero_page_title_hide_default', $page_title_hide_default, get_post_type( $object->ID ), $object->ID );
	$page_title_hide_guide_text = apply_filters( 'andros_hero_page_title_hide_guide_text', $page_title_hide_guide_text, get_post_type( $object->ID ), $object->ID, $page_title_hide_default );

	andros_plugin_metabox_open_tab( esc_html__( 'Hero section', 'andros-plugin' ) );

		if ( ! $support['required'] ) {
			andros_plugin_metabox_checkbox( 'hero_show', 1, esc_html__( 'Show hero section.', 'andros-plugin' ), array( 'default' => intval( $support['show-default'] ) ) );
		}

		andros_plugin_metabox_dropdown( 'hero_text_align', andros_plugin_get_text_align_choices(), esc_html__( 'Title / subtitle alignment:', 'andros-plugin' ), array( 'default' => $support['text-align'] ) );

		andros_plugin_metabox_guide( wp_kses( $page_title_hide_guide_text, andros_plugin_get_allowed_tags( 'guide' ) ) );
		andros_plugin_metabox_checkbox( 'page_title_hide', 1, esc_html__( 'Hide page title.', 'andros-plugin' ), array( 'default' => $page_title_hide_default ) );

		?>
		<p class="ci-field-group ci-field-input">
			<?php andros_plugin_metabox_input( 'hero_bg_color', esc_html__( 'Background Color:', 'andros-plugin' ), array(
				'input_class' => 'andros-color-picker widefat',
				'before'      => '',
				'after'       => '',
			) ); ?>
		</p>

		<p class="ci-field-group ci-field-input">
			<?php andros_plugin_metabox_input( 'hero_text_color', esc_html__( 'Text Color:', 'andros-plugin' ), array(
				'input_class' => 'andros-color-picker widefat',
				'before'      => '',
				'after'       => '',
			) ); ?>
		</p>

		<p class="ci-field-group ci-field-input">
			<?php andros_plugin_metabox_input( 'hero_overlay_color', esc_html__( 'Overlay Color:', 'andros-plugin' ), array(
				'input_class' => 'andros-alpha-color-picker widefat',
				'before'      => '',
				'after'       => '',
			) ); ?>
		</p>
		<?php

		andros_plugin_metabox_input( 'hero_video_url', esc_html__( 'Video URL (YouTube or Vimeo)', 'andros-plugin' ), array( 'esc_func' => 'esc_url' ) );

		andros_plugin_metabox_guide( array(
			wp_kses( __( 'The following image options are only applicable when a Hero image is selected.', 'andros-plugin' ), andros_plugin_get_allowed_tags( 'guide' ) ),
		) );

		$hero_image_id = get_post_meta( $object->ID, 'hero_image_id', true );
		?>
		<div class="ci-field-group ci-field-input">
			<label for="header_image_id"><?php esc_html_e( 'Hero image:', 'andros-plugin' ); ?></label>
			<div class="ci-upload-preview">
				<div class="upload-preview">
					<?php if ( ! empty( $hero_image_id ) ) : ?>
						<?php
							$image_url = wp_get_attachment_image_url( $hero_image_id, 'andros_plugin_featgal_small_thumb' );
							echo sprintf( '<img src="%s" /><a href="#" class="close media-modal-icon" title="%s"></a>',
								esc_url( $image_url ),
								esc_attr__( 'Remove image', 'andros-plugin' )
							);
						?>
					<?php endif; ?>
				</div>
				<input name="hero_image_id" type="hidden" class="ci-uploaded-id" value="<?php echo esc_attr( $hero_image_id ); ?>" />
				<input id="hero_image_id" type="button" class="button ci-media-button" value="<?php esc_attr_e( 'Select Image', 'andros-plugin' ); ?>" />
			</div>
		</div>
		<?php

		andros_plugin_metabox_dropdown( 'hero_image_repeat', andros_plugin_get_image_repeat_choices(), esc_html__( 'Image repeat:', 'andros-plugin' ), array( 'default' => 'no-repeat' ) );
		andros_plugin_metabox_dropdown( 'hero_image_position_x', andros_plugin_get_image_position_x_choices(), esc_html__( 'Image horizontal position:', 'andros-plugin' ), array( 'default' => 'center' ) );
		andros_plugin_metabox_dropdown( 'hero_image_position_y', andros_plugin_get_image_position_y_choices(), esc_html__( 'Image vertical position:', 'andros-plugin' ), array( 'default' => 'center' ) );
		andros_plugin_metabox_dropdown( 'hero_image_attachment', andros_plugin_get_image_attachment_choices(), esc_html__( 'Image attachment:', 'andros-plugin' ), array( 'default' => 'scroll' ) );
		andros_plugin_metabox_checkbox( 'hero_image_cover', 1, esc_html__( 'Scale the image to cover its container.', 'andros-plugin' ), array( 'default' => 1 ) );
		?><?php

	andros_plugin_metabox_close_tab();
}
