<?php
add_action( 'init', 'andros_plugin_create_cpt_testimonial' );

if ( ! function_exists( 'andros_plugin_create_cpt_testimonial' ) ) :
	function andros_plugin_create_cpt_testimonial() {
		$labels = array(
			'name'               => esc_html_x( 'Testimonials', 'post type general name', 'andros-plugin' ),
			'singular_name'      => esc_html_x( 'Testimonial', 'post type singular name', 'andros-plugin' ),
			'menu_name'          => esc_html_x( 'Testimonials', 'admin menu', 'andros-plugin' ),
			'name_admin_bar'     => esc_html_x( 'Testimonial', 'add new on admin bar', 'andros-plugin' ),
			'add_new'            => esc_html_x( 'Add New', 'testimonial', 'andros-plugin' ),
			'add_new_item'       => esc_html__( 'Add New Testimonial', 'andros-plugin' ),
			'edit_item'          => esc_html__( 'Edit Testimonial', 'andros-plugin' ),
			'new_item'           => esc_html__( 'New Testimonial', 'andros-plugin' ),
			'view_item'          => esc_html__( 'View Testimonial', 'andros-plugin' ),
			'search_items'       => esc_html__( 'Search Testimonials', 'andros-plugin' ),
			'not_found'          => esc_html__( 'No Testimonials found', 'andros-plugin' ),
			'not_found_in_trash' => esc_html__( 'No Testimonials found in the trash', 'andros-plugin' ),
			'parent_item_colon'  => esc_html__( 'Parent Testimonial:', 'andros-plugin' ),
		);

		$args = array(
			'labels'          => $labels,
			'singular_label'  => esc_html_x( 'Testimonial', 'post type singular name', 'andros-plugin' ),
			'public'          => false,
			'show_ui'         => true,
			'capability_type' => 'post',
			'hierarchical'    => false,
			'has_archive'     => false,
			'rewrite'         => array( 'slug' => esc_html_x( 'testimonial', 'post type slug', 'andros-plugin' ) ),
			'menu_position'   => 10,
			'supports'        => array( 'title', 'editor' ),
			'menu_icon'       => 'dashicons-format-quote',
		);

		register_post_type( 'andros_testimonial', $args );
	}
endif;

add_action( 'admin_init', 'andros_plugin_cpt_testimonial_add_metaboxes' );
add_action( 'save_post', 'andros_plugin_cpt_testimonial_update_meta' );

if ( ! function_exists( 'andros_plugin_cpt_testimonial_add_metaboxes' ) ) :
	function andros_plugin_cpt_testimonial_add_metaboxes() {
		add_meta_box( 'andros-plugin-testimonial-cite', esc_html__( 'Citation', 'andros-plugin' ), 'andros_plugin_add_testimonial_cite_meta_box', 'andros_testimonial', 'normal', 'high' );
	}
endif;

if ( ! function_exists( 'andros_plugin_cpt_testimonial_update_meta' ) ) :
	function andros_plugin_cpt_testimonial_update_meta( $post_id ) {

		// Nonce verification is being done inside andros_plugin_can_save_meta()
		// phpcs:disable WordPress.Security.NonceVerification
		if ( ! andros_plugin_can_save_meta( 'andros_testimonial' ) ) {
			return;
		}

		update_post_meta( $post_id, 'andros_cite', wp_kses( $_POST['andros_cite'], andros_plugin_get_allowed_tags() ) );

		// phpcs:enable
	}
endif;

if ( ! function_exists( 'andros_plugin_add_testimonial_cite_meta_box' ) ) :
	function andros_plugin_add_testimonial_cite_meta_box( $object, $box ) {
		andros_plugin_prepare_metabox( 'andros_testimonial' );

		?><div class="ci-cf-wrap"><?php

			andros_plugin_metabox_open_tab( esc_html__( 'Citation', 'andros-plugin' ) );

				andros_plugin_metabox_guide( array(
					wp_kses( __( 'Cite the person that provided the testimonial.', 'andros-plugin' ), andros_plugin_get_allowed_tags( 'guide' ) ),
				) );
				andros_plugin_metabox_input( 'andros_cite', esc_html__( 'Citation:', 'andros-plugin' ) );

			andros_plugin_metabox_close_tab();

		?></div><?php
	}
endif;
