<?php
	/**
	 * Generates CSS based on standard customizer settings.
	 *
	 * @return string
	 */
	function andros_base_get_customizer_css() {
		ob_start();

		//
		// Logo
		//
		$custom_logo_id = get_theme_mod( 'custom_logo' );
		if ( get_theme_mod( 'limit_logo_size' ) && ! empty( $custom_logo_id ) ) {
			$image_metadata = wp_get_attachment_metadata( $custom_logo_id );
			$max_width      = floor( $image_metadata['width'] / 2 );
			?>
			.header img.custom-logo {
				width: <?php echo intval( $max_width ); ?>px;
				max-width: 100%;
			}
			<?php
		}

		//
		// Header Top Menu Bar
		//
		$header_top_bar_padding = get_theme_mod( 'header_top_bar_padding' );

		if ( ! empty( $header_top_bar_padding ) ) {
			?>
			.head-intro {
				padding-top: <?php echo intval( $header_top_bar_padding ); ?>px;
				padding-bottom: <?php echo intval( $header_top_bar_padding ); ?>px;
			}
			<?php
		}

		$header_top_bar_text_size = get_theme_mod( 'header_top_bar_text_size' );

		if ( ! empty( $header_top_bar_text_size ) ) {
			?>
			.head-intro {
				font-size: <?php echo intval( $header_top_bar_text_size ); ?>px;
			}
			<?php
		}

		$header_top_bar_text_color = get_theme_mod( 'header_top_bar_text_color' );

		if ( ! empty( $header_top_bar_text_color ) ) {
			?>
			.head-intro {
				color: <?php echo sanitize_hex_color( $header_top_bar_text_color ); ?>;
			}
			<?php
		}

		$header_top_bar_bg_color = get_theme_mod( 'header_top_bar_bg_color' );

		if ( ! empty( $header_top_bar_bg_color ) ) {
			?>
			.head-intro {
				background-color: <?php echo sanitize_hex_color( $header_top_bar_bg_color ); ?>;
			}
			<?php
		}

		//
		// Header Main Menu Bar
		//
		$header_primary_menu_padding = get_theme_mod( 'header_primary_menu_padding' );

		if ( ! empty( $header_primary_menu_padding ) ) {
			?>
			.head-mast {
				padding-top: <?php echo intval( $header_primary_menu_padding ); ?>px;
				padding-bottom: <?php echo intval( $header_primary_menu_padding ); ?>px;
			}
			<?php
		}

		$header_primary_menu_text_size = get_theme_mod( 'header_primary_menu_text_size' );

		if ( ! empty( $header_primary_menu_text_size ) ) {
			?>
			.navigation-main > li > a {
				font-size: <?php echo intval( $header_primary_menu_text_size ); ?>px;
			}
			<?php
		}

		$header_primary_menu_bg_color = get_theme_mod( 'header_primary_menu_bg_color' );

		if ( ! empty( $header_primary_menu_bg_color ) ) {
			?>
			.head-mast,
			.head-sticky.is_stuck {
				background-color: <?php echo sanitize_hex_color( $header_primary_menu_bg_color ); ?>;
			}
			<?php
		}

		$header_primary_menu_text_color = get_theme_mod( 'header_primary_menu_text_color' );

		if ( ! empty( $header_primary_menu_text_color ) ) {
			?>
			.site-logo a,
			.site-tagline,
			.navigation-main > li > a {
				color: <?php echo sanitize_hex_color( $header_primary_menu_text_color ); ?>;
			}

			.navigation-main .nav-button > a {
				border-color: <?php echo sanitize_hex_color( $header_primary_menu_text_color ); ?>;
			}
			<?php
		}

		$header_primary_menu_active_color = get_theme_mod( 'header_primary_menu_active_color' );

		if ( ! empty( $header_primary_menu_active_color ) ) {
			?>
			.navigation-main > li:hover > a,
			.navigation-main > li > a:focus,
			.navigation-main > .current-menu-item > a,
			.navigation-main > .current-menu-parent > a,
			.navigation-main > .current-menu-ancestor > a,
			.navigation-main > .current_page_item > a,
			.navigation-main > .current_page_ancestor > a,
			.navigation-main li li:hover > a,
			.navigation-main li li > a:focus,
			.navigation-main li .current-menu-item > a,
			.navigation-main li .current-menu-parent > a,
			.navigation-main li .current-menu-ancestor > a,
			.navigation-main li .current_page_item > a,
			.navigation-main li .current_page_ancestor > a,
			.navigation-main .nav-button > a:hover {
				color: <?php echo sanitize_hex_color( $header_primary_menu_active_color ); ?>;
			}

			.navigation-main .nav-button > a:hover {
				border-color: <?php echo sanitize_hex_color( $header_primary_menu_active_color ); ?>;
			}
			<?php
		}

		$header_primary_submenu_bg_color = get_theme_mod( 'header_primary_submenu_bg_color' );

		if ( ! empty( $header_primary_submenu_bg_color ) ) {
			?>
			.navigation-main ul {
				background-color: <?php echo sanitize_hex_color( $header_primary_submenu_bg_color ); ?>;
			}
			<?php
		}

		$header_primary_submenu_text_color = get_theme_mod( 'header_primary_submenu_text_color' );

		if ( ! empty( $header_primary_submenu_text_color ) ) {
			?>
			.navigation-main li li a {
				color: <?php echo sanitize_hex_color( $header_primary_submenu_text_color ); ?>;
			}
			<?php
		}

			$header_primary_submenu_active_text_color = get_theme_mod( 'header_primary_submenu_active_text_color' );

		if ( ! empty( $header_primary_submenu_active_text_color ) ) {
			?>
			.navigation-main li li:hover > a,
			.navigation-main li li > a:focus,
			.navigation-main li .current-menu-item > a,
			.navigation-main li .current-menu-parent > a,
			.navigation-main li .current-menu-ancestor > a,
			.navigation-main li .current_page_item > a,
			.navigation-main li .current_page_ancestor > a {
				color: <?php echo sanitize_hex_color( $header_primary_submenu_active_text_color ); ?>;
			}
			<?php
		}

		//
		// Footer Colors
		//
		$footer_bg_color = get_theme_mod( 'footer_bg_color' );

		if ( ! empty( $footer_bg_color ) ) {
			?>
			.footer-widgets {
				background-color: <?php echo sanitize_hex_color( $footer_bg_color ); ?>;
			}
			<?php
		}

		$footer_text_color = get_theme_mod( 'footer_text_color' );

		if ( ! empty( $footer_text_color ) ) {
			?>
			.footer-widgets,
			.footer-widgets .widget,
			.footer-widgets .widget-title,
			.footer-widgets .ci-contact-widget-item i {
				color: <?php echo sanitize_hex_color( $footer_text_color ); ?>;
			}
			<?php
		}

		$footer_link_color = get_theme_mod( 'footer_link_color' );

		if ( ! empty( $footer_link_color ) ) {
			?>
			.footer-widgets a,
			.footer-widgets .widget a,
			.footer-widgets .widget a:hover {
				color: <?php echo sanitize_hex_color( $footer_link_color ); ?>;
			}
			<?php
		}

		$footer_bottom_bg_color = get_theme_mod( 'footer_bottom_bg_color' );

		if ( ! empty( $footer_bottom_bg_color ) ) {
			?>
			.footer-info {
				background-color: <?php echo sanitize_hex_color( $footer_bottom_bg_color ); ?>;
			}
			<?php
		}

		$footer_bottom_text_color = get_theme_mod( 'footer_bottom_text_color' );

		if ( ! empty( $footer_bottom_text_color ) ) {
			?>
			.footer-info {
				color: <?php echo sanitize_hex_color( $footer_bottom_text_color ); ?>;
			}
			<?php
		}

		$footer_bottom_link_color = get_theme_mod( 'footer_bottom_link_color' );

		if ( ! empty( $footer_bottom_link_color ) ) {
			?>
			.footer-info a,
			.footer-info a:hover {
				color: <?php echo sanitize_hex_color( $footer_bottom_link_color ); ?>;
			}
			<?php
		}

		$footer_titles_color = get_theme_mod( 'footer_titles_color' );

		if ( ! empty( $footer_titles_color ) ) {
			?>
			.footer .widget-title {
				color: <?php echo sanitize_hex_color( $footer_titles_color ); ?>;
			}
			<?php
		}

		//
		// Sidebar Colors
		//
		$sidebar_bg_color = get_theme_mod( 'sidebar_bg_color' );

		if ( ! empty( $sidebar_bg_color ) ) {
			?>
			.sidebar {
				background-color: <?php echo sanitize_hex_color( $sidebar_bg_color ); ?>;
				padding: 20px;
			}
			<?php
		}

		$sidebar_text_color = get_theme_mod( 'sidebar_text_color' );

		if ( ! empty( $sidebar_text_color ) ) {
			?>
			.sidebar,
			.sidebar .widget,
			.sidebar .ci-contact-widget-item i {
				color: <?php echo sanitize_hex_color( $sidebar_text_color ); ?>;
			}
			<?php
		}

		$sidebar_link_color = get_theme_mod( 'sidebar_link_color' );

		if ( ! empty( $sidebar_link_color ) ) {
			?>
			.sidebar a:not(.btn) {
				color: <?php echo sanitize_hex_color( $sidebar_link_color ); ?>;
			}
			<?php
		}

		$sidebar_link_hover_color = get_theme_mod( 'sidebar_link_hover_color' );

		if ( ! empty( $sidebar_link_hover_color ) ) {
			?>
			.sidebar a:not(.btn):hover {
				color: <?php echo sanitize_hex_color( $sidebar_link_hover_color ); ?>;
			}
			<?php
		}

		$sidebar_border_color = get_theme_mod( 'sidebar_border_color' );

		if ( ! empty( $sidebar_border_color ) ) {
			?>
			.sidebar select,
			.sidebar input,
			.sidebar textarea {
				border-color: <?php echo sanitize_hex_color( $sidebar_border_color ); ?>;
			}

			.sidebar .widget_recent_comments li,
			.sidebar .widget_recent_entries li,
			.sidebar .widget_rss li,
			.sidebar .widget_meta li a,
			.sidebar .widget_pages li a,
			.sidebar .widget_categories li a,
			.sidebar .widget_archive li a,
			.sidebar .widget_nav_menu li a {
				border-bottom-color: <?php echo sanitize_hex_color( $sidebar_border_color ); ?>;
			}
			<?php
		}

		$sidebar_titles_color = get_theme_mod( 'sidebar_titles_color' );

		if ( ! empty( $sidebar_titles_color ) ) {
			?>
			.sidebar .widget-title {
				color: <?php echo sanitize_hex_color( $sidebar_titles_color ); ?>;
			}
			<?php
		}

		//
		// Button colors
		//
		$site_button_bg_color = get_theme_mod( 'site_button_bg_color' );

		if ( ! empty( $site_button_bg_color ) ) {
			?>
			.btn,
			.button,
			.comment-reply-link,
			input[type="submit"],
			input[type="reset"],
			button,
			.navigation-main .nav-button > a {
				background-color: <?php echo sanitize_hex_color( $site_button_bg_color ); ?>;
			}

			.btn:focus,
			.button:focus,
			.comment-reply-link:focus,
			input[type="submit"]:focus,
			input[type="reset"]:focus,
			button:focus,
			.navigation-main .nav-button > a:focus {
			box-shadow: 0 0 10px <?php echo andros_hex2rgba( $site_button_bg_color, .7 ); ?>;
			}
			<?php
		}

		$site_button_text_color = get_theme_mod( 'site_button_text_color' );

		if ( ! empty( $site_button_text_color ) ) {
			?>
			.btn,
			.button,
			.comment-reply-link,
			input[type="submit"],
			input[type="reset"],
			button,
			.navigation-main .nav-button > a {
				color: <?php echo sanitize_hex_color( $site_button_text_color ); ?>;
			}
			<?php
		}

		$site_button_hover_bg_color = get_theme_mod( 'site_button_hover_bg_color' );

		if ( ! empty( $site_button_hover_bg_color ) ) {
			?>
			.btn:hover,
			.button:hover,
			.comment-reply-link:hover,
			input[type="submit"]:hover,
			input[type="reset"]:hover,
			button:hover,
			.navigation-main .nav-button > a:hover {
				background-color: <?php echo sanitize_hex_color( $site_button_hover_bg_color ); ?>;
			}
			<?php
		}

		$site_button_hover_text_color = get_theme_mod( 'site_button_hover_text_color' );

		if ( ! empty( $site_button_hover_text_color ) ) {
			?>
			.btn:hover,
			.button:hover,
			.comment-reply-link:hover,
			input[type="submit"]:hover,
			input[type="reset"]:hover,
			button:hover,
			.navigation-main .nav-button > a:hover {
				color: <?php echo sanitize_hex_color( $site_button_hover_text_color ); ?>;
			}
			<?php
		}

		$site_button_border_color = get_theme_mod( 'site_button_border_color' );

		if ( ! empty( $site_button_border_color ) ) {
			?>
			.btn,
			.button,
			.comment-reply-link,
			input[type="submit"],
			input[type="reset"],
			button,
			.navigation-main .nav-button > a {
				border-color: <?php echo sanitize_hex_color( $site_button_border_color ); ?>;
			}
			<?php
		}

		$css = ob_get_clean();
		return apply_filters( 'andros_base_customizer_css', $css );
	}

	function andros_base_get_hero_styles() {
		$hero  = andros_get_hero_data();
		$style = '';

		if ( ! $hero['show'] ) {
			return apply_filters( 'andros_base_hero_styles', $style, $hero );
		}

		$styles_selector  = '.page-hero';
		$overlay_selector = '.page-hero::before';

		$support = get_theme_support( 'andros-hero' );
		$support = $support[0];
		if ( is_page_template( 'templates/builder.php' ) && true === $support['required'] ) {
			$styles_selector  = '.header';
			$overlay_selector = '.header::before';
		}

		$styles_selector  = apply_filters( 'andros_base_hero_styles_selector', $styles_selector );
		$overlay_selector = apply_filters( 'andros_base_hero_styles_overlay_selector', $overlay_selector );

		if ( $hero['overlay_color'] ) {
			$style .= $overlay_selector . ' { ';
			$style .= sprintf( 'background-color: %s; ',
				$hero['overlay_color']
			);
			$style .= '} ' . PHP_EOL;
		}

		if ( $hero['bg_color'] || $hero['image'] || $hero['text_color'] ) {
			$style .= $styles_selector . ' { ';

			if ( $hero['bg_color'] ) {
				$style .= sprintf( 'background-color: %s; ',
					$hero['bg_color']
				);
			}

			if ( $hero['text_color'] ) {
				$style .= sprintf( 'color: %s; ',
					$hero['text_color']
				);
			}

			if ( $hero['image'] ) {
				$style .= sprintf( 'background-image: url(%s); ',
					$hero['image']
				);

				if ( $hero['image_repeat'] ) {
					$style .= sprintf( 'background-repeat: %s; ',
						$hero['image_repeat']
					);
				}

				if ( $hero['image_position_x'] && $hero['image_position_y'] ) {
					$style .= sprintf( 'background-position: %s %s; ',
						$hero['image_position_x'],
						$hero['image_position_y']
					);
				}

				if ( $hero['image_attachment'] ) {
					$style .= sprintf( 'background-attachment: %s; ',
						$hero['image_attachment']
					);
				}

				if ( ! $hero['image_cover'] ) {
					$style .= 'background-size: auto; ';
				}
			}

			$style .= '}';
		}

		return apply_filters( 'andros_base_hero_styles', $style, $hero );
	}
