<?php
/**
 * Standard Customizer Sections and Settings
 */

/**
 * Registers Customizer panels and sections.
 *
 * @param WP_Customize_Manager $wp_customize Reference to the customizer's manager object.
 */
function andros_base_customize_register( $wp_customize ) {

	// Partial for various settings that affect the customizer styles, but can't have a dedicated icon, e.g. 'limit_logo_size'
	$wp_customize->selective_refresh->add_partial( 'theme_base_style', array(
		'selector'            => '#andros-base-style-inline-css',
		'render_callback'     => 'andros_get_all_customizer_css',
		'settings'            => array_keys( andros_get_registered_typography_controls() ),
		'container_inclusive' => false,
	) );

	$wp_customize->selective_refresh->add_partial( 'theme_gfonts', array(
		'selector'            => '#andros-user-google-fonts-css',
		'render_callback'     => 'andros_customize_preview_google_fonts',
		'settings'            => array_keys( andros_get_registered_typography_controls() ),
		'container_inclusive' => true,
	) );

	//
	// Header
	//
	$wp_customize->add_panel( 'theme_header', array(
		'title'    => esc_html_x( 'Header', 'customizer section title', 'andros' ),
		'priority' => 10, // Before site_identity, 20
	) );

	$wp_customize->add_section( 'theme_header_style', array(
		'title'    => esc_html_x( 'Header style', 'customizer section title', 'andros' ),
		'panel'    => 'theme_header',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-header-style.php' );

	$wp_customize->add_section( 'theme_header_top_bar', array(
		'title'    => esc_html_x( 'Top menu bar', 'customizer section title', 'andros' ),
		'panel'    => 'theme_header',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-header-top-bar.php' );

	$wp_customize->add_section( 'theme_header_primary_menu', array(
		'title'    => esc_html_x( 'Primary menu bar', 'customizer section title', 'andros' ),
		'panel'    => 'theme_header',
		'priority' => 30,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-header-primary-menu.php' );


	//
	// Blog
	//
	$wp_customize->add_panel( 'theme_blog', array(
		'title'    => esc_html_x( 'Blog settings', 'customizer section title', 'andros' ),
		'priority' => 30, // After site_identity, 20
	) );

	$wp_customize->add_section( 'theme_archive_options', array(
		'title'       => esc_html_x( 'Archive options', 'customizer section title', 'andros' ),
		'panel'       => 'theme_blog',
		'description' => esc_html__( 'Customize the default archive pages, such as the blog, category, tag, date archives, etc.', 'andros' ),
		'priority'    => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-archive-options.php' );

	$wp_customize->add_section( 'theme_post_options', array(
		'title'    => esc_html_x( 'Post options', 'customizer section title', 'andros' ),
		'panel'    => 'theme_blog',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-post-options.php' );


	//
	// Colors
	//
	$wp_customize->add_panel( 'theme_colors', array(
		'title'    => esc_html_x( 'Colors', 'customizer section title', 'andros' ),
		'priority' => 30,
	) );

	$wp_customize->add_section( 'theme_colors_header_top_bar', array(
		'title'    => esc_html_x( 'Header top bar', 'customizer section title', 'andros' ),
		'panel'    => 'theme_colors',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-colors-header-top-bar.php' );

	$wp_customize->add_section( 'theme_colors_primary_menu_bar', array(
		'title'    => esc_html_x( 'Primary menu bar', 'customizer section title', 'andros' ),
		'panel'    => 'theme_colors',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-colors-primary-menu-bar.php' );

	if ( get_theme_support( 'andros-hero' ) ) {
		$wp_customize->add_section( 'theme_colors_hero', array(
			'title'    => esc_html_x( 'Hero', 'customizer section title', 'andros' ),
			'panel'    => 'theme_colors',
			'priority' => 30,
		) );
		require_once get_theme_file_path( 'base/customizer/sections/theme-colors-hero.php' );
	}

	$wp_customize->add_section( 'theme_colors_global', array(
		'title'    => esc_html_x( 'Global', 'customizer section title', 'andros' ),
		'panel'    => 'theme_colors',
		'priority' => 40,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-colors-global.php' );

	$wp_customize->add_section( 'theme_colors_sidebar', array(
		'title'    => esc_html_x( 'Sidebar', 'customizer section title', 'andros' ),
		'panel'    => 'theme_colors',
		'priority' => 50,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-colors-sidebar.php' );

	$wp_customize->add_section( 'theme_colors_footer', array(
		'title'    => esc_html_x( 'Footer', 'customizer section title', 'andros' ),
		'panel'    => 'theme_colors',
		'priority' => 60,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-colors-footer.php' );


	//
	// Typography
	//
	$wp_customize->add_panel( 'theme_typography', array(
		'title'    => esc_html_x( 'Typography', 'customizer section title', 'andros' ),
		'priority' => 70,
	) );

	$wp_customize->add_section( 'theme_typography_content', array(
		'title'    => esc_html_x( 'Global', 'customizer section title', 'andros' ),
		'panel'    => 'theme_typography',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-typography-content.php' );

	$wp_customize->add_section( 'theme_typography_widgets', array(
		'title'    => esc_html_x( 'Widgets', 'customizer section title', 'andros' ),
		'panel'    => 'theme_typography',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-typography-widgets.php' );


	//
	// Social
	//
	$wp_customize->add_section( 'theme_social', array(
		'title'       => esc_html_x( 'Social Networks', 'customizer section title', 'andros' ),
		'description' => esc_html__( 'Enter your social network URLs. Leaving a URL empty will hide its respective icon.', 'andros' ),
		'priority'    => 80,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-social.php' );


	//
	// Footer
	//
	$wp_customize->add_panel( 'theme_footer', array(
		'title'    => esc_html_x( 'Footer', 'customizer section title', 'andros' ),
		'priority' => 90,
	) );

	$wp_customize->add_section( 'theme_footer_style', array(
		'title'    => esc_html_x( 'Footer style', 'customizer section title', 'andros' ),
		'panel'    => 'theme_footer',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-footer-style.php' );

	$wp_customize->add_section( 'theme_footer_bottom_bar', array(
		'title'    => esc_html_x( 'Bottom bar', 'customizer section title', 'andros' ),
		'panel'    => 'theme_footer',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-footer-bottom-bar.php' );


	//
	// Titles
	//
	$wp_customize->add_panel( 'theme_titles', array(
		'title'    => esc_html_x( 'Titles', 'customizer section title', 'andros' ),
		'priority' => 100,
	) );

	$wp_customize->add_section( 'theme_titles_general', array(
		'title'    => esc_html_x( 'General', 'customizer section title', 'andros' ),
		'panel'    => 'theme_titles',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-titles-general.php' );

	$wp_customize->add_section( 'theme_titles_post', array(
		'title'    => esc_html_x( 'Posts', 'customizer section title', 'andros' ),
		'panel'    => 'theme_titles',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-titles-post.php' );


	//
	// Other
	//
	$wp_customize->add_panel( 'theme_other', array(
		'title'                    => esc_html_x( 'Other', 'customizer section title', 'andros' ),
		'description'              => esc_html__( 'Other options affecting the whole site.', 'andros' ),
		'auto_expand_sole_section' => true,
		'priority'                 => 110,
	) );

	$wp_customize->add_section( 'theme_other_sample_content', array(
		'title'    => esc_html_x( 'Sample Content', 'customizer section title', 'andros' ),
		'panel'    => 'theme_other',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/sections/theme-other-sample-content.php' );


	//
	// Site identity
	//
	require_once get_theme_file_path( 'base/customizer/sections/site-identity.php' );

}
add_action( 'customize_register', 'andros_base_customize_register' );



add_action( 'customize_register', 'andros_base_customize_register_custom_controls', 9 );
/**
 * Registers custom Customizer controls.
 *
 * @param WP_Customize_Manager $wp_customize Reference to the customizer's manager object.
 */
function andros_base_customize_register_custom_controls( $wp_customize ) {
	require_once get_theme_file_path( '/base/customizer-controls/static-text/static-text.php' );
	require_once get_theme_file_path( '/base/customizer-controls/alpha-color-picker/alpha-color-picker.php' );

	require_once get_theme_file_path( '/base/customizer-controls/typography/typography.php' );
	$wp_customize->register_control_type( 'Andros_Customize_Typography_Control' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function andros_base_customize_preview_js() {
	wp_enqueue_script( 'andros-base-customizer-preview', get_theme_file_uri( '/base/assets/js/customizer-preview.js' ), array( 'customize-preview' ), andros_asset_version(), true );
	wp_enqueue_style( 'andros-base-customizer-preview', get_theme_file_uri( '/base/customizer/preview/preview.css' ), array( 'customize-preview' ), andros_asset_version() );

	// Generic preview code.
	wp_enqueue_script( 'andros-base-customizer-preview-typography', get_theme_file_uri( '/base/customizer/preview/preview.js' ), array( 'jquery' ), andros_asset_version(), true );

	// Options-specific preview code.
	wp_enqueue_script( 'andros-base-customizer-preview-global', get_theme_file_uri( '/base/customizer/preview/global.js' ), array( 'jquery' ), andros_asset_version(), true );
}
add_action( 'customize_preview_init', 'andros_base_customize_preview_js' );

function andros_base_customize_controls_js() {
	wp_enqueue_style( 'alpha-color-picker-customizer', get_theme_file_uri( '/base/customizer-controls/alpha-color-picker/alpha-color-picker.css' ), array(
		'wp-color-picker',
	), andros_asset_version( '1.0.0' ) );
	wp_enqueue_script( 'alpha-color-picker-customizer', get_theme_file_uri( '/base/customizer-controls/alpha-color-picker/alpha-color-picker.js' ), array(
		'jquery',
		'wp-color-picker',
	), andros_asset_version( '1.0.0' ), true );

	wp_enqueue_style( 'andros-base-customizer-controls', get_theme_file_uri( '/base/customizer-controls/style.css' ), array(), andros_asset_version() );

	wp_enqueue_script( 'andros-base-customizer-controls', get_theme_file_uri( '/base/assets/js/customizer-controls.js' ), array(), andros_asset_version(), true );
}
add_action( 'customize_controls_enqueue_scripts', 'andros_base_customize_controls_js' );

function andros_typography_control_defaults_empty_breakpoints( $override_breakpoints = array() ) {
	$defaults = array(
		'desktop' => array(
			'family'     => '',
			'variant'    => '',
			'size'       => '',
			'lineHeight' => '',
			'transform'  => '',
			'spacing'    => '',
			'is_gfont'   => false,
		),
		'tablet'  => array(
			'family'     => '',
			'variant'    => '',
			'size'       => '',
			'lineHeight' => '',
			'transform'  => '',
			'spacing'    => '',
			'is_gfont'   => false,
		),
		'mobile'  => array(
			'family'     => '',
			'variant'    => '',
			'size'       => '',
			'lineHeight' => '',
			'transform'  => '',
			'spacing'    => '',
			'is_gfont'   => false,
		),
	);

	$return = array();
	foreach ( $defaults as $breakpoint => $values ) {
		if ( isset( $override_breakpoints[ $breakpoint ] ) && is_array( $override_breakpoints[ $breakpoint ] ) ) {
			$return[ $breakpoint ] = array_merge( $values, $override_breakpoints[ $breakpoint ] );
		} else {
			$return[ $breakpoint ] = $values;
		}
	}

	return $return;
}

function andros_sanitize_typography_control_breakpoints( $values ) {
	$defaults = andros_typography_control_defaults_empty_breakpoints();

	if ( ! empty( $values ) && is_string( $values ) ) {
		$values = json_decode( $values, true );
	}

	if ( ! is_array( $values ) ) {
		return $defaults;
	}

	$values = wp_parse_args( $values, $defaults );

	foreach ( $values as $breakpoint => $value ) {
		if ( ! array_key_exists( $breakpoint, $defaults ) ) {
			unset( $values[ $breakpoint ] );
		}
	}

	$new_values = array();

	foreach ( $values as $breakpoint => $breakpoint_values ) {
		if ( array_key_exists( $breakpoint, $defaults ) ) {
			$new_breakpoint_values = wp_parse_args( $breakpoint_values, $defaults[ $breakpoint ] );

			$new_breakpoint_values['family']     = sanitize_text_field( $new_breakpoint_values['family'] );
			$new_breakpoint_values['variant']    = sanitize_text_field( $new_breakpoint_values['variant'] );
			$new_breakpoint_values['size']       = andros_sanitize_intval_or_empty( $new_breakpoint_values['size'] );
			$new_breakpoint_values['lineHeight'] = andros_sanitize_floatval_or_empty( $new_breakpoint_values['lineHeight'] );
			$new_breakpoint_values['transform']  = sanitize_text_field( $new_breakpoint_values['transform'] );
			$new_breakpoint_values['spacing']    = andros_sanitize_floatval_or_empty( $new_breakpoint_values['spacing'] );
			$new_breakpoint_values['is_gfont']   = (bool) intval( $new_breakpoint_values['is_gfont'] );

			$new_values[ $breakpoint ] = $new_breakpoint_values;
		}
	}

	return $new_values;
}

/**
 * CSS Generator.
 */
require_once get_theme_file_path( '/base/class-andros-customizer-css-generator.php' );

/**
 * Customizer generated styles.
 */
require_once get_theme_file_path( '/base/generated-styles.php' );
