/**
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Customizer preview changes asynchronously.
 *
 * https://developer.wordpress.org/themes/customize-api/tools-for-improved-user-experience/#using-postmessage-for-improved-setting-previewing
 */

// Check these.
(function ( $ ) {
	//
	// Typography
	//
	wp.customize( 'global_typo_body', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_body',
				'body',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_secondary', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_body',
				'h1, h2, h3, h4, h5, h6,label,.footer-info,.site-logo,.site-tagline,.head-language-selector,.page-hero-subtitle,.section-subtitle,.item-tooltip,.item-subtitle,.item-title,.navigation,.navigation-main a,.btn,.comment-reply-link,input[type="submit"],input[type="reset"],button,.nav-button > a',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_h1', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_h1',
				'h1, h1.entry-title',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_h2', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_h2',
				'h2, h2.entry-title',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_h3', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_h3',
				'h3',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_h4', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_h4',
				'h4',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_h5', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_h5',
				'h5',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_h6', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_h6',
				'h6',
				to,
			);
		} );
	} );
	
	wp.customize( 'global_typo_menu', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_menu',
				'.navigation-main a',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_form_labels', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_form_labels',
				'form label, form .label',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_form_text', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_form_text',
				'input, textarea, select',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_buttons', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_buttons',
				'.btn, .button, .comment-reply-link, input[type="submit"], input[type="reset"], button, .nav-button > a',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_widget_titles', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_widget_titles',
				'.widget-title',
				to,
			);
		} );
	} );

	wp.customize( 'global_typo_widget_text', function ( value ) {
		value.bind( function ( to ) {
			ANDROS_PREVIEW_SCRIPTS.createTypographyStyles(
				'global_typo_widget_text',
				'.sidebar .widget, .footer .widget, .widget_meta li a, .widget_pages li a, .widget_categories li a, .widget_archive li a, .widget_nav_menu li a, .widget_recent_entries li, .widget_recent_comments li, .widget_rss li',
				to,
			);
		} );
	} );

})( jQuery );
