<?php
/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function andros_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'andros_pingback_header' );


add_filter( 'excerpt_length', 'andros_base_excerpt_length' );
function andros_base_excerpt_length( $length ) {
	return get_theme_mod( 'excerpt_length', 55 );
}

add_filter( 'the_content', 'andros_lightbox_rel', 12 );
add_filter( 'get_comment_text', 'andros_lightbox_rel' );
if ( ! function_exists( 'andros_lightbox_rel' ) ) :
	function andros_lightbox_rel( $content ) {
		if ( get_theme_mod( 'theme_lightbox', 1 ) ) {
			global $post;
			$pattern     = "/<a(.*?)href=('|\")([^>]*).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>(.*?)<\/a>/i";
			$replacement = '<a$1href=$2$3.$4$5 data-lightbox="gal[' . $post->ID . ']"$6>$7</a>';
			$content     = preg_replace( $pattern, $replacement, $content );
		}

		return $content;
	}
endif;

add_filter( 'the_title', 'andros_base_replace_the_title', 10, 2 );
if ( ! function_exists( 'andros_base_replace_the_title' ) ) :
	function andros_base_replace_the_title( $title, $id ) {
		if ( is_admin() ) {
			return $title;
		}

		$alt_title = get_post_meta( $id, 'title', true );

		if ( $alt_title ) {
			$title = $alt_title;
		}

		return $title;
	}
endif;

add_filter( 'wp_link_pages_args', 'andros_wp_link_pages_args' );
function andros_wp_link_pages_args( $params ) {
	return array_merge( $params, array(
		'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'andros' ),
		'after'       => '</div>',
		'link_before' => '<span class="page-number">',
		'link_after'  => '</span>',
	) );
}

// Handle the dismissible sample content notice.
add_action( 'admin_notices', 'andros_admin_notice_sample_content' );
add_action( 'wp_ajax_andros_dismiss_sample_content', 'andros_ajax_dismiss_sample_content' );
function andros_admin_notice_sample_content() {

	$dismissed = get_theme_mod( 'dismissed_sample_content', false );

	if ( ! current_user_can( 'manage_options' ) || $dismissed ) {
		return;
	}

	$sample_content_url = apply_filters( 'andros_sample_content_url',
		sprintf( 'https://www.cssigniter.com/sample_content/%s.zip', ANDROS_NAME ),
		'https://www.cssigniter.com/sample_content/',
		ANDROS_NAME
	);

	if ( empty( $sample_content_url ) ) {
		return;
	}

	?>
	<div class="notice notice-info is-dismissible">
		<div class="andros-sample-content-notice">
			<p>
				<?php
					/* translators: %s is a URL. */
					echo wp_kses( sprintf( __( 'It looks like the theme was just installed. <a href="%s" target="_blank">Download the sample content</a> to get things moving.', 'andros' ), esc_url( $sample_content_url ) ),
						andros_get_allowed_tags( 'guide' )
					);
				?>
			</p>
		</div>
	</div>
	<?php

	wp_enqueue_script( 'andros-sample-content', get_theme_file_uri( '/base/assets/js/sample-content.js' ), array(), andros_asset_version(), true );

	$settings = array(
		'ajaxurl'       => admin_url( 'admin-ajax.php' ),
		'dismiss_nonce' => wp_create_nonce( 'andros-dismiss-sample-content' ),
	);
	wp_localize_script( 'andros-sample-content', 'andros_SampleContent', $settings );
}

function andros_ajax_dismiss_sample_content() {
	check_ajax_referer( 'andros-dismiss-sample-content', 'nonce' );

	if ( current_user_can( 'manage_options' ) && ! empty( $_POST['dismissed'] ) && true === (bool) $_POST['dismissed'] ) {
		set_theme_mod( 'dismissed_sample_content', true );
		wp_send_json_success( 'OK' );
	} else {
		wp_send_json_error( 'BAD' );
	}
}
