<?php
/**
 * Andros functions and definitions
 */

if ( ! defined( 'ANDROS_NAME' ) ) {
	define( 'ANDROS_NAME', 'andros' );
}
if ( ! defined( 'ANDROS_WHITELABEL' ) ) {
	// Set the following to true, if you want to remove any user-facing CSSIgniter traces.
	define( 'ANDROS_WHITELABEL', false );
}

if ( ! function_exists( 'andros_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function andros_setup() {

	// Default content width.
	$GLOBALS['content_width'] = 750;

	// Add common theme supports.
	andros_base_setup();

	// Image sizes
	set_post_thumbnail_size( 750, 500, true );
	add_image_size( 'andros_tall', 750 );
	add_image_size( 'andros_item', 555, 440, true );
	add_image_size( 'andros_item_tall', 555 );
	add_image_size( 'andros_fullwidth', 1140, 650, true );
	add_image_size( 'andros_hero', 1570, 500, true );
	add_image_size( 'andros_slide', 1570, 750, true );

	add_theme_support( 'andros-hero', apply_filters( 'andros_theme_support_hero_defaults', wp_parse_args( array(
		'front-page-classes'    => 'page-hero-lg',
		'front-page-image-size' => 'andros_slide',
		'text-align'            => 'center',
	), andros_base_theme_support_hero_defaults() ) ) );


	add_theme_support( 'andros-hide-single-featured', apply_filters( 'andros_theme_support_hide_single_featured_post_types', array(
		'post',
		'page',
	) ) );

	// Disable spacing support (e.g. no-gutter) for post type listings.
	add_filter( 'andros_post_type_listing_spacing_support', '__return_false' );


	// This provides back-compat for author descriptions on WP < 4.9. Remove by WP 5.1.
	if ( ! has_filter( 'get_the_author_description', 'wpautop' ) ) {
		add_filter( 'get_the_author_description', 'wpautop' );
	}
}
endif;
add_action( 'after_setup_theme', 'andros_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function andros_content_width() {
	$content_width = $GLOBALS['content_width'];

	if ( is_page_template( 'templates/full-width-page.php' )
		|| is_page_template( 'templates/listing-andros_room.php' )
		|| is_page_template( 'templates/front-page.php' )
		|| is_page_template( 'templates/builder.php' )
	) {
		$content_width = 1140;
	} elseif ( is_singular() || is_home() || is_archive() ) {
		$info          = andros_get_layout_info();
		$content_width = $info['content_width'];
	}

	$GLOBALS['content_width'] = apply_filters( 'andros_content_width', $content_width );
}
add_action( 'template_redirect', 'andros_content_width', 0 );

/**
 * Register widget areas.
 */
function andros_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Blog', 'andros' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Widgets added here will appear on the blog section.', 'andros' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Page', 'andros' ),
		'id'            => 'sidebar-2',
		'description'   => esc_html__( 'Widgets added here will appear on the static pages.', 'andros' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Room', 'andros' ),
		'id'            => 'room',
		'description'   => esc_html__( 'Widgets added here will appear on room pages.', 'andros' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Front Page', 'andros' ),
		'id'            => 'frontpage',
		'description'   => esc_html__( 'These widgets appear on pages that have the "Front page" template assigned.', 'andros' ),
		'before_widget' => '<section id="%1$s" class="widget-section %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="section-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Pre-footer', 'andros' ),
		'id'            => 'prefooter',
		'description'   => esc_html__( 'Full width widget area. Accepts the same widgets as the Front Page.', 'andros' ),
		'before_widget' => '<section id="%1$s" class="widget-section %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="section-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'andros_widgets_init' );


function andros_load_widgets() {
	require_once get_theme_file_path( '/inc/widgets/home-latest-post-type.php' );
	require_once get_theme_file_path( '/inc/widgets/home-latest-testimonials.php' );
	require_once get_theme_file_path( '/inc/widgets/home-post-type-items.php' );
	require_once get_theme_file_path( '/inc/widgets/home-split-content.php' );
	require_once get_theme_file_path( '/inc/widgets/home-instagram.php' );

	register_widget( 'CI_Widget_Home_Latest_Post_Type' );
	register_widget( 'CI_Widget_Home_Latest_Testimonials' );
	register_widget( 'CI_Widget_Home_Post_Type_Items' );
	register_widget( 'CI_Widget_Home_Split_Content' );
	if ( class_exists( 'CI_Widget_Home_Instagram' ) ) {
		register_widget( 'CI_Widget_Home_Instagram' );
	}
}
add_action( 'widgets_init', 'andros_load_widgets' );


function andros_get_fullwidth_sidebars() {
	return apply_filters( 'andros_fullwidth_sidebars', array(
		'frontpage',
		'prefooter',
	) );
}


function andros_get_fullwidth_widgets() {
	return apply_filters( 'andros_fullwidth_widgets', array(
		'ci-home-instagram',
		'ci-home-latest-post-type',
		'ci-home-latest-testimonials',
		'ci-home-post-type-items',
		'ci-home-split-content',
	) );
}


function andros_wrap_non_fullwidth_widgets( $params ) {
	$sidebar = $params[0]['id'];
	if ( is_admin() || ! in_array( $sidebar, andros_get_fullwidth_sidebars(), true ) ) {
		return $params;
	}

	$fullwidth_widgets = andros_get_fullwidth_widgets();

	$pattern = '/\-' . $params[1]['number'] . '$/';
	$widget  = $params[0]['widget_id'];
	$widget  = preg_replace( $pattern, '', $widget, 1 );

	$wrap_widget = ! in_array( $widget, $fullwidth_widgets, true );
	$wrap_widget = apply_filters( 'andros_wrap_non_fullwidth_widget', $wrap_widget, $widget, $sidebar, $params );

	if ( $wrap_widget ) {
		$params[0]['before_widget'] = $params[0]['before_widget'] . '<div class="container"><div class="row"><div class="col-12">';
		$params[0]['after_widget']  = '</div></div></div>' . $params[0]['after_widget'];
		$params[0]['before_title']  = '<div class="section-heading">' . $params[0]['before_title'];
		$params[0]['after_title']   = $params[0]['after_title'] . '</div>';
	}

	return $params;
}
add_filter( 'dynamic_sidebar_params', 'andros_wrap_non_fullwidth_widgets' );

function andros_set_layout_info( $classes, $has_sidebar ) {
	$narrow = 'col-xl-8 offset-xl-2 col-lg-10 offset-lg-1 col-12';

	$classes = array(
		'container_classes' => $has_sidebar ? 'col-lg-8 col-12' : $narrow,
		'sidebar_classes'   => $has_sidebar ? 'col-lg-4 col-12' : '',
		'content_width'     => 750,
		'has_sidebar'       => $has_sidebar,
	);

	if ( is_singular() ) {
		if ( 'left' === get_post_meta( get_the_ID(), 'andros_sidebar', true ) ) {
			$classes = array(
				'container_classes' => $has_sidebar ? 'col-lg-8 push-lg-4 col-12' : $narrow,
				'sidebar_classes'   => $has_sidebar ? 'col-lg-4 pull-lg-8 col-12' : '',
				'content_width'     => 750,
				'has_sidebar'       => $has_sidebar,
			);
		} elseif ( 'none' === get_post_meta( get_the_ID(), 'andros_sidebar', true ) ) {
			$classes = array(
				'container_classes' => $narrow,
				'sidebar_classes'   => '',
				'content_width'     => 750,
				'has_sidebar'       => false,
			);
		}
	} elseif ( is_home() || is_archive() ) {
		// 1 will get default narrow fullwidth classes. 2 and 3 will get fullwidth.
		if ( 1 !== (int) get_theme_mod( 'archive_layout', andros_archive_layout_default() ) ) {
			if ( ! $has_sidebar ) {
				$classes = array(
					'container_classes' => 'col-12',
					'sidebar_classes'   => '',
					'content_width'     => 1140,
					'has_sidebar'       => false,
				);
			}
		}
	}

	return $classes;
}
add_filter( 'andros_layout_info', 'andros_set_layout_info', 10, 2 );

/**
 * Enqueue scripts and styles.
 */
function andros_scripts() {
	wp_register_style( 'andros-base', get_theme_file_uri( '/css/base.css' ), array(), andros_asset_version() );
	wp_register_style( 'andros-hotel-icons', get_theme_file_uri( '/base/assets/vendor/ci-hotel-icons/css/ci-hotel-icons.css' ), array(), andros_asset_version() );
	wp_register_style( 'mmenu', get_theme_file_uri( '/css/mmenu.css' ), array(), andros_asset_version( '5.5.3' ) );

	wp_register_style( 'andros-dependencies', false, array(
		'andros-base',
		'andros-common',
		'mmenu',
		'slick',
		'font-awesome-5',
		'andros-hotel-icons',
	), andros_asset_version() );

	$main_dependencies = array(
		'andros-dependencies',
	);

	if ( is_child_theme() ) {
		wp_enqueue_style( 'andros-style-parent', get_template_directory_uri() . '/style.css', $main_dependencies, andros_asset_version() );
	}

	wp_enqueue_style( 'andros-style', get_stylesheet_uri(), $main_dependencies, andros_asset_version() );


	wp_register_script( 'mmenu', get_theme_file_uri( '/js/jquery.mmenu.min.all.js' ), array( 'jquery' ), andros_asset_version( '5.5.3' ), true );
	wp_register_script( 'fitVids', get_theme_file_uri( '/js/jquery.fitvids.js' ), array( 'jquery' ), andros_asset_version( '1.1' ), true );
	wp_register_script( 'isotope', get_theme_file_uri( '/js/isotope.pkgd.min.js' ), array( 'jquery' ), andros_asset_version( '3.0.2' ), true );
	wp_register_script( 'sticky-kit', get_theme_file_uri( '/js/jquery.sticky-kit.min.js' ), array( 'jquery' ), andros_asset_version( '1.1.4' ), true );

	/*
	 * Enqueue
	 */
	wp_enqueue_script( 'andros-front-scripts', get_theme_file_uri( '/js/scripts.js' ), array(
		'jquery',
		'mmenu',
		'slick',
		'fitVids',
		'isotope',
		'sticky-kit',
		'anim-on-scroll',
	), andros_asset_version(), true );

}
add_action( 'wp_enqueue_scripts', 'andros_scripts' );


/**
 * Enqueue admin scripts and styles.
 */
function andros_admin_scripts( $hook ) {
	//
	// Styles
	//
	wp_register_style( 'andros-widgets', get_theme_file_uri( '/css/admin/widgets.css' ), array(
		'andros-repeating-fields',
		'andros-plugin-post-meta',
		'alpha-color-picker',
	), andros_asset_version() );


	//
	// Scripts
	//
	wp_register_script( 'andros-widgets', get_theme_file_uri( '/js/admin/widgets.js' ), array(
		'jquery',
		'andros-repeating-fields',
		'andros-plugin-post-meta',
		'alpha-color-picker',
	), andros_asset_version(), true );
	$params = array(
		'ajaxurl' => admin_url( 'admin-ajax.php' ),
	);
	wp_localize_script( 'andros-widgets', 'ThemeWidget', $params );


	/*
	 * Enqueue
	 */
	if ( in_array( $hook, array( 'widgets.php', 'customize.php' ), true ) ) {
		wp_enqueue_media();
		wp_enqueue_style( 'andros-widgets' );
		wp_enqueue_script( 'andros-widgets' );
	}

}
add_action( 'admin_enqueue_scripts', 'andros_admin_scripts' );


if ( ! function_exists( 'andros_get_columns_classes' ) ) :
	function andros_get_columns_classes( $columns ) {
		switch ( intval( $columns ) ) {
			case 1:
				$classes = 'col-12';
				break;
			case 2:
				$classes = 'col-sm-6 col-12';
				break;
			case 3:
				$classes = 'col-lg-4 col-sm-6 col-12';
				break;
			case 4:
			default:
				$classes = 'col-xl-3 col-lg-4 col-sm-6 col-12';
				break;
		}

		return apply_filters( 'andros_get_columns_classes', $classes, $columns );
	}
endif;

add_filter( 'andros_has_sidebar', 'andros_filter_has_sidebar' );
function andros_filter_has_sidebar( $has_sidebar ) {
	if ( is_singular( 'andros_room' ) ) {
		if ( is_active_sidebar( 'room' ) ) {
			$has_sidebar = true;
		} else {
			$has_sidebar = false;
		}
	}

	return $has_sidebar;
}

add_action( 'tgmpa_register', 'andros_register_required_plugins' );
function andros_register_required_plugins() {
	$plugins = array(
		array(
			'name'               => 'Andros theme-specific plugin', // The plugin name.
			'version'            => '1.2.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
			'slug'               => 'andros-plugin', // The plugin slug (typically the folder name).
			'source'             => get_template_directory() . '/plugins/andros-plugin.zip', // The plugin source.
			'required'           => true, // If false, the plugin is only 'recommended' instead of required.
			'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			'external_url'       => '', // If set, overrides default API URL and points to an external URL.
			'is_callable'        => 'andros_plugin_setup', // If set, this callable will be be checked for availability to determine if a plugin is active.
		),
		array(
			'name'     => 'MaxSlider',
			'slug'     => 'maxslider',
			'required' => false,
		),
		array(
			'name'     => 'Elementor',
			'slug'     => 'elementor',
			'required' => false,
		),
	);

	$config = array(
		'id'           => 'andros',              // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}


if ( ! defined( 'ANDROS_WHITELABEL' ) || false === (bool) ANDROS_WHITELABEL ) {
	add_filter( 'pt-ocdi/import_files', 'andros_ocdi_import_files' );
	add_action( 'pt-ocdi/after_import', 'andros_ocdi_after_import_setup' );
}

add_filter( 'pt-ocdi/timeout_for_downloading_import_file', 'andros_ocdi_download_timeout' );
function andros_ocdi_download_timeout( $timeout ) {
	return 60;
}

function andros_ocdi_import_files( $files ) {
	if ( ! defined( 'ANDROS_NAME' ) ) {
		define( 'ANDROS_NAME', 'andros' );
	}

	$demo_dir_url = untrailingslashit( apply_filters( 'andros_ocdi_demo_dir_url', 'https://www.cssigniter.com/sample_content/' . ANDROS_NAME ) );

	// When having more that one predefined imports, set a preview image, preview URL, and categories for isotope-style filtering.
	$new_files = array(
		array(
			'import_file_name'           => esc_html__( 'Demo Import', 'andros' ),
			'import_file_url'            => $demo_dir_url . '/content.xml',
			'import_widget_file_url'     => $demo_dir_url . '/widgets.wie',
			'import_customizer_file_url' => $demo_dir_url . '/customizer.dat',
		),
	);

	return array_merge( $files, $new_files );
}

function andros_ocdi_after_import_setup() {
	// Set up nav menus.
	$main_menu = get_term_by( 'name', 'Main', 'nav_menu' );

	set_theme_mod( 'nav_menu_locations', array(
		'menu-1' => $main_menu->term_id,
	) );

	// Set up home and blog pages.
	$front_page_id = get_page_by_title( 'Home' );
	$blog_page_id  = get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );

	// Try to force a term recount.
	// wp_defer_term_counting( false ) doesn't work properly as there are post imported from different AJAX requests.
	$taxonomies = get_taxonomies( array(), 'names' );
	foreach ( $taxonomies as $taxonomy ) {
		$terms             = get_terms( $taxonomy, array( 'hide_empty' => false ) );
		$term_taxonomy_ids = wp_list_pluck( $terms, 'term_taxonomy_id' );

		wp_update_term_count( $term_taxonomy_ids, $taxonomy );
	}
}

function andros_customizer_defaults( $setting = false ) {
	$theme = wp_get_theme();

	// phpcs:disable WordPress.Arrays.MultipleStatementAlignment.DoubleArrowNotAligned
	$defaults = apply_filters(
		'andros_customizer_defaults',
		array(
			'global_typo_disable_google_fonts' => 0,
			'global_typo_body' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Roboto',
						'variant'    => '300',
						'size'       => 16,
						'lineHeight' => 1.5,
						'transform'  => 'none',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_secondary' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_h1' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 26,
						'lineHeight' => 1.2,
						'transform'  => 'uppercase',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_h2' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 22,
						'lineHeight' => 1.2,
						'transform'  => 'uppercase',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_h3' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 20,
						'lineHeight' => 1.2,
						'transform'  => 'uppercase',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_h4' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 18,
						'lineHeight' => 1.2,
						'transform'  => 'uppercase',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_h5' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 16,
						'lineHeight' => 1.2,
						'transform'  => 'uppercase',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_h6' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 14,
						'lineHeight' => 1.2,
						'transform'  => 'uppercase',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_menu' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 14,
						'lineHeight' => 1.2,
						'transform'  => 'uppercase',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_form_labels' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 14,
						'lineHeight' => 1.2,
						'transform'  => 'none',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_form_text' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Roboto',
						'variant'    => 'regular',
						'size'       => 16,
						'lineHeight' => 1.2,
						'transform'  => 'none',
						'spacing'    => '',
						'is_gfont'   => false,
					),
				)
			),
			'global_typo_buttons' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => '700',
						'size'       => 14,
						'lineHeight' => 1.2,
						'transform'  => 'uppercase',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_widget_titles' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Lora',
						'variant'    => 'regular',
						'size'       => 16,
						'lineHeight' => 1.2,
						'transform'  => 'none',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
			'global_typo_widget_text' => andros_typography_control_defaults_empty_breakpoints(
				array(
					'desktop' => array(
						'family'     => 'Roboto',
						'variant'    => '300',
						'size'       => 14,
						'lineHeight' => 1.57,
						'transform'  => 'none',
						'spacing'    => '',
						'is_gfont'   => true,
					),
				)
			),
		)
	);
	// phpcs:enable

	if ( ! empty( $setting ) && array_key_exists( $setting, $defaults ) ) {
		return apply_filters( 'andros_customizer_default', $defaults[ $setting ], $setting );
	}

	return $defaults;
}

add_filter( 'andros_customizer_css_generator_standard_gfont_weights', 'andros_extra_gfont_weights' );
function andros_extra_gfont_weights( $weights ) {
	$extra_weights = array(
		'300',
		'300i',
	);

	$weights = array_merge( $weights, $extra_weights );

	return $weights;
}

/**
 * Data upgrade.
 */
require_once get_theme_file_path( '/inc/upgrade.php' );

/**
 * Fonts list.
 */
require_once get_theme_file_path( '/inc/class-fonts-list.php' );

/**
 * Common theme features.
 */
require_once get_theme_file_path( '/common/common.php' );

/**
 * Base theme functions and definitions.
 */
require_once get_theme_file_path( '/base/functions.php' );

/**
 * Customizer additions.
 */
require_once get_theme_file_path( '/inc/customizer.php' );

/**
 * Customizer styles.
 */
require_once get_theme_file_path( '/inc/customizer-styles.php' );

/**
 * Customizer styles.
 */
require_once get_theme_file_path( '/inc/maxslider.php' );

/**
 * Post type related includes.
 */
require_once get_theme_file_path( '/base/items-listing.php' );

/**
 * FontAwesome Conversion Helper.
 */
require_once get_theme_file_path( '/inc/class-cssigniter-fontawesome-convert-4-to-5.php' );

/**
 * TGM_Plugin_Activation class.
 */
require_once get_theme_file_path( '/base/class-tgm-plugin-activation.php' );

/**
 * Elementor related code.
 */
if ( defined( 'ELEMENTOR_VERSION' ) && version_compare( PHP_VERSION, '5.4', '>=' ) ) {
	require_once get_theme_file_path( '/inc/elementor/inc/elementor-helper.php' );
	require_once get_theme_file_path( '/inc/elementor/inc/andros-element-common-functions.php' );
	require_once get_theme_file_path( '/inc/elementor/elementor.php' );
}
