<?php
	if ( ! function_exists( 'andros_get_part_customizer_css' ) ) :
		/**
		 * Generates CSS based on per-theme customizer settings.
		 *
		 * @return string
		 */
		function andros_get_part_customizer_css() {
			ob_start();

			//
			// Global Colors
			//
			$site_accent_color = get_theme_mod( 'site_accent_color' );

			if ( ! empty( $site_accent_color ) ) {
				?>
				a,
				.entry-title a:hover,
				.social-icon:hover,
				.text-theme,
				.section-subtitle,
				.item-subtitle,
				.entry-content blockquote:not(.slide-testimonial)::before {
					color: <?php echo sanitize_hex_color( $site_accent_color ); ?>;
				}

				a:hover {
					color: <?php echo sanitize_hex_color( andros_color_luminance( $site_accent_color, .1 ) ); ?>;
				}

				a:focus {
					outline: 1px dotted <?php echo sanitize_hex_color( $site_accent_color ); ?>;
				}

				.entry-amenities li::before,
				.item-tooltip,
				.navigation a:hover,
				.navigation .current,
				.page-links .page-number:hover,
				.page-links .current .page-number {
					background-color: <?php echo sanitize_hex_color( $site_accent_color ); ?>;
				}

				input:focus,
				textarea:focus {
					box-shadow: inset 2px 2px 0 0 <?php echo andros_hex2rgba( $site_accent_color, .5 ); ?>;
				}

				.btn:focus,
				.button:focus,
				.comment-reply-link:focus,
				input[type="submit"]:focus,
				input[type="reset"]:focus,
				button:focus,
				.navigation-main .nav-button > a:focus {
					box-shadow: 0 0 10px <?php echo andros_hex2rgba( $site_accent_color, .7 ); ?>;
				}

				.comments-title::after,
				.comment-reply-title::after,
				.section-heading::after,
				.widget-title::after {
					border-color: <?php echo sanitize_hex_color( $site_accent_color ); ?>;
				}
				<?php
			}

			$site_text_color = get_theme_mod( 'site_text_color' );

			if ( ! empty( $site_text_color ) ) {
				$site_text_color_light = andros_color_luminance( $site_text_color, 0.3 );
				?>
				body,
				blockquote cite,
				.instagram-pics li a,
				.social-icon,
				.widget_meta li a,
				.widget_pages li a,
				.widget_categories li a,
				.widget_archive li a,
				.widget_nav_menu li a {
					color: <?php echo sanitize_hex_color( $site_text_color ); ?>;
				}

				h1, h2, h3, h4, h5, h6,
				.entry-title a,
				.entry-meta,
				.item-title,
				.item-filter,
				.navigation a,
				.navigation .page-numbers,
				.page-links .page-number,
				.entry-tags a,
				.tag-cloud-link {
					color: <?php echo sanitize_hex_color( $site_text_color_light ); ?>;
				}

				.item-filter,
				.slideshow-testimonials .slick-dots button::before,
				.navigation a,
				.navigation .page-numbers,
				.page-links .page-number,
				.entry-tags a,
				.tag-cloud-link {
					border-color: <?php echo sanitize_hex_color( $site_text_color_light ); ?>;
				}

				.slideshow-testimonials .slick-dots button {
					background-color: <?php echo sanitize_hex_color( $site_text_color_light ); ?>;
				}
				<?php
			}

			$site_border_color = get_theme_mod( 'site_border_color' );

			if ( ! empty( $site_border_color ) ) {
				?>
				blockquote,
				select,
				input,
				textarea,
				input:focus,
				textarea:focus,
				.no-comments,
				.footer,
				.footer-info,
				.header,
				.widget select,
				.ci-schedule-widget-table tr,
				.widget_recent_comments li,
				.widget_rss li,
				.widget_recent_entries li,
				.entry-room-amenities,
				.entry-room-amenities li {
					border-color: <?php echo sanitize_hex_color( $site_border_color ); ?>;
				}
				<?php
			}

			$css = ob_get_clean();
			return apply_filters( 'andros_part_customizer_css', $css );
		}
	endif;
