<?php
namespace Elementor;

class Andros_Element extends Widget_Base {

	use \Elementor\ElementsCommonFunctions;

	public function get_name() {
		return 'andros_element';
	}

	public function get_title() {
		return __( 'Andros Element', 'andros' );
	}

	public function get_icon() {
		return 'eicon-wordpress';
	}

	public function get_categories() {
		return [ 'andros-elements' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Andros Element', 'andros' ),
			]
		);

		$this->add_control(
			'columns',
			[
				'label'   => __( 'Columns', 'andros' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '2',
				'options' => [
					'2' => __( '2', 'andros' ),
					'3' => __( '3', 'andros' ),
					'4' => __( '4', 'andros' ),
				],
			]
		);

		$this->add_control(
			'view',
			[
				'label'   => __( 'View', 'andros' ),
				'type'    => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->query_controls();

		$this->appearance_controls( 'andros_element_posts_post_type' );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_title',
			[
				'label' => __( 'Title Styles', 'andros' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_text_color',
			[
				'label'     => __( 'Text Color', 'andros' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#616161',
				'selectors' => [
					'{{WRAPPER}} .item-title' => 'color: {{VALUE}};',
				],
				'scheme'    => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_3,
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
				'selector' => '{{WRAPPER}} .item-title',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_subtitle',
			[
				'label' => __( 'Subtitle Styles', 'andros' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_text_color',
			[
				'label'     => __( 'Text Color', 'andros' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#bca857',
				'selectors' => [
					'{{WRAPPER}} .item-subtitle' => 'color: {{VALUE}};',
				],
				'scheme'    => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_3,
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
				'selector' => '{{WRAPPER}} .item-subtitle',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_offer',
			[
				'label'     => __( 'Offer Box Styles', 'andros' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'andros_element_posts_post_type' => 'andros_room',
				],
			]
		);

		$this->add_control(
			'offer_bg_color',
			[
				'label'     => __( 'Background Color', 'andros' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-tooltip' => 'background-color: {{VALUE}};',
				],
				'scheme'    => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_3,
				],
			]
		);

		$this->add_control(
			'offer_text_color',
			[
				'label'     => __( 'Text Color', 'andros' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-tooltip' => 'color: {{VALUE}};',
				],
				'scheme'    => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_3,
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'offer_typography',
				'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
				'selector' => '{{WRAPPER}} .item-tooltip',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_button',
			[
				'label' => __( 'Button', 'andros-plugin' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button_typography',
				'scheme'   => Scheme_Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} a.btn',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'andros-plugin' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label'     => __( 'Text Color', 'andros-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_color',
			[
				'label'     => __( 'Background Color', 'andros-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} a.btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'andros-plugin' ),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label'     => __( 'Text Color', 'andros-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.btn:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label'     => __( 'Background Color', 'andros-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label'     => __( 'Border Color', 'andros-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.btn:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'button_border',
				'selector'  => '{{WRAPPER}} a.btn',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label'      => __( 'Border Radius', 'andros-plugin' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} a.btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_box_shadow',
				'selector' => '{{WRAPPER}} a.btn',
			]
		);

		$this->add_responsive_control(
			'button_text_padding',
			[
				'label'      => __( 'Padding', 'andros-plugin' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} a.btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings();

		$columns = $settings['columns'];

		$query_args = Andros_Element_Helper::get_query_args( 'andros_element_posts', $this->get_settings() );

		$columns_classes = function_exists( 'andros_get_columns_classes' ) ? andros_get_columns_classes( $columns ) : 'col-12';

		$q = new \WP_Query( $query_args );

		if ( $q->have_posts() ) {

			?><div class="row row-items"><?php

			while ( $q->have_posts() ) {
				$q->the_post();

				?>
				<div class="<?php echo esc_attr( $columns_classes ); ?>">

					<?php
						$post_ext = '';

						if ( in_array( get_post_type(), array( 'post', 'andros_room' ), true ) ) {
							$post_ext = '-' . get_post_type();
						}

						$template_path = 'template-parts/elementor/item' . $post_ext . '.php';

						include locate_template( $template_path, false, false );
					?>

				</div>
				<?php
			}
			wp_reset_postdata();

			?></div><?php
		}

	}

}
