<?php
namespace Elementor;

/**
 * Andros Elementor related code.
 */

function andros_elementor_init() {
	Plugin::instance()->elements_manager->add_category(
		'andros-elements',
		[
			'title' => __( 'Andros Elements', 'andros' ),
			'icon'  => 'font',
		],
		1
	);
}
add_action( 'elementor/init', 'Elementor\andros_elementor_init' );

add_action( 'elementor/theme/register_locations', 'Elementor\andros_register_elementor_locations' );
function andros_register_elementor_locations( $elementor_theme_manager ) {
	$elementor_theme_manager->register_location( 'header' );
	$elementor_theme_manager->register_location( 'footer' );
	$elementor_theme_manager->register_location( 'single' );
	$elementor_theme_manager->register_location( 'archive' );
}


add_action( 'elementor/editor/before_enqueue_scripts', 'Elementor\andros_enqueue_scripts_elementor' );
function andros_enqueue_scripts_elementor() {
	andros_base_register_scripts();
	andros_admin_scripts( '' );
	wp_enqueue_media();
	wp_enqueue_style( 'andros-widgets' );
	wp_enqueue_script( 'andros-widgets' );
}

add_action( 'elementor/widgets/widgets_registered', 'Elementor\andros_elementor_add_elements' );
function andros_elementor_add_elements() {
	require_once get_theme_file_path( '/inc/elementor/andros-element.php' );
	Plugin::instance()->widgets_manager->register_widget_type( new Andros_Element() );
}

add_action( 'elementor/controls/controls_registered', 'Elementor\andros_posts_register_control' );
function andros_posts_register_control( $controls_manager ) {
	require_once get_theme_file_path( '/inc/elementor/inc/andros-element-posts-group-control.php' );
	$controls_manager->add_group_control( 'andros_element_posts', new Andros_Element_Posts_Group_Control() );
}

