<?php
namespace Elementor;

use Elementor\Group_Control_Base;

trait ElementsCommonFunctions {

	/**
	 * For Exclude Option
	 */
	public function add_exclude_controls() {
		$this->add_control(
			'post__not_in',
			[
				'label'       => __( 'Exclude', 'andros' ),
				'type'        => Controls_Manager::SELECT2,
				'options'     => Andros_Element_Helper::get_all_post_type_items(),
				'label_block' => true,
				'post_type'   => '',
				'multiple'    => true,
				'condition'   => [
					'andros_element_posts_post_type!' => 'by_id',
				],
			]
		);
	}

	protected function query_controls() {

		$this->add_group_control(
			Andros_Element_Posts_Group_Control::get_type(),
			[
				'name' => 'andros_element_posts',
			]
		);

		$this->add_exclude_controls();

		$this->add_control(
			'posts_per_page',
			[
				'label'     => __( 'Posts Per Page', 'andros' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => '4',
				'condition' => [
					'andros_element_posts_post_type!' => 'by_id',
				],
			]
		);

		$this->add_control(
			'offset',
			[
				'label'     => __( 'Offset', 'andros' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => '0',
				'condition' => [
					'andros_element_posts_post_type!' => 'by_id',
				],
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => __( 'Order By', 'andros' ),
				'type'    => Controls_Manager::SELECT,
				'options' => Andros_Element_Helper::get_post_orderby_options(),
				'default' => 'date',

			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __( 'Order', 'andros' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'asc'  => __( 'Ascending', 'andros' ),
					'desc' => __( 'Descending', 'andros' ),
				],
				'default' => 'desc',

			]
		);

	}

	protected function appearance_controls( $pt_source ) {
		$this->add_control(
			'show_offer',
			[
				'label'        => __( 'Show Room Offer Badge', 'andros' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'andros' ),
				'label_off'    => __( 'Hide', 'andros' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					$pt_source => [ 'andros_room', 'by_id' ],
				],
			]
		);

		$this->add_control(
			'show_thumbnail',
			[
				'label'        => __( 'Show Thumbnail', 'andros' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'andros' ),
				'label_off'    => __( 'Hide', 'andros' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'        => __( 'Show Title', 'andros' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'andros' ),
				'label_off'    => __( 'Hide', 'andros' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_subtitle',
			[
				'label'        => __( 'Show Subtitle', 'andros' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'andros' ),
				'label_off'    => __( 'Hide', 'andros' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'        => __( 'Show Button', 'andros' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'andros' ),
				'label_off'    => __( 'Hide', 'andros' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
	}
}
