<?php
namespace Elementor;

class Andros_Element_Helper {

	public static function get_query_args( $control_id, $settings ) {
		$defaults = [
			$control_id . '_post_type' => 'post',
			$control_id . '_posts_ids' => [],
			'orderby'                  => 'date',
			'order'                    => 'desc',
			'posts_per_page'           => 3,
			'offset'                   => 0,
		];

		$settings = wp_parse_args( $settings, $defaults );

		$post_type = $settings[ $control_id . '_post_type' ];

		$query_args = [
			'orderby'             => $settings['orderby'],
			'order'               => $settings['order'],
			'ignore_sticky_posts' => 1,
			'post_status'         => 'publish',
		];

		if ( 'by_id' === $post_type ) {
			$query_args['post_type'] = 'any';
			$query_args['post__in']  = $settings[ $control_id . '_posts_ids' ];

			if ( empty( $query_args['post__in'] ) ) {
				// If no selection - return an empty query
				$query_args['post__in'] = [ 0 ];
			}
		} else {
			$query_args['post_type']      = $post_type;
			$query_args['posts_per_page'] = $settings['posts_per_page'];
			$query_args['tax_query']      = [];

			$query_args['offset'] = $settings['offset'];

			$taxonomies = get_object_taxonomies( $post_type, 'objects' );

			foreach ( $taxonomies as $object ) {
				$setting_key = $control_id . '_' . $object->name . '_ids';

				if ( ! empty( $settings[ $setting_key ] ) ) {
					$query_args['tax_query'][] = [
						'taxonomy' => $object->name,
						'field'    => 'term_id',
						'terms'    => $settings[ $setting_key ],
					];
				}
			}
		}

		if ( ! empty( $settings[ $control_id . '_authors' ] ) ) {
			$query_args['author__in'] = $settings[ $control_id . '_authors' ];
		}

		$post__not_in = [];
		if ( ! empty( $settings['post__not_in'] ) ) {
			$post__not_in               = array_merge( $post__not_in, $settings['post__not_in'] );
			$query_args['post__not_in'] = $post__not_in;
		}

		if ( isset( $query_args['tax_query'] ) && count( $query_args['tax_query'] ) > 1 ) {
			$query_args['tax_query']['relation'] = 'OR';
		}

		return $query_args;
	}

	/**
	 * Get All Post Types
	 *
	 * @return array
	 */
	public static function element_post_types() {
		$cpts = get_post_types( array(
			'public'            => true,
			'show_in_nav_menus' => true,
		), 'object' );

		// TODO: Add any post types that we don't want to be selectable.
		$excluded_cpts = apply_filters( 'andros_element_excluded_cpts', array(
			'elementor_library',
			'attachment',
		) );

		foreach ( $excluded_cpts as $excluded_cpt ) {
			unset( $cpts[ $excluded_cpt ] );
		}

		$post_types = array_merge( $cpts );

		$types = wp_list_pluck( $post_types, 'label', 'name' );

		return $types;
	}

	/**
	 * Get all types of post.
	 *
	 * @return array
	 */
	public static function get_all_post_type_items() {
		$posts_args = array(
			'post_type'      => array_keys( self::element_post_types() ),
			'post_status'    => 'publish',
			'posts_per_page' => '-1',
		);

		$posts = new \WP_Query( $posts_args );

		$post_list = wp_list_pluck( $posts->posts, 'post_title', 'ID' );

		return $post_list;
	}

	/**
	 * Post Orderby Options
	 *
	 * @return array
	 */
	public static function get_post_orderby_options() {
		$orderby = array(
			'ID'            => __( 'Post ID', 'andros' ),
			'author'        => __( 'Post Author', 'andros' ),
			'title'         => __( 'Title', 'andros' ),
			'date'          => __( 'Date', 'andros' ),
			'modified'      => __( 'Last Modified Date', 'andros' ),
			'parent'        => __( 'Parent Id', 'andros' ),
			'rand'          => __( 'Random', 'andros' ),
			'comment_count' => __( 'Comment Count', 'andros' ),
			'menu_order'    => __( 'Menu Order', 'andros' ),
		);

		return apply_filters( 'andros_element_orderby_options', $orderby );
	}

}
