<?php
// TODO: Remove migration when theme reaches v1.6.0 or 2.0.0
add_action( 'after_setup_theme', 'andros_migrate_typography_mods' );
function andros_migrate_typography_mods() {
	if ( get_theme_mod( 'migrated_typography' ) ) {
		return;
	}

	$sizes = array(
		'content_h1_size'         => 'global_typo_h1',
		'content_h2_size'         => 'global_typo_h2',
		'content_h3_size'         => 'global_typo_h3',
		'content_h4_size'         => 'global_typo_h4',
		'content_h5_size'         => 'global_typo_h5',
		'content_h6_size'         => 'global_typo_h6',
		'content_body_size'       => 'global_typo_body',
		'theme_widget_title_size' => 'global_typo_widget_titles',
		'theme_widget_text_size'  => 'global_typo_widget_text',
	);

	foreach ( $sizes as $old => $new ) {
		if ( get_theme_mod( $old ) ) {
			$new_mod = andros_typography_control_defaults_empty_breakpoints( array(
				'desktop' => array(
					'size' => intval( get_theme_mod( $old ) ),
				),
			) );
			set_theme_mod( $new, $new_mod );
			remove_theme_mod( $old );
		}
	}

	set_theme_mod( 'migrated_typography', true );
}
// TODO: Remove migration when theme reaches v1.6.0 or v2.0
// TODO: When we remove the migration code, make sure to also clean up the options/meta created by the migration.
if ( ! get_option( 'andros_migrated_typography_lineheight' ) ) {
	add_action( 'wp_loaded', 'andros_migrate_typography_line_height_pixels_to_unitless' );
}
function andros_migrate_typography_line_height_pixels_to_unitless() {
	if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) ||
		( defined( 'DOING_CRON' ) && DOING_CRON ) ) {
		return;
	}

	if ( get_option( 'andros_migrated_typography_lineheight' ) ) {
		return;
	}

	$theme_mods = array_keys( andros_get_registered_typography_controls() );

	foreach ( $theme_mods as $key ) {
		$value = get_theme_mod( $key );
		if ( is_array( $value ) ) {
			$value = andros_convert_typography_line_height_to_unitless( $value );
			set_theme_mod( $key, $value );
		}
	}

	update_option( 'andros_migrated_typography_lineheight', true, true );
}

function andros_convert_typography_line_height_to_unitless( $typo_array ) {
	if ( ! is_array( $typo_array ) ) {
		return $typo_array;
	}

	foreach ( $typo_array as $breakpoint => $bp_values ) {
		if ( ! empty( $bp_values['size'] ) && ! empty( $bp_values['lineHeight'] ) ) {
			$typo_array[ $breakpoint ]['lineHeight'] = round( $bp_values['lineHeight'] / $bp_values['size'], 2 );
		} elseif ( empty( $bp_values['size'] ) && ! empty( $bp_values['lineHeight'] ) ) {
			$typo_array[ $breakpoint ]['lineHeight'] = '';
		}
	}

	return $typo_array;
}

// TODO: Remove when theme reaches v1.6.0 or v2.0
// Fix typography mods that don't have a font family assigned.
// These were caused by andros_migrate_typography_mods() in previous versions,
// as (at the time) default typography settings weren't outputted.
add_action( 'wp_loaded', 'andros_fix_empty_family_typography_mods' );
function andros_fix_empty_family_typography_mods() {
	if ( ! get_theme_mod( 'migrated_typography' ) || ! get_option( 'andros_migrated_typography_lineheight' ) || get_theme_mod( 'migrated_typography_filled_defaults' ) ) {
		return;
	}

	$mods = array(
		'content_h1_size'         => 'global_typo_h1',
		'content_h2_size'         => 'global_typo_h2',
		'content_h3_size'         => 'global_typo_h3',
		'content_h4_size'         => 'global_typo_h4',
		'content_h5_size'         => 'global_typo_h5',
		'content_h6_size'         => 'global_typo_h6',
		'content_body_size'       => 'global_typo_body',
		'theme_widget_title_size' => 'global_typo_widget_titles',
		'theme_widget_text_size'  => 'global_typo_widget_text',
	);

	foreach ( $mods as $key ) {
		$value   = get_theme_mod( $key );
		$default = andros_customizer_defaults( $key );

		if ( ! is_array( $value ) || ! isset( $value['desktop']['family'] ) ) {
			$value = $default;
		} else {
			// 'family' and 'is_gfont' are a pair, so make sure to copy them together.
			$family = $value['desktop']['family'];
			if ( '' === $family ) {
				$value['desktop']['family']   = $default['desktop']['family'];
				$value['desktop']['is_gfont'] = $default['desktop']['is_gfont'];
			}

			// Go through the rest.
			foreach ( $default['desktop'] as $d_key => $d_value ) {
				if ( '' === $value['desktop'][ $d_key ] ) {
					$value['desktop'][ $d_key ] = $d_value;
				}
			}
		}

		set_theme_mod( $key, $value );
	}


	set_theme_mod( 'migrated_typography_filled_defaults', true );
}