/**
 * Base Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Base Theme Customizer preview reload changes asynchronously.
 *
 * https://developer.wordpress.org/themes/customize-api/tools-for-improved-user-experience/#using-postmessage-for-improved-setting-previewing
 */

(function ($) {
	function createStyleSheet(settingName, styles) {
		var $styleElement;

		style = '<style class="' + settingName + '">';
		style += styles.reduce(function (rules, style) {
			rules += style.selectors + '{' + style.property + ':' + style.value + ';} ';
			return rules;
		}, '');
		style += '</style>';

		$styleElement = $('.' + settingName);

		if ($styleElement.length) {
			$styleElement.replaceWith(style);
		} else {
			$('head').append(style);
		}
	}

	//
	// Theme global colors
	//
	wp.customize('site_accent_color', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_accent_color', [
				{
					property: 'color',
					value: to,
					selectors: 'a,.entry-title a:hover,.social-icon:hover,.text-theme,.section-subtitle,.item-subtitle,.entry-content blockquote:not(.slide-testimonial)::before'
				},
				{
					property: 'background-color',
					value: to,
					selectors: '.entry-amenities li::before,.item-tooltip,.navigation a:hover,.navigation .current,.page-links .page-number:hover'
				},
				{
					property: 'border-color',
					value: to,
					selectors: '.comments-title::after,.comment-reply-title::after,.section-heading::after,.widget-title::after'
				},
			]);
		});
	});

	wp.customize('site_text_color', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_text_color', [
				{
					property: 'color',
					value: to,
					selectors: 'body,blockquote cite,.instagram-pics li a,.social-icon,h1, h2, h3, h4, h5, h6,.entry-title a,.entry-meta,.item-title,.item-filter,.navigation a,.navigation .page-numbers,.page-links .page-number,.entry-tags a,.tag-cloud-link,.widget_meta li a,.widget_pages li a,.widget_categories li a,.widget_archive li a,.widget_nav_menu li a'
				},
				{
					property: 'border-color',
					value: to,
					selectors: '.item-filter,.slideshow-testimonials .slick-dots button::before,.navigation a,.navigation .page-numbers,.page-links .page-number,.entry-tags a,.tag-cloud-link'
				},
				{
					property: 'background-color',
					value: to,
					selectors: '.slideshow-testimonials .slick-dots button'
				}
			]);
		});
	});

	wp.customize('site_border_color', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_border_color', [
				{
					property: 'border-color',
					value: to,
					selectors: 'blockquote,select,input,textarea,input:focus,textarea:focus,.no-comments,.footer,.footer-info,.header,.widget select,.ci-schedule-widget-table tr,.widget_recent_comments li,.widget_rss li,.widget_recent_entries li, .entry-room-amenities,.entry-room-amenities li'
				}
			]);
		});
	});
})(jQuery);
