<?php get_header(); ?>

<?php $gallery = andros_plugin_featgal_get_attachments( get_queried_object_id() ); ?>
<?php if ( $gallery->have_posts() ) : ?>
	<div
		class="hero-room-slideshow andros-slick-slider"
		data-navigation="arrows"
		data-effect="slide"
		data-slide-speed="3000"
		data-autoslide="true"
	>
		<?php while ( $gallery->have_posts() ) : $gallery->the_post(); ?>
			<?php $details = wp_prepare_attachment_for_js( get_the_ID() ); ?>
			<div><img src="<?php echo esc_attr( wp_get_attachment_image_url( get_the_ID(), 'andros_slide' ) ); ?>" alt="<?php echo esc_attr( $details['caption'] ); ?>"></div>
		<?php endwhile; ?>
		<?php wp_reset_postdata(); ?>
	</div>
<?php endif; ?>

<main class="main">

	<div class="container">

		<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'single' ) ) : ?>

			<?php get_template_part( 'template-parts/section-heading' ); ?>

			<div class="row">

				<div class="<?php andros_the_container_classes(); ?>">

					<?php while ( have_posts() ) : the_post(); ?>

						<article class="entry">

							<div class="entry-content">
								<?php the_content(); ?>
							</div>

						</article>

					<?php endwhile; ?>

				</div>

				<?php get_sidebar(); ?>

			</div>

		<?php endif; ?>

	</div>

</main>

<?php get_footer();
