<?php get_header(); ?>

<?php get_template_part( 'template-parts/hero' ); ?>

<main class="main">

	<div class="container">

		<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'single' ) ) : ?>

			<div class="row">

				<div class="<?php andros_the_container_classes(); ?>">

					<?php while ( have_posts() ) : the_post(); ?>

						<article class="entry">

							<?php andros_the_post_header(); ?>

							<?php andros_the_post_thumbnail(); ?>

							<div class="entry-content">
								<?php the_content(); ?>

								<?php wp_link_pages(); ?>
							</div>

							<?php if ( has_tag() && get_theme_mod( 'post_show_tags', 1 ) ) : ?>
								<div class="entry-tags">
									<?php the_tags( '', ' ' ); ?>
								</div>
							<?php endif; ?>

						</article>

						<?php if ( get_theme_mod( 'post_show_authorbox', 1 ) ) {
							andros_the_post_author_box();
						} ?>

						<?php if ( get_theme_mod( 'post_show_comments', 1 ) ) {
							comments_template();
						} ?>

					<?php endwhile; ?>

				</div>

				<?php get_sidebar(); ?>

			</div>

		<?php endif; ?>

	</div>

	<?php if ( get_theme_mod( 'post_show_related', 1 ) ) {
		get_template_part( 'template-parts/related', get_post_type() );
	} ?>
</main>

<?php get_footer();
