<?php $subtitle = get_post_meta( get_the_ID(), 'subtitle', true ); ?>
<div class="item">
	<?php if ( 'yes' === $settings['show_thumbnail'] ) : ?>
		<figure class="item-thumb">
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( 'andros_item' ); ?>
			</a>
		</figure>
	<?php endif; ?>

	<div class="item-content">
		<?php if ( $subtitle && 'yes' === $settings['show_subtitle'] ) : ?>
			<p class="item-subtitle"><?php echo wp_kses( $subtitle, andros_get_allowed_tags( 'guide' ) ); ?></p>
		<?php endif; ?>

		<?php if ( 'yes' === $settings['show_title'] ) : ?>
			<h2 class="item-title"><?php the_title(); ?></h2>
		<?php endif; ?>

		<?php if ( 'yes' === $settings['show_button'] ) : ?>
			<a href="<?php the_permalink(); ?>" class="btn item-read-more-btn"><?php esc_html_e( 'Learn More', 'andros' ); ?></a>
		<?php endif; ?>
	</div>
</div>
