<?php $subtitle = get_post_meta( get_the_ID(), 'subtitle', true ); ?>
<div class="item">
	<?php if ( get_post_meta( get_the_ID(), 'andros_room_on_offer', true ) ) : ?>
		<?php
			$offer_text = get_post_meta( get_the_ID(), 'andros_room_offer_text', true );
			if ( empty( $offer_text ) ) {
				$offer_text = __( 'Special Offer', 'andros' );
			}
		?>
		<span class="item-tooltip"><?php echo esc_html( $offer_text ); ?></span>
	<?php endif; ?>

	<figure class="item-thumb">
		<a href="<?php the_permalink(); ?>">
			<?php the_post_thumbnail( 'andros_item' ); ?>
		</a>
	</figure>

	<div class="item-content">
		<?php if ( $subtitle ) : ?>
			<p class="item-subtitle"><?php echo wp_kses( $subtitle, andros_get_allowed_tags( 'guide' ) ); ?></p>
		<?php endif; ?>
		<h2 class="item-title"><?php the_title(); ?></h2>

		<a href="<?php the_permalink(); ?>" class="btn item-read-more-btn"><?php esc_html_e( 'Learn More', 'andros' ); ?></a>
	</div>
</div>
