<?php
	$subtitle = get_post_meta( get_the_ID(), 'subtitle', true );
	if ( ! $subtitle ) {
		$subtitle = get_the_date();
	}
?>
<div class="item">
	<figure class="item-thumb">
		<a href="<?php the_permalink(); ?>">
			<?php the_post_thumbnail( 'andros_item_tall' ); ?>
		</a>
	</figure>

	<div class="item-content">
		<?php if ( $subtitle ) : ?>
			<p class="item-subtitle"><?php echo wp_kses( $subtitle, andros_get_allowed_tags( 'guide' ) ); ?></p>
		<?php endif; ?>
		<h2 class="item-title"><?php the_title(); ?></h2>

		<a href="<?php the_permalink(); ?>" class="btn item-read-more-btn"><?php esc_html_e( 'Learn More', 'andros' ); ?></a>
	</div>
</div>
