<?php
	$related   = andros_get_related_posts( get_the_ID(), 2 );
	$title     = get_theme_mod( 'title_post_related_title', __( 'Related articles', 'andros' ) );
	$subtitle  = get_theme_mod( 'title_post_related_subtitle' );
	$post_type = get_post_type();

	do_action( "andros_before_related_{$post_type}", $related, $post_type, $title, $subtitle );

	if ( $related->have_posts() ) : ?>
		<section class="section section-related">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<?php if ( $title || $subtitle ) : ?>
							<div class="section-heading">
								<h3 class="section-title"><?php echo esc_html( $title ); ?></h3>
								<p class="section-subtitle"><?php echo esc_html( $subtitle ); ?></p>
							</div>
						<?php endif; ?>

						<div class="row row-items">
							<?php while ( $related->have_posts() ) : $related->the_post(); ?>
								<div class="col-sm-6 col-12">
									<?php get_template_part( 'template-parts/item', get_post_type() ); ?>
								</div>
							<?php endwhile; ?>
							<?php wp_reset_postdata(); ?>
						</div>
					</div>
				</div>
			</div>
		</section>
	<?php endif;

	do_action( "andros_after_related_{$post_type}", $related, $post_type, $title, $subtitle );

