<?php
	$post_id = false;
	if ( is_singular() ) {
		$post_id = get_queried_object_id();
	}

	$hero = andros_get_hero_data( $post_id );

	if ( ! $hero['show'] || ! $hero['page_title_hide'] ) : ?>
		<div class="row">
			<div class="col-12">
				<div class="section-heading text-center">
					<?php if ( $hero['subtitle'] ) : ?>
						<p class="section-subtitle"><?php echo wp_kses( $hero['subtitle'], andros_get_allowed_tags( 'guide' ) ); ?></p>
					<?php endif; ?>

					<?php if ( $hero['title'] ) : ?>
						<h1 class="section-title"><?php echo wp_kses( $hero['title'], andros_get_allowed_tags() ); ?></h1>
					<?php endif; ?>
				</div>
			</div>
		</div>
	<?php endif;
