<?php 
/**
* @version		$Id: currency.class.php 1397 2020-01-20 17:11:26Z IOS $
* @package		Component IOS Reservations
* @author		Ioannis Sannos ( https://www.isopensource.com )
* @copyright	Copyright (c) 2008-2020 Is Open Source (https://www.isopensource.com). All rights reserved.
* @license		Commercial
* @description 	Online booking system
**************************************/

/**
=== COMMERCIAL LICENSE ===

IT IS EXTREMELY FORBIDDEN TO MODIFY THIS FILE
IOS RENTALS IS COPYRIGHTED BY IOANNIS SANNOS
HTTPS://WWW.ISOPENSOURCE.COM
*/

defined('_IOSRTAPICLIENT_') or die ('Direct access to this location is not allowed');


class iosrtApiCurrency {

	private $currency = 'EUR';
	private $currency_symb = '&#8364;';
	private $currency_dec = 2;
	private $curfront = 0;
	private $thous_sep = ',';
	private $decim_sep = '.';


	/*********************/
	/* MAGIC CONSTRUCTOR */
	/*********************/
	public function __construct($currency, $thous_sep, $decim_sep, $curfront) {
		$currencies = $this->getCurrencies();
		if ($currency == '') { return; }
		if (!isset($currencies[$currency])) { return; }

		$this->currency = $currency;
		$this->thous_sep = $thous_sep;
		$this->decim_sep = $decim_sep;
		$this->curfront = $curfront;
		$this->currency_symb = $currencies[$currency]['symbol'];
		$this->currency_dec = $currencies[$currency]['decimals'];
	}


	/****************************/
	/* GET SUPPORTED CURRENCIES */
	/****************************/
	public function getCurrencies() {
		$currencies = array(
			'AED' => array('name' => 'United Arab Emirates dirham', 'symbol' => '', 'decimals' => 2),
			'AFN' => array('name' => 'Afghanistan, Afghanis', 'symbol' => '&#1547;', 'decimals' => 2),
			'ALL' => array('name' => 'Albanian Lek', 'symbol' => '&#76;&#101;&#107;', 'decimals' => 2),
			'AMD' => array('name' => 'Armenian dram', 'symbol' => '', 'decimals' => 2),
			'ARS' => array('name' => 'Argentine peso', 'symbol' => '&#36;', 'decimals' => 2),
			'AOA' => array('name' => 'Angolan Kwanza', 'symbol' => 'kz', 'decimals' => 0),
			'AUD' => array('name' => 'Australian dollar', 'symbol' => '&#36;', 'decimals' => 2),
			'AZN' => array('name' => 'Azerbaijan New Manat', 'symbol' => '&#1084;&#1072;&#1085;', 'decimals' => 2),
			'BGN' => array('name' => 'Bulgarian lev', 'symbol' => '&#1083;&#1074;', 'decimals' => 2),
			'BRL' => array('name' => 'Brazil, Reais', 'symbol' => '&#82;&#36;', 'decimals' => 2),
			'BYR' => array('name' => 'Belarus Ruble', 'symbol' => '&#112;&#46;', 'decimals' => 0),
			'CAD' => array('name' => 'Canadian dollar', 'symbol' => '&#36;', 'decimals' => 2),
			'CHF' => array('name' => 'Swiss franc', 'symbol' => '&#67;&#72;&#70;', 'decimals' => 2),
			'CNY' => array('name' => 'China, Yuan Renminbi', 'symbol' => '&#165;', 'decimals' => 2),
			'COP' => array('name' => 'Colombian Peso', 'symbol' => '$', 'decimals' => 0),
			'CUP' => array('name' => 'Cuban Peso', 'symbol' => '&#8369;', 'decimals' => 2),
			'CZK' => array('name' => 'Czech koruna', 'symbol' => '&#75;&#269;', 'decimals' => 1),
			'DKK' => array('name' => 'Danish krone', 'symbol' => '&#107;&#114;', 'decimals' => 2),
			'DOP' => array('name' => 'Dominican Peso', 'symbol' => '&#82;&#68;&#36;', 'decimals' => 1),
			'DZD' => array('name' => 'Algerian dinar', 'symbol' => '', 'decimals' => 2),
			'EGP' => array('name' => 'Egypt, Pounds', 'symbol' => '&#163;', 'decimals' => 2),	
			'ETB' => array('name' => 'Ethiopian birr', 'symbol' => '', 'decimals' => 2),
			'EUR' => array('name' => 'Euro', 'symbol' => '&#8364;', 'decimals' => 2),
			'GEL' => array('name' => 'Georgian Lari', 'symbol' => '', 'decimals' => 2),
			'GBP' => array('name' => 'Pound sterling', 'symbol' => '&#163;', 'decimals' => 2),
			'GHS' => array('name' => 'Ghana Cedi', 'symbol' => '&#162;', 'decimals' => 2),
			'HKD' => array('name' => 'Hong Kong dollar', 'symbol' => '&#36;', 'decimals' => 2),
			'HRK' => array('name' => 'Croatian kuna', 'symbol' => '&#107;&#110;', 'decimals' => 2),
			'HUF' => array('name' => 'Hungarian Forint', 'symbol' => '&#70;&#116;', 'decimals' => 0),
			'IDR' => array('name' => 'Indonesia, Rupiahs', 'symbol' => '&#82;&#112;', 'decimals' => 0),
			'ILS' => array('name' => 'Israeli new sheqel', 'symbol' => '&#8362;', 'decimals' => 2),
			'JMD' => array('name' => 'Jamaican Dollar', 'symbol' => 'J$', 'decimals' => 1),
			'INR' => array('name' => 'Indian rupee', 'symbol' => '&#8360;', 'decimals' => 1),
			'IQD' => array('name' => 'Iraqi dinar', 'symbol' => '', 'decimals' => 2),
			'IRR' => array('name' => 'Iranian rial', 'symbol' => '&#65020;', 'decimals' => 2),
			'ISK' => array('name' => 'Iceland Krona', 'symbol' => '&#107;&#114;', 'decimals' => 1),
			'JPY' => array('name' => 'Japanese yen', 'symbol' => '&yen;', 'decimals' => 0),
			'KES' => array('name' => 'Kenyan Shilling', 'symbol' => 'KSh', 'decimals' => 1),
			'KGS' => array('name' => 'Kyrgyzstani Som', 'symbol' => '', 'decimals' => 2),
			'KRW' => array('name' => 'Korea (South), Won', 'symbol' => '&#8361;', 'decimals' => 0),
			'KWD' => array('name' => 'Kuwaiti Dinar', 'symbol' => '', 'decimals' => 2),
			'KZT' => array('name' => 'Kazakhstan Tenge', 'symbol' => '&#1083;&#1074;', 'decimals' => 0),
			'MDL' => array('name' => 'Moldovan leu', 'symbol' => '', 'decimals' => 2),
			'MKD' => array('name' => 'FYROM Denar', 'symbol' => '&#1076;&#1077;&#1085;', 'decimals' => 2),
			'MNT' => array('name' => 'Mongolian Tughrik', 'symbol' => '&#8366;', 'decimals' => 0),
			'MXN' => array('name' => 'Mexican peso', 'symbol' => '&#36;', 'decimals' => 2),
			'MYR' => array('name' => 'Malaysia, Ringgits', 'symbol' => '&#82;&#77;', 'decimals' => 2),
			'NGN' => array('name' => 'Nigeria Naira', 'symbol' => '&#8358;', 'decimals' => 1),
			'NZD' => array('name' => 'New Zealand dollar', 'symbol' => '&#36;', 'decimals' => 2),
			'NOK' => array('name' => 'Norwegian krone', 'symbol' => '&#107;&#114;', 'decimals' => 2),
			'PHP' => array('name' => 'Philippines, Pesos', 'symbol' => '&#80;&#104;&#112;', 'decimals' => 1),	
			'PKR' => array('name' => 'Pakistan Rupee', 'symbol' => '&#8360;', 'decimals' => 0),
			'PLN' => array('name' => 'Polish Zloty', 'symbol' => '&#122;&#322;', 'decimals' => 2),
			'QAR' => array('name' => 'Qatar Riyal', 'symbol' => '&#65020;', 'decimals' => 2),
			'RON' => array('name' => 'Romanian new leu', 'symbol' => '&#108;&#101;&#105;', 'decimals' => 2),
			'RSD' => array('name' => 'Serbian dinar', 'symbol' => '&#1044;&#1080;&#1085;&#46;', 'decimals' => 2),
			'RUB' => array('name' => 'Russian Rouble', 'symbol' => '&#1088;&#1091;&#1073;', 'decimals' => 1),
			'SAR' => array('name' => 'Saudi Arabia Riyal', 'symbol' => '&#65020;', 'decimals' => 2),
			'SEK' => array('name' => 'Swedish krona', 'symbol' => '&#107;&#114;', 'decimals' => 2),
			'SGD' => array('name' => 'Singapore dollar', 'symbol' => '&#36;', 'decimals' => 2),
			'SYP' => array('name' => 'Syrian pound', 'symbol' => '&#163;', 'decimals' => 2),
			'THB' => array('name' => 'Thai Baht', 'symbol' => '&#3647;', 'decimals' => 1),
			'TJS' => array('name' => 'Tajikistani Somoni', 'symbol' => '', 'decimals' => 2),
			'TMT' => array('name' => 'Turkmenistani Manat', 'symbol' => '', 'decimals' => 2),
			'TRY' => array('name' => 'Turkish lira', 'symbol' => '&#84;&#76;', 'decimals' => 2),
			'TWD' => array('name' => 'Taiwan New dollar', 'symbol' => '&#78;&#84;&#36;', 'decimals' => 2),
			'UAH' => array('name' => 'Ukrainian Hryvnia', 'symbol' => '&#8372;', 'decimals' => 2),
			'USD' => array('name' => 'US dollar', 'symbol' => '&#36;', 'decimals' => 2),
			'UZS' => array('name' => 'Uzbekistan Som', 'symbol' => '&#1083;&#1074;', 'decimals' => 0),
			'VEF' => array('name' => 'Venezuela Bolivar', 'symbol' => '&#66;&#115;', 'decimals' => 0),
			'VND' => array('name' => 'Viet Nam Dong', 'symbol' => '&#8363;', 'decimals' => 0),
			'XAF' => array('name' => 'CFA Franc', 'symbol' => '', 'decimals' => 2),
			'XPF' => array('name' => 'CFP Franc', 'symbol' => '', 'decimals' => 2),
			'ZAR' => array('name' => 'South African rand', 'symbol' => '&#82;', 'decimals' => 2),
			'ZMW' => array('name' => 'Zambian Kwacha', 'symbol' => 'ZK', 'decimals' => 2)
		);
		return $currencies;
	}


	/***************************/
	/* GET CURRENCY SHORT CODE */
	/***************************/
	public function currencySymbol() {
		return ($this->currency_symb != '') ? $this->currency_symb : $this->currency;
	}


	/*************************/
	/* GET CURRENCY ISO CODE */
	/*************************/
	public function currencyISO() {
		return $this->currency;
	}


	/*************************/
	/* GET CURRENCY DECIMALS */
	/*************************/
	public function currencyDecs() {
		return $this->currency_dec;
	}


	/***************************************/
	/* EXCHANGE RATES SUPPORTED CURRENCIES */
	/***************************************/
	public function getExCurrencies() {
		$currencies = array('AUD', 'BGN', 'BRL', 'CAD', 'CHF', 'CNY', 'CZK', 'DKK', 'EUR', 
		'GBP', 'HKD', 'HRK', 'HUF', 'IDR', 'INR', 'JPY', 'KRW', 'MXN', 'MYR', 'NOK', 
		'NZD', 'PLN', 'PHP', 'RON', 'RUB', 'SEK', 'SGD', 'THB', 'TRY', 'USD', 'ZAR');
		return $currencies;
	}


	/************************************/
	/* FORMAT PRICE IN DEFAULT CURRENCY */
	/************************************/
	public function formatprice($amount='0.00', $langseps=0, $roundprices=0) {
		if ($roundprices > 0) {
			if ($roundprices == 3) {//round to nearest integer with decimals
				$v = round($amount);
				if ($langseps) {
					return number_format($v, $this->currency_dec, $this->decim_sep, $this->thous_sep);
				} else {
					return number_format($v, $this->currency_dec, '.', '');
				}
			}

			if ($roundprices == 2) {//round to nearest integer
				$v = round($amount);
				if ($langseps) {
					return number_format($v, 0, $this->decim_sep, $this->thous_sep);
				} else {
					return number_format($v, 0, '.', '');
				}
			}

			//$roundprices = 1: round if integer
			if ($this->currency_dec == 0) {
				$v = round($amount);
				if ($langseps) {
					return number_format($v, 0, $this->decim_sep, $this->thous_sep);
				} else {
					return number_format($v, 0, '.', '');
				}
			} else {
				$v = (int)$amount;
				if ($amount == $v) {//no decimals exist, return without decinals
					if ($langseps) {
						return number_format($v, 0, $this->decim_sep, $this->thous_sep);
					} else {
						return number_format($v, 0, '.', '');
					}
				}
			}
		}

		if ($langseps) {
			return number_format($amount, $this->currency_dec, $this->decim_sep, $this->thous_sep);
		} else {
			return number_format($amount, $this->currency_dec, '.', '');
		}
	}


	/************************************/
	/* FORMAT PRICE AND CURRENCY SYMBOL */
	/************************************/
	public function shortprice($amount='0.00', $roundprices=0) {
		$prc = $this->formatprice($amount, 1, $roundprices);
		$symb = $this->currencySymbol(0);
		$out = ($this->curfront) ? $symb.' '.$prc : $prc.' '.$symb;
		return $out;
	}


	/*****************************/
	/* FORMAT PRICE AND CURRENCY */
	/*****************************/
	public function longprice($amount='0.00', $roundprices=0) {
		$prc = $this->formatprice($amount, 1, $roundprices);
		$symb = $this->currencyISO(0);
		$out = ($this->curfront) ? $symb.' '.$prc : $prc.' '.$symb;
		return $out;
	}

}

?>