/* IOS RENTALS API SPECIFIC JS - Author: Ioannis Sannos ( https://www.isopensource.com ) */

function iosRTStdAjax() {
	var rto;
	if (window.XMLHttpRequest) {
		rto = new XMLHttpRequest();
	} else if (window.ActiveXObject) {
		rto = new ActiveXObject("Msxml2.XMLHTTP");
		if (!rto) { rto = new ActiveXObject("Microsoft.XMLHTTP"); }
	}
	return rto;
}

function iosRTAjax(eurl, edata, successfunc, errorfunc) {
	if (eurl == '') { return false; }
	if (errorfunc == null) {
		errorfunc = function (XMLHttpRequest, textStatus, errorThrown) { alert('Error! '+errorThrown); }
	}
	if (successfunc == null) { successfunc = function (result) { } }
	if (edata && (typeof (edata) === 'object')) {
		var sdata = '';
		for (k in edata) { sdata += k+'='+edata[k]+'&'; }
		sdata += 'rnd='+Math.floor((Math.random()*100)+1);
		edata = sdata;
	}
	var rthttp = iosRTStdAjax();
	try {
		rthttp.open('POST', eurl, true);
		rthttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		rthttp.setRequestHeader('charset', 'utf-8');
		rthttp.onreadystatechange = function () {
			if (rthttp.readyState == 4) {
				if (rthttp.status != 200) {
					errorfunc(rthttp.responseText, rthttp.status, rthttp.statusText);
				} else {
					successfunc(rthttp.responseText);
				}
			}
		};
		rthttp.send(edata);
	}
	catch(e){}
	finally{}
}

function iosRTMinMaxRentDur() {
	if (iosRTCalminrentdays != undefined) {
		var rentdur = { 'min': iosRTCalminrentdays, 'max': iosRTCalmaxrentdays };
	} else {
		var rentdur = { 'min': 0, 'max': 100 };
	}
	var sObj = document.getElementById('iosrt_picklid');
	var plid = parseInt(sObj.options[sObj.selectedIndex].value, 10);
	if (plid > 0) {
		if (iosRTCalRentdRanges != undefined) {
			if (iosRTCalRentdRanges[plid] != undefined) {
				var pdate = document.getElementById('iosrt_pickdate').value;
				var dparts = pdate.split('-');
				var dt = dparts[2]+'-'+dparts[1]+'-'+dparts[0]+' 12:00:00';
				var zdate = iosRTmakeZdate(dt);
				for (var i = 0; i < iosRTCalRentdRanges[plid].length; i++) {
					if ((iosRTCalRentdRanges[plid][i].from <= zdate) && (iosRTCalRentdRanges[plid][i].to >= zdate)) {
						rentdur.min = iosRTCalRentdRanges[plid][i].min;
						rentdur.max = iosRTCalRentdRanges[plid][i].max;
						break;
					}
				}
			}
		}
	}
	return rentdur;
}

function iosRTUserDate(dateObj) {
	let userdate = (dateObj.getDate() < 10) ? '0'+dateObj.getDate() : dateObj.getDate();
	let m = dateObj.getMonth() + 1;
	userdate += (m < 10) ? '-0'+m+'-'+dateObj.getFullYear() : '-'+m+'-'+dateObj.getFullYear();
	return userdate;
}

function iosRTISODate(dateObj, withtime) {
	let m = dateObj.getMonth() + 1;
	let dt = (m < 10) ? dateObj.getFullYear()+'-0'+m : dateObj.getFullYear()+'-'+m;
	dt += (dateObj.getDate() < 10) ? '-0'+dateObj.getDate() : '-'+dateObj.getDate();
	if (withtime) {
		let hours = (dateObj.getHours() < 10) ? '0'+dateObj.getHours() : dateObj.getHours();
		let min = (dateObj.getMinutes() < 10) ? '0'+dateObj.getMinutes() : dateObj.getMinutes();
		dt += ' '+hours+':'+min+':00';
	}
	return dt;
}

function iosRTStdDatetime(userdate) {
	let dparts = userdate.split('-');
	let dt = dparts[2]+'-'+dparts[1]+'-'+dparts[0]+' 12:00:00';
	return dt;
}

function iosRTHighlight(elem) {
	var eObj = document.getElementById(elem);
	if ((eObj.type == 'select-one') || (eObj.type == 'select-multiple')) {
		var cclass = 'iosrt_select';
	} else {
		var cclass = 'iosrt_text';
	}
	eObj.className = cclass+' iosrt_highlight';
	eObj.focus();
	setTimeout(function(){ document.getElementById(elem).className = cclass; }, 1000);
}

function iosRTTodayDateTime(withplus) {
	if (withplus == undefined) { withplus = false; }
	if (withplus) {
		var today = iosRTPlusDatePickup();
	} else {
		var today = new Date();
	}
	var m = today.getMonth() + 1;
	var datetime = (m < 10) ? today.getFullYear()+'-0'+m+'-' : today.getFullYear()+'-'+m+'-';
	datetime += (today.getDate() < 10) ? '0'+today.getDate()+' 12:00:00' : today.getDate()+' 12:00:00';
	return datetime;
}

function iosRTPlusDatePickup() {
	var pluspickdate = new Date();
	if (iosRTpickplushours != undefined) {
		var pickplushours = parseInt(iosRTpickplushours, 10);//from "0" to "24"
		pluspickdate.setHours(pluspickdate.getHours() + pickplushours);
	}
	return pluspickdate;
}

function iosRTInitPickDatetime(lid) {
	var response = { 'cfgmindate': 'today', 'disabledday': '', 'timestart': 10 };

	var today = new Date();
	var pickdate = iosRTPlusDatePickup();

	if (today.getDate() != pickdate.getDate()) {
		var is_today = false;
		response.disabledday = iosRTUserDate(today);
		response.cfgmindate = iosRTUserDate(today);
	} else {
		var is_today = true;
		if (pickdate.getHours() > 22) {//try next day
			response.disabledday = iosRTUserDate(pickdate);
			var pickdate = new Date().fp_incr(1);
			response.cfgmindate = iosRTUserDate(pickdate);
			is_today = false;
		}
	}

	if (iosRTCalDisRanges != undefined) {
		if (iosRTCalDisRanges[lid] != undefined) {
			var pickdt = iosRTISODate(pickdate, false)+' 12:00:00';
			for (var i = 0; i < iosRTCalDisRanges[lid].length; i++) {
				var sdt = iosRTStdDatetime(iosRTCalDisRanges[lid][i].from);
				var edt = iosRTStdDatetime(iosRTCalDisRanges[lid][i].to);
				if ((sdt <= pickdt) && (edt >= pickdt)) {
					pickdate = new Date(edt).fp_incr(1);//set pick date to the next of the closing one
					response.cfgmindate = iosRTUserDate(pickdate);
					is_today = false;
					break;
				}
			}
		}
	}

	if (!is_today) { return response; }

	var disable_hours = [];
	for (var passedh=0; passedh <= pickdate.getHours(); passedh++) { disable_hours.push(passedh); }
	if (iosRTCalHourRanges != undefined) {
		if (iosRTCalHourRanges[lid] != undefined) {
			var m = pickdate.getMonth() + 1;
			var datetime = (m < 10) ? pickdate.getFullYear()+'-0'+m+'-' : pickdate.getFullYear()+'-'+m+'-';
			datetime += (pickdate.getDate() < 10) ? '0'+pickdate.getDate() : pickdate.getDate();
			var zdate = iosRTmakeZdate(datetime+' 12:00:00');
			for (var i = iosRTCalHourRanges[lid].length - 1; i >= 0; i--) {
				if ((iosRTCalHourRanges[lid][i].from <= zdate) && (iosRTCalHourRanges[lid][i].to >= zdate)) {
					var hpairs, q, hpair, starttime, starthour, endtime, endhour, h;
					hpairs = iosRTCalHourRanges[lid][i].hours.split(',');
					for (q = 0; q < hpairs.length; q++) {
						hpair = hpairs[q].split('-');
						starttime = hpair[0].split(':');
						starthour = parseInt(starttime[0], 10);
						endtime = hpair[1].split(':');
						endhour = parseInt(endtime[0], 10);
						for (h=starthour; h <= endhour; h++) { disable_hours.push(h); }
					}
					break;
				}
			}
		}
	}

	var allowedhour = -1;
	if (disable_hours.indexOf(10) == -1) {
		allowedhour = 10;
	} else {
		for (var k = pickdate.getHours(); k < 24; k++) {
			if (disable_hours.indexOf(k) == -1) {
				allowedhour = k;
				break;
			}
		}
	}

	if ((allowedhour > 0) && (allowedhour < 23)) {
		response.timestart = allowedhour;
	} else {
		response.disabledday = iosRTUserDate(pickdate);
		var pickdate = new Date().fp_incr(1);
		response.cfgmindate = iosRTUserDate(pickdate);
	}
	return response;
}

function iosRT2DigitsDay(monthday) {
	return (monthday) ? '0'+monthday : monthday;
}

var disdatesObj = { 'pick':[], 'drop':[] };

function iosRTSetLocation(datetype) {
	if (datetype == 'pick') {
		var dtelements = { 'selectlid': 'iosrt_picklid', 'selectdate': 'iosrt_pickdate', 'selecthour': 'iosrt_pickhour', 'selectmin': 'iosrt_pickmin' };
	} else {
		var dtelements = { 'selectlid': 'iosrt_droplid', 'selectdate': 'iosrt_dropdate', 'selecthour': 'iosrt_drophour', 'selectmin': 'iosrt_dropmin' };
	}

	if (datetype == 'pick') {
		var sObj = document.getElementById(dtelements.selectlid);
		var lid = parseInt(sObj.options[sObj.selectedIndex].value, 10);
		if (document.getElementById('iosrt_droplid').tagName == 'INPUT') {//"hidedrop" option in action => same drop-off location (hidden input) with pick-up
			document.getElementById('iosrt_droplid').value = lid;
		}
	} else {
		if (document.getElementById(dtelements.selectlid).tagName == 'INPUT') {//"hidedrop" option in action => same drop-off location with pick-up
			var sObj = document.getElementById('iosrt_picklid');
			var lid = parseInt(sObj.options[sObj.selectedIndex].value, 10);
			document.getElementById(dtelements.selectlid).value = lid;
		} else {
			var sObj = document.getElementById(dtelements.selectlid);
			var lid = parseInt(sObj.options[sObj.selectedIndex].value, 10);
		}
	}

	if (lid < 1) {
		document.getElementById(dtelements.selectdate).value = '';
		return;
	}

	if (datetype == 'pick') {
		var dtObj = new Date().fp_incr(365);
		var cfgmaxdate = iosRTUserDate(dtObj);
		var response = iosRTInitPickDatetime(lid);
		var cfgmindate = response.cfgmindate;
		var init_disabledday = response.disabledday;
		var init_timestart = response.timestart;
	} else {//drop
		var ksObj = document.getElementById('iosrt_picklid');
		var klid = parseInt(ksObj.options[ksObj.selectedIndex].value, 10);
		if (klid < 1) {
			if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
				document.getElementById('iosrt_droplid').selectedIndex = 0;
			} else {
				document.getElementById('iosrt_droplid').value = 0;
			}
			document.getElementById('iosrt_pickdate').value = '';
			document.getElementById('iosrt_dropdate').value = '';
			iosRTHighlight('iosrt_picklid');
			return;
		}

		if (document.getElementById('iosrt_pickdate').value == '') {
			if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
				document.getElementById('iosrt_droplid').selectedIndex = 0;
				document.getElementById('iosrt_dropdate').value = '';
				iosRTHighlight('iosrt_pickdate');
				return;				
			}
		}
		var rentdur = iosRTMinMaxRentDur();
		var cfgmindate = document.getElementById('iosrt_pickdate').value;
		if (cfgmindate == '') {//in case it is input
			var nowdate = new Date();
			cfgmindate = iosRTUserDate(nowdate);
		}
		var dt = iosRTStdDatetime(cfgmindate);
		if (rentdur.min > 0) {
			var dtObj = new Date(dt).fp_incr(rentdur.min);
			cfgmindate = iosRTUserDate(dtObj);
		}
		var dtObj2 = new Date(dt).fp_incr(rentdur.max);
		var cfgmaxdate = iosRTUserDate(dtObj2);
		var init_disabledday = '';
		var init_timestart = 10;
	}

	var disdates = [];
	var idxplus = 0;
	if (init_disabledday != '') { disdates[0] = { 'from': init_disabledday, 'to': init_disabledday }; idxplus = 1; }
	if (iosRTCalDisRanges != undefined) {
		if (iosRTCalDisRanges[lid] != undefined) {
			for (var i = 0; i < iosRTCalDisRanges[lid].length; i++) {
				var idx = i + idxplus;
				disdates[idx] = { 'from': iosRTCalDisRanges[lid][i].from, 'to': iosRTCalDisRanges[lid][i].to };
			}
		}
	}
	if (datetype == 'pick') {
		disdatesObj.pick = disdates;
	} else {
		disdatesObj.drop = disdates;
	}

	document.getElementById(dtelements.selectdate).onclick = '';

	flatpickr('#'+dtelements.selectdate, {
		dateFormat: 'd-m-Y',
		minDate: cfgmindate,
		maxDate: cfgmaxdate,
		disableMobile: true,
		disdates: [],
		disable: [
			function(date) {
				let dayofweek = (datetype == 'pick') ? iosRTCalpickupdayofweek : iosRTCaldropoffdayofweek;
				return iosRTisDayDisabled(date, dayofweek, datetype);
			}
		],
		onOpen: function(selectedDates, dateStr, instance) {
			if (instance.input.id == 'iosrt_pickdate') {
				var ksObj = document.getElementById('iosrt_picklid');
				var klid = parseInt(ksObj.options[ksObj.selectedIndex].value, 10);
				if (klid < 1) {
					document.getElementById('iosrt_pickdate').value = '';
					iosRTHighlight('iosrt_picklid');
					instance.close();
				}
			} else {
				var ksObj = document.getElementById('iosrt_droplid');
				if (ksObj.tagName == 'SELECT') {
					var klid = parseInt(ksObj.options[ksObj.selectedIndex].value, 10);
				} else {
					var klid = parseInt(ksObj.value, 10);
				}
				if (klid < 1) {
					document.getElementById('iosrt_dropdate').value = '';
					if (ksObj.tagName == 'SELECT') { iosRTHighlight('iosrt_droplid'); }
					instance.close();
				}
				if (ksObj.tagName == 'INPUT') {
					var dObj = document.getElementById('iosrt_dropdate');
					var rentdur = iosRTMinMaxRentDur();
					var cfgmindate = document.getElementById('iosrt_pickdate').value;
					var dt = iosRTStdDatetime(cfgmindate);
					if (rentdur.min > 0) {
						var dtObj = new Date(dt).fp_incr(rentdur.min);
						cfgmindate = iosRTUserDate(dtObj);
						var dtObj2 = new Date(dt).fp_incr(rentdur.max);
						var cfgmaxdate = iosRTUserDate(dtObj2);
					} else {
						var dtObj2 = new Date(dt).fp_incr(rentdur.max);
						var cfgmaxdate = iosRTUserDate(dtObj2);
					}
					//Note: Calendar controls itself the case when new drop date is within the disabled dates
					const iosrtfpd = dObj._flatpickr;
					iosrtfpd.set('minDate', cfgmindate);
					iosrtfpd.set('maxDate', cfgmaxdate);
				}
			}
		},
		onChange: function(selectedDates, dateStr, instance) {
			var dparts = dateStr.split('-');
			var dt = dparts[2]+'-'+dparts[1]+'-'+dparts[0]+' 12:00:00';
			var zdate = iosRTmakeZdate(dt);
			var disable_hours = [];
			var is_today = false;
			var plusdt = iosRTTodayDateTime(true);
			if (dt == iosRTTodayDateTime(false)) {
				is_today = true;
				nowdt = iosRTPlusDatePickup();
				for (var passedh=0; passedh <= nowdt.getHours(); passedh++) { disable_hours.push(passedh); }
			} else if (dt == plusdt) {
				is_today = true;
				nowdt = iosRTPlusDatePickup();
				for (var passedh=0; passedh <= nowdt.getHours(); passedh++) { disable_hours.push(passedh); }
			}

			if (iosRTCalHourRanges != undefined) {
				if (iosRTCalHourRanges[lid] != undefined) {
					for (var i = iosRTCalHourRanges[lid].length - 1; i >= 0; i--) {
						if ((iosRTCalHourRanges[lid][i].from <= zdate) && (iosRTCalHourRanges[lid][i].to >= zdate)) {
							var hpairs, q, hpair, starttime, starthour, endtime, endhour, h;
							hpairs = iosRTCalHourRanges[lid][i].hours.split(',');
							for (q = 0; q < hpairs.length; q++) {
								hpair = hpairs[q].split('-');
								starttime = hpair[0].split(':');
								starthour = parseInt(starttime[0], 10);
								endtime = hpair[1].split(':');
								endhour = parseInt(endtime[0], 10);
								for (h=starthour; h <= endhour; h++) { disable_hours.push(h); }
							}
							break;
						}
					}
				}
			}
			var hObj = document.getElementById(dtelements.selecthour);
			if (hObj.tagName == 'SELECT') {//sellect or hidden input with fixed time
				var h = -1;
				var selected10index = -1;
				var selectedindex = -1;

				for (var i=0; i < hObj.options.length; i++) {
					h = parseInt(hObj.options[i].value, 10);
					var dis = false;
					if (disable_hours.length > 0) { if (disable_hours.indexOf(h) > -1) { dis = true; } }
					hObj.options[i].disabled = dis;
					if (dis == false) {
						if (is_today) {
							if (h == init_timestart) { selected10index = i; }
						} else {
							if (h == 10) { selected10index = i; }
						}
						if (selectedindex == -1) { selectedindex = i; }
					}
				}
				if (selected10index != -1) { hObj.selectedIndex = selected10index; } else { hObj.selectedIndex = selectedindex; }
			}

			if (instance.input.id == 'iosrt_pickdate') {
				var dObj = document.getElementById('iosrt_dropdate');
				if (dObj.value != '') {
					var rentdur = iosRTMinMaxRentDur();
					var cfgmindate = document.getElementById('iosrt_pickdate').value;
					var dt = iosRTStdDatetime(cfgmindate);
					var dtdrop = iosRTStdDatetime(dObj.value);

					var dropdate = '';
					var dop = new Date(dt);
					var dod = new Date(dtdrop);
					var diff = (dod - dop) + ((dop.getTimezoneOffset() - dop.getTimezoneOffset()) * 60 * 1000);
					var days = Math.floor(diff / 86400000);
					if ((days >= 0) && (days >= rentdur.min) && (days <= rentdur.max)) {//ok, keep current dropdate
						dropdate = dObj.value;
					}

					if (rentdur.min > 0) {
						var dtObj = new Date(dt).fp_incr(rentdur.min);
						cfgmindate = iosRTUserDate(dtObj);
						var dtObj2 = new Date(dt).fp_incr(rentdur.max);
						var cfgmaxdate = iosRTUserDate(dtObj2);
						if (dropdate == '') { dropdate = cfgmindate; }
					} else {
						var dtObj2 = new Date(dt).fp_incr(rentdur.max);
						var cfgmaxdate = iosRTUserDate(dtObj2);
						if (dropdate == '') {
							var dtObj3 = new Date(dt).fp_incr(1);
							dropdate = iosRTUserDate(dtObj3);
						}
					}

					//Note: Calendar controls itself the case when new drop date is within the disabled dates
					const iosrtfpd = dObj._flatpickr;
					iosrtfpd.set('minDate', cfgmindate);
					iosrtfpd.set('maxDate', cfgmaxdate);
					iosrtfpd.input.value = dropdate;
					iosrtfpd.setDate(dropdate, 'onChange');
				}
			}
		},//onChange
		onClose: function(selectedDates, dateStr, instance) {//solves the problem of firefox touch onclose where triggers below element (eg vtype)
			var ua = navigator.userAgent.toLowerCase();
			if ((ua.indexOf('firefox') > -1) && ((ua.indexOf('mobile') > -1) || (ua.indexOf('android') > -1))) {
				document.getElementById('iosrt_picklid').disabled = true;
				if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
					document.getElementById('iosrt_droplid').disabled = true;
				}
				if (document.getElementById('iosrt_pickhour').tagName == 'SELECT') {
					document.getElementById('iosrt_pickhour').disabled = true;
					document.getElementById('iosrt_pickmin').disabled = true;
				}
				if (document.getElementById('iosrt_drophour').tagName == 'SELECT') {
					document.getElementById('iosrt_drophour').disabled = true;
					document.getElementById('iosrt_dropmin').disabled = true;
				}
				if (document.getElementById('iosrt_vtype').tagName == 'SELECT') {
					document.getElementById('iosrt_vtype').disabled = true;
				}
				setTimeout(function() {
					document.getElementById('iosrt_picklid').disabled = false;
					if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
						document.getElementById('iosrt_droplid').disabled = false;
					}
					if (document.getElementById('iosrt_pickhour').tagName == 'SELECT') {
						document.getElementById('iosrt_pickhour').disabled = false;
						document.getElementById('iosrt_pickmin').disabled = false;
					}
					if (document.getElementById('iosrt_drophour').tagName == 'SELECT') {
						document.getElementById('iosrt_drophour').disabled = false;
						document.getElementById('iosrt_dropmin').disabled = false;
					}
					if (document.getElementById('iosrt_vtype').tagName == 'SELECT') {
						document.getElementById('iosrt_vtype').disabled = false;
					}
				}, 300);
			}
		}
	}); //flatpickr

	if (datetype == 'pick') {
		const iosrtfpp = document.querySelector('#'+dtelements.selectdate)._flatpickr;
	} else {
		const iosrtfpd = document.querySelector('#'+dtelements.selectdate)._flatpickr;
	}

	if (datetype == 'pick') {
		document.getElementById(dtelements.selectdate).value = '';
		if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
			document.getElementById('iosrt_droplid').selectedIndex = 0;
		}
		document.getElementById('iosrt_dropdate').value = '';
		if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
			if (typeof(iosrtfpd) != "undefined") {
				iosrtfpd.destroy();
				document.getElementById('iosrt_dropdate').onclick = 'iosRTHighlight(\'iosrt_droplid\');';
			}
		}
	} else {
		document.getElementById(dtelements.selectdate).value = '';
	}
}


function iosRTisDayDisabled(date, dayofweek, datetype) {
	if (dayofweek > -1) {
		if (date.getDay() !== dayofweek) { return true; }//disabled date
	}

	if (datetype == 'pick') {
		var disdates = disdatesObj.pick;
	} else {
		var disdates = disdatesObj.drop;
	}
	if (disdates.length == 0) { return false; }
	let start, end, y, m, d;
	for (let q=0; q < disdates.length; q++) {
		y = parseInt(disdates[q].from.substr(6, 4), 10);
		m = parseInt(disdates[q].from.substr(3, 2), 10) - 1;
		d = parseInt(disdates[q].from.substr(0, 2), 10);
		start = new Date(y, m, d);
		y = parseInt(disdates[q].to.substr(6, 4), 10);
		m = parseInt(disdates[q].to.substr(3, 2), 10) - 1;
		d = parseInt(disdates[q].to.substr(0, 2), 10);
		end = new Date(y, m, d);
		if (start == end) {
			if (start == date) { return true; }
			return false;
		}
	    if (date >= start && date <= end ) { return true; }
	}
	return false;
}

function iosRTDropSamePick() {
	var sObj = document.getElementById('iosrt_picklid');
	var lid = parseInt(sObj.options[sObj.selectedIndex].value, 10);
	if (lid < 1) { return; }
	if (document.getElementById('iosrt_pickdate').value == '') { return; }
	if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
		if (document.getElementById('iosrt_droplid').selectedIndex != sObj.selectedIndex) {
			document.getElementById('iosrt_droplid').selectedIndex = sObj.selectedIndex;
			iosRTSetLocation('drop');	
		}
	} else {
		document.getElementById('iosrt_droplid').value = lid;
		iosRTSetLocation('drop');
	}
}

function iosRTInitCalendar() {//We consider that everything is OK and pre-defined, and load full calendar functionality
	var sObj = document.getElementById('iosrt_picklid');
	var picklid = parseInt(sObj.options[sObj.selectedIndex].value, 10);
	var sObj = document.getElementById('iosrt_droplid');
	if (sObj.tagName == 'SELECT') {
		var droplid = parseInt(sObj.options[sObj.selectedIndex].value, 10);
	} else {
		var droplid = picklid;
	}
	var response = iosRTInitPickDatetime(picklid);
	var init_disabledday = response.disabledday;
	var init_timestart = response.timestart;
	var cfgmindate_pick = response.cfgmindate;
	var dtObj = new Date().fp_incr(365);
	var cfgmaxdate_pick = iosRTUserDate(dtObj);
	var rentdur = iosRTMinMaxRentDur();
	var cfgmindate_drop = document.getElementById('iosrt_pickdate').value;
	var dt = iosRTStdDatetime(cfgmindate_drop);
	if (rentdur.min > 0) {
		var dtObj = new Date(dt).fp_incr(rentdur.min);
		cfgmindate_drop = iosRTUserDate(dtObj);
	}
	var dtObj2 = new Date(dt).fp_incr(rentdur.max);
	var cfgmaxdate_drop = iosRTUserDate(dtObj2);

	var disdatesx = [], disdatesy = [], idxplus = 0;
	if (init_disabledday != '') { disdatesx[0] = { 'from': init_disabledday, 'to': init_disabledday }; idxplus = 1; }
	if (iosRTCalDisRanges != undefined) {
		if (iosRTCalDisRanges[picklid] != undefined) {
			for (var i = 0; i < iosRTCalDisRanges[picklid].length; i++) {
				var idx = i + idxplus;
				disdatesx[idx] = { 'from': iosRTCalDisRanges[picklid][i].from, 'to': iosRTCalDisRanges[picklid][i].to };
			}
		}
		if (iosRTCalDisRanges[droplid] != undefined) {
			for (var i = 0; i < iosRTCalDisRanges[droplid].length; i++) {
				disdatesy[i] = { 'from': iosRTCalDisRanges[droplid][i].from, 'to': iosRTCalDisRanges[droplid][i].to };
			}
		}
	}

	disdatesObj.pick = disdatesx;
	disdatesObj.drop = disdatesy;

	flatpickr('#iosrt_pickdate', {
		dateFormat: 'd-m-Y',
		minDate: cfgmindate_pick,
		maxDate: cfgmaxdate_pick,
		disableMobile: true,
		disable: [
			function(date) {
				return iosRTisDayDisabled(date, iosRTCalpickupdayofweek, 'pick');
			}
		],
		onOpen: function(selectedDates, dateStr, instance) {
			var ksObj = document.getElementById('iosrt_picklid');
			var klid = parseInt(ksObj.options[ksObj.selectedIndex].value, 10);
			if (klid < 1) {
				document.getElementById('iosrt_pickdate').value = '';
				iosRTHighlight('iosrt_picklid');
				instance.close();
			}
		},
		onChange: function(selectedDates, dateStr, instance) {
			var dparts = dateStr.split('-');
			var dt = dparts[2]+'-'+dparts[1]+'-'+dparts[0]+' 12:00:00';
			var zdate = iosRTmakeZdate(dt);
			var disable_hours_pick = [];
			var is_today = false;
			var plusdt = iosRTTodayDateTime(true);
			if (dt == iosRTTodayDateTime(false)) {//today
				is_today = true;
				nowdt = iosRTPlusDatePickup();
				for (var passedh=0; passedh <= nowdt.getHours(); passedh++) { disable_hours_pick.push(passedh); }
			} else if (dt == plusdt) {
				is_today = true;
				nowdt = iosRTPlusDatePickup();
				for (var passedh=0; passedh <= nowdt.getHours(); passedh++) { disable_hours_pick.push(passedh); }
			}
			if (iosRTCalHourRanges != undefined) {
				if (iosRTCalHourRanges[picklid] != undefined) {
					for (var i = iosRTCalHourRanges[picklid].length - 1; i >= 0; i--) {
						if ((iosRTCalHourRanges[picklid][i].from <= zdate) && (iosRTCalHourRanges[picklid][i].to >= zdate)) {
							var hpairs, q, hpair, starttime, starthour, endtime, endhour, h;
							hpairs = iosRTCalHourRanges[picklid][i].hours.split(',');
							for (q = 0; q < hpairs.length; q++) {
								hpair = hpairs[q].split('-');
								starttime = hpair[0].split(':');
								starthour = parseInt(starttime[0], 10);
								endtime = hpair[1].split(':');
								endhour = parseInt(endtime[0], 10);
								for (h=starthour; h <= endhour; h++) { disable_hours_pick.push(h); }
							}
							break;
						}
					}
				}
			}
			var hObj = document.getElementById('iosrt_pickhour');
			if (hObj.tagName == 'SELECT') {//sellect or hidden input with fixed time
				var h = -1;
				var selected10index = -1;
				var selectedindex = -1;
				for (var i=0; i < hObj.options.length; i++) {
					h = parseInt(hObj.options[i].value, 10);
					var dis = false;
					if (disable_hours_pick.length > 0) { if (disable_hours_pick.indexOf(h)> -1) { dis = true; } }
					hObj.options[i].disabled = dis;
					if (dis == false) {
						if (is_today) {
							if (h == init_timestart) { selected10index = i; }
						} else {
							if (h == 10) { selected10index = i; }
						}
						if (selectedindex == -1) { selectedindex = i; }
					}
				}

				if (selected10index != -1) { hObj.selectedIndex = selected10index; } else { hObj.selectedIndex = selectedindex; }
			}

			var dObj = document.getElementById('iosrt_dropdate');
			var rentdur = iosRTMinMaxRentDur();
			var cfgmindate_pick = document.getElementById('iosrt_pickdate').value;
			var dt = iosRTStdDatetime(cfgmindate_pick);
			var dtdrop = iosRTStdDatetime(dObj.value);

			var dropdate = '';
			var dop = new Date(dt);
			var dod = new Date(dtdrop);
			var diff = (dod - dop) + ((dop.getTimezoneOffset() - dop.getTimezoneOffset()) * 60 * 1000);
			var days = Math.floor(diff / 86400000);
			if ((days >= 0) && (days >= rentdur.min) && (days <= rentdur.max)) {//ok, keep current dropdate
				dropdate = dObj.value;
			}

			if (rentdur.min > 0) {
				var dtObj = new Date(dt).fp_incr(rentdur.min);
				cfgmindate_pick = iosRTUserDate(dtObj);
				var dtObj2 = new Date(dt).fp_incr(rentdur.max);
				var cfgmaxdate_pick = iosRTUserDate(dtObj2);
				if (dropdate == '') { dropdate = cfgmindate_pick; }
			} else {
				var dtObj2 = new Date(dt).fp_incr(rentdur.max);
				var cfgmaxdate_pick = iosRTUserDate(dtObj2);
				if (dropdate == '') {
					var dtObj3 = new Date(dt).fp_incr(1);
					dropdate = iosRTUserDate(dtObj3);
				}
			}

			//Note: Calendar controls itself the case when new drop date is within the disabled dates
			const iosrtfpd = dObj._flatpickr;
			iosrtfpd.set('minDate', cfgmindate_pick);
			iosrtfpd.set('maxDate', cfgmaxdate_pick);
			iosrtfpd.input.value = dropdate;
			iosrtfpd.setDate(dropdate, 'onChange');
		},//onChange
		onClose: function(selectedDates, dateStr, instance) {//solves then problem of firefox mobile onclose where vtype is triggered
			var ua = navigator.userAgent.toLowerCase();
			if ((ua.indexOf('firefox') > -1) && ((ua.indexOf('mobile') > -1) || (ua.indexOf('android') > -1))) {
				document.getElementById('iosrt_picklid').disabled = true;
				if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
					document.getElementById('iosrt_droplid').disabled = true;
				}
				if (document.getElementById('iosrt_pickhour').tagName == 'SELECT') {
					document.getElementById('iosrt_pickhour').disabled = true;
					document.getElementById('iosrt_pickmin').disabled = true;
				}
				if (document.getElementById('iosrt_drophour').tagName == 'SELECT') {
					document.getElementById('iosrt_drophour').disabled = true;
					document.getElementById('iosrt_dropmin').disabled = true;
				}
				if (document.getElementById('iosrt_vtype').tagName == 'SELECT') {
					document.getElementById('iosrt_vtype').disabled = true;
				}
				setTimeout(function() {
					document.getElementById('iosrt_picklid').disabled = false;
					if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
						document.getElementById('iosrt_droplid').disabled = false;
					}
					if (document.getElementById('iosrt_pickhour').tagName == 'SELECT') {
						document.getElementById('iosrt_pickhour').disabled = false;
						document.getElementById('iosrt_pickmin').disabled = false;
					}
					if (document.getElementById('iosrt_drophour').tagName == 'SELECT') {
						document.getElementById('iosrt_drophour').disabled = false;
						document.getElementById('iosrt_dropmin').disabled = false;
					}
					if (document.getElementById('iosrt_vtype').tagName == 'SELECT') {
						document.getElementById('iosrt_vtype').disabled = false;
					}
				}, 300);
			}
		}
	}); //flatpickr

	flatpickr('#iosrt_dropdate', {
		dateFormat: 'd-m-Y',
		minDate: cfgmindate_drop,
		maxDate: cfgmaxdate_drop,
		disableMobile: true,
		disable: [
			function(date) {
				return iosRTisDayDisabled(date, iosRTCaldropoffdayofweek, 'drop');
			}
		],
		onOpen: function(selectedDates, dateStr, instance) {
			var ksObj = document.getElementById('iosrt_droplid');
			if (ksObj.tagName == 'SELECT') {
				var klid = parseInt(ksObj.options[ksObj.selectedIndex].value, 10);
			} else {
				var klid = parseInt(ksObj.value, 10);
			}
			if (klid < 1) {
				document.getElementById('iosrt_dropdate').value = '';
				if (ksObj.tagName == 'SELECT') { iosRTHighlight('iosrt_droplid'); }
				instance.close();
			}
		},
		onChange: function(selectedDates, dateStr, instance) {
			var dparts = dateStr.split('-');
			var dt = dparts[2]+'-'+dparts[1]+'-'+dparts[0]+' 12:00:00';
			var zdate = iosRTmakeZdate(dt);
			var disable_hours_drop = [];
			var plusdt = iosRTTodayDateTime(true);
			if (dt == iosRTTodayDateTime(false)) {//today
				nowdt = iosRTPlusDatePickup();
				for (var passedh=0; passedh <= nowdt.getHours(); passedh++) { disable_hours_drop.push(passedh); }
			} else if (dt == plusdt) {
				nowdt = iosRTPlusDatePickup();
				for (var passedh=0; passedh <= nowdt.getHours(); passedh++) { disable_hours_drop.push(passedh); }
			}

			if (iosRTCalHourRanges != undefined) {
				if (iosRTCalHourRanges[droplid] != undefined) {
					for (var i = iosRTCalHourRanges[droplid].length - 1; i >= 0; i--) {
						if ((iosRTCalHourRanges[droplid][i].from <= zdate) && (iosRTCalHourRanges[droplid][i].to >= zdate)) {
							var hpairs, q, hpair, starttime, starthour, endtime, endhour, h;
							hpairs = iosRTCalHourRanges[droplid][i].hours.split(',');
							for (q = 0; q < hpairs.length; q++) {
								hpair = hpairs[q].split('-');
								starttime = hpair[0].split(':');
								starthour = parseInt(starttime[0], 10);
								endtime = hpair[1].split(':');
								endhour = parseInt(endtime[0], 10);
								for (h=starthour; h <= endhour; h++) { disable_hours_drop.push(h); }
							}
							break;
						}
					}
				}
			}

			var hObj = document.getElementById('iosrt_drophour');
			if (hObj.tagName == 'SELECT') {//sellect or hidden input with fixed time
				var h = -1;
				var selected10index = -1;
				var selectedindex = -1;
				for (var i=0; i < hObj.options.length; i++) {
					h = parseInt(hObj.options[i].value, 10);
					var dis = false;
					if (disable_hours_drop.length > 0) { if (disable_hours_drop.indexOf(h)> -1) { dis = true; } }
					hObj.options[i].disabled = dis;
					if (dis == false) {
						if (h == 10) { selected10index = i; }
						if (selectedindex == -1) { selectedindex = i; }
					}
				}
				if (selected10index != -1) { hObj.selectedIndex = selected10index; } else { hObj.selectedIndex = selectedindex; }
			}
		}, //onChange
		onClose: function(selectedDates, dateStr, instance) {//solves then problem of firefox mobile onclose where vtype is triggered
			var ua = navigator.userAgent.toLowerCase();
			if ((ua.indexOf('firefox') > -1) && ((ua.indexOf('mobile') > -1) || (ua.indexOf('android') > -1))) {
				document.getElementById('iosrt_picklid').disabled = true;
				if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
					document.getElementById('iosrt_droplid').disabled = true;
				}
				if (document.getElementById('iosrt_pickhour').tagName == 'SELECT') {
					document.getElementById('iosrt_pickhour').disabled = true;
					document.getElementById('iosrt_pickmin').disabled = true;
				}
				if (document.getElementById('iosrt_drophour').tagName == 'SELECT') {
					document.getElementById('iosrt_drophour').disabled = true;
					document.getElementById('iosrt_dropmin').disabled = true;
				}
				if (document.getElementById('iosrt_vtype').tagName == 'SELECT') {
					document.getElementById('iosrt_vtype').disabled = true;
				}
				setTimeout(function() {
					document.getElementById('iosrt_picklid').disabled = false;
					if (document.getElementById('iosrt_droplid').tagName == 'SELECT') {
						document.getElementById('iosrt_droplid').disabled = false;
					}
					if (document.getElementById('iosrt_pickhour').tagName == 'SELECT') {
						document.getElementById('iosrt_pickhour').disabled = false;
						document.getElementById('iosrt_pickmin').disabled = false;
					}
					if (document.getElementById('iosrt_drophour').tagName == 'SELECT') {
						document.getElementById('iosrt_drophour').disabled = false;
						document.getElementById('iosrt_dropmin').disabled = false;
					}
					if (document.getElementById('iosrt_vtype').tagName == 'SELECT') {
						document.getElementById('iosrt_vtype').disabled = false;
					}
				}, 300);
			}
		}
	}); //flatpickr

	if (iosRTCalHourRanges != undefined) {
		if (iosRTCalHourRanges[picklid] != undefined) {
			var disable_hours_pick = [];
			var dparts = document.getElementById('iosrt_pickdate').value.split('-');
			var dt = dparts[2]+'-'+dparts[1]+'-'+dparts[0]+' 12:00:00';
			var zdate_pick = iosRTmakeZdate(dt);
			for (var i = iosRTCalHourRanges[picklid].length - 1; i >= 0; i--) {
				if ((iosRTCalHourRanges[picklid][i].from <= zdate_pick) && (iosRTCalHourRanges[picklid][i].to >= zdate_pick)) {
					var hpairs, q, hpair, starttime, starthour, endtime, endhour, h;
					hpairs = iosRTCalHourRanges[picklid][i].hours.split(',');
					for (q = 0; q < hpairs.length; q++) {
						hpair = hpairs[q].split('-');
						starttime = hpair[0].split(':');
						starthour = parseInt(starttime[0], 10);
						endtime = hpair[1].split(':');
						endhour = parseInt(endtime[0], 10);
						for (h=starthour; h <= endhour; h++) { disable_hours_pick.push(h); }
					}
					break;
				}
			}
			var hObj = document.getElementById('iosrt_pickhour');
			if (hObj.tagName == 'SELECT') {//sellect or hidden input with fixed time
				for (var i=0; i < hObj.options.length; i++) {
					h = parseInt(hObj.options[i].value, 10);
					var dis = false;
					if (disable_hours_pick.length > 0) { if (disable_hours_pick.indexOf(h)> -1) { dis = true; } }
					hObj.options[i].disabled = dis;
				}
			}
		}

		if (iosRTCalHourRanges[droplid] != undefined) {
			var disable_hours_drop = [];
			var dparts = document.getElementById('iosrt_dropdate').value.split('-');
			var dt = dparts[2]+'-'+dparts[1]+'-'+dparts[0]+' 12:00:00';
			var zdate_drop = iosRTmakeZdate(dt);
			for (var i = iosRTCalHourRanges[droplid].length - 1; i >= 0; i--) {
				if ((iosRTCalHourRanges[droplid][i].from <= zdate_drop) && (iosRTCalHourRanges[droplid][i].to >= zdate_drop)) {
					var hpairs, q, hpair, starttime, starthour, endtime, endhour, h;
					hpairs = iosRTCalHourRanges[droplid][i].hours.split(',');
					for (q = 0; q < hpairs.length; q++) {
						hpair = hpairs[q].split('-');
						starttime = hpair[0].split(':');
						starthour = parseInt(starttime[0], 10);
						endtime = hpair[1].split(':');
						endhour = parseInt(endtime[0], 10);
						for (h=starthour; h <= endhour; h++) { disable_hours_drop.push(h); }
					}
					break;
				}
			}
			var hObj = document.getElementById('iosrt_drophour');
			if (hObj.tagName == 'SELECT') {//sellect or hidden input with fixed time
				for (var i=0; i < hObj.options.length; i++) {
					h = parseInt(hObj.options[i].value, 10);
					var dis = false;
					if (disable_hours_drop.length > 0) { if (disable_hours_drop.indexOf(h)> -1) { dis = true; } }
					hObj.options[i].disabled = dis;
				}
			}
		}
	}
}

function iosRTmakeZdate(dateString) {
	var dt = new Date(dateString);
	var year = dt.getFullYear();
	var start = new Date(year, 0, 0);
	var diff = (dt - start) + ((start.getTimezoneOffset() - dt.getTimezoneOffset()) * 60 * 1000);
	var zday = Math.floor(diff / 86400000) - 1;
	if (zday < 10) {
		return parseInt(year+'00'+zday, 10);
	} else if (zday < 100) {
		return parseInt(year+'0'+zday, 10);
	} else {
		return parseInt(year+''+zday, 10);
	}
}


function iosRTAVFSubmit() {
	if (!document.getElementById('iosrt_fmpickdates')) { return; }
	var pObj = document.getElementById('iosrt_picklid');
	var picklid = parseInt(pObj.options[pObj.selectedIndex].value, 10);
	if (picklid < 1) { iosRTHighlight('iosrt_picklid'); return; }
	var pd = document.getElementById('iosrt_pickdate').value;
	if ((pd == '') || (pd.length != 10)) { iosRTHighlight('iosrt_pickdate'); return; }
	var dObj = document.getElementById('iosrt_droplid');
	if (dObj.tagName == 'SELECT') {
		var droplid = parseInt(dObj.options[dObj.selectedIndex].value, 10);
		if (droplid < 1) { iosRTHighlight('iosrt_droplid'); return; }
	} else {
		var droplid = picklid;
	}
	var dd = document.getElementById('iosrt_dropdate').value;
	if ((dd == '') || (dd.length != 10)) { iosRTHighlight('iosrt_dropdate'); return; }
	if (pd.indexOf('/') > 0) {//bad format
		pd = pd.replace('/', '-');
		document.getElementById('iosrt_pickdate').value = pd;
	}
	if (dd.indexOf('/') > 0) {//bad format
		dd = dd.replace('/', '-');
		document.getElementById('iosrt_dropdate').value = dd;
	}

	//in case calendar disabled dates, min/max duration, etc, not working (eg iphone) re-check here
	//DISABLED DATES
	var sdt, edt;
	var dt = iosRTStdDatetime(pd);
	var pickdt = new Date(dt);
	var dt = iosRTStdDatetime(dd);
	var dropdt = new Date(dt);
	var pick_is_closed = false;
	var drop_is_closed = false;
	if (iosRTCalDisRanges != undefined) {
		if (iosRTCalDisRanges[picklid] != undefined) {
			for (var i = 0; i < iosRTCalDisRanges[picklid].length; i++) {
				if ((iosRTCalDisRanges[picklid][i].from == pd) || (iosRTCalDisRanges[picklid][i].to == pd)) {
					pick_is_closed = true;
					break;
				} else if (iosRTCalDisRanges[picklid][i].from != iosRTCalDisRanges[picklid][i].to) {
					sdt = iosRTStdDatetime(iosRTCalDisRanges[picklid][i].from);
					edt = iosRTStdDatetime(iosRTCalDisRanges[picklid][i].to);
					if ((pickdt >= sdt) && (pickdt <= edt)) {
						pick_is_closed = true;
						break;
					}
				}
			}
		}

		if (!pick_is_closed) {
			if (iosRTCalDisRanges[droplid] != undefined) {
				for (var i = 0; i < iosRTCalDisRanges[droplid].length; i++) {
					if ((iosRTCalDisRanges[droplid][i].from == dd) || (iosRTCalDisRanges[droplid][i].to == dd)) {
						drop_is_closed = true;
						break;
					} else if (iosRTCalDisRanges[droplid][i].from != iosRTCalDisRanges[droplid][i].to) {
						sdt = iosRTStdDatetime(iosRTCalDisRanges[droplid][i].from);
						edt = iosRTStdDatetime(iosRTCalDisRanges[droplid][i].to);
						if ((dropdt >= sdt) && (dropdt <= edt)) {
							drop_is_closed = true;
							break;
						}
					}
				}
			}
		}
	}

	if (pick_is_closed) {
		document.getElementById('iosrt_droplid').selectedIndex = 0;
		document.getElementById('iosrt_dropdate').value = '';
		if (typeof(iosrtfpd) != "undefined") {
			iosrtfpd.destroy();
			document.getElementById('iosrt_dropdate').onclick = 'iosRTHighlight(\'iosrt_droplid\');';
		}
		var msg = document.getElementById('iosrt_sfmlang').getAttribute('data-closedon').replace('ZZZZZ', pd);
		alert(msg);
		return;
	} else if (drop_is_closed) {
		var msg = document.getElementById('iosrt_sfmlang').getAttribute('data-closedon').replace('ZZZZZ', dd);
		alert(msg);
		return;
	}

	var hObj = document.getElementById('iosrt_pickhour');
	var mObj = document.getElementById('iosrt_pickmin');
	if (hObj.tagName == 'SELECT') {
		var fpickhour = parseInt(hObj.options[hObj.selectedIndex].value, 10);
		var fpickhmin = parseInt(mObj.options[mObj.selectedIndex].value, 10);
	} else {//hidden input with fixed time
		var fpickhour = parseInt(hObj.value, 10);
		var fpickhmin = parseInt(mObj.value, 10);
	}

	var fullpickdt = new Date(pickdt.getFullYear(), pickdt.getMonth(), pickdt.getDate(), fpickhour, fpickhmin, 0);
	var h2Obj = document.getElementById('iosrt_drophour');
	var m2Obj = document.getElementById('iosrt_dropmin');
	if (h2Obj.tagName == 'SELECT') {
		var fdrophour = parseInt(h2Obj.options[h2Obj.selectedIndex].value, 10);
		var fdrophmin = parseInt(m2Obj.options[m2Obj.selectedIndex].value, 10);
	} else {//hidden input with fixed time
		var fdrophour = parseInt(h2Obj.value, 10);
		var fdrophmin = parseInt(m2Obj.value, 10);
	}

	var fulldropdt = new Date(dropdt.getFullYear(), dropdt.getMonth(), dropdt.getDate(), fdrophour, fdrophmin, 0);
	if (fulldropdt <= fullpickdt) {
		var msg = document.getElementById('iosrt_sfmlang').getAttribute('data-dropafterpick');
		alert(msg);
		return;
	}

	var nowdt = new Date();
	if (fullpickdt <= nowdt) {
		var v1 = fullpickdt.getFullYear()+'-'+fullpickdt.getMonth()+'-'+fullpickdt.getDate();
		var v2 = nowdt.getFullYear()+'-'+nowdt.getMonth()+'-'+nowdt.getDate();
		var mint = (nowdt.getHours() < 10) ? '0'+nowdt.getHours()+':' : nowdt.getHours()+':';
		mint += (nowdt.getMinutes() < 10) ? '0'+nowdt.getMinutes() : nowdt.getMinutes();
		if (v1 == v2) {//same day
			var msg = document.getElementById('iosrt_sfmlang').getAttribute('data-aftertime').replace('ZZZZZ', mint);
		} else {
			var m = nowdt.getMonth() + 1;
			var mind = (m < 10) ? nowdt.getFullYear()+'-0'+m+'-' : nowdt.getFullYear()+'-'+m+'-';
			mind += (nowdt.getDate() < 10) ? '0'+nowdt.getDate()+' '+mint :nowdt.getDate()+' '+mint;
			var msg = document.getElementById('iosrt_sfmlang').getAttribute('data-afterdatetime').replace('ZZZZZ', mind);
		}
		alert(msg);
		return;
	}

	//MIN/MAX RENT DURATION
	var rentdur = iosRTMinMaxRentDur();
	var diff = (dropdt - pickdt) + ((dropdt.getTimezoneOffset() - pickdt.getTimezoneOffset()) * 60 * 1000);
	var days = Math.floor(diff / 86400000);
	if (days < rentdur.min) {
		var msg = document.getElementById('iosrt_sfmlang').getAttribute('data-minis').replace('ZZZZZ', pd);
		msg = msg.replace('QQQQQ', rentdur.min);
		alert(msg);
		return;
	}
	if (days > rentdur.max) {
		var msg = document.getElementById('iosrt_sfmlang').getAttribute('data-maxis').replace('ZZZZZ', pd);
		msg = msg.replace('QQQQQ', rentdur.max);
		alert(msg);
		return;
	}

	//WORKING HOURS
	if (iosRTCalHourRanges != undefined) {
		if (iosRTCalHourRanges[picklid] != undefined) {
			dt = iosRTStdDatetime(pd);
			var zdate_pick = iosRTmakeZdate(dt);
			var hObj = document.getElementById('iosrt_pickhour');
			var mObj = document.getElementById('iosrt_pickmin');
			if (hObj.tagName == 'SELECT') {
				var pickhour = parseInt(hObj.options[hObj.selectedIndex].value, 10);
				var pickhmin = (pickhour * 60) + parseInt(mObj.options[mObj.selectedIndex].value, 10);
			} else {//hidden input with fixed time
				var pickhour = parseInt(hObj.value, 10);
				var pickhmin = (pickhour * 60) + parseInt(mObj.value, 10);
			}
			var is_closed = false;
			var closed_period = '';
			var hpairs, q, hpair, starttime, starthour, endtime, endhour, shmin, ehmin;
			for (var i = iosRTCalHourRanges[picklid].length - 1; i >= 0; i--) {
				if (is_closed) { break; }
				if ((iosRTCalHourRanges[picklid][i].from <= zdate_pick) && (iosRTCalHourRanges[picklid][i].to >= zdate_pick)) {
					hpairs = iosRTCalHourRanges[picklid][i].hours.split(',');
					for (q = 0; q < hpairs.length; q++) {
						hpair = hpairs[q].split('-');
						starttime = hpair[0].split(':');
						starthour = parseInt(starttime[0], 10);
						endtime = hpair[1].split(':');
						endhour = parseInt(endtime[0], 10);
						shmin = (starthour * 60) + parseInt(starttime[1], 10);
						ehmin = (endhour * 60) + parseInt(endtime[1], 10);
						if ((shmin <= pickhmin) && (pickhmin <= ehmin)) { is_closed = true; closed_period = hpairs[q]; break; }
					}
					break;
				}
			}

			if (is_closed) {
				hpair = closed_period.split('-');
				var msg = document.getElementById('iosrt_sfmlang').getAttribute('closedtime-minis').replace('ZZZZZ', hpair[0]);
				msg = msg.replace('QQQQQ', hpair[1]);
				alert(msg);
				return;
			}
		}

		if (iosRTCalHourRanges[droplid] != undefined) {
			dt = iosRTStdDatetime(dd);
			var zdate_drop = iosRTmakeZdate(dt);
			var hObj = document.getElementById('iosrt_drophour');
			var mObj = document.getElementById('iosrt_dropmin');
			if (hObj.tagName == 'SELECT') {
				var drophour = parseInt(hObj.options[hObj.selectedIndex].value, 10);
				var drophmin = (drophour * 60) + parseInt(mObj.options[mObj.selectedIndex].value, 10);
			} else {//hidden input with fixed time
				var drophour = parseInt(hObj.value, 10);
				var drophmin = (drophour * 60) + parseInt(mObj.value, 10);
			}
			var is_closed = false;
			var closed_period = '';
			var hpairs, q, hpair, starttime, starthour, endtime, endhour, shmin, ehmin;
			for (var i = iosRTCalHourRanges[droplid].length - 1; i >= 0; i--) {
				if (is_closed) { break; }
				if ((iosRTCalHourRanges[droplid][i].from <= zdate_drop) && (iosRTCalHourRanges[droplid][i].to >= zdate_drop)) {
					hpairs = iosRTCalHourRanges[droplid][i].hours.split(',');
					for (q = 0; q < hpairs.length; q++) {
						hpair = hpairs[q].split('-');
						starttime = hpair[0].split(':');
						starthour = parseInt(starttime[0], 10);
						endtime = hpair[1].split(':');
						endhour = parseInt(endtime[0], 10);
						shmin = (starthour * 60) + parseInt(starttime[1], 10);
						ehmin = (endhour * 60) + parseInt(endtime[1], 10);
						if ((shmin <= drophmin) && (drophmin <= ehmin)) { is_closed = true; closed_period = hpairs[q]; break; }
					}
					break;
				}
			}

			if (is_closed) {
				hpair = closed_period.split('-');
				var msg = document.getElementById('iosrt_sfmlang').getAttribute('closedtime-minis').replace('ZZZZZ', hpair[0]);
				msg = msg.replace('QQQQQ', hpair[1]);
				alert(msg);
				return;
			}
		}
	}

	var fObj = document.getElementById('iosrt_fmpickdates');
	try { fObj.onsubmit(); } catch(e) { }
	fObj.submit();
}

function iosRTPickExtra(xid, fromlink, xgid) {
	if (!document.getElementById('iosrt_quantity_x'+xid)) { return; }
	var qObj = document.getElementById('iosrt_quantity_x'+xid);
	var quantity = parseInt(qObj.options[qObj.selectedIndex].value, 10);
	if (fromlink == 1) {
		var getnow = false, q = 0, found = false;
		for (var i = 0; i < qObj.length; i++) {
			q = parseInt(qObj.options[i].value);
			if (q == quantity) { getnow = true; continue; }
			if (getnow) { quantity = q; qObj.selectedIndex = i; found = true; break; }
		}
		if (!found) { qObj.selectedIndex = 0; quantity = 0; }//max quantity reached, reset back to 0!
	}

	var str = document.getElementById('iosrt_allxids').value;
	if (str == '') { return; }//just in case
	var xids = str.split(',');

	var sObj, sxgid, squantity;

	if ((xgid > 0) && (quantity > 0)) {
		var singleselect = parseInt(qObj.getAttribute('data-singleselect'), 10);
		if (singleselect == 1) {//Force only one of this extras group can be selected
			for (var i=0; i < xids.length; i++) {
				if (xids[i] == xid) { continue; }
				sObj = document.getElementById('iosrt_quantity_x'+xids[i]);
				sxgid = parseInt(sObj.getAttribute('data-xgid'), 10);
				if (sxgid != xgid) { continue; }
				squantity = sObj.options[sObj.selectedIndex].value;
				squantity = parseInt(squantity, 10);
				if (squantity == 0) { continue; }
				sObj.selectedIndex = 0;
				document.getElementById('iosrt_whamount_x'+xids[i]).className = 'iosrt_extra_amount';
			}
		}
	}

	if (quantity < 1) {
		document.getElementById('iosrt_whamount_x'+xid).className = 'iosrt_extra_amount';
	} else {
		document.getElementById('iosrt_whamount_x'+xid).className = 'iosrt_extra_amount iosrt_extra_amount_selected';
	}

	var pickup = document.getElementById('iosrt_pickup').value;
	var charge_days = document.getElementById('iosrt_charge_days').value;
	charge_days = parseInt(charge_days, 10);

	var pObj, xprice, price, maxprice, priceperday, priceformula, freeitems, priceduration, k;
	var extrasprice = 0.00;

	for (var i=0; i < xids.length; i++) {
		sObj = document.getElementById('iosrt_quantity_x'+xids[i]);
		quantity = sObj.options[sObj.selectedIndex].value;
		quantity = parseInt(quantity, 10);
		pObj = document.getElementById('iosrt_price_x'+xids[i]);
		if (quantity == 0) {
			xprice = pObj.value;
			xprice = parseFloat(xprice);
			document.getElementById('iosrt_price_x'+xids[i]).value = '0.00';
			document.getElementById('iosrt_hamount_x'+xids[i]).innerHTML = '0.00';
			continue;
		}

		price = pObj.getAttribute('data-price');
		price = parseFloat(price);
		maxprice = pObj.getAttribute('data-maxprice');
		maxprice = parseFloat(maxprice);
		priceperday = pObj.getAttribute('data-priceperday');
		priceperday = parseInt(priceperday, 10);
		priceformula = pObj.getAttribute('data-priceformula');
		freeitems = pObj.getAttribute('data-freeitems');
		freeitems = parseInt(freeitems, 10);
		priceduration = pObj.getAttribute('data-priceduration');

		str = document.getElementById('iosrt_xid_x'+xids[i]).getAttribute('data-seasons');
		if (str != '') {
			try {
				var jsonAObj = JSON.parse(str);
			} catch(e) {
				alert(e.message);
				return false;
			}

			for (k=0; k < jsonAObj.length; k++) {
				if (iosRTInSeason(pickup, jsonAObj[k].from, jsonAObj[k].to) === false) { continue; }
				price = parseFloat(jsonAObj[k].price);
				priceperday = parseInt(jsonAObj[k].priceperday, 10);
				priceformula = jsonAObj[k].priceformula;
				freeitems = parseInt(jsonAObj[k].freeitems, 10);
				priceduration = '';
				if (jsonAObj[k].hasOwnProperty('priceduration')) { priceduration = jsonAObj[k].priceduration; }
				break;
			}
		}

		if (priceformula == '') {
			if (priceduration != '') {//price based on rental duration
				var last = 0.00;
				var found = false;
				var parts = priceduration.split(',');
				for (var q = 0; q < parts.length; q++) {
					var daysprice = parts[q].split(':');
					var d = parseInt(daysprice[0], 10);
					last = parseFloat(daysprice[1]);
					if (d >= charge_days) {
						price = parseFloat(daysprice[1]);
						found = true;
						break;
					}
				}
				if (!found) { price = last; }
			}
			if (priceperday == 1) {
				xprice = price * charge_days * (quantity - freeitems);
			} else {
				xprice = price * (quantity - freeitems);
			}
			if (xprice < 0) { xprice = 0; }
			xprice = parseFloat(xprice);
			if ((maxprice > 0) && (xprice > maxprice)) { xprice = maxprice; }
			document.getElementById('iosrt_price_x'+xids[i]).value = xprice.toFixed(2);
			document.getElementById('iosrt_hamount_x'+xids[i]).innerHTML = xprice.toFixed(2);
			extrasprice += xprice;
		}
		if (priceformula == 'FULLEMPTY') {
			xprice = 0.00;
			var mObj = document.getElementById('iosrt_algomodel');
			var tank = parseInt(mObj.getAttribute('data-tank'), 10);
			var fuel = parseInt(mObj.getAttribute('data-fuel'), 10);
			if ((tank > 0) && (fuel > 0)) {
				var fObj = document.getElementById('iosrt_algofuel');
				var refuelcost = parseFloat(fObj.getAttribute('data-refuelcost'));
				switch (fuel) {
					case 1: case 3: var fuelprice = parseFloat(fObj.getAttribute('data-gasoline')); xprice = (fuelprice * tank) + refuelcost; break;
					case 2: var fuelprice = parseFloat(fObj.getAttribute('data-diesel')); xprice = (fuelprice * tank) + refuelcost; break;
					case 4: var fuelprice = parseFloat(fObj.getAttribute('data-gas')); xprice = (fuelprice * tank) + refuelcost; break;
					case 5: var fuelprice = parseFloat(fObj.getAttribute('data-hydrogen')); xprice = (fuelprice * tank) + refuelcost; break;
					case 6: var fuelprice = parseFloat(fObj.getAttribute('data-electric')); xprice = (fuelprice * tank) + refuelcost; break;
					default:break;
				}
				xprice = xprice * (quantity - freeitems);
				if (xprice < 0) { xprice = 0; }
				if ((maxprice > 0) && (xprice > maxprice)) { xprice = maxprice; }
			}
			document.getElementById('iosrt_price_x'+xids[i]).value = xprice.toFixed(2);
			document.getElementById('iosrt_hamount_x'+xids[i]).innerHTML = xprice.toFixed(2);
			extrasprice += xprice;
		}
	}

	if (extrasprice < 0) { extrasprice = 0; }
	document.getElementById('iosrt_extrasprice').value = extrasprice.toFixed(2);
	document.getElementById('iosrt_analysis_extrasprice').innerHTML = extrasprice.toFixed(2);
	iosRTCalcTotal();
}

function iosRTCalcTotal() {
	var rentalfee = document.getElementById('iosrt_rentalfee').value;
	rentalfee = parseFloat(rentalfee);
	var extrahoursfee = document.getElementById('iosrt_extrahoursfee').value;
	extrahoursfee = parseFloat(extrahoursfee);
	var pickupfee = document.getElementById('iosrt_pickupfee').value;
	pickupfee = parseFloat(pickupfee);
	var dropofffee = document.getElementById('iosrt_dropofffee').value;
	dropofffee = parseFloat(dropofffee);
	var afterhourspick = document.getElementById('iosrt_afterhourspick').value;
	afterhourspick = parseFloat(afterhourspick);
	var afterhoursdrop = document.getElementById('iosrt_afterhoursdrop').value;
	afterhoursdrop = parseFloat(afterhoursdrop);
	var couponamount = document.getElementById('iosrt_couponamount').value;
	couponamount = parseFloat(couponamount);
	var extrasprice = document.getElementById('iosrt_extrasprice').value;
	extrasprice = parseFloat(extrasprice);
	var earlybook = document.getElementById('iosrt_earlybook').value;
	earlybook = parseFloat(earlybook);
	var fullamount = document.getElementById('iosrt_fullamount').value;
	fullamount = parseFloat(fullamount);

	var cashamount = 0.00;
	if (document.getElementById('iosrt_cash')) {
		let cObj = document.getElementById('iosrt_cash');
		if (cObj.checked == true) {
			let cashpc = parseInt(cObj.value, 10);
			cashamount = (rentalfee * cashpc) / 100;
			cashamount = parseFloat(cashamount);
		}
	}

	var subtotal = rentalfee + extrahoursfee + pickupfee + dropofffee - couponamount + afterhourspick + afterhoursdrop + extrasprice - earlybook - fullamount - cashamount;
	subtotal = parseFloat(subtotal);
	document.getElementById('iosrt_subtotal').value = subtotal.toFixed(2);
	if (document.getElementById('iosrt_analysis_subtotal')) {
		document.getElementById('iosrt_analysis_subtotal').innerHTML = subtotal.toFixed(2);
	}
	var tax = 0.00;
	var taxObj = document.getElementById('iosrt_tax');
	var cfgtax = taxObj.getAttribute('data-cfgtax');
	if (cfgtax == '') { cfgtax = 0.00; }
	if (isNaN(cfgtax)) { cfgtax = 0.00; }
	if (cfgtax < 0) { cfgtax = 0.00; }
	cfgtax = parseFloat(cfgtax);
	if (cfgtax > 0) {
		var cfgtaxispc = taxObj.getAttribute('data-cfgtaxispc');
		cfgtaxispc = parseInt(cfgtaxispc, 10);
		if (subtotal > 0) {
			if (cfgtaxispc == 1) { tax = (cfgtax * subtotal) / 100; } else { tax = cfgtax; }
		}
	}
	document.getElementById('iosrt_tax').value = tax.toFixed(2);
	if (document.getElementById('iosrt_analysis_tax')) {
		document.getElementById('iosrt_analysis_tax').innerHTML = tax.toFixed(2);
	}
	var totalprice = subtotal + tax;
	document.getElementById('iosrt_totalprice').value = totalprice.toFixed(2);
	document.getElementById('iosrt_analysis_totalprice').innerHTML = totalprice.toFixed(2);

	var sfee = 0.00;
	var sfeeObj = document.getElementById('iosrt_feeamount');
	var cfgsfee = sfeeObj.getAttribute('data-surfee');
	if (cfgsfee == '') { cfgsfee = '0.00'; }
	var sfnote = '';

	var paymodsurfee = parseInt(sfeeObj.getAttribute('data-paymodsurfee'), 10);
	if (paymodsurfee > -1) {
		var sfeepc = parseFloat(paymodsurfee);
		if (sfeepc > 0) {
			sfee = (totalprice * sfeepc) / 100;
			sfee = parseFloat(sfee);
			sfnote = paymodsurfee+'%';
		}
	} else if (cfgsfee.indexOf('pc') == -1) {
		sfee = parseFloat(cfgsfee);
	} else {
		var sfeepc = cfgsfee.replace('pc', '');
		sfeepc = parseFloat(sfeepc);
		if (sfeepc > 0) {
			sfee = (totalprice * sfeepc) / 100;
			sfee = parseFloat(sfee);
			sfnote = sfeepc+'%';
		}
	}
	if (sfee > totalprice) { sfee = totalprice; }
	sfeeObj.value = sfee.toFixed(2);
	if (document.getElementById('iosrt_analysis_feeamount')) {
		document.getElementById('iosrt_analysis_feeamount').innerHTML = sfee.toFixed(2);
	}

	if (document.getElementById('iosrt_sfeenote')) {
		if (sfnote != '') {
			document.getElementById('iosrt_sfeenote').innerHTML = '('+sfnote+')';
			document.getElementById('iosrt_sfeenote').className = 'iosrt_sfeenote';
		} else {
			document.getElementById('iosrt_sfeenote').className = 'iosrt_invisible';
			document.getElementById('iosrt_sfeenote').innerHTML = '';
		}
	}
}


function iosRTInSeason(checkdatetime, seasonfrom, seasonto) {
	var year = parseInt(checkdatetime.substr(0, 4), 10);
	var month = parseInt(checkdatetime.substr(5, 2), 10);
	var day = parseInt(checkdatetime.substr(8, 2), 10);
	var ts = Date.UTC(year, month, day, 12, 0, 0);
	ts = ts / 1000;//milliseconds to seconds
	var pf = seasonfrom.split('-');
	if (pf.length != 2) { return false; }
	var pt = seasonto.split('-');
	if (pt.length != 2) { return false; }
	var d1 = parseInt(pf[0], 10);
	var m1 = parseInt(pf[1], 10);
	var d2 = parseInt(pt[0], 10);
	var m2 = parseInt(pt[1], 10);
	var tsf = Date.UTC(year, m1, d1, 12, 0, 0);
	tsf = tsf / 1000;
	var tst = Date.UTC(year, m2, d2, 12, 0, 0);
	tst = tst / 1000;
	if ((tsf <= ts) && (tst >= ts)) { return true; }
	return false;
}

var checkcouponwait = 0;

function iosrtCheckCoupon() {
	if (checkcouponwait == 1) { return; }
	if (!document.getElementById('iosrt_checkcoupon')) { return; }
	var couponcode = document.getElementById('iosrt_checkcoupon').value;
	if (couponcode == '') { return; }
	var apiid = document.getElementById('iosrt_ccapiid').value;
	var ccguilang = document.getElementById('iosrt_ccguilang').value;
	var cclang = document.getElementById('iosrt_cclang').value;
	var currency = document.getElementById('iosrt_cccurrency').value;
	var pickup = document.getElementById('iosrt_pickup').value;
	var dropoff = document.getElementById('iosrt_dropoff').value;
	var charge_days = document.getElementById('iosrt_charge_days').value;
	charge_days = parseInt(charge_days, 10);
	if (charge_days < 1) { return; }

	var eurl = document.getElementById('iosrt_fmcoupon').action;
	var btn = document.getElementById('iosrt_couponbtn');
	btn.innerHTML = btn.getAttribute('data-wait');
	btn.className = 'iosrt_couponwaitbtn';
	document.getElementById('iosrt_checkcouponmsg').className = 'iosrt_invisible';
	checkcouponwait = 1;

	var successfunc = function(xreply) {
		btn.innerHTML = btn.getAttribute('data-apply');
		btn.className = 'iosrt_couponbtn';
		checkcouponwait = 0;
		try {
			var jsonObj = JSON.parse(xreply);
		} catch(e) {
			document.getElementById('iosrt_checkcouponmsg').innerHTML = e.message;
			document.getElementById('iosrt_checkcouponmsg').className = 'iosrt_couponerror';
			return false;
		}

		if (parseInt(jsonObj.success, 10) == 1) {
			var amount = parseFloat(jsonObj.amount);
			var ispc = parseInt(jsonObj.ispc, 10);
			var caObj = document.getElementById('iosrt_couponamount');
			caObj.setAttribute('data-amount', jsonObj.amount);
			caObj.setAttribute('data-ispc', ispc);
			document.getElementById('iosrt_couponcode').value = jsonObj.code;
			if (ispc == 1) {
				var rentalfee = document.getElementById('iosrt_rentalfee').value;
				rentalfee = parseFloat(rentalfee);
				var couponamount = (rentalfee * amount) / 100;
				couponamount = parseFloat(couponamount);
				caObj.value = couponamount.toFixed(2);
				var arepl = amount+'%';
				document.getElementById('iosrt_analysis_couponamount').innerHTML = '-'+couponamount.toFixed(2);
			} else {
				caObj.value = amount.toFixed(2);
				var arepl = amount.toFixed(2)+' '+jsonObj.currency;
				document.getElementById('iosrt_analysis_couponamount').innerHTML = '-'+amount.toFixed(2);
			}
			document.getElementById('iosrt_fmcoupon').className = 'iosrt_invisible';
			var msgtxt = document.getElementById('iosrt_couponwonmsg').innerHTML;
			msgtxt = msgtxt.replace('AAAAA', jsonObj.code);
			msgtxt = msgtxt.replace('BBBBB', arepl);
			document.getElementById('iosrt_couponwonmsg').innerHTML = msgtxt;
			document.getElementById('iosrt_fmcoupon').className = 'iosrt_invisible';
			document.getElementById('iosrt_couponwonmsg').className = 'iosrt_coupon_tip';
			iosRTCalcTotal();
		} else {
			if (jsonObj.message != '') {
				document.getElementById('iosrt_checkcouponmsg').innerHTML = jsonObj.message;
			} else {
				document.getElementById('iosrt_checkcouponmsg').innerHTML = 'Request failed!';
			}
			document.getElementById('iosrt_checkcouponmsg').className = 'iosrt_couponerror';
			return false;
		}
	}
	var errorfunc = function (XMLHttpRequest, textStatus, errorThrown) {
		btn.innerHTML = btn.getAttribute('data-apply');
		btn.className = 'iosrt_couponbtn';
		checkcouponwait = 0;
		document.getElementById('iosrt_checkcouponmsg').innerHTML = errorThrown;
		document.getElementById('iosrt_checkcouponmsg').className = 'iosrt_couponerror';
	}

	var edata = { 'act': 'checkcoupon', 'apiid':apiid, 'couponcode':couponcode, 'guilang':ccguilang, 'lang':cclang, 'currency':currency, 'pickup':pickup, 'dropoff':dropoff, 'charge_days':charge_days };
	iosRTAjax(eurl, edata, successfunc, errorfunc);
}

function iosRTPickPaymod(pid) {
	if (!document.getElementById('iosrt_pid'+pid)) { return; }
	if (document.getElementById('iosrt_pid'+pid).checked == true) { return; }
	var str = document.getElementById('iosrt_allpids').value;
	var pids = str.split(',');
	var paymod = '', show_pmd = true;
	for (var i=0; i < pids.length; i++) {
		var npid = parseInt(pids[i], 10);
		if (npid == pid) {
			paymod = document.getElementById('iosrt_pid'+npid).getAttribute('data-module');
			document.getElementById('iosrt_pid'+npid).checked = true;
			document.getElementById('iosrt_paymodrow'+npid).className = 'iosrt_paymodsel';
			document.getElementById('iosrt_pid').value = npid;
			document.getElementById('iosrt_paymod').value = paymod;
			show_pmd = true;
		} else {
			document.getElementById('iosrt_pid'+npid).checked = false;
			document.getElementById('iosrt_paymodrow'+npid).className = '';
			show_pmd = false;
		}
		if (document.getElementById('iosrt_paymoddetails_box'+npid)) {//has credit card, or other details
			if (show_pmd == true) {
				document.getElementById('iosrt_paymoddetails_box'+npid).className = 'iosrt_vpad';
			} else {
				document.getElementById('iosrt_paymoddetails_box'+npid).className = 'iosrt_invisible';
			}
		}
	}
	var prev_paymodsurfee = parseInt(document.getElementById('iosrt_feeamount').getAttribute('data-paymodsurfee'), 10);
	var recalc = false;
	if (paymod == 'cashondelivery') {
		document.getElementById('iosrt_feeamount').setAttribute('data-paymodsurfee', '0');
		if (prev_paymodsurfee != 0) { recalc = true; }
	} else {
		document.getElementById('iosrt_feeamount').setAttribute('data-paymodsurfee', '-1');
		if (prev_paymodsurfee != -1) { recalc = true; }
	}
	if (recalc) {
		iosRTCalcTotal();
	}
}

function iosRTCheckPaymods() {
	var str = document.getElementById('iosrt_allpids').value;
	var pids = str.split(',');
	var paymod = '', show_pmd = false;
	for (var i=0; i < pids.length; i++) {
		var xpid = pids[i];
		if (document.getElementById('iosrt_pid'+xpid).checked == true) {
			paymod = document.getElementById('iosrt_pid'+xpid).getAttribute('data-module');
			document.getElementById('iosrt_paymodrow'+xpid).className = 'iosrt_paymodsel';
			document.getElementById('iosrt_pid').value = xpid;
			document.getElementById('iosrt_paymod').value = paymod;
			show_pmd = true;
		} else {
			document.getElementById('iosrt_paymodrow'+xpid).className = '';
			show_pmd = false;
		}
		if (document.getElementById('iosrt_paymoddetails_box'+xpid)) {//has credit card, or other details
			if (show_pmd == true) {
				document.getElementById('iosrt_paymoddetails_box'+xpid).className = 'iosrt_vpad';
			} else {
				document.getElementById('iosrt_paymoddetails_box'+xpid).className = 'iosrt_invisible';
			}
		}
	}
	var prev_paymodsurfee = parseInt(document.getElementById('iosrt_feeamount').getAttribute('data-paymodsurfee'), 10);
	var recalc = false;
	if (paymod == 'cashondelivery') {
		document.getElementById('iosrt_feeamount').setAttribute('data-paymodsurfee', '0');
		if (prev_paymodsurfee != 0) { recalc = true; }
	} else {
		document.getElementById('iosrt_feeamount').setAttribute('data-paymodsurfee', '-1');
		if (prev_paymodsurfee != -1) { recalc = true; }
	}
	if (recalc) {
		iosRTCalcTotal();
	}
}

function iosRTToggleInvoice() {
	if (document.getElementById('iosrt_invoice').checked) {
		document.getElementById('iosrt_invoice_wrap').className = 'iosrt_zero';
	} else {
		document.getElementById('iosrt_invoice_wrap').className = 'iosrt_invisible';
	}
}

function iosRTTrim(str) {
	return str.replace(/^\s+|\s+$/gm,'');
}

var iosrt_bookwait = 0;

function iosRTBook() {
	if (iosrt_bookwait == 1) { return false; } //prevent double click
	var edata = {};
	edata.ofirstname = iosRTTrim(document.getElementById('iosrt_ofirstname').value);
	if (edata.ofirstname == '') { document.getElementById('iosrt_ofirstname').focus(); return false; }
	edata.olastname = iosRTTrim(document.getElementById('iosrt_olastname').value);
	if (edata.olastname == '') { document.getElementById('iosrt_olastname').focus(); return false; }
	edata.oemail = iosRTTrim(document.getElementById('iosrt_oemail').value);
	if (edata.oemail == '') { document.getElementById('iosrt_oemail').focus(); return false; }
	if (document.getElementById('iosrt_oemailconf')) {
		var emailconf = iosRTTrim(document.getElementById('iosrt_oemailconf').value);
		if (emailconf == '') { document.getElementById('iosrt_oemailconf').focus(); return false; }
		if (emailconf != edata.oemail) { document.getElementById('iosrt_oemailconf').focus(); return false; }
	}
	if (document.getElementById('iosrt_driverage')) {
		var obj = document.getElementById('iosrt_driverage');
		edata.driverage = parseInt(obj.value, 10);
		if (obj.hasAttribute('required')) {
			if ((obj.value == '') || isNaN(edata.driverage)) { obj.focus(); return false; }
			if (edata.driverage < 12) { obj.focus(); return false; }
		}
	}
	if (document.getElementById('iosrt_licnumber')) {
		var obj = document.getElementById('iosrt_licnumber');
		edata.licnumber = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.licnumber == '') { obj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_ocountry')) {
		var sObj = document.getElementById('iosrt_ocountry');
		edata.ocountry = sObj.options[sObj.selectedIndex].value;
		if (sObj.hasAttribute('required')) { if (edata.ocountry == '') { sObj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_ocity')) {
		var obj = document.getElementById('iosrt_ocity');
		edata.ocity = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.ocity == '') { obj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_oaddress')) {
		var obj = document.getElementById('iosrt_oaddress');
		edata.oaddress = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.oaddress == '') { obj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_opostalcode')) {
		var obj = document.getElementById('iosrt_opostalcode');
		edata.opostalcode = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.opostalcode == '') { obj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_ophone')) {
		var obj = document.getElementById('iosrt_ophone');
		edata.ophone = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.ophone == '') { obj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_omobile')) {
		var obj = document.getElementById('iosrt_omobile');
		edata.omobile = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.omobile == '') { obj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_flight')) {
		var obj = document.getElementById('iosrt_flight');
		edata.flight = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.flight == '') { obj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_ship')) {
		var obj = document.getElementById('iosrt_ship');
		edata.ship = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.ship == '') { obj.focus(); return false; } }
	}
	if (document.getElementById('iosrt_hotel')) {
		var obj = document.getElementById('iosrt_hotel');
		edata.hotel = iosRTTrim(obj.value);
		if (obj.hasAttribute('required')) { if (edata.hotel == '') { obj.focus(); return false; } }
	}

	var cok = true;
	for (var i = 1; i < 9; i++) {
		if (!document.getElementById('iosrt_ccustom'+i)) { continue; }
		var tobj = document.getElementById('iosrt_ccustom'+i);
		if (tobj.tagName == 'SELECT') {
			edata['ccustom'+i] = tobj.options[tobj.selectedIndex].value;
		} else if ((tobj.type == 'checkbox') || (tobj.type == 'CHECKBOX')) {
			edata['ccustom'+i] = tobj.checked ? 1 : 0;
		} else {
			edata['ccustom'+i] = tobj.value;
			if (tobj.hasAttribute('required')) { if (tobj.value == '') { tobj.focus(); cok = false; break; } }
		}
	}
	if (!cok) { return false; }

	//invoice
	edata.invoice = 0;
	if (document.getElementById('iosrt_invoice')) {
		if (document.getElementById('iosrt_invoice').checked) {
			edata.invoice = 1;
			var obj = document.getElementById('iosrt_invtitle');
			edata.invtitle = iosRTTrim(obj.value);
			if (edata.invtitle == '') { obj.focus(); return false; }
			var obj = document.getElementById('iosrt_invact');
			edata.invact = iosRTTrim(obj.value);
			if (edata.invact == '') { obj.focus(); return false; }
			var obj = document.getElementById('iosrt_invaddress');
			edata.invaddress = iosRTTrim(obj.value);
			if (edata.invaddress == '') { obj.focus(); return false; }
			var obj = document.getElementById('iosrt_invcity');
			edata.invcity = iosRTTrim(obj.value);
			if (edata.invcity == '') { obj.focus(); return false; }
			var obj = document.getElementById('iosrt_invirs');
			edata.invirs = iosRTTrim(obj.value);
			if (edata.invirs == '') { obj.focus(); return false; }
			var obj = document.getElementById('iosrt_invafm');
			edata.invafm = iosRTTrim(obj.value);
			if (edata.invafm == '') { obj.focus(); return false; }
		}
	}

	if (document.getElementById('iosrt_comments')) {
		var obj = document.getElementById('iosrt_comments');
		edata.ocomments = iosRTTrim(obj.value);
	}

	//extras
	if (document.getElementById('iosrt_allxids')) {
		var str = document.getElementById('iosrt_allxids').value;
		if (str != '') {
			var allxids = str.split(',');
			var xids_selected = [];
			for (var i=0; i < allxids.length; i++) {
				sObj = document.getElementById('iosrt_quantity_x'+allxids[i]);
				quantity = sObj.options[sObj.selectedIndex].value;
				quantity = parseInt(quantity, 10);
				if (quantity > 0) { xids_selected.push(allxids[i]+':'+quantity); }
			}
			if (xids_selected.length > 0) { edata.extras = xids_selected.join(','); }
		}
	}

	//paymethod + credit card
	var pid = parseInt(document.getElementById('iosrt_pid').value, 10);
	edata.pid = pid;
	edata.paymod = document.getElementById('iosrt_paymod').value;
	if (document.getElementById('iosrt_allpids')) {
		if (edata.pid < 1) { return false; } //just in case
		//if (edata.paymod == 'creditcardoff') {
		if (document.getElementById('iosrt_ccowner'+pid)) {// creditcardoff / cashondelivery / other
			var obj = document.getElementById('iosrt_ccowner'+pid);
			edata.ccowner = iosRTTrim(obj.value);
			if (edata.ccowner == '') { obj.focus(); return false; }
			var sObj = document.getElementById('iosrt_cctype'+pid);
			edata.cctype = sObj.options[sObj.selectedIndex].value;
			if (edata.cctype == '') { return false; } //just in case
			var obj = document.getElementById('iosrt_ccnumber'+pid);
			edata.ccnumber = iosRTTrim(obj.value);
			if (edata.ccnumber == '') { obj.focus(); return false; }
			var obj = document.getElementById('iosrt_ccseccode'+pid);
			edata.ccseccode = iosRTTrim(obj.value);
			if (edata.ccseccode == '') { obj.focus(); return false; }
			var sObj = document.getElementById('iosrt_ccexpire'+pid);
			edata.ccexpire = sObj.options[sObj.selectedIndex].value;
			if (edata.ccexpire == '') { return false; } //just in case
		}
	}

	if (document.getElementById('iosrt_agreeterms')) {
		if (document.getElementById('iosrt_agreeterms').checked == false) {
			alert(document.getElementById('iosrt_warnterms').innerHTML);
			return false;
		}
	}

	edata.pickup = document.getElementById('iosrt_pickup').value;
	edata.dropoff = document.getElementById('iosrt_dropoff').value;
	edata.picklid = document.getElementById('iosrt_picklid').value;
	edata.droplid = document.getElementById('iosrt_droplid').value;
	edata.couponcode = document.getElementById('iosrt_couponcode').value;
	edata.vtype = document.getElementById('iosrt_vtype').value;
	edata.gid = document.getElementById('iosrt_gid').value;
	edata.mid = document.getElementById('iosrt_mid').value;
	edata.usecash = 0;
	if (document.getElementById('iosrt_cash')) {
		if (document.getElementById('iosrt_cash').checked == true) { edata.usecash = 1; }
	}
	edata.usefullamount = 0;
	let fullamount = parseFloat(document.getElementById('iosrt_fullamount').value);
	if (fullamount > 0) { edata.usefullamount = 1; }

	edata.clip = '';
	if (document.getElementById('iosrt_clip')) { edata.clip = document.getElementById('iosrt_clip').value; }
	edata.act = 'book';
	edata.apiid = document.getElementById('iosrt_ccapiid').value;
	edata.guilang = document.getElementById('iosrt_ccguilang').value;
	edata.lang = document.getElementById('iosrt_cclang').value;
	edata.currency = document.getElementById('iosrt_cccurrency').value;
	edata.ubase = document.getElementById('iosrt_ubase').value;

	iosRTStartPageLoader();
	var successfunc = function(xreply) {
		iosrt_bookwait = 0;
		try {
			var jsonObj = JSON.parse(xreply);
		} catch(e) {
			iosRTStopPageLoader();
			alert(e.message);
			return false;
		}

		if (parseInt(jsonObj.success, 10) < 1) {
			if (jsonObj.message != '') {
				var msg = jsonObj.message;
			} else {
				var msg = 'Action failed!';
			}
			iosRTStopPageLoader();
			alert(msg);
			return false;
		} else {
			if (parseInt(jsonObj.processor, 10) == 1) {
				var fmObj = document.getElementById('iosrt_fmppapi');
				fmObj.action = jsonObj.formaction;
				if (jsonObj.formitems.length > 0) {
					for (var i in jsonObj.formitems) {
						var hObj = document.createElement('input');
						hObj.type = 'hidden';
						hObj.name = jsonObj.formitems[i].iname;
						if ((jsonObj.formitems[i].iname == 'confirmUrl') || (jsonObj.formitems[i].iname == 'cancelUrl')) {
							hObj.value = jsonObj.formitems[i].ivalue.replace('&amp;', '&');
						} else {
							hObj.value = jsonObj.formitems[i].ivalue;
						}
						fmObj.appendChild(hObj);
					}
				}
				fmObj.submit();
			} else {
				var rurl = jsonObj.sucurl+'&rnd='+Math.floor((Math.random()*100)+1);
				window.location.href = rurl;
			}
		}
	}

	var errorfunc = function (XMLHttpRequest, textStatus, errorThrown) {
		iosrt_bookwait = 0;
		iosRTStopPageLoader();
		alert('Action failed! '+errorThrown);
	};

	var eurl = document.getElementById('iosrt_fmbook').action;
	iosrt_bookwait = 1;
	iosRTAjax(eurl, edata, successfunc, errorfunc);
}

function iosRTStartPageLoader() {
	if (!document.getElementById('iosrt_pgloading')) { return; }
	document.getElementById('iosrt_pgloading').style.display = 'block';
}

function iosRTStopPageLoader() {
	if (!document.getElementById('iosrt_pgloading')) { return; }
	document.getElementById('iosrt_pgloading').style.display = 'none';
}

function iosRTTogglePI(mid) {
	if (!document.getElementById('iosrt_piwrap'+mid)) { return; }
	var pibox = document.getElementById('iosrt_piwrap'+mid);
	if (pibox.className == 'iosrt_model_pi2cols') {
		if (window.matchMedia('(max-width: 420px)').matches) {
			if (pibox.style.display == 'none') {
				pibox.style.display = 'block';
			} else if (pibox.style.display == 'block') {
				pibox.style.display = 'none';
			} else {
				pibox.style.display = 'block';
			}
		} else {
			if ((pibox.style.display == '') || (pibox.style.display == 'block') || (pibox.style.display == 'flex')) {
				pibox.style.display = 'none';
			} else {
				pibox.style.display = 'flex';
			}
		}
	} else {//iosrt_model_pi1cols
		if ((pibox.style.display == '') || (pibox.style.display == 'block')) {
			pibox.style.display = 'none';
		} else {
			pibox.style.display = 'block';
		}
	}
}

function iosRTToggleSearch(aObj) {
	var fgObj = document.getElementById('iosrt_form_search');
	if (aObj.className == 'iosrt_filter_lnkup') {
		fgObj.style.maxHeight = '0px';
		aObj.className = 'iosrt_filter_lnkdown';
	} else {
		fgObj.style.maxHeight = '1000px';
		aObj.className = 'iosrt_filter_lnkup';
	}
}
function iosRTToggleFilterGroup(fgroup, aObj) {
	if (!document.getElementById('iosrt_filter_group_'+fgroup)) { return; }
	var fgObj = document.getElementById('iosrt_filter_group_'+fgroup);
	if (aObj.className == 'iosrt_filter_lnkup') {
		fgObj.style.paddingBottom = '0px';
		fgObj.style.marginBottom = '0px';
		fgObj.style.maxHeight = '0px';
		aObj.className = 'iosrt_filter_lnkdown';
	} else {
		fgObj.style.paddingBottom = '10px';
		fgObj.style.marginBottom = '10px';
		fgObj.style.maxHeight = '1000px';
		aObj.className = 'iosrt_filter_lnkup';
	}
}

function iosRTSingleFilter(fgroup, cObj, isfleet) {
	if (cObj.checked == true) {
		if (document.getElementById('iosrt_all_filters')) {
			var filters = document.getElementById('iosrt_all_filters').getAttribute('data-filters').split(';');
			var cid = cObj.id;
			for (i=0; i < filters.length; i++) {
				if (filters[i].indexOf(fgroup+':') === 0) {
					if (document.getElementById('iosrt_filter_'+filters[i]).checked == true) {
						if ('iosrt_filter_'+filters[i] != cObj.id) {
							document.getElementById('iosrt_filter_'+filters[i]).checked = false;
						}
					}
				}
			}
		}
	}
	iosRTFilter(isfleet);
}

function iosRTGetGroupFilters(fgroup, filters) {
	let groupfilters = [];
	if (filters.length == 0) { return groupfilters; }
	for (let g=0; g < filters.length; g++) {
		if (filters[g].indexOf(fgroup+':') === 0) { groupfilters.push(filters[g]); }
	}
	return groupfilters;
}

function iosRTFilter(isfleet) {
	var filters = document.getElementById('iosrt_all_filters').getAttribute('data-filters').split(';');
	var mids = document.getElementById('iosrt_all_models').getAttribute('data-mids').split(';');
	var i, q, cObj, mObj;
	var mids_to_hide = [];

	var orgroups = [];
	for (i=0; i < filters.length; i++) {
		cObj = document.getElementById('iosrt_filter_'+filters[i]);
		if (cObj.hasAttribute('data-orgroup')) {
			var orgroup = cObj.getAttribute('data-orgroup');
			if (orgroups.indexOf(orgroup) === -1) { orgroups.push(orgroup); }
		} else if (cObj.checked) {
			for (q=0; q < mids.length; q++) {
				if (document.getElementById('iosrt_model_'+mids[q]).getAttribute('data-filters').indexOf(filters[i]) === -1) {
					mids_to_hide.push(mids[q]);
				}
			}
		}
	}

	if (orgroups) {
		for (i=0; i < orgroups.length; i++) {
			var groupfilters = iosRTGetGroupFilters(orgroups[i], filters);
			if (!groupfilters) { continue; }
			var checked_filters = [];
			for (q=0; q < groupfilters.length; q++) {
				if (!document.getElementById('iosrt_filter_'+groupfilters[q])) { continue; }//just in case
				if (document.getElementById('iosrt_filter_'+groupfilters[q]).checked) { checked_filters.push(groupfilters[q]); }
			}
			//if checked_filters is empty then display all vehicles from this filters group. Else only the ones that match at least one filter
			if (checked_filters.length > 0) {
				for (q=0; q < mids.length; q++) {
					var modelfilters = document.getElementById('iosrt_model_'+mids[q]).getAttribute('data-filters');
					var mshow = false;
					for (k=0; k < checked_filters.length; k++) {
						if (modelfilters.indexOf(checked_filters[k]) > -1) { mshow = true; break; }
					}
					if (!mshow) { mids_to_hide.push(mids[q]); }
				}
			}
		}
	}

	var visclass = (isfleet) ? 'iosrt_fleet_model' : 'iosrt_model';

	var has_vis_models = false;
	for (q=0; q < mids.length; q++) {
		if (mids_to_hide) {
			if (mids_to_hide.indexOf(mids[q]) === -1) {
				document.getElementById('iosrt_model_'+mids[q]).className = visclass;
				has_vis_models = true;
			} else {
				document.getElementById('iosrt_model_'+mids[q]).className = 'iosrt_invisible';
			}
		} else {
			document.getElementById('iosrt_model_'+mids[q]).className = visclass;
			has_vis_models = true;
		}
	}

	if (has_vis_models) {
		document.getElementById('iosrt_novehmatch_filters').className = 'iosrt_invisible';
	} else {
		document.getElementById('iosrt_novehmatch_filters').className = 'iosrt_iosrt_nofiltersmatch';
	}
}

function iosRTToggleCash() {
	let cObj = document.getElementById('iosrt_cash');
	let cashpc = parseInt(cObj.value, 10);
	if ((cashpc < 1) || (cashpc > 99)) { return; }//just in case...
	let cashamount = 0.00;
	if (cObj.checked == true) {
		let rentalfee = document.getElementById('iosrt_rentalfee').value;
		rentalfee = parseFloat(rentalfee);
		cashamount = (rentalfee * cashpc) / 100;
		cashamount = parseFloat(cashamount);
	}
	if (cashamount > 0) {
		document.getElementById('iosrt_analysis_cash').innerHTML = '-'+cashamount.toFixed(2);
	} else {
		document.getElementById('iosrt_analysis_cash').innerHTML = '0.00';
	}
	iosRTCalcTotal();
}

function iosRTToggleFleetFilters() {
	if (!document.getElementById('iosrt_fleetfilter_lnk')) { return; }
	var aObj = document.getElementById('iosrt_fleetfilter_lnk');
	if (aObj.className == 'iosrt_fleetfilter_lnkup') {
		aObj.className = 'iosrt_fleetfilter_lnkdown';
		document.getElementById('iosrt_filters_showhidebox').className = 'iosrt_invisible';
	} else {
		aObj.className = 'iosrt_fleetfilter_lnkup';
		document.getElementById('iosrt_filters_showhidebox').className = 'iosrt_zero';
	}
}

function iosRTModalOpen(sfx) {
	if (typeof sfx !== "undefined") {
		var modal = document.getElementById('iosrt_modal'+sfx);
	} else {
		var modal = document.getElementById('iosrt_modal');
	}
	modal.style.display = 'flex';
}

function iosRTModalClose(sfx) {
	if (typeof sfx !== "undefined") {
		document.getElementById('iosrt_modal'+sfx).style.display = 'none';
	} else {
		document.getElementById('iosrt_modal').style.display = 'none';
	}
}

function iosRTChangeForm() {
	if (!document.getElementById('iosrt_crrescode')) { return; }
	document.getElementById('iosrt_modalmessage77').className = 'iosrt_invisible';
	iosRTModalOpen(77);
}

function iosRTChangeReservation() {
	if (!document.getElementById('iosrt_crrescode')) { return; }

	document.getElementById('iosrt_modalmessage77').className = 'iosrt_invisible';

	var edata = {};
	edata.act = 'change';
	edata.rescode = iosRTTrim(document.getElementById('iosrt_crrescode').value);
	edata.email = iosRTTrim(document.getElementById('iosrt_cremail').value);
	edata.comments = iosRTTrim(document.getElementById('iosrt_crcomments').value);
	if (edata.rescode == '') { document.getElementById('iosrt_crrescode').focus(); return false; }
	if (edata.email == '') { document.getElementById('iosrt_cremail').focus(); return false; }
	var sObj = document.getElementById('iosrt_crsubject');
	edata.subject = parseInt(sObj.options[sObj.selectedIndex].value, 10);
	var dataObj = document.getElementById('iosrt_condata');
	edata.guilang = dataObj.getAttribute('data-guilang');
	edata.lang = dataObj.getAttribute('data-lang');
	edata.currency = dataObj.getAttribute('data-currency');
	edata.apiid = dataObj.getAttribute('data-apiid');

	iosRTStartPageLoader();
	var successfunc = function(xreply) {
		iosRTStopPageLoader();
		try {
			var jsonObj = JSON.parse(xreply);
		} catch(e) {
			document.getElementById('iosrt_modalmessage77').innerHTML = 'Request failed!';
			document.getElementById('iosrt_modalmessage77').className = 'iosrt_warning';
			return false;
		}
		if (parseInt(jsonObj.success, 10) < 1) {
			if (jsonObj.message != '') {
				var msg = jsonObj.message;
			} else {
				var msg = 'Action failed!';
			}
			document.getElementById('iosrt_modalmessage77').innerHTML = msg;
			document.getElementById('iosrt_modalmessage77').className = 'iosrt_warning';
			return false;
		} else {
			if (jsonObj.message != '') {
				var msg = jsonObj.message;
			} else {
				var msg = 'Your request submitted successfuly. We will contact you as soon as possible. Thank you very much.';
			}
			document.getElementById('iosrt_crrescode').value = '';
			document.getElementById('iosrt_cremail').value = '';
			document.getElementById('iosrt_crcomments').value = '';
			document.getElementById('iosrt_crsubject').selectedIndex = 0;
			document.getElementById('iosrt_modalmessage77').innerHTML = msg;
			document.getElementById('iosrt_modalmessage77').className = 'iosrt_success';
		}
	}

	var errorfunc = function (XMLHttpRequest, textStatus, errorThrown) {
		iosRTStopPageLoader();
		document.getElementById('iosrt_modalmessage77').innerHTML = 'Action failed! '+errorThrown;
		document.getElementById('iosrt_modalmessage77').className = 'iosrt_warning';
	};

	var eurl = document.getElementById('fmrtreschange').action;
	iosRTAjax(eurl, edata, successfunc, errorfunc);
}
