<?php 
/**
* @version		$Id: lang.class.php 1013 2018-04-14 12:50:01Z IOS $
* @package		Component IOS Reservations
* @author		Ioannis Sannos ( https://www.isopensource.com )
* @copyright	Copyright (c) 2008-2018 Is Open Source (https://www.isopensource.com). All rights reserved.
* @license		Commercial
* @description 	Online booking system
**************************************/

/**
=== COMMERCIAL LICENSE ===

IT IS EXTREMELY FORBIDDEN TO MODIFY THIS FILE
IOS RENTALS IS COPYRIGHTED BY IOANNIS SANNOS
HTTPS://WWW.ISOPENSOURCE.COM
*/

defined('_IOSRTAPICLIENT_') or die ('Direct access to this location is not allowed');


class iosrtApiLang {

	private $path = '';
	public $guilang = 'en';
	private $strings = array();

	public function __construct() {
	}

	public function loadLang($path, $optionslang) {
		$this->path = $path;
		$this->guilang = ($optionslang == '') ? $this->browserLang() : $optionslang;
		if (!preg_match('@^[a-z]+$@', $this->guilang)) { $this->guilang = 'en'; }
		if (!file_exists(($this->path.'/language/'.$this->guilang.'.php'))) { $this->guilang = 'en'; }
		if (!defined('_ELXIS_')) { define('_ELXIS_', 2); }
		include($this->path.'/language/'.$this->guilang.'.php');
		$this->strings = $_lang;
	}


	public function get($k) {
		if (isset($this->strings[$k])) { return $this->strings[$k]; }
		$v = strtolower(str_replace('_', ' ', $k));
		return ucfirst($v);
	}


	public function exist($k) {
		return (isset($this->strings[$k])) ? true : false;
	}


	/********************************************************/
	/* DETECT BROWSER LANGUAGE AND CONVERT IT TO ELXIS LANG */
	/********************************************************/
	private function browserLang() {
		$allowed_langs = array();
		if ($handle = opendir($this->path.'/language/')) {
			while (false !== ($entry = readdir($handle))) {
				if ($entry != '.' && $entry != '..') {
					$allowed_langs[] = str_replace('.php', '', $entry);
				}
			}
			closedir($handle);
		}

		if (!is_array($allowed_langs) || (count($allowed_langs) == 0)) { $allowed_langs = array('en'); }
		if (!isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) { return $allowed_langs[0]; }
		$acc_langs_str = trim($_SERVER['HTTP_ACCEPT_LANGUAGE']);
		if ($acc_langs_str == '') { return $allowed_langs[0]; }
		$langs = array();
		$acc_langs = explode(',', trim($acc_langs_str));
		foreach ($acc_langs as $acc_lang) {
			if (preg_match('/(\*|[a-zA-Z0-9]{1,8}(?:-[a-zA-Z0-9]{1,8})*)(?:\s*;\s*q\s*=\s*(0(?:\.\d{0,3})|1(?:\.0{0,3})))?/', trim($acc_lang), $match)) {
				$q = (!isset($match[2])) ? '1.0' : (string)floatval($match[2]);
				$m = trim(strtolower($match[1]));
				$n = strpos($m, '-');
				if ($n !== false) { $m = substr($m, 0, $n); }
				if (!in_array($m, $allowed_langs)) { continue; }
				if (!isset($langs[$q])) { $langs[$q] = array(); }
				$langs[$q][] = $m;
			}
		}
		if (!$langs) { return $allowed_langs[0]; }
		krsort($langs);
		$final_lang = $allowed_langs[0];
		foreach ($langs as $k => $lngs) {
			$final_lang = $lngs[0];
			break;
		}
		return $final_lang;
	}


	/*****************/
	/* I18N STRFTIME */
	/*****************/
	public function i18n_strftime($format, $ts) {
		if (strpos($format, '%a') !== false) {
			$format = str_replace('%a', $this->dayName(gmdate('w', $ts), true), $format);
		}
		if (strpos($format, '%A') !== false) {
			$format = str_replace('%A', $this->dayName(gmdate('w', $ts), false), $format);
		}
		if (strpos($format, '%b') !== false) {
			$format = str_replace('%b', $this->monthName(gmdate('n', $ts), true), $format);
		}
		if (strpos($format, '%B') !== false) {
			$format = str_replace('%B', $this->monthName(gmdate('n', $ts), false), $format);
		}
		$date = strftime($format, $ts);
		return $date;
	}


	/*****************************/
	/* GET FULL/SHORT MONTH NAME */
	/*****************************/
	public function monthName($month, $short=false) {
		switch (intval($month)) {
			case 1: return $short ? $this->strings['JANUARY_SHORT'] : $this->strings['JANUARY']; break;
			case 2: return $short ? $this->strings['FEBRUARY_SHORT'] : $this->strings['FEBRUARY']; break;
			case 3: return $short ? $this->strings['MARCH_SHORT'] : $this->strings['MARCH']; break;
			case 4: return $short ? $this->strings['APRIL_SHORT'] : $this->strings['APRIL']; break;
			case 5: return $short ? $this->strings['MAY_SHORT'] : $this->strings['MAY']; break;
			case 6: return $short ? $this->strings['JUNE_SHORT'] : $this->strings['JUNE']; break;
			case 7: return $short ? $this->strings['JULY_SHORT'] : $this->strings['JULY']; break;
			case 8: return $short ? $this->strings['AUGUST_SHORT'] : $this->strings['AUGUST']; break;
			case 9: return $short ? $this->strings['SEPTEMBER_SHORT'] : $this->strings['SEPTEMBER']; break;
			case 10: return $short ? $this->strings['OCTOBER_SHORT'] : $this->strings['OCTOBER']; break;
			case 11: return $short ? $this->strings['NOVEMBER_SHORT'] : $this->strings['NOVEMBER']; break;
			case 12: return $short ? $this->strings['DECEMBER_SHORT'] : $this->strings['DECEMBER']; break;
			default: return ''; break;
		}
	}


	/***************************/
	/* GET FULL/SHORT DAY NAME */
	/***************************/
	public function dayName($day, $short=false) {
		switch (intval($day)) {
			case 0: return $short ? $this->strings['SUNDAY_SHORT'] : $this->strings['SUNDAY']; break;
			case 1: return $short ? $this->strings['MONDAY_SHORT'] : $this->strings['MONDAY']; break;
			case 2: return $short ? $this->strings['THUESDAY_SHORT'] : $this->strings['THUESDAY']; break;
			case 3: return $short ? $this->strings['WEDNESDAY_SHORT'] : $this->strings['WEDNESDAY']; break;
			case 4: return $short ? $this->strings['THURSDAY_SHORT'] : $this->strings['THURSDAY']; break;
			case 5: return $short ? $this->strings['FRIDAY_SHORT'] : $this->strings['FRIDAY']; break;
			case 6: return $short ? $this->strings['SATURDAY_SHORT'] : $this->strings['SATURDAY']; break;
			default: return ''; break;
		}
	}

}

?>