<?php 
/**
* @version		1.8
* @package		Component IOS Reservations - IOS Rentals
* @author		Ioannis Sannos ( https://www.isopensource.com )
* @copyright	Copyright (c) 2008-2020 Is Open Source (https://www.isopensource.com). All rights reserved.
* @license		Commercial
* @description	en-GB (English - Great Britain) language for IOS Rentals API Client
* @translator	Ioannis Sannos ( https://www.isopensource.com )
*
* ---- THIS FILE MUST BE ENCODED AS UTF-8! ----
*
*****************************************************************************/

defined('_IOSRTAPICLIENT_') or die ('Direct access to this location is not allowed.');


$_lang = array();
$_lang['DIR'] = 'ltr';//ltr: Left-To-Right, rtl: Right-To-Left (like arabic and farsi)
$_lang['ERROR'] = 'Error';
$_lang['LOADFAIL_ERRMSGFOL'] = 'Loading data failed! Error details follows.';
$_lang['PICKUP_LOC'] = 'Pick-up location';
$_lang['RETURN_LOC'] = 'Drop-off location';
$_lang['PICKUP_DATE'] = 'Pick-up date';
$_lang['RETURN_DATE'] = 'Drop-off date';
$_lang['SEARCH'] = 'Search';
$_lang['SELECT_LOCATION'] = 'Select location';
$_lang['VEHICLE_TYPE'] = 'Vehicle type';
$_lang['ANY_VEHICLE'] = 'Any vehicle';
$_lang['CARS'] = 'Cars';
$_lang['MOTORCYCLES'] = 'Motorcycles';
$_lang['BOATS'] = 'Boats';
$_lang['SCOOTERS'] = 'Scooters';
$_lang['ATVS'] = 'ATVs/Quads';
$_lang['BUGGIES'] = 'Buggies';
$_lang['BICYCLES'] = 'Bicycles';
$_lang['OTHER_VEHICLES'] = 'Other vehicles';
$_lang['DATE_PLACEHOLDER'] = 'DD-MM-YYYY';
$_lang['PLEASE_SEL_PICKLOC'] = 'Please select pick-up location!';
$_lang['PLEASE_SEL_DROPLOC'] = 'Please select drop-off location!';
$_lang['PLEASE_SEL_PICKDATE'] = 'Please select pick-up date!';
$_lang['PLEASE_SEL_DROPDATE'] = 'Please select drop-off date!';
$_lang['PLEASE_SEL_VEHICLE'] = 'Please select vehicle!';
$_lang['INVALID_PICKDATE'] = 'Invalid pick-up date!';
$_lang['INVALID_DROPDATE'] = 'Invalid drop-off date!';
$_lang['OR_SIMILAR'] = 'Or similar';
$_lang['BOOK_BUTTON'] = 'Book';
$_lang['YES'] = 'Yes';
$_lang['NO'] = 'No';
$_lang['OUR_PRICES_INCLUDE'] = 'Our prices include';
$_lang['MORE_INFO'] = 'More information';
$_lang['PRICE_FOR_ONE_DAY'] = 'price for 1 day';
$_lang['PRICE_FOR_X_DAYS'] = 'price for %s days';
$_lang['PRICE_FOR_ONE_HOUR'] = 'price for 1 hour';
$_lang['PRICE_FOR_X_HOURS'] = 'price for %s hours';
$_lang['PRICE_FOR_1DAY_1HOUR'] = 'price for 1 day and 1 hour';
$_lang['PRICE_FOR_1DAY_XHOURS'] = 'price for 1 day and %s hours';
$_lang['PRICE_FOR_XDAYS_1HOUR'] = 'price for %s days and 1 hour';
$_lang['PRICE_FOR_XDAYS_XHOURS'] = 'price for %s days and %s hours';
$_lang['THOUSANDS_SEP'] = ',';
$_lang['DECIMALS_SEP'] = '.';
$_lang['CURRENCYFRONT'] = 1; //translators help: if "0" currency is after amount, if "1" currency is before amount
$_lang['OTHER_CHARGES'] = 'other charges';
$_lang['EXTRA_HOURS_FEE'] = 'Extra hours fee';
$_lang['AFTER_WORKHOURS_PICKUP'] = 'After working hours pick-up';
$_lang['AFTER_WORKHOURS_DROPOFF'] = 'After working hours drop-off';
$_lang['PICKUP_FEE'] = 'Pick-up fee';
$_lang['DROPOFF_FEE'] = 'Drop-off fee';
$_lang['VAT'] = 'VAT';
$_lang['AVAILABLE_VEHICLES'] = 'Available vehicles';
$_lang['AVAILABLE_CARS'] = 'Available cars';
$_lang['AVAILABLE_MOTOS'] = 'Available motorcycles';
$_lang['NO_AVAILABLE_VEHICLES'] = 'No available vehicles found!';
$_lang['NO_AVAILABLE_CARS'] = 'No available cars found!';
$_lang['NO_AVAILABLE_MOTOS'] = 'No available motorcycles found!';
$_lang['VEHICLE_DETAILS'] = 'Vehicle details';
$_lang['PRICE_ANALYSIS'] = 'Price analysis';
$_lang['EXTRAS'] = 'Extras';
$_lang['PERSONAL_DETAILS'] = 'Personal details';
$_lang['BOOKING_DETAILS'] = 'Booking details';
$_lang['PAYMENT_INFO'] = 'Payment information';
$_lang['FIRSTNAME'] = 'First name';
$_lang['LASTNAME'] = 'Last name';
$_lang['EMAIL'] = 'E-mail';
$_lang['COUNTRY'] = 'Country';
$_lang['CITY'] = 'City';
$_lang['ADDRESS'] = 'Address';
$_lang['POSTALCODE'] = 'Postal code';
$_lang['TELEPHONE'] = 'Telephone';
$_lang['MOBILE'] = 'Mobile';
$_lang['DRIVER_AGE'] = 'Driver age';
$_lang['CHANGE_CAR'] = 'Change car';
$_lang['CHANGE_VEHICLE'] = 'Change vehicle';
$_lang['CHANGE_BOAT'] = 'Change boat';
$_lang['DATETIME_FORMAT_1'] = "%A %b %d, %Y %H:%M"; //example: Saturday Dec 25, 2010 10:45
$_lang['DATETIME_FORMAT_2'] = "%a %b %d, %Y %H:%M"; //example: Sat Dec 25, 2010 10:45
$_lang['DATETIME_FORMAT_3'] = "%b %d, %Y %H:%M"; //example: Dec 25, 2010 10:45
$_lang['DATETIME_FORMAT_4'] = "%A %B %d, %Y %H:%M"; //example: Saturday December 25, 2010 10:45
$_lang['DATETIME_FORMAT_5'] = "%a %B %d, %Y %H:%M"; //example: Sat December 25, 2010 10:45
$_lang['DATETIME_FORMAT_6'] = "%B %d, %Y %H:%M"; //example: December 25, 2010 10:45
$_lang['DATE_FORMAT_1'] = "%A %b %d, %Y"; //example: Saturday Dec 25, 2010
$_lang['DATE_FORMAT_2'] = "%a %b %d, %Y"; //example: Sat Dec 25, 2010
$_lang['DATE_FORMAT_3'] = "%b %d, %Y"; //example: Dec 25, 2010
$_lang['DATE_FORMAT_4'] = "%A %B %d, %Y"; //example: Saturday December 25, 2010
$_lang['DATE_FORMAT_5'] = "%a %B %d, %Y"; //example: Sat December 25, 2010
$_lang['DATE_FORMAT_6'] = "%B %d, %Y"; //example: December 25, 2010
$_lang['PICKUP'] = 'Pick-up';
$_lang['DROPOFF'] = 'Drop-off';
$_lang['FROM'] = 'from';//translator help: pick-up from {LOCATION}
$_lang['AT'] = 'at';//translator help: drop-off at {LOCATION}
$_lang['RENTAL_DURATION'] = 'Rental duration';
$_lang['DAYS'] = 'days';
$_lang['DAY'] = 'day';
$_lang['HOURS'] = 'hours';
$_lang['HOUR'] = 'hour';
$_lang['AND'] = 'and';
$_lang['CHARGE'] = 'Charge';
$_lang['PRICE_PER_DAY'] = '%s per day';
$_lang['PRICE_PER_RESERVATION'] = '%s per reservation';
$_lang['FIRST_FREE'] = 'first free!';
$_lang['FIRST_NUM_FREE'] = 'first %s free!';
//month names
$_lang['JANUARY'] = 'January';
$_lang['FEBRUARY'] = 'February';
$_lang['MARCH'] = 'March';
$_lang['APRIL'] = 'April';
$_lang['MAY'] = 'May';
$_lang['JUNE'] = 'June';
$_lang['JULY'] = 'July';
$_lang['AUGUST'] = 'August';
$_lang['SEPTEMBER'] = 'September';
$_lang['OCTOBER'] = 'October';
$_lang['NOVEMBER'] = 'November';
$_lang['DECEMBER'] = 'December';
$_lang['JANUARY_SHORT'] = 'Jan';
$_lang['FEBRUARY_SHORT'] = 'Feb';
$_lang['MARCH_SHORT'] = 'Mar';
$_lang['APRIL_SHORT'] = 'Apr';
$_lang['MAY_SHORT'] = 'May';
$_lang['JUNE_SHORT'] = 'Jun';
$_lang['JULY_SHORT'] = 'Jul';
$_lang['AUGUST_SHORT'] = 'Aug';
$_lang['SEPTEMBER_SHORT'] = 'Sep';
$_lang['OCTOBER_SHORT'] = 'Oct';
$_lang['NOVEMBER_SHORT'] = 'Nov';
$_lang['DECEMBER_SHORT'] = 'Dec';
//day names
$_lang['MONDAY'] = 'Monday';
$_lang['THUESDAY'] = 'Tuesday';
$_lang['WEDNESDAY'] = 'Wednesday';
$_lang['THURSDAY'] = 'Thursday';
$_lang['FRIDAY'] = 'Friday';
$_lang['SATURDAY'] = 'Saturday';
$_lang['SUNDAY'] = 'Sunday';
$_lang['MONDAY_SHORT'] = 'Mon';
$_lang['THUESDAY_SHORT'] = 'Tue';
$_lang['WEDNESDAY_SHORT'] = 'Wed';
$_lang['THURSDAY_SHORT'] = 'Thu';
$_lang['FRIDAY_SHORT'] = 'Fri';
$_lang['SATURDAY_SHORT'] = 'Sat';
$_lang['SUNDAY_SHORT'] = 'Sun';
//days end
$_lang['RENTAL_FEE'] = 'Rental fee';
$_lang['EXTRA_HOURS'] = 'Extra hours';
$_lang['PICK_UP'] = 'Pick-up';
$_lang['DROP_OFF'] = 'Drop off';
$_lang['PICKDROP_OUTWORKH'] = 'Pick-up / Drop-off outside of working hours';
$_lang['PICKUP_AFTERH'] = 'O.W.H. Pick-up';
$_lang['DROPOFF_AFTERH'] = 'O.W.H. Drop-off';
$_lang['EXTRAS_SHORT'] = 'Extras';
$_lang['COUPON'] = 'Coupon';
$_lang['SUBTOTAL'] = 'Subtotal';
$_lang['TAX'] = 'Tax';
$_lang['TOTAL'] = 'Total';
$_lang['PRICES_INC_TAXES'] = 'Prices includes all taxes';
$_lang['SURETY_FEE'] = 'Advanced payment';
$_lang['DISCOUNT_COUPON'] = 'Discount coupon';
$_lang['DISCOUNT_COUPON_TIP'] = 'If you own a discount coupon fill-in its code below and click Apply to receive a discount.';
$_lang['COUPON_CODE'] = 'Coupon code';
$_lang['APPLY'] = 'Apply';
$_lang['WAIT'] = 'Wait...';
$_lang['INV_COUPON_CODE'] = 'Invalid coupon code!';
$_lang['COUPON_GOT_DISCOUNT'] = 'With coupon %s you got a discount of %s';
$_lang['PAYMENT_OPTIONS'] = 'Payment options';
$_lang['ONLINE_PAYMENT'] = 'Online payment';
$_lang['OFFLINE_PAYMENT'] = 'Offline payment';
$_lang['CC_OWNER'] = 'Owner name';
$_lang['CC_TYPE'] = 'Credit Card type';
$_lang['CC_NUMBER'] = 'Credit Card number';
$_lang['CC_SECURITY_CODE'] = 'Security code';
$_lang['CC_EXPDATE'] = 'Expiration date';
$_lang['AGREE_TERMS_CONDS'] = 'I agree to the rental terms and conditions';
$_lang['CONMUSTAGREE_TERMS_CONDS'] = 'To continue you must agree to the rental terms and conditions!';
$_lang['COMMENTS'] = 'Comments';
$_lang['HOTEL'] = 'Hotel';
$_lang['COMMENTS_TIP'] = 'If there is anything we should know in order to service you better please write it here.';
$_lang['PLEASE_WAIT'] = 'Please wait...';
$_lang['ISSUE_INVOICE_TIP'] = 'I represent a company and I want to receive an invoice';
$_lang['COMPANY_TITLE'] = 'Company title';
$_lang['COMPANY_ACTIV'] = 'Job function';
$_lang['IRS'] = 'IRS';
$_lang['AFM'] = 'VAT number';
$_lang['INVOICE_FIELDS_NOTE'] = 'Depending on your country and the local law fields Job function and IRS may not be used. 
	Type anything (eg. NA) in these fields in this case.';
$_lang['FIELD_NOEMPTY'] = 'Field %s cannot be empty!';
$_lang['INV_EMAIL'] = 'Invalid e-mail address!';
$_lang['YRESERV_COMPLETE'] = 'Your reservation is complete!';
$_lang['YRESERV_COMPLETE_DESC'] = 'Your reservation completed successfully. Τhe status of the reservation is <strong>Pending</strong>. One of our 
	representatives will contact you shortly. An e-mail, containing the full booking details, was sent to your e-mail address.';
$_lang['YRESERV_PAIDCONF_DESC'] = 'Your reservation was paid and confirmed. An e-mail containing the full booking details sent to your e-mail address.';
$_lang['RESERVATION_CODE'] = 'Reservation code';
$_lang['THANKS_CHOOSE'] = 'Thank you for choosing us!';
$_lang['PAYMENT_FAILED'] = 'Payment failed!';
$_lang['YRESERV_FAIL_DESC'] = 'Your reservation saved but payment failed. Please contact us.';
$_lang['VEHICLE'] = 'Vehicle';
$_lang['PAYMENT_METHOD'] = 'Payment method';
$_lang['RETRY_PAYMENT'] = 'Re-try payment';
$_lang['NEW_SEARCH'] = 'New search';
$_lang['SHOW_HIDE_DETAILS'] = 'Show/Hide details';
$_lang['SAME_AS_PICKLOC'] = 'Same as pick-up location';
$_lang['LICENSE_NUMBER'] = 'License number';
$_lang['EMAIL_CONFIRMATION'] = 'E-mail confirmation';
$_lang['VAT_X_INCLUDED'] = 'VAT %s included';
$_lang['VAT_X_NOT_INCLUDED'] = 'prices without VAT %s';
$_lang['PRINT_PAGE'] = 'Print this page';
$_lang['CLOSED_ON_DATE'] = 'We are closed on %s';//translators help: ... closed on {DATE}
$_lang['MINRENT_FORIS'] = 'Minimum rental duration for %s is %s days!';
$_lang['MAXRENT_FORIS'] = 'Maximum rental duration for %s is %s days!';
$_lang['CLOSED_FROMTO'] = 'We are closed from %s to %s!';//translators help: ... from {TIME} to {TIME}
$_lang['CATEGORY'] = 'Category';
$_lang['CAR_SPECIFICATIONS'] = 'Car specifications';
$_lang['VEHICLE_SPECIFICATIONS'] = 'Vehicle specifications';
$_lang['NOVEH_MATCH_FILTERS'] = 'No vehicles match selected filters!';
$_lang['FORMTEXT_PDAFTER20_CONTACT'] = 'For pick-ups or drop-offs after 20:00 please contact us!';
$_lang['FORMTEXT_PDAFTER21_CONTACT'] = 'For pick-ups or drop-offs after 21:00 please contact us!';
$_lang['FORMTEXT_PDAFTER22_CONTACT'] = 'For pick-ups or drop-offs after 22:00 please contact us!';
$_lang['FORMTEXT_PDAFTER23_CONTACT'] = 'For pick-ups or drop-offs after 23:00 please contact us!';
$_lang['FORMTEXT_PDAFTER00_CONTACT'] = 'For pick-ups or drop-offs after 00:00 please contact us!';
$_lang['FORMTEXT_PDAFTER01_CONTACT'] = 'For pick-ups or drop-offs after 01:00 please contact us!';
$_lang['FORMTEXT_PDAFTER02_CONTACT'] = 'For pick-ups or drop-offs after 02:00 please contact us!';
$_lang['FORMTEXT_MORE07_CONTACT'] = 'For rentals for more than 7 days please contact us!';
$_lang['FORMTEXT_MORE10_CONTACT'] = 'For rentals for more than 10 days please contact us!';
$_lang['FORMTEXT_MORE12_CONTACT'] = 'For rentals for more than 12 days please contact us!';
$_lang['FORMTEXT_MORE15_CONTACT'] = 'For rentals for more than 15 days please contact us!';
$_lang['FORMTEXT_MORE20_CONTACT'] = 'For rentals for more than 20 days please contact us!';
$_lang['FORMTEXT_MORE25_CONTACT'] = 'For rentals for more than 25 days please contact us!';
$_lang['FORMTEXT_MORE30_CONTACT'] = 'For rentals for more than 30 days please contact us!';
$_lang['FORMTEXT_CUSTOM1'] = 'For pick-ups or drop-offs after XX:XX please contact us!';/* edit as you wish! Dont forget to edit files for ALL languages */
$_lang['FORMTEXT_CUSTOM2'] = 'For rentals for more than X days please contact us!';/* edit as you wish! Dont forget to edit files for ALL languages */
$_lang['SELPICK_AFTER_DATETIME'] = 'Please select pick-up date after %s!';
$_lang['SELPICK_AFTER_TIME'] = 'Please select pick-up time after %s!';
$_lang['SIMILAR_CARS'] = 'Similar cars';
$_lang['SIMILAR_MOTOS'] = 'Similar motorcycles';
$_lang['SIMILAR_VEHICLES'] = 'Similar vehicles';
$_lang['SELDROP_AFTERPICK'] = 'Please select drop-off date and time after pick-up!';
//v1.1
$_lang['EARLYDISC_PC_DAYS_PICKUP'] = '%s discount for booking %s days before the pick-up date';
$_lang['EARLY_BOOKING'] = 'Early booking';
$_lang['CASH_DISCOUNT'] = 'Cash discount';
$_lang['100_PREPAYMENT'] = '100% prepayment';
$_lang['FULLAMOUNT_DISC_PAYNOW'] = '%s discount for paying the whole amount now.';
$_lang['PAYCASH_GETDISCOUNT'] = 'I wish to pay the rest amount in cash on vehicle pick-up and get a %s discount.';
$_lang['VEH_PICKUP_FROM'] = 'Vehicle pick-up charge from %s';//translators help: ... from {PICK-UP LOCATION}
$_lang['VEH_DROPOFF_TO'] = 'Vehicle drop-off charge to %s';//translators help: ... to {DROP-OFF LOCATION}
$_lang['EXTRA_HOURS_DESC'] = 'Charge for returning the vehicle with %s hours delay.';
$_lang['FIRST_HOUR_FREE'] = 'The first hour is free.';
$_lang['FIRST_HOURS_FREE'] = 'The first %s hours are free.';
$_lang['SPECIAL_OFFER_DISCOUNT'] = 'Special offer -%s';//translators help: ... offer -{PERCENTAGE} (FAKE DISCOUNT)
$_lang['NONREFUND_DISCOUNT'] = 'Non refundable discount';
$_lang['BOOK_PAYNOW_PC'] = 'Book and pay now only the %s.';//translators help: ... the {PERCENTAGE} ...
$_lang['BOOK_PAYNOW_AMOUNT'] = 'Book and pay now %s.';//translators help: ... now {AMOUNT CURRENCY}
$_lang['BOOK_PAYNOW_NOTHING'] = 'Book without prepaying anything!';
$_lang['OR_BOOK'] = 'or';
//v1.2
$_lang['FLEET'] = 'Fleet';
$_lang['CARS_FLEET'] = 'Cars fleet';
$_lang['VEH_NOT_FOUND'] = 'Vehicle not found!';
$_lang['BACK_FLEET_PAGE'] = 'Back to fleet page';
$_lang['MODEL_FEATURES'] = 'Model features';
$_lang['VEHNOTAV_ALTERNATIVES'] = 'Unfortunately your selected vehicle is not available for the chosen dates. Consider the following alternatives for your rental.';
$_lang['FILTERS'] = 'Filters';
//v1.3
$_lang['PAY_WITH_CREDITCARD'] = 'Pay with credit card';
$_lang['PAY_WITH_MASTERPASS'] = 'Pay with Masterpass';
$_lang['CANCEL_CHANGE_RESERVATION'] = 'Cancel/Change reservation';
$_lang['CANCEL_RESERVATION'] = 'Cancel reservation';
$_lang['CHANGE_RESERVATION'] = 'Change reservation';
$_lang['INFORMATION'] = 'Information';
$_lang['CHANGE_RESERVATION_TIP'] = 'In case you want to cancel a reservation, you want to change it, or you want to inform us about something 
	regarding it you can submit a request below. Type the reservation code, the e-mail address you used in reservation and, optionally, a comment.';
 $_lang['NOCANCEL_RESERVATION_DAYS'] = 'You cannot cancel a reservation if the pick-up date is sooner than %s days.';
$_lang['SUBMIT_REQUEST'] = 'Submit request';
$_lang['CLOSE'] = 'Close';
$_lang['SUBJECT'] = 'Subject';
//v1.4
$_lang['FLIGHT_NUMBER'] = 'Flight number';
$_lang['SHIP_NAME'] = 'Ship name';
$_lang['SPECIFICATION'] = 'Specification';
$_lang['AVAILABLE_IN_LOCATION'] = 'Available in %s';//translators help: ... in {LOCATION NAME}
$_lang['AVAILABLE_IN_LOCATIONS'] = 'Available in %s locations';//translators help: ... in {NUMBER} locations
$_lang['AVAILABLE_IN_ALL_LOCATIONS'] = 'Available in all locations';
$_lang['AVAILABLE_BOATS'] = 'Available boats';
$_lang['BOAT_DETAILS'] = 'Boat details';
$_lang['AGE'] = 'Age';
$_lang['NO_AVAILABLE_BOATS'] = 'No available boats found!';
$_lang['BOAT'] = 'Boat';
$_lang['SIMILAR_BOATS'] = 'Similar boats';
$_lang['TERMS_CONDS'] = 'Terms and conditions';
//v1.6
$_lang['SELECT'] = 'Select';
//v1.8
$_lang['PICKUP_HOUR'] = 'Pick-up hour';
$_lang['PICKUP_MINUTES'] = 'Pick-up minutes';
$_lang['DROPOFF_HOUR'] = 'Drop-off hour';
$_lang['DROPOFF_MINUTES'] = 'Drop-off minutes';
$_lang['QUANTITY'] = 'Quantity';
$_lang['CHARGE_DURATION'] = 'Charge duration';

?>