<?php
if ( ! defined( 'ABSPATH' ) ) {  exit;  }    // Exit if accessed directly

/**
 * Handles option page definition for import of demos
 * 
 * IMPORTANT:
 * ==========
 * 
 * Enable WP_DEBUG to get complete error messages during import in debug.log file 
 * (Always make sure to disable not needed plugins when testing import of a demo during development - otherwise import might break for user !! )
 * 
 * 
 * @added_by Günter
 * @since 4.8.2
 * 
 * 
 * DEMO Files:
 * ===========
 * 
 * Directory atructure on download server (Github does not work because png files cannot be read):
 * 
 * - Main folder ( e.g. https://test.aviathemes.com/wp-content/enfold_demos/ )
 *	-- subfolder(s) to group demos
 *		--- folder for demo - must have demo name (e.g. my-demo)
 *			---- my-demo.png contains preview image
 *			---- my-demo.zip contains my-demo.xml and my-demo.php
 * 
 * Directory atructure on user server:
 * 
 * Downloaded demos are placed in
 * 
 *		- .../uploads/avia_demo_files 
 * 
 * using the same subfolder(s) - folder hierarchy as on download server.
 * 
 * User must select which demos he wants to download.
 * --------
 * Array elements:
 * 
 *	Shipped demos:
 * 
 *		'image'		Link to preview image (if empty only a button is displayed)  e.g.   'includes/admin/demo_files/demo_images/enfold-2017.jpg'
 *		'files'		Link to files without file extension e.g.  '/includes/admin/demo_files/enfold-2017'
 *		
 *	External demos (since 4.8.2):
 * 
 *		'folders'	Allows to group demos (if empty folder for demo must be in main directory, else in main directory/folders) e.g.   'shop/'
 *		'demo_name'	Name of folder and files in folder e.g.    'enfold-2017'
 *		'demo_img'	Name of preview image (defaults to demo_name.jpg) e.g.   'enfold-2017.jpg'
 */


global $avia_config;

/**
 * Define global variables to deal with demo import and the demo files
 * 
 * @since 4.8.2
 */
if( ! isset( $avia_config['demo_import'] ) )
{
	$avia_config['demo_import']['download_server_url'] = 'https://kriesi.at/enfold_demos/';

	
	$avia_config['demo_import']['local_image_url'] = trailingslashit(get_template_directory_uri() ) . 'includes/admin/demo_files/demo_images/';
	$avia_config['demo_import']['local_image_path'] = trailingslashit( get_template_directory() ) . 'includes/admin/demo_files/demo_images/';
	$avia_config['demo_import']['local_image_path'] = str_replace( '\\' , '/', $avia_config['demo_import']['local_image_path'] );
	
	$avia_config['demo_import']['upload_folders'] = wp_upload_dir();
	$avia_config['demo_import']['upload_folders']['basedir'] = str_replace( '\\' , '/', $avia_config['demo_import']['upload_folders']['basedir'] );
	if( is_ssl() )
	{
		$avia_config['demo_import']['local_image_url'] = str_replace( 'http://', 'https://', $avia_config['demo_import']['local_image_url'] );
		$avia_config['demo_import']['upload_folders']['baseurl'] = str_replace( 'http://', 'https://', $avia_config['demo_import']['upload_folders']['baseurl'] );
	}

	$folder = apply_filters( 'avf_demo_import_folder_name', 'avia_demo_files' );
	
	$avia_config['demo_import']['upload_folders']['main_dir'] = trailingslashit( trailingslashit( $avia_config['demo_import']['upload_folders']['basedir'] ) . $folder );
	$avia_config['demo_import']['upload_folders']['main_url'] = trailingslashit( trailingslashit( $avia_config['demo_import']['upload_folders']['baseurl'] ) . $folder );
}

/**
 * 
 * @since 4.8.2
 * @param array 
 * @return array
 */
$avia_config['demo_import'] = apply_filters( 'avf_demo_import_settings', $avia_config['demo_import'] );


/**
 * Define the demos
 */

$what_get 		= __( 'What you get:', 'avia_framework' );
$online_demo 	= __( 'Online Demo', 'avia_framework' );
$demo_id		= 0;

/**
 * Shipped Demos
 * =============
 */
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Default Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a> ".__( '(for shop functionality)', 'avia_framework' )."</li>"
									."<li><a href='https://wordpress.org/plugins/bbpress/' target='_blank'>BBPress</a> ".__( '(for forum functionality)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'A few', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'image'		=> 'includes/admin/demo_files/demo_images/default.jpg',
					);

/**
 * External Server Demos
 * =====================
 */
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Enfold 2017', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-2017/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a> ".__( '(for shop functionality)', 'avia_framework' )."</li>"
									."<li><a href='https://wordpress.org/plugins/bbpress/' target='_blank'>BBPress</a> ".__( '(for forum functionality)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'enfold-2017',
					'demo_img'	=> 'enfold-2017.jpg',
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Small Business - Flat Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-business-flat/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'business-flat'
					);

					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Startup Business Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-startup/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'startup'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: One Page Portfolio Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-one-page-portfolio/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'one-page-portfolio'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Minimal Portfolio Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-minimal-portfolio/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'minimal-portfolio'
					);

					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Elegant Portfolio Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-elegant-portfolio/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'elegant-portfolio'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Photography Portfolio Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-photography/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a> ".__("(if you want to sell photos online)", 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'photography'
					);
					
					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Minimal Photography Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-minimal-photography/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'minimal-photography'
					);
					
					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Dark Photography Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-dark-photography/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'dark-photography'
					);					
					
					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Creative Studio Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-creative-studio/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'creative-studio'
					);	
					
					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: One Page Agency Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-one-page-agency/' target='_blank'>{$online_demo}</a></strong></p>"
								."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
								."<li>".__( 'None', 'avia_framework' )."</li>"
								."</ul>"
								."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
								."<li>".__( 'All', 'avia_framework' )."</li>"
								."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'one-page-agency'
					);					
					
			
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Medical Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-medical/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'medical'
					);
	

$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Shop Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-shop/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Required Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a> ".__( '(needs to be active to install the demo)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'exists'	=> array( 'WooCommerce' => __( 'The WooCommerce Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo', 'avia_framework' ) ),
					'demo_name'	=> 'shop'
					);
					

$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Restaurant Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-restaurant/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a> ".__("(if you want to provide online ordering and delivery)", 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'restaurant'
					);

					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: One Page Restaurant Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-restaurant-one-page/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a> ".__("(if you want to provide online ordering and delivery)", 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'one-page-restaurant'	
					);

					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: One Page Wedding Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-wedding/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'one-page-wedding'	
					);		

					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Construction Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-construction/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'construction'
					);	


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Church Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-church/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Required Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='https://wordpress.org/plugins/the-events-calendar/' target='_blank'>The Events Calendar</a> "
									.__( '(needs to be active to install the demo)', 'avia_framework' )."</li>"
									."<li>or <a href='http://mbsy.co/6cr37' target='_blank'>The Events Calendar PRO</a></li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'exists'	=> array( 'Tribe__Events__Main' => __( 'The Events Calendar Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo', 'avia_framework' ) ),
					'demo_name'	=> 'church'
					);
					

$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Simple Blog Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-blog/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'simple-blog'		
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Lifestyle Blog Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-lifestyle-blog/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'lifestyle-blog'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: \'Coming Soon\' Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-coming-soon/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'coming-soon'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: \'Landing Page\' Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-landing-page/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'landing-page'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Travel Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-travel/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__("Required Plugins:", 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a> ".__( '(needs to be active to install the demo)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='https://woocommerce.com/products/woocommerce-bookings/?ref=84' target='_blank'>WooCommerce Bookings</a> ".__( '(needs to be active to allow date based bookings)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'exists'	=> array( 'WooCommerce' => __( 'The WooCommerce Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo', 'avia_framework' ) ),
					'demo_name'	=> 'travel'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Hotel Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-hotel/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Required Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a> ".__( '(needs to be active to install the demo)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='https://woocommerce.com/products/woocommerce-bookings/?ref=84' target='_blank'>WooCommerce Bookings</a> ".__( '(needs to be active to allow date based bookings)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'exists'	=> array( 'WooCommerce' => __( 'The WooCommerce Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo', 'avia_framework' ) ),
					'demo_name'	=> 'hotel'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Spa Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-spa/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a></li>"
									."<li><a href='https://woocommerce.com/products/woocommerce-bookings/?ref=84' target='_blank'>WooCommerce Bookings</a> ".__("(needs to be active to allow date based bookings)", 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'spa'
					);
					
					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Law Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-law/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'law'
					);
					
					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Consulting Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-consulting/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'consulting'
					);
					

$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Résumé Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-resume/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'resume'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: GYM Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-gym/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'gym'
					);


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Health Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-health-coach/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'health'
					);

					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: App Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-app/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'app'
					);

					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Gaming Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-gaming/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'gaming'
					);
					
					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: DJ Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-dj/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'dj'
					);			
					
					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Band Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-band/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Required Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='http://woocommerce.com/?ref=84' target='_blank'>WooCommerce</a></li>" . __( '(needs to be active to install the demo)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'exists'	=> array( 'WooCommerce' => __( 'The WooCommerce Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo', 'avia_framework' ) ),
					'demo_name'	=> 'band'
					);		


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Freelancer Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-freelancer/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'freelancer'
					);	


$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Visual Artist Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-visual-artist/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Recommended Plugins:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'None', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'demo_name'	=> 'visual-artist'
					);	

					
$avia_elements[] =	array(
					'slug'		=> 'demo',
					'name'		=> __( 'Import: Knowledgebase Demo', 'avia_framework' ),
					'desc'		=> 	 "<p><strong>{$what_get} <a href='https://kriesi.at/themes/enfold-knowledgebase-demo/' target='_blank'>{$online_demo}</a></strong></p>"
									."<h4 class='av-before-plugins'>".__( 'Required Plugins:', 'avia_framework' )."</h4><ul>"
									."<li><a href='https://wordpress.org/plugins/bbpress/' target='_blank'>BBPress</a> ".__( '(needs to be active to install the demo)', 'avia_framework' )."</li>"
									."</ul>"
									."<h4 class='av-before-plugins'>".__( 'Demo Images included:', 'avia_framework' )."</h4><ul>"
									."<li>".__( 'All', 'avia_framework' )."</li>"
									."</ul>",
					'id'		=> 'import' . ++$demo_id,
					'type'		=> 'import',
					'exists'	=> array( 'bbPress' => __( 'The bbPress Plugin is currently not active. Please install and activate it, then reload this page in order to be able to import this demo', 'avia_framework' ) ),
					'demo_name'	=> 'knowledgebase'
					);
	


