<?php
//
// Uncomment one of the following two. Their functions are in panel/generic.php
//
//add_action('wp_enqueue_scripts', 'ci_enqueue_modernizr');
add_action('wp_enqueue_scripts', 'ci_print_html5shim');

// This function lives in panel/generic.php
//add_action('wp_footer', 'ci_print_selectivizr', 100);


add_action('init', 'ci_register_theme_scripts');
if ( !function_exists('ci_register_theme_scripts') ) :
function ci_register_theme_scripts() {
	//
	// Register all scripts here, both front-end and admin. 
	// There is no need to register them conditionally, as the enqueueing can be conditional.
	//

	wp_register_script( 'jquery-gmaps-latlon-picker', get_child_or_parent_file_uri( '/js/admin/jquery-gmaps-latlon-picker.js' ), array(
		'jquery',
		'google-maps'
	), '1.2', true );

	wp_register_script( 'ci-repeating-fields', get_child_or_parent_file_uri( '/js/admin/repeating-fields.js' ) );
	wp_register_script( 'ci-post-edit-screens', get_child_or_parent_file_uri( '/js/admin/post-edit-screens.js' ), array(
		'jquery',
		'ci-repeating-fields',
		'jquery-gmaps-latlon-picker',
	), CI_THEME_VERSION, true );

	wp_register_script( 'select2', get_child_or_parent_file_uri( '/js/admin/select2.js' ), array( 'jquery' ), '4.0.0-rc.1', true );
	wp_register_script( 'ci-select2-scripts', get_child_or_parent_file_uri( '/js/admin/select2scripts.js' ), array(
		'jquery',
		'select2'
	), CI_THEME_VERSION, true );
	$params = array(
		'ajaxurl'            => admin_url( 'admin-ajax.php' ),
		'woeid_search_api'   => trim( ci_setting( 'yahoo_weather_api_key' ) ) != '' && trim( ci_setting( 'yahoo_weather_api_secret' ) ) != '' ? true : false,
		'woeid_search_nonce' => wp_create_nonce( 'woeid-search' ),
	);
	wp_localize_script( 'ci-select2-scripts', 's2param', $params );


	wp_register_script( 'ci-admin-widgets', get_child_or_parent_file_uri( '/js/admin/admin-widgets.js' ), array(
		'jquery',
		'ci-repeating-fields',
	), CI_THEME_VERSION, true );

	wp_register_script( 'superfish', get_template_directory_uri() . '/js/superfish.js', array( 'jquery' ), '1.7.5', true );
	wp_register_script( 'mmenu', get_template_directory_uri() . '/js/jquery.mmenu.min.all.js', array( 'jquery' ), '5.2.0', true );
	wp_register_script( 'flexslider', get_template_directory_uri() . '/js/jquery.flexslider.js', array( 'jquery' ), '2.5.0', true );
	wp_register_script( 'isotope', get_template_directory_uri() . '/js/isotope.pkgd.js', array( 'jquery' ), '2.2.0', true );
	wp_register_script( 'placeholders', get_template_directory_uri() . '/js/placeholders.js', array( 'jquery' ), '4.0.1', true );
	wp_register_script( 'dropkick', get_template_directory_uri() . '/js/dropkick.2.1.4.min.js', array( 'jquery' ), '2.1.4', true );
	wp_register_script( 'parallax', get_template_directory_uri() . '/js/jquery.parallax-1.1.3.js', array( 'jquery' ), '1.1.3', true );
	wp_register_script( 'fitVids', get_template_directory_uri() . '/js/jquery.fitvids.js', array( 'jquery' ), '1.1', true );
	wp_register_script( 'magnific', get_template_directory_uri() . '/js/jquery.magnific-popup.js', array( 'jquery' ), '1.0.0', true );
	wp_register_script( 'ci-front-scripts', get_template_directory_uri() . '/js/scripts.js', array(
		'jquery',
		'jquery-ui-datepicker',
		'superfish',
		'mmenu',
		'flexslider',
		'isotope',
		'placeholders',
		'dropkick',
		'parallax',
		'fitVids',
		'magnific',
	), CI_THEME_VERSION, true );

	$vars = array(
		'ajaxurl'       => admin_url( 'admin-ajax.php' ),
		'weather_nonce' => wp_create_nonce( 'weather-check' ),
	);
	wp_localize_script( 'ci-front-scripts', 'ci_theme_vars', $vars );
}
endif;



add_action('wp_enqueue_scripts', 'ci_enqueue_theme_scripts');
if( !function_exists('ci_enqueue_theme_scripts') ):
function ci_enqueue_theme_scripts() {
	//
	// Enqueue all (or most) front-end scripts here.
	// They can be also enqueued from within template files.
	//	
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	if ( ci_setting( 'google_maps_api_enable' ) == 'on' ) {
		wp_enqueue_script( 'google-maps' );
	}

	wp_enqueue_script( 'ci-front-scripts' );

	ci_localize_datepicker();

}
endif;


if( !function_exists('ci_enqueue_admin_theme_scripts') ):
add_action('admin_enqueue_scripts','ci_enqueue_admin_theme_scripts');
function ci_enqueue_admin_theme_scripts() 
{
	global $pagenow;

	//
	// Enqueue here scripts that are to be loaded on all admin pages.
	//

	if(is_admin() and $pagenow=='themes.php' and isset($_GET['page']) and $_GET['page']=='ci_panel.php')
	{
		//
		// Enqueue here scripts that are to be loaded only on CSSIgniter Settings panel.
		//

		wp_enqueue_script('ci-select2-scripts');
	}

	if ( in_array( $pagenow, array( 'widgets.php', 'customize.php' ) ) ) {
		wp_enqueue_script( 'ci-admin-widgets' );

		$params['no_posts_found'] = __('No posts found.', 'ci_theme');
		$params['ajaxurl'] = admin_url( 'admin-ajax.php' );

		wp_localize_script('ci-admin-widgets', 'ThemeWidget', $params);
	}
}
endif;

?>
