<?php global $ci, $ci_defaults, $load_defaults, $content_width; ?>
<?php if ($load_defaults===TRUE): ?>
<?php
	add_filter('ci_panel_tabs', 'ci_add_tab_weather_options', 75);
	if( !function_exists('ci_add_tab_weather_options') ):
		function ci_add_tab_weather_options($tabs)
		{ 
			$tabs[sanitize_key(basename(__FILE__, '.php'))] = __('Weather Options', 'ci_theme');
			return $tabs; 
		}
	endif;

	// Default values for options go here.
	// $ci_defaults['option_name'] = 'default_value';
	// or
	// load_panel_snippet( 'snippet_name' );

	$ci_defaults['yahoo_weather_api_key']    = '';
	$ci_defaults['yahoo_weather_api_secret'] = '';
	$ci_defaults['weather_woeid']            = '957831';
	$ci_defaults['weather_unit']             = 'c';

?>
<?php else: ?>
		
	<fieldset class="set">
		<legend><?php _e( 'Weather Settings', 'ci_theme' ); ?></legend>

		<p class="guide"><?php echo wp_kses( sprintf( __( 'In order to show the current weather conditions on your site, you need an API key/secret from Yahoo! You can obtain a free API key/secret by visiting the <a href="%s" target="_blank">Yahoo! Developer Network</a>. Make sure to <strong>Create an App</strong>, enter an <strong>Application Name</strong> and set the <strong>Application Type</strong> to <strong>Web Application</strong>.', 'ci_theme' ), 'https://developer.yahoo.com/apps/create' ), ci_theme_get_allowed_tags( 'guide' ) ); ?></p>
		<fieldset class="mt10">
			<?php
				ci_panel_input( 'yahoo_weather_api_key', __( 'Yahoo Weather API Key', 'ci_theme' ) );
				ci_panel_input( 'yahoo_weather_api_secret', __( 'Yahoo Weather API Secret', 'ci_theme' ), array( 'input_type' => 'password' ) );
			?>
		</fieldset>

		<p class="guide"><?php echo sprintf( __( 'You can display the weather temperature for your location. Leaving the weather code empty, disables the weather display in the front end. Use the following box to search for your location. If the search didn\'t work for you, <a href="%s" target="_blank">go to this website</a>, enter your location and press search. Copy and paste in the <strong>Weather Code</strong> field. For example for Grenoble, France the code is <strong>593720</strong>.', 'ci_theme' ), 'http://woeid.rosselliot.co.nz' ); ?></p>
		<fieldset class="mb10">
			<label for="ci-select2-weather-city-lookup"><?php _e( 'City lookup:', 'ci_theme' ); ?></label>
			<select id="ci-select2-weather-city-lookup" class="ci-select2-weather-city-lookup">
				<option><?php _e( 'Type a place to search...', 'ci_theme' ); ?></option>
			</select>
		</fieldset>
		<?php ci_panel_input( 'weather_woeid', __( 'Weather Code', 'ci_theme' ) ); ?>
		<?php
			$weather_unit_options = array(
				'c' => __( 'Celsius', 'ci_theme' ),
				'f' => __( 'Fahrenheit', 'ci_theme' )
			);
			ci_panel_dropdown( 'weather_unit', $weather_unit_options, __( 'Temperature Unit.', 'ci_theme' ) );
		?>
	</fieldset>

<?php endif; ?>