<?php
if ( ! class_exists( 'CI_Newsletter' ) ):
class CI_Newsletter extends WP_Widget {

	function __construct() {
		$widget_ops  = array( 'description' => __( 'Displays a Newsletter form for your users to register.', 'ci_theme' ) );
		$control_ops = array(/*'width' => 300, 'height' => 400*/ );
		parent::__construct( 'ci_newsletter_widget', $name = __( '-= CI Newsletter =-', 'ci_theme' ), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		$button      = ci_get_string_translation( 'Newsletter - Button', $instance['button'], 'Widgets' );
		$description = ci_get_string_translation( 'Newsletter - Description', $instance['description'], 'Widgets' );

		if ( ci_setting( 'newsletter_action' ) != '' ):
			?>
			<div class="widget ci-newsletter bg bs">
				<?php
						if ( ! empty( $title ) ) {
							echo $before_title . $title . $after_title;
						}
					?>
				<?php if ( ! empty( $description ) ): ?>
					<?php echo wpautop( $description ); ?>
				<?php endif; ?>

				<form class="ci-newsletter" action="<?php ci_e_setting( 'newsletter_action' ); ?>">
					<p>
						<input type="email" id="<?php ci_e_setting( 'newsletter_email_id' ); ?>"
						       name="<?php ci_e_setting( 'newsletter_email_name' ); ?>"
						       placeholder="<?php echo esc_attr( __( 'Your Email', 'ci_theme' ) ); ?>">
						<button type="submit"><i class="fa fa-chevron-right"></i> <?php echo $button; ?></button>
					</p>
					<?php echo ci_newsletter_hidden_fields(); ?>
				</form>
			</div>
		<?php
		endif;

	} // widget

	function update( $new_instance, $old_instance ) {
		$instance                = $old_instance;
		$instance['title']       = sanitize_text_field( $new_instance['title'] );
		$instance['button']      = sanitize_text_field( $new_instance['button'] );
		$instance['description'] = wp_kses( $new_instance['description'], wp_kses_allowed_html( 'post' ) );

		ci_register_string_translation( 'Newsletter - Description', $instance['description'], 'Widgets' );
		ci_register_string_translation( 'Newsletter - Button', $instance['button'], 'Widgets' );

		return $instance;
	} // save

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array(
			'title'       => '',
			'description' => '',
			'button'      => __( 'Subscribe', 'ci_theme' )
		) );
		extract( $instance );

		if ( ci_setting( 'newsletter_action' ) == '' ) {
			?>
			<p><?php _e( 'It seems you have not entered an Action URL for the newsletter form. This can be done from the Theme Options. The newsletter form will not appear while the Action URL is empty.', 'ci_theme' ); ?></p><?php
		}
		?>
		<p><?php _e( "This widget will display a newsletter form. You can configure your newsletter options in the theme settings under the Appearance menu.", 'ci_theme' ); ?></p>
		<p><label><?php _e( 'Title:', 'ci_theme' ); ?></label><input id="<?php echo $this->get_field_id( 'title' ); ?>"
		                                                             name="<?php echo $this->get_field_name( 'title' ); ?>"
		                                                             type="text"
		                                                             value="<?php echo esc_attr( $title ); ?>"
		                                                             class="widefat"/></p>
		<p>
			<label><?php _e( 'Description:', 'ci_theme' ); ?></label>
			<textarea
				id="<?php echo $this->get_field_id( 'description' ); ?>"
				name="<?php echo $this->get_field_name( 'description' ); ?>"
				class="widefat"><?php echo esc_textarea( $description ); ?>
			</textarea>
		</p>
		<p>
			<label><?php _e( 'Button text:', 'ci_theme' ); ?></label>
			<input
				id="<?php echo $this->get_field_id( 'button' ); ?>" name="<?php echo $this->get_field_name( 'button' ); ?>"
				type="text" value="<?php echo esc_attr( $button ); ?>" class="widefat"/>
		</p>
	<?php
	} // form

} // class

register_widget( 'CI_Newsletter' );

endif;