jQuery( document ).ready( function( $ ) {
	"use strict";

	if ( s2param.woeid_search_api == true ) {
		var s_url = s2param.ajaxurl;
		var s_data = function( params ) {
			return {
				action: 'ci_theme_search_yahoo_woeid',
				woeid_search_nonce: s2param.woeid_search_nonce,
				q     : params.term,
				format: 'json',
			};
		};
	} else {
		var s_url = 'http://query.yahooapis.com/v1/public/yql';
		var s_data = function( params ) {
			return {
				q     : 'select * from geo.places(10) where text ="' + params.term + '"', // search term
				format: 'json',
				_nocache: Math.floor( ( new Date().getTime() ) / 1200 / 1000 )
			};
		};
	}

	// Panel weather lookup.
	var woeid_lookup = $( ".ci-select2-weather-city-lookup" );
	woeid_lookup.select2( {
		width             : '100%',
		ajax              : {
			url           : s_url,
			dataType      : 'json',
			delay         : 250,
			data          : s_data,
			processResults: function( data, page ) {
				// parse the results into the format expected by Select2.
				// since we are using custom formatting functions we do not need to
				// alter the remote JSON data
				var $results = [];
				var remote_results;

				if( data.query.count != undefined ) {
					if( data.query.count == 1 ) {
						remote_results = data.query.results;
					} else if(data.query.count > 1) {
						remote_results = data.query.results.place;
					}
					$.each(remote_results, function(key, val){
						var $text = val.name;
						if( typeof val.admin1 == 'object' && val.admin1 !== null ) {
							$text = $text + ', ' + val.admin1.content;
						}
						if( typeof val.admin2 == 'object' && val.admin2 !== null ) {
							$text = $text + ', ' + val.admin2.content;
						}
						if( typeof val.admin3 == 'object' && val.admin3 !== null ) {
							$text = $text + ', ' + val.admin3.content;
						}
						$results.push( {
							id: val.woeid, text: $text
						} );
					});

				}

				return {
					results: $results
				};
			},
			cache         : true
		}, escapeMarkup   : function( markup ) {
			return markup;
		},
		minimumInputLength: 3,
	} );

	woeid_lookup.on( 'change', function( e ) {
		$('#weather_woeid').val($(this).val());
	} );


});
