<?php
/*
* Template Name: Rooms Listing
*/
?>

<?php get_header(); ?>

<?php while ( have_posts() ) : the_post(); ?>
	<?php $post = get_post(); ?>
	<main class="main">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<?php if ( ! empty( $post->post_content ) ) : ?>
						<article id="post-<?php the_ID(); ?>" <?php post_class( 'entry' ); ?>>
							<div class="entry-content">
								<?php the_content(); ?>
							</div>
						</article>
					<?php endif; ?>

					<?php
						$cpt_taxonomy   = 'room_category';
						$base_category  = get_post_meta( get_the_ID(), 'base_room_category', true );
						$columns        = get_post_meta( get_the_ID(), 'room_listing_columns', true );
						$show_offers    = get_post_meta( get_the_ID(), 'room_listing_filter', true );
						$posts_per_page = get_post_meta( get_the_ID(), 'room_listing_posts_per_page', true );
						$isotope        = get_post_meta( get_the_ID(), 'room_listing_isotope', true );
						$column_classes = ci_theme_get_columns_classes( $columns );

						$args = array(
							'post_type' => 'cpt_room',
							'paged'     => ci_get_page_var()
						);

						if ( $posts_per_page >= 1 ) {
							$args['posts_per_page'] = $posts_per_page;
						} elseif ( $posts_per_page <= -1 ) {
							$args['posts_per_page'] = -1;
						} else {
							$args['posts_per_page'] = get_option('posts_per_page');
						}

						if ( ! empty( $base_category ) and $base_category >= 1 ) {
							$args['tax_query'] = array(
								array(
									'taxonomy'         => $cpt_taxonomy,
									'field'            => 'term_id',
									'terms'            => intval( $base_category ),
									'include_children' => true
								)
							);
						}


						if ( 'only_offers' == $show_offers ) {
							$args['meta_query'] = array(
								array(
									'key'   => 'on_offer',
									'value' => '1',
								)
							);
						} elseif ( 'no_offers' == $show_offers ) {
							$args['meta_query'] = array(
								array(
									'key'     => 'on_offer',
									'value'   => '1',
									'compare' => '!=',
								)
							);
						}

						$div_class = '';
						if( 1 == $isotope ) {
							$div_class = 'listing-isotope';
							$args['posts_per_page'] = - 1;
						}

						$q = new WP_Query( $args );
					?>

					<?php if ( 1 == $isotope ): ?>
						<?php $cats = get_terms( $cpt_taxonomy, array(
							'hide_empty' => 1,
							'child_of'   => intval( $base_category ),
						) ); ?>
						<?php if( ! empty( $cats ) ): ?>
							<ul class="filters-nav">
								<li><a href="#filter" class="selected" data-filter="*"><?php _ex( 'All', 'all items', 'ci_theme' ); ?></a></li>
								<?php foreach ( $cats as $cat ): ?>
									<li><a href="#filter" data-filter=".<?php echo esc_attr( $cat->slug ); ?>"><?php echo esc_html( $cat->name ); ?></a></li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
					<?php endif; ?>

					<?php if ( $q->have_posts() ) : ?>
						<div class="row row-joined item-list <?php echo esc_attr( $div_class ); ?>">
							<?php while ( $q->have_posts() ) : $q->the_post(); ?>
								<?php $terms = implode( ' ', wp_list_pluck( wp_get_object_terms( get_the_ID(), $cpt_taxonomy ), 'slug' ) ); ?>
								<div class="<?php echo esc_attr( $column_classes ); ?> <?php echo esc_attr( $terms ); ?>">
									<?php get_template_part( 'item', get_post_type() ); ?>
								</div>
							<?php endwhile; ?>
						</div>
					<?php endif; wp_reset_postdata(); ?>

					<?php ci_pagination( array(
						'container_class' => 'centered'
					), $q ); ?>
				</div>
			</div>
		</div>
	</main>
<?php endwhile; ?>

<?php get_footer(); ?>
