<?php
/*
* Template Name: Services Listing
*/
?>

<?php get_header(); ?>

<?php while ( have_posts() ) : the_post(); ?>
	<?php $post = get_post(); ?>
	<main class="main">
		<div class="container">
			<div class="row">
				<div class="col-md-8 col-sm-7">
					<?php if ( ! empty( $post->post_content ) ) : ?>
						<article id="post-<?php the_ID(); ?>" <?php post_class( 'entry' ); ?>>
							<div class="entry-content">
								<?php the_content(); ?>
							</div>
						</article>
					<?php endif; ?>

					<?php
						$base_category  = get_post_meta( get_the_ID(), 'base_service_category', true );
						$posts_per_page = get_post_meta( get_the_ID(), 'service_listing_posts_per_page', true );

						$args = array(
							'post_type' => 'cpt_service',
							'paged'     => ci_get_page_var()
						);

						if ( $posts_per_page >= 1 ) {
							$args['posts_per_page'] = $posts_per_page;
						} elseif ( $posts_per_page <= -1 ) {
							$args['posts_per_page'] = -1;
						} else {
							$args['posts_per_page'] = get_option('posts_per_page');
						}

						if ( ! empty( $base_category ) and $base_category >= 1 ) {
							$args['tax_query'] = array(
								array(
									'taxonomy'         => 'service_category',
									'field'            => 'term_id',
									'terms'            => intval( $base_category ),
									'include_children' => true
								)
							);
						}

						$q = new WP_Query( $args );
					?>

					<?php if ( $q->have_posts() ) : ?>
						<div class="item-list">
							<?php while ( $q->have_posts() ) : $q->the_post(); ?>
								<div id="<?php echo get_post_type(); ?>-<?php the_ID(); ?>" <?php post_class( 'item item-media' ); ?>>
									<figure class="item-thumb">
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail( 'ci_square' ); ?>
										</a>
									</figure>

									<div class="item-content">
										<p class="item-title"><?php the_title(); ?></p>
										<?php the_excerpt(); ?>
										<?php ci_read_more(); ?>
									</div>
								</div>
							<?php endwhile; ?>
						</div>
					<?php endif; wp_reset_postdata(); ?>

					<?php ci_pagination( array(), $q ); ?>
				</div>

				<div class="col-md-4 col-sm-5">
					<?php get_sidebar(); ?>
				</div>
			</div>
		</div>
	</main>
<?php endwhile; ?>

<?php get_footer(); ?>
