<?php
	get_template_part('panel/constants');

	load_theme_textdomain( 'ci_theme', get_template_directory() . '/lang' );

	// This is the main options array. Can be accessed as a global in order to reduce function calls.
	$ci = get_option(THEME_OPTIONS);
	$ci_defaults = array();

	// The $content_width needs to be before the inclusion of the rest of the files, as it is used inside of some of them.
	if ( ! isset( $content_width ) ) $content_width = 750;

	//
	// Let's bootstrap the theme.
	//
	get_template_part('panel/bootstrap');

	//
	// Use HTML5 on galleries
	//
	add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );

	//
	// Define our various image sizes.
	// Notice: Changing the values below requires running a thumbnail regeneration
	// plugin such as "Regenerate Thumbnails" (http://wordpress.org/plugins/regenerate-thumbnails/)
	// in order for the new dimensions to take effect.
	//
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 750, 400, true );
	add_image_size( 'ci_square', 750, 750, true );
	add_image_size( 'ci_gallery', 750, 460, true );
	add_image_size( 'ci_room_slider', 1140, 660, true );
	add_image_size( 'ci_full_width', 1140, 430, true );
	add_image_size( 'ci_full_page', 1920, 980, true );
	add_image_size( 'ci_header', 1920, 310, true );


	function ci_theme_header_image() {
		global $post;

		$output = '';

		$rule  = "background-color: %s; ";
		$color = ci_sanitize_hex_color( ci_setting( 'default_header_color' ) );
		if ( ! empty( $color ) ) {
			$output .= sprintf( $rule, $color );
		}

		$rule    = "background-image: url('%s');";
		$custom  = false;
		$default = esc_url_raw( ci_setting( 'default_header_bg' ) );

		if ( is_singular() ) {
			$custom = esc_url_raw( get_post_meta( $post->ID, 'header_image', true ) );
		}

		if ( !empty( $custom ) ) {
			$output .= sprintf( $rule, $custom );
		} elseif ( !empty( $default ) ) {
			$output .= sprintf( $rule, $default );
		}

		return $output;
	}

	function ci_add_cpt_header_bg_meta_box( $post ) {
		ci_prepare_metabox( get_post_type( $post ) );

		$image_sizes = ci_get_image_sizes();
		$size = $image_sizes['ci_header']['width'] . 'x' . $image_sizes['ci_header']['height'];

		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				ci_metabox_guide( array(
					__( 'You can replace the default header image if you want, by uploading and / or selecting an already uploaded image. This applies to the current page only.', 'ci_theme' ),
					sprintf( __( 'For best results, use a high resolution image, at least %s pixels in size. Make sure you select the desired image size before pressing <em>Use this file</em>.', 'ci_theme' ), $size ),
				), array( 'type' => 'ul' ) );

				?>
				<p>
					<?php
						ci_metabox_input( 'header_image', '', array(
							'input_type'  => 'hidden',
							'esc_func'    => 'esc_url',
							'input_class' => 'uploaded',
							'before'      => '',
							'after'       => ''
						) );

						ci_metabox_input( 'header_image_id', '', array(
							'input_type'  => 'hidden',
							'input_class' => 'uploaded-id',
							'before'      => '',
							'after'       => ''
						) );
					?>
					<span class="selected_image" style="display: block;">
						<?php
							$image_url = ci_get_image_src( get_post_meta( $post->ID, 'header_image_id', true ), 'thumbnail' );
							if( !empty( $image_url ) ) {
								echo sprintf( '<img src="%s" /><a href="#" class="close media-modal-icon"></a>', $image_url );
							}
						?>
					</span>
					<a href="#" class="button ci-upload"><?php _e( 'Upload / Select Image', 'ci_theme' ); ?></a>
				</p>
				<?php

			ci_metabox_close_tab();
		?></div><?php
	}

	add_action( 'wp_ajax_ci_theme_widget_get_selected_image_preview', 'ci_theme_widget_get_selected_image_preview' );
	function ci_theme_widget_get_selected_image_preview() {
		$image_id   = intval( $_POST['image_id'] );
		$image_size = 'thumbnail';

		if ( ! empty( $image_id ) ) {
			$image_url = ci_get_image_src( $image_id, $image_size );
			if ( ! empty( $image_url ) ) {
				echo sprintf( '<img src="%s" /><a href="#" class="close media-modal-icon"></a>', $image_url );
			}
		}
		die;
	}

	function ci_theme_get_fullwidth_sidebars() {
		return array(
			'home',
			'bottom-widgets',
			'footer'
		);
	}

	function ci_theme_get_columns_classes( $columns ) {
		switch ( $columns ) {
			case 1:
				$classes = 'col-xs-12';
				break;
			case 2:
				$classes = 'col-xs-12 col-sm-6';
				break;
			case 4:
				$classes = 'col-xs-12 col-sm-6 col-md-3';
				break;
			case 3:
			default:
				$classes = 'col-xs-12 col-sm-6 col-md-4';
				break;
		}

		return $classes;
	}

	function ci_theme_get_slides( $base_category = false, $post_id = false, $return_ids = false ) {

		if ( $base_category === false && $post_id === false && get_option( 'show_on_front' ) == 'page' ) {
			$front = get_option( 'page_on_front' );
			if ( ! empty( $front ) ) {
				$base = get_post_meta( $front, 'base_slider_category', true );
				if ( ! empty( $base ) ) {
					$base_category = $base;
				}
			}
		} elseif ( $base_category === false && $post_id !== false ) {
			$base = get_post_meta( $post_id, 'base_slider_category', true );
			if ( ! empty( $base ) ) {
				$base_category = $base;
			}
		}

		$args = array(
			'post_type'      => 'cpt_slider',
			'posts_per_page' => - 1,
		);

		if ( ! empty( $base_category ) && $base_category > 0 ) {
			$args = array_merge( $args, array(
				'tax_query' => array(
					array(
						'taxonomy' => 'slider_category',
						'terms'    => intval( $base_category ),
					)
				)
			) );
		}

		if ( $return_ids === true ) {
			$args['fields'] = 'ids';
		}

		return new WP_Query( $args );
	}

	function ci_theme_sanitize_checkbox( &$input ) {
		if ( $input == 1 ) {
			return 1;
		}

		return '';
	}


	// Add custom style in WP Editor
	add_action( 'admin_init', 'ci_add_editor_styles' );
	if ( ! function_exists( 'ci_add_editor_styles' ) ) {
		function ci_add_editor_styles() {
			add_editor_style( 'css/admin/editor.css' );
		}
	}

	add_filter( 'mce_buttons_2', 'ci_mce_buttons_2' );
	if ( ! function_exists( 'ci_mce_buttons_2' ) ) {
		function ci_mce_buttons_2( $buttons ) {
			array_unshift( $buttons, 'styleselect' );

			return $buttons;
		}
	}

	add_filter( 'tiny_mce_before_init', 'ci_insert_wp_editor_formats' );
	if ( ! function_exists( 'ci_insert_wp_editor_formats' ) ) {
		function ci_insert_wp_editor_formats( $init_array ) {
			// Define the style_formats array
			$style_formats = array(
				// Each array child is a format with it's own settings
				array(
					'title'   => 'Hero Text',
					'block'   => 'div',
					'classes' => 'text-primary',
					'wrapper' => true,
				)
			);
			// Insert the array, JSON ENCODED, into 'style_formats'
			$init_array['style_formats'] = json_encode( $style_formats );

			return $init_array;

		}
	}
