<?php
	//
	// Attraction Post Type related functions.
	//
	add_action( 'init', 'ci_create_cpt_attraction' );
	add_action( 'admin_init', 'ci_add_cpt_attraction_meta' );
	add_action( 'save_post', 'ci_update_cpt_attraction_meta' );

	function ci_create_cpt_attraction() {
		$labels = array(
			'name'               => _x( 'Attractions', 'post type general name', 'ci_theme' ),
			'singular_name'      => _x( 'Attraction', 'post type singular name', 'ci_theme' ),
			'add_new'            => __( 'Add New', 'ci_theme' ),
			'add_new_item'       => __( 'Add New Attraction', 'ci_theme' ),
			'edit_item'          => __( 'Edit Attraction', 'ci_theme' ),
			'new_item'           => __( 'New Attraction', 'ci_theme' ),
			'view_item'          => __( 'View Attraction', 'ci_theme' ),
			'search_items'       => __( 'Search Attractions', 'ci_theme' ),
			'not_found'          => __( 'No Attractions found', 'ci_theme' ),
			'not_found_in_trash' => __( 'No Attractions found in the trash', 'ci_theme' ),
			'parent_item_colon'  => __( 'Parent Attraction:', 'ci_theme' )
		);

		$args = array(
			'labels'          => $labels,
			'singular_label'  => __( 'Attraction', 'ci_theme' ),
			'public'          => true,
			'show_ui'         => true,
			'capability_type' => 'post',
			'hierarchical'    => false,
			'has_archive'     => false,
			'rewrite'         => array( 'slug' => _x( 'attraction', 'post type slug', 'ci_theme' ) ),
			'menu_position'   => 5,
			'supports'        => array( 'title', 'editor', 'thumbnail' ),
			'menu_icon'       => 'dashicons-visibility'
		);

		register_post_type( 'cpt_attraction' , $args );

	}

	function ci_add_cpt_attraction_meta() {
		add_meta_box( 'ci-attraction-box', __( 'Attraction Details', 'ci_theme' ), 'ci_cpt_attraction_meta_box', 'cpt_attraction', 'normal', 'high' );
		add_meta_box( 'ci-header-bg-box', __( 'Header background', 'ci_theme' ), 'ci_add_cpt_header_bg_meta_box', 'cpt_attraction', 'normal', 'high' );
	}

	function ci_update_cpt_attraction_meta( $post_id ) {
		if ( ! ci_can_save_meta( 'cpt_attraction' ) ) return;

		update_post_meta( $post_id, 'header_image', esc_url_raw( $_POST['header_image'] ) );

		ci_metabox_gallery_save( $_POST );
	}

	function ci_cpt_attraction_meta_box( $object, $box ) {
		ci_prepare_metabox( 'cpt_attraction' );

		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( __( 'Gallery', 'ci_theme' ) );
				ci_metabox_guide( __( "You can create a gallery by pressing the <em>Add Images</em> button below. You should also set a featured image that will be used as this Attraction's cover.", 'ci_theme' ) );
				ci_metabox_gallery();
			ci_metabox_close_tab();
		?></div><?php

	}

