<?php
	//
	// Page Post Type related functions.
	//
	add_action( 'admin_init', 'ci_add_page_meta' );
	add_action( 'save_post', 'ci_update_page_meta' );


	function ci_add_page_meta() {
		add_meta_box( 'ci-page-room-listing-box', __( 'Room Listing Options', 'ci_theme' ), 'ci_add_page_room_listing_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'ci-page-gallery-listing-box', __( 'Gallery Listing Options', 'ci_theme' ), 'ci_add_page_gallery_listing_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'ci-page-attraction-listing-box', __( 'Attraction Listing Options', 'ci_theme' ), 'ci_add_page_attraction_listing_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'ci-page-service-listing-box', __( 'Service Listing Options', 'ci_theme' ), 'ci_add_page_service_listing_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'ci-page-video-listing-box', __( 'Video Listing Options', 'ci_theme' ), 'ci_add_page_video_listing_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'ci-page-location-box', __( 'Location Options', 'ci_theme' ), 'ci_add_page_location_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'ci-page-homepage-box', __( 'Homepage Options', 'ci_theme' ), 'ci_add_page_homepage_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'ci-header-bg-box', __( 'Header background', 'ci_theme' ), 'ci_add_cpt_header_bg_meta_box', 'page', 'normal', 'high' );
	}

	function ci_update_page_meta( $post_id ) {

		if ( ! ci_can_save_meta( 'page' ) ) return;

		update_post_meta( $post_id, 'header_image', esc_url_raw( $_POST['header_image'] ) );
		update_post_meta( $post_id, 'header_image_id', intval( $_POST['header_image_id'] ) );

		update_post_meta( $post_id, 'base_room_category', intval( $_POST['base_room_category'] ) );
		update_post_meta( $post_id, 'room_listing_columns', intval( $_POST['room_listing_columns'] ) );
		update_post_meta( $post_id, 'room_listing_filter', in_array( $_POST['room_listing_filter'], array( 'only_offers', 'no_offers' ) ) ? $_POST['room_listing_filter'] : '' );
		update_post_meta( $post_id, 'room_listing_posts_per_page', intval( $_POST['room_listing_posts_per_page'] ) );
		update_post_meta( $post_id, 'room_listing_isotope', ci_theme_sanitize_checkbox( $_POST['room_listing_isotope'] ) );

		update_post_meta( $post_id, 'base_gallery_category', intval( $_POST['base_gallery_category'] ) );
		update_post_meta( $post_id, 'gallery_listing_columns', intval( $_POST['gallery_listing_columns'] ) );
		update_post_meta( $post_id, 'gallery_listing_posts_per_page', intval( $_POST['gallery_listing_posts_per_page'] ) );
		update_post_meta( $post_id, 'gallery_listing_isotope', ci_theme_sanitize_checkbox( $_POST['gallery_listing_isotope'] ) );

		update_post_meta( $post_id, 'base_attraction_category', intval( $_POST['base_attraction_category'] ) );
		update_post_meta( $post_id, 'attraction_listing_columns', intval( $_POST['attraction_listing_columns'] ) );
		update_post_meta( $post_id, 'attraction_listing_posts_per_page', intval( $_POST['attraction_listing_posts_per_page'] ) );
		update_post_meta( $post_id, 'attraction_listing_isotope', ci_theme_sanitize_checkbox( $_POST['attraction_listing_isotope'] ) );

		update_post_meta( $post_id, 'base_video_category', intval( $_POST['base_video_category'] ) );
		update_post_meta( $post_id, 'video_listing_columns', intval( $_POST['video_listing_columns'] ) );
		update_post_meta( $post_id, 'video_listing_posts_per_page', intval( $_POST['video_listing_posts_per_page'] ) );
		update_post_meta( $post_id, 'video_listing_isotope', ci_theme_sanitize_checkbox( $_POST['video_listing_isotope'] ) );

		update_post_meta( $post_id, 'base_service_category', intval( $_POST['base_service_category'] ) );
		update_post_meta( $post_id, 'service_listing_posts_per_page', intval( $_POST['service_listing_posts_per_page'] ) );

		update_post_meta( $post_id, 'location_map_lon', sanitize_text_field( $_POST['location_map_lon'] ) );
		update_post_meta( $post_id, 'location_map_lat', sanitize_text_field( $_POST['location_map_lat'] ) );
		update_post_meta( $post_id, 'location_map_zoom', intval( $_POST['location_map_zoom'] ) );
		update_post_meta( $post_id, 'location_map_title', sanitize_text_field( $_POST['location_map_title'] ) );
		update_post_meta( $post_id, 'location_map_tooltip', wp_kses_post( $_POST['location_map_tooltip'] ) );

		update_post_meta( $post_id, 'base_slider_category', intval( $_POST['base_slider_category'] ) );
	}

	function ci_add_page_room_listing_meta_box( $object, $box ) {
		ci_prepare_metabox( 'page' );


		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				$category = get_post_meta( $object->ID, 'base_room_category', true );

				ci_metabox_guide( __( "Select a base category. Only items from the selected category and sub-categories will be displayed. If you don't select one (i.e. empty) all items will be shown.", 'ci_theme' ) );
				wp_dropdown_categories( array(
					'selected'          => $category,
					'name'              => 'base_room_category',
					'show_option_none'  => ' ',
					'option_none_value' => 0,
					'taxonomy'          => 'room_category',
					'hierarchical'      => 1,
					'show_count'        => 1,
					'hide_empty'        => 0
				) );

				$options = array();
				for ( $i = 2; $i <= 4; $i ++ ) {
					$options[ $i ] = sprintf( _n( '1 Column', '%s Columns', $i, 'ci_theme' ), $i );
				}
				ci_metabox_dropdown( 'room_listing_columns', $options, __( 'Number of columns to display the items in:', 'ci_theme' ), array( 'default' => 3 ) );

				$options = array(
					''            => __( 'All rooms', 'ci_theme' ),
					'only_offers' => __( 'Only rooms on offer', 'ci_theme' ),
					'no_offers'   => __( 'Only rooms not on offer', 'ci_theme' ),
				);
				ci_metabox_dropdown( 'room_listing_filter', $options, __( 'Room filter:', 'ci_theme' ) );

				ci_metabox_guide( sprintf( __( 'Set the number of items per page that you want to display. Setting this to <strong>-1</strong> will show <em>all items</em>, while setting it to zero or leaving it empty, will follow the global option set from <em>Settings -> Reading</em>, currently set to <strong>%s items per page</strong>.', 'ci_theme' ), get_option( 'posts_per_page' ) ) );
				ci_metabox_input( 'room_listing_posts_per_page', __( 'Items per page:', 'ci_theme' ) );
				ci_metabox_checkbox( 'room_listing_isotope', 1, __( 'Isotope effect (ignores <em>Items per page</em> setting).', 'ci_theme' ) );
			ci_metabox_close_tab();
		?></div><?php

		ci_bind_metabox_to_page_template( 'ci-page-room-listing-box', 'template-listing-cpt_room.php', 'tpl_rooms_listing' );
	}

	function ci_add_page_gallery_listing_meta_box( $object, $box ) {
		ci_prepare_metabox( 'page' );


		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				$category = get_post_meta( $object->ID, 'base_gallery_category', true );

				ci_metabox_guide( __( "Select a base category. Only items from the selected category and sub-categories will be displayed. If you don't select one (i.e. empty) all items will be shown.", 'ci_theme' ) );
				wp_dropdown_categories( array(
					'selected'          => $category,
					'name'              => 'base_gallery_category',
					'show_option_none'  => ' ',
					'option_none_value' => 0,
					'taxonomy'          => 'gallery_category',
					'hierarchical'      => 1,
					'show_count'        => 1,
					'hide_empty'        => 0
				) );

				$options = array();
				for ( $i = 2; $i <= 4; $i ++ ) {
					$options[ $i ] = sprintf( _n( '1 Column', '%s Columns', $i, 'ci_theme' ), $i );
				}
				ci_metabox_dropdown( 'gallery_listing_columns', $options, __( 'Number of columns to display the items in:', 'ci_theme' ), array( 'default' => 3 ) );

				ci_metabox_guide( sprintf( __( 'Set the number of items per page that you want to display. Setting this to <strong>-1</strong> will show <em>all items</em>, while setting it to zero or leaving it empty, will follow the global option set from <em>Settings -> Reading</em>, currently set to <strong>%s items per page</strong>.', 'ci_theme' ), get_option( 'posts_per_page' ) ) );
				ci_metabox_input( 'gallery_listing_posts_per_page', __( 'Items per page:', 'ci_theme' ) );
				ci_metabox_checkbox( 'gallery_listing_isotope', 1, __( 'Isotope effect (ignores <em>Items per page</em> setting).', 'ci_theme' ) );
			ci_metabox_close_tab();
		?></div><?php

		ci_bind_metabox_to_page_template( 'ci-page-gallery-listing-box', 'template-listing-cpt_gallery.php', 'tpl_galleries_listing' );
	}

	function ci_add_page_attraction_listing_meta_box( $object, $box ) {
		ci_prepare_metabox( 'page' );


		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				$category = get_post_meta( $object->ID, 'base_attraction_category', true );

				ci_metabox_guide( __( "Select a base category. Only items from the selected category and sub-categories will be displayed. If you don't select one (i.e. empty) all items will be shown.", 'ci_theme' ) );
				wp_dropdown_categories( array(
					'selected'          => $category,
					'name'              => 'base_attraction_category',
					'show_option_none'  => ' ',
					'option_none_value' => 0,
					'taxonomy'          => 'attraction_category',
					'hierarchical'      => 1,
					'show_count'        => 1,
					'hide_empty'        => 0
				) );

				$options = array();
				for ( $i = 2; $i <= 4; $i ++ ) {
					$options[ $i ] = sprintf( _n( '1 Column', '%s Columns', $i, 'ci_theme' ), $i );
				}
				ci_metabox_dropdown( 'attraction_listing_columns', $options, __( 'Number of columns to display the items in:', 'ci_theme' ), array( 'default' => 3 ) );

				ci_metabox_guide( sprintf( __( 'Set the number of items per page that you want to display. Setting this to <strong>-1</strong> will show <em>all items</em>, while setting it to zero or leaving it empty, will follow the global option set from <em>Settings -> Reading</em>, currently set to <strong>%s items per page</strong>.', 'ci_theme' ), get_option( 'posts_per_page' ) ) );
				ci_metabox_input( 'attraction_listing_posts_per_page', __( 'Items per page:', 'ci_theme' ) );
				ci_metabox_checkbox( 'attraction_listing_isotope', 1, __( 'Isotope effect (ignores <em>Items per page</em> setting).', 'ci_theme' ) );
			ci_metabox_close_tab();
		?></div><?php

		ci_bind_metabox_to_page_template( 'ci-page-attraction-listing-box', 'template-listing-cpt_attraction.php', 'tpl_attractions_listing' );
	}

	function ci_add_page_video_listing_meta_box( $object, $box ) {
		ci_prepare_metabox( 'page' );

		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				$category = get_post_meta( $object->ID, 'base_video_category', true );

				ci_metabox_guide( __( "Select a base category. Only items from the selected category and sub-categories will be displayed. If you don't select one (i.e. empty) all items will be shown.", 'ci_theme' ) );
				wp_dropdown_categories( array(
					'selected'          => $category,
					'name'              => 'base_video_category',
					'show_option_none'  => ' ',
					'option_none_value' => 0,
					'taxonomy'          => 'video_category',
					'hierarchical'      => 1,
					'show_count'        => 1,
					'hide_empty'        => 0
				) );

				$options = array();
				for ( $i = 2; $i <= 4; $i ++ ) {
					$options[ $i ] = sprintf( _n( '1 Column', '%s Columns', $i, 'ci_theme' ), $i );
				}
				ci_metabox_dropdown( 'video_listing_columns', $options, __( 'Number of columns to display the items in:', 'ci_theme' ), array( 'default' => 3 ) );

				ci_metabox_guide( sprintf( __( 'Set the number of items per page that you want to display. Setting this to <strong>-1</strong> will show <em>all items</em>, while setting it to zero or leaving it empty, will follow the global option set from <em>Settings -> Reading</em>, currently set to <strong>%s items per page</strong>.', 'ci_theme' ), get_option( 'posts_per_page' ) ) );
				ci_metabox_input( 'video_listing_posts_per_page', __( 'Items per page:', 'ci_theme' ) );
				ci_metabox_checkbox( 'video_listing_isotope', 1, __( 'Isotope effect (ignores <em>Items per page</em> setting).', 'ci_theme' ) );
			ci_metabox_close_tab();
		?></div><?php

		ci_bind_metabox_to_page_template( 'ci-page-video-listing-box', 'template-listing-cpt_video.php', 'tpl_videos_listing' );
	}


	function ci_add_page_service_listing_meta_box( $object, $box ) {
		ci_prepare_metabox('page');

		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				$category = get_post_meta( $object->ID, 'base_service_category', true );

				ci_metabox_guide( __( "Select a base category. Only items from the selected category and sub-categories will be displayed. If you don't select one (i.e. empty) all items will be shown.", 'ci_theme' ) );
				wp_dropdown_categories( array(
					'selected'          => $category,
					'name'              => 'base_service_category',
					'show_option_none'  => ' ',
					'option_none_value' => 0,
					'taxonomy'          => 'service_category',
					'hierarchical'      => 1,
					'show_count'        => 1,
					'hide_empty'        => 0
				) );

				ci_metabox_guide( sprintf( __( 'Set the number of items per page that you want to display. Setting this to <strong>-1</strong> will show <em>all items</em>, while setting it to zero or leaving it empty, will follow the global option set from <em>Settings -> Reading</em>, currently set to <strong>%s items per page</strong>.', 'ci_theme' ), get_option( 'posts_per_page' ) ) );
				ci_metabox_input( 'service_listing_posts_per_page', __( 'Items per page:', 'ci_theme' ) );
			ci_metabox_close_tab();
		?></div><?php

		ci_bind_metabox_to_page_template( 'ci-page-service-listing-box', 'template-listing-cpt_service.php', 'tpl_services_listing' );
	}

	function ci_add_page_location_meta_box( $object, $box ) {
		ci_prepare_metabox( 'page' );

		ci_metabox_guide( sprintf( __( 'In order to show a contact form in this page, you need to install, activate, and insert a form from one of the following plugins: <a href="%1$s" target="_blank">Contact Form 7</a>, <a href="%2$s" target="_blank">Jetpack</a>.', 'ci_theme' ), 'https://wordpress.org/plugins/contact-form-7/', 'https://wordpress.org/plugins/jetpack/' ) );

		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );

				ci_metabox_guide( __( 'Enter a place or address and press <em>Search place/address</em>. Alternatively, you can drag the marker to the desired position, or double click on the map to set a new location.', 'ci_theme' ) );

				?>
				<fieldset class="gllpLatlonPicker">
					<input type="text" class="gllpSearchField">
					<input type="button" class="button gllpSearchButton" value="<?php esc_attr_e( 'Search place/address', 'ci_theme' ); ?>" />
					<div class="gllpMap"><?php _e( 'Google Maps', 'ci_theme' ); ?></div>
					<?php
						ci_metabox_input( 'location_map_zoom', '', array(
							'input_type'  => 'hidden',
							'before'      => '',
							'after'       => '',
							'default'     => '8',
							'input_class' => 'gllpZoom',
						) );
						ci_metabox_input( 'location_map_lat', __( 'Location Latitude.', 'ci_theme' ), array(
							'input_class' => 'widefat gllpLatitude',
							'default'     => '36'
						) );
						ci_metabox_input( 'location_map_lon', __( 'Location Longitude.', 'ci_theme' ), array(
							'input_class' => 'widefat gllpLongitude',
							'default'     => '-120'
						) );
					?>
					<input type="button" class="button gllpUpdateButton" value="<?php esc_attr_e( 'Update map', 'ci_theme' ); ?>" />
				</fieldset>
				<?php

				ci_metabox_input( 'location_map_title', __( 'Map marker title:', 'ci_theme' ), array( 'default' => get_option( 'blogname' ) ) );
				ci_metabox_textarea( 'location_map_tooltip', __( 'Map marker tooltip text (accepts HTML):', 'ci_theme' ) );

			ci_metabox_close_tab();
		?></div><?php

		ci_bind_metabox_to_page_template( 'ci-page-location-box', 'template-location.php', 'tpl_location' );
	}

	function ci_add_page_homepage_meta_box( $object, $box ) {
		ci_prepare_metabox( 'page' );

		$category = get_post_meta( $object->ID, 'base_slider_category', true );

		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				ci_metabox_guide( __( "Select the base slideshow category. Only items of the selected category will be displayed. If you don't select one (i.e. empty) slides from all categories will be shown.", 'ci_theme' ) );
				?><p><label for="base_slider_category"><?php _e( 'Base category:', 'ci_theme' ); ?></label> <?php
				wp_dropdown_categories( array(
					'selected'          => $category,
					'id'                => 'base_slider_category',
					'name'              => 'base_slider_category',
					'show_option_none'  => ' ',
					'option_none_value' => 0,
					'taxonomy'          => 'slider_category',
					'hierarchical'      => 1,
					'show_count'        => 1,
					'hide_empty'        => 0
				) );
				?></p><?php
			ci_metabox_close_tab();
		?></div><?php

		ci_bind_metabox_to_page_template( 'ci-page-homepage-box', 'template-homepage.php', 'tpl_homepage' );
	}
