<?php
	//
	// Room Post Type related functions.
	//
	add_action( 'init', 'ci_create_cpt_room' );
	add_action( 'admin_init', 'ci_add_cpt_room_meta' );
	add_action( 'save_post', 'ci_update_cpt_room_meta' );

	function ci_create_cpt_room() {
		$labels = array(
			'name'               => _x( 'Rooms', 'post type general name', 'ci_theme' ),
			'singular_name'      => _x( 'Room', 'post type singular name', 'ci_theme' ),
			'add_new'            => __( 'New Room', 'ci_theme' ),
			'add_new_item'       => __( 'Add New Room', 'ci_theme' ),
			'edit_item'          => __( 'Edit Room', 'ci_theme' ),
			'new_item'           => __( 'New Room', 'ci_theme' ),
			'view_item'          => __( 'View Room', 'ci_theme' ),
			'search_items'       => __( 'Search Rooms', 'ci_theme' ),
			'not_found'          => __( 'No Rooms found', 'ci_theme' ),
			'not_found_in_trash' => __( 'No Rooms found in the trash', 'ci_theme' ),
			'parent_item_colon'  => __( 'Parent Room:', 'ci_theme' )
		);

		$args = array(
			'labels'          => $labels,
			'singular_label'  => __( 'Room', 'ci_theme' ),
			'public'          => true,
			'show_ui'         => true,
			'capability_type' => 'post',
			'hierarchical'    => false,
			'has_archive'     => false,
			'rewrite'         => array( 'slug' => _x( 'room', 'post type slug', 'ci_theme' ) ),
			'menu_position'   => 5,
			'supports'        => array( 'title', 'editor', 'thumbnail' ),
			'menu_icon'       => 'dashicons-admin-home',
		);

		register_post_type( 'cpt_room', $args );
	}

	function ci_add_cpt_room_meta() {
		add_meta_box( 'ci-room-box', __( 'Room Details', 'ci_theme' ), 'ci_add_cpt_room_meta_box', 'cpt_room', 'normal', 'high' );
		add_meta_box( 'ci-header-bg-box', __( 'Header background', 'ci_theme' ), 'ci_add_cpt_header_bg_meta_box', 'cpt_room', 'normal', 'high' );
	}

	function ci_update_cpt_room_meta( $post_id ) {

		if ( ! ci_can_save_meta( 'cpt_room' ) ) return;

		update_post_meta( $post_id, 'header_image', esc_url_raw( $_POST['header_image'] ) );
		update_post_meta( $post_id, 'header_image_id', intval( $_POST['header_image_id'] ) );

		update_post_meta( $post_id, 'amenities', ci_sanitize_room_amenities( $_POST ) );
		update_post_meta( $post_id, 'amenities_title', sanitize_text_field( $_POST['amenities_title'] ) );

		update_post_meta( $post_id, 'price', sanitize_text_field( $_POST['price'] ) );
		update_post_meta( $post_id, 'on_offer', ci_theme_sanitize_checkbox( $_POST['on_offer'] ) );

		ci_metabox_gallery_save( $_POST );

	}

	function ci_add_cpt_room_meta_box( $object, $box ) {
		ci_prepare_metabox('cpt_room');

		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( __( 'Gallery', 'ci_theme' ) );
				ci_metabox_guide( __( "You can create a featured gallery by pressing the <em>Add Images</em> button below. You should also set a featured image that will be used as this Gallery's cover.", 'ci_theme' ) );
				ci_metabox_gallery();
			ci_metabox_close_tab();

			ci_metabox_open_tab( __( 'Amenities', 'ci_theme' ) );
				ci_metabox_guide( __( 'Provide the amenities of the room. Select <em>Add Field</em> as many times as you want to create a list of amenities. You can delete one by clicking on its <em><span class="dashicons dashicons-no"><span class="screen-reader-text">Remove Me</span></span></em> icon next to it. You may also click and drag the fields to re-arrange them.', 'ci_theme' ) );
				ci_metabox_input( 'amenities_title', __( "Amenities' title", 'ci_theme' ), array( 'default' => __( 'Amenities', 'ci_theme' ) ) );
				?>
				<fieldset class="amenities ci-repeating-fields">
					<div class="inner">
						<?php
							$fields = get_post_meta($object->ID, 'amenities', true);
							if ( ! empty( $fields ) ) {
								foreach ( $fields as $field ) {
									?>
									<div class="post-field">
										<label><?php _e( 'Amenity:', 'ci_theme' ); ?> <input type="text" name="ci_repeatable_room_amenities_title[]" value="<?php echo esc_attr( $field['title'] ); ?>" class="widefat" /></label>
										<p class="ci-repeating-remove-action"><a href="#" class="button ci-repeating-remove-field"><i class="dashicons dashicons-dismiss"></i><?php _e( 'Remove me', 'ci_theme' ); ?></a></p>
									</div>
									<?php
								}
							}
						?>
						<div class="post-field field-prototype" style="display: none;">
							<label><?php _e( 'Amenity:', 'ci_theme' ); ?> <input type="text" name="ci_repeatable_room_amenities_title[]" value="" class="widefat" /></label>
							<p class="ci-repeating-remove-action"><a href="#" class="button ci-repeating-remove-field"><i class="dashicons dashicons-dismiss"></i><?php _e( 'Remove me', 'ci_theme' ); ?></a></p>
						</div>
					</div>
					<a href="#" class="ci-repeating-add-field button"><i class="dashicons dashicons-plus-alt"></i><?php _e('Add Field', 'ci_theme'); ?></a>
				</fieldset>
				<?php
			ci_metabox_close_tab();

			ci_metabox_open_tab( __( 'Offer', 'ci_theme' ) );
				ci_metabox_guide( __( 'Enter the price per night for the room. Include any currency symbols where appropriate.', 'ci_theme' ) );
				ci_metabox_input( 'price', __( 'Room price.', 'ci_theme' ) );
				ci_metabox_checkbox( 'on_offer', 1, __( 'Room is on offer.', 'ci_theme' ) );
			ci_metabox_close_tab();

		?></div><?php

	}

	function ci_sanitize_room_amenities( $POST_array ) {
		if ( empty( $POST_array ) || !is_array( $POST_array ) ) {
			return false;
		}

		$titles = $POST_array['ci_repeatable_room_amenities_title'];

		$count = count( $titles );

		$new_fields = array();

		$records_count = 0;
		for ( $i = 0; $i < $count; $i++ ) {
			if ( empty( $titles[ $i ] ) ) {
				continue;
			}

			$new_fields[ $records_count ]['title'] = sanitize_text_field( $titles[ $i ] );
			$records_count++;
		}
		return $new_fields;
	}
