<?php
	//
	// Slider Post Type related functions.
	//
	add_action( 'init', 'ci_create_cpt_slider' );
	add_action( 'admin_init', 'ci_add_cpt_slider_meta' );
	add_action( 'save_post', 'ci_update_cpt_slider_meta' );

	function ci_create_cpt_slider() {
		$labels = array(
			'name'               => _x( 'Slides', 'post type general name', 'ci_theme' ),
			'singular_name'      => _x( 'Slide', 'post type singular name', 'ci_theme' ),
			'add_new'            => __( 'New Slide', 'ci_theme' ),
			'add_new_item'       => __( 'Add New Slide', 'ci_theme' ),
			'edit_item'          => __( 'Edit Slide', 'ci_theme' ),
			'new_item'           => __( 'New Slide', 'ci_theme' ),
			'view_item'          => __( 'View Slide', 'ci_theme' ),
			'search_items'       => __( 'Search Slides', 'ci_theme' ),
			'not_found'          => __( 'No Slides found', 'ci_theme' ),
			'not_found_in_trash' => __( 'No Slides found in the trash', 'ci_theme' ),
			'parent_item_colon'  => __( 'Parent Slide:', 'ci_theme' )
		);
	
		$args = array(
			'labels'          => $labels,
			'singular_label'  => __( 'Slide', 'ci_theme' ),
			'public'          => false,
			'show_ui'         => true,
			'capability_type' => 'post',
			'hierarchical'    => false,
			'has_archive'     => false,
			'rewrite'         => array( 'slug' => _x( 'slider', 'post type slug', 'ci_theme' ) ),
			'menu_position'   => 5,
			'supports'        => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
			'menu_icon'       => 'dashicons-image-flip-horizontal'
		);
	
		register_post_type( 'cpt_slider' , $args );
	}

	function ci_add_cpt_slider_meta() {
		add_meta_box( 'ci-slider-box', __( 'Slider Details', 'ci_theme' ), 'ci_add_cpt_slider_meta_box', 'cpt_slider', 'normal', 'high' );
	}

	function ci_update_cpt_slider_meta( $post_id ) {
		if ( ! ci_can_save_meta( 'cpt_slider' ) ) return;
	
		update_post_meta( $post_id, 'link_url', esc_url_raw( $_POST['link_url'] ) );
		update_post_meta( $post_id, 'subtitle', sanitize_text_field( $_POST['subtitle'] ) );
		update_post_meta( $post_id, 'button_text', sanitize_text_field( $_POST['button_text'] ) );
	
	}

	function ci_add_cpt_slider_meta_box( $object, $box ) {
		ci_prepare_metabox( 'cpt_slider' );
	
		?><div class="ci-cf-wrap"><?php
			ci_metabox_open_tab( '' );
				ci_metabox_input( 'subtitle', __( 'Subtitle:', 'ci_theme' ) );

				ci_metabox_guide( __( 'Enter the URL that this slide will link to. Leaving the URL blank, will make the slide unclickable and will also disable the <em>Read More</em> button.', 'ci_theme' ) );
				ci_metabox_input( 'link_url', __( 'Link URL:', 'ci_theme' ), array( 'esc_func' => 'esc_url' ) );
				ci_metabox_input( 'button_text', __( '"Read More" button text:', 'ci_theme' ), array( 'default' => _x( 'Read More', 'slider button', 'ci_theme' ) ) );
			ci_metabox_close_tab();
		?></div><?php
	
	}
